/*
 *	This file was originally part of Matt Smith's
 *	mICQ, and is now included in GTK-ICQ.  Below
 *	are the original authors and contributors:
 *
 *	Original Author:
 *		 Matthew Smith		04/23/1998
 *		 
 *	Contributors:
 *
 *		airog			04/13/1998
 */

#include "gnomeicu.h"
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <assert.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/time.h>

#include <unistd.h>
#include <termios.h>

#include "pixmaps.h"

#include "timezone.h"
#include "lang.h"

typedef struct 
{
   const char *name;
   WORD code;
} COUNTRY_CODE;


static COUNTRY_CODE Country_Codes[] = { { USA_COUNTRY_STR, 1 },
                                 { Afghanistan_COUNTRY_STR, 93 },
                                 { Albania_COUNTRY_STR, 355 },
                                 { Algeria_COUNTRY_STR, 213 },
                                 { American_Samoa_COUNTRY_STR, 684 },
                                 { Andorra_COUNTRY_STR, 376 },
                                 { Angola_COUNTRY_STR, 244 },
                                 { Anguilla_COUNTRY_STR, 101 },
                                 { Antigua_COUNTRY_STR, 102 },
                                 { Argentina_COUNTRY_STR, 54 },
                                 { Armenia_COUNTRY_STR, 374 },
                                 { Aruba_COUNTRY_STR, 297 },
                                 { Ascention_Island_COUNTRY_STR, 274 },
                                 { Australia_COUNTRY_STR, 61 },
                                 { Australian_Antartic_Territory_COUNTRY_STR, 6721 },
                                 { Austria_COUNTRY_STR, 43 },
                                 { Azerbaijan_COUNTRY_STR, 934 },
                                 { Bahamas_COUNTRY_STR, 103 },
                                 { Bahrain_COUNTRY_STR, 973 },
                                 { Bangladesh_COUNTRY_STR, 880 },
                                 { Barbados_COUNTRY_STR, 104 },
                                 { Belarus_COUNTRY_STR, 375 },
                                 { Belgium_COUNTRY_STR, 32 },
                                 { Belize_COUNTRY_STR, 501 },
                                 { Benin_COUNTRY_STR, 229 },
                                 { Bermuda_COUNTRY_STR, 105 },
                                 { Bhutan_COUNTRY_STR, 975 },
                                 { Bolivia_COUNTRY_STR, 591 },
                                 { Bosnia_Herzegovina_COUNTRY_STR, 387 },
                                 { Botswana_COUNTRY_STR, 267 },
                                 { Brazil_COUNTRY_STR, 55 },
                                 { British_Virgin_Islands_COUNTRY_STR, 106 },
                                 { Brunei_COUNTRY_STR, 673 },
                                 { Bulgaria_COUNTRY_STR, 359 },
                                 { Burkina_Faso_COUNTRY_STR, 226 },
                                 { Burundi_COUNTRY_STR, 257 },
                                 { Cambodia_COUNTRY_STR, 855 },
                                 { Cameroon_COUNTRY_STR, 237 },
                                 { Canada_COUNTRY_STR, 107 },
                                 { Cape_Verde_Islands_COUNTRY_STR, 238 },
                                 { Cayman_Islands_COUNTRY_STR, 108},
                                 { Central_African_Republic_COUNTRY_STR, 236},
                                 { Chad_COUNTRY_STR, 235},
                                 { Christmas_Island_COUNTRY_STR, 672},
                                 { Cocos_Keeling_Islands_COUNTRY_STR, 6101},
                                 { Comoros_COUNTRY_STR, 2691},
                                 { Congo_COUNTRY_STR, 242},
                                 { Cook_Islands_COUNTRY_STR, 682},
                                 { Chile_COUNTRY_STR, 56 },
                                 { China_COUNTRY_STR, 86 },
                                 { Columbia_COUNTRY_STR, 57 },
                                 { Costa_Rice_COUNTRY_STR, 506 },
                                 { Croatia_COUNTRY_STR, 385 }, /* Observerd */
                                 { Cuba_COUNTRY_STR, 53 },
                                 { Cyprus_COUNTRY_STR, 357 },
                                 { Czech_Republic_COUNTRY_STR, 42 },
                                 { Denmark_COUNTRY_STR, 45 },
                                 { Diego_Garcia_COUNTRY_STR, 246},
                                 { Djibouti_COUNTRY_STR, 253},
                                 { Dominica_COUNTRY_STR, 109},
                                 { Dominican_Republic_COUNTRY_STR, 110},
                                 { Ecuador_COUNTRY_STR, 593 },
                                 { Egypt_COUNTRY_STR, 20 },
                                 { El_Salvador_COUNTRY_STR, 503 },
                                 { Equitorial_Guinea_COUNTRY_STR, 240},
                                 { Eritrea_COUNTRY_STR, 291},
                                 { Estonia_COUNTRY_STR, 372},
                                 { Ethiopia_COUNTRY_STR, 251 },
                                 { Former_Yugoslavia_COUNTRY_STR, 389},
                                 { Faeroe_Islands_COUNTRY_STR, 298},
                                 { Falkland_Islands_COUNTRY_STR, 500},
                                 { Federated_States_of_Micronesia_COUNTRY_STR, 691 },
                                 { Fiji_COUNTRY_STR, 679 },
                                 { Finland_COUNTRY_STR, 358 },
                                 { France_COUNTRY_STR, 33 },
                                 { French_Antilles_COUNTRY_STR, 596 },  /* Leave it */
                                 { French_Antilles_COUNTRY_STR, 5901 }, /* Either on or the other is right :) */
                                 { French_Guiana_COUNTRY_STR, 594 },
                                 { French_Polynesia_COUNTRY_STR, 689 },
                                 { Gabon_COUNTRY_STR, 241 },
                                 { Gambia_COUNTRY_STR, 220 },
                                 { Georgia_COUNTRY_STR, 995 },
                                 { Germany_COUNTRY_STR, 49 },
                                 { Ghana_COUNTRY_STR, 233 },
                                 { Gibraltar_COUNTRY_STR, 350 },
                                 { Greece_COUNTRY_STR, 30 },
                                 { Greenland_COUNTRY_STR, 299 },
                                 { Grenada_COUNTRY_STR, 111 },
                                 { Guadeloupe_COUNTRY_STR, 590 },
                                 { Guam_COUNTRY_STR, 671 },
                                 { Guantanomo_Bay_COUNTRY_STR, 5399 },
                                 { Guatemala_COUNTRY_STR, 502 },
                                 { Guinea_COUNTRY_STR, 224 },
                                 { Guinea_Bissau_COUNTRY_STR, 245 },
                                 { Guyana_COUNTRY_STR, 592 },
                                 { Haiti_COUNTRY_STR, 509 },
                                 { Honduras_COUNTRY_STR, 504 },
                                 { Hong_Kong_COUNTRY_STR, 852 },
                                 { Hungary_COUNTRY_STR, 36 },
                                 { Iceland_COUNTRY_STR, 354 },
                                 { India_COUNTRY_STR, 91 },
                                 { Indonesia_COUNTRY_STR, 62 },
                                 { INMARSAT_COUNTRY_STR, 870 },
                                 { INMARSAT_Atlantic_East_COUNTRY_STR, 870 },
                                 { Iran_COUNTRY_STR, 98 },
                                 { Iraq_COUNTRY_STR, 964 },
                                 { Ireland_COUNTRY_STR, 353 },
                                 { Israel_COUNTRY_STR, 972 },
                                 { Italy_COUNTRY_STR, 39 },
                                 { Ivory_Coast_COUNTRY_STR, 225 },
                                 { Japan_COUNTRY_STR, 81 },
                                 { Jordan_COUNTRY_STR, 962 },
                                 { Kenya_COUNTRY_STR, 254 },
                                 { South_Korea_COUNTRY_STR, 82 },
                                 { Kuwait_COUNTRY_STR, 965 },
                                 { Liberia_COUNTRY_STR, 231 },
                                 { Libya_COUNTRY_STR, 218 },
                                 { Liechtenstein_COUNTRY_STR, 4101 },
                                 { Luxembourg_COUNTRY_STR, 352 },
                                 { Malawi_COUNTRY_STR, 265 },
                                 { Malaysia_COUNTRY_STR, 60 },
                                 { Mali_COUNTRY_STR, 223 },
                                 { Malta_COUNTRY_STR, 356 },
                                 { Mexico_COUNTRY_STR, 52 },
                                 { Monaco_COUNTRY_STR, 33 },
                                 { Morocco_COUNTRY_STR, 212 },
                                 { Namibia_COUNTRY_STR, 264 },
                                 { Nepal_COUNTRY_STR, 977 },
                                 { Netherlands_COUNTRY_STR, 31 },
                                 { Netherlands_Antilles_COUNTRY_STR, 599 },
                                 { New_Caledonia_COUNTRY_STR, 687 },
                                 { New_Zealand_COUNTRY_STR, 64 },
                                 { Nicaragua_COUNTRY_STR, 505 },
                                 { Nigeria_COUNTRY_STR, 234 },
                                 { Norway_COUNTRY_STR, 47 }, 
                                 { Oman_COUNTRY_STR, 968 },
                                 { Pakistan_COUNTRY_STR, 92 },
                                 { Panama_COUNTRY_STR, 507 },
                                 { Papua_New_Guinea_COUNTRY_STR, 675 },
                                 { Paraguay_COUNTRY_STR, 595 },
                                 { Peru_COUNTRY_STR, 51 },
                                 { Philippines_COUNTRY_STR, 63 },
                                 { Poland_COUNTRY_STR, 48 },
                                 { Portugal_COUNTRY_STR, 351 },
                                 { Qatar_COUNTRY_STR, 974 },
                                 { Romania_COUNTRY_STR, 40 },
                                 { Russia_COUNTRY_STR, 7 },
                                 { Saipan_COUNTRY_STR, 670 },
                                 { San_Marino_COUNTRY_STR, 39 },
                                 { Saudia_Arabia_COUNTRY_STR, 966 },
                                 { Senegal_COUNTRY_STR, 221},
                                 { Singapore_COUNTRY_STR, 65 },
                                 { Slovakia_COUNTRY_STR, 42 },
                                 { South_Africa_COUNTRY_STR, 27 },
                                 { Spain_COUNTRY_STR, 34 },
                                 { Sri_Lanka_COUNTRY_STR, 94 },
                                 { Suriname_COUNTRY_STR, 597 },
                                 { Sweden_COUNTRY_STR, 46 },
                                 { Switzerland_COUNTRY_STR, 41 },
                                 { Taiwan_COUNTRY_STR, 886 },
                                 { Tanzania_COUNTRY_STR, 255 },
                                 { Thailand_COUNTRY_STR, 66 },
                                 { Tunisia_COUNTRY_STR, 216 },
                                 { Turkey_COUNTRY_STR, 90 },
                                 { United_Arab_Emirates_COUNTRY_STR, 971 },
                                 { Uruguay_COUNTRY_STR, 598 },
                                 { UK_COUNTRY_STR, 0x2c },
                                 { Ukraine_COUNTRY_STR, 380 },
                                 { Vatican_City_COUNTRY_STR, 39 },
                                 { Venezuela_COUNTRY_STR, 58 },
                                 { Vietnam_COUNTRY_STR, 84 },
                                 { Yemen_COUNTRY_STR, 967 },
                                 { Yugoslavia_COUNTRY_STR, 38 },
                                 { Zaire_COUNTRY_STR, 243 },
                                 { Zimbabwe_COUNTRY_STR, 263 },
                                 {NON_COUNTRY_STR, 0 },
                                 {NON_COUNTRY_STR, 0xffff } };

GList *get_time_zones( void )
{
	GList *l = NULL;
	int cx;

	for( cx = 0; time_zones[ cx ].gmt_offset != -1; cx ++ )
		l = g_list_append( l, (char*)time_zones[ cx ].str );

	return l;
}

GList *get_country_codes( void )
{
	GList *l = NULL;
	int cx;

	for( cx = 0; Country_Codes[ cx ].code != 0xffff; cx ++ )
		l = g_list_append( l, (char*)Country_Codes[ cx ].name );

	return l;
}

const char *Get_Country_Name( int code )
{
   int i;
   
   for ( i = 0; Country_Codes[i].code != 0xffff; i++)
   {
      if ( Country_Codes[i].code == code )
      {
         return Country_Codes[i].name;
      }
   }
	return Country_Codes[i].name;
}

const char *Get_Time_Zone_String( int code )
{
	int cx;

	for( cx = 0; time_zones[ cx ].gmt_offset != -1; cx ++ )
	{
		if( time_zones[ cx ].gmt_offset == code )
			return time_zones[ cx ].str;
	}
	return time_zones[ cx ].str;
}

int Get_Country_Code( char *country )
{
	int cx;

	for( cx = 0; Country_Codes[ cx ].code != 0xffff; cx++ )
	{
		if( !strcmp( Country_Codes[ cx ].name, country ) )
			return Country_Codes[ cx ].code;
	}
	if( !strcmp( Country_Codes[ cx ].name, country ) )
		return Country_Codes[ cx ].code;
	return 0;
}

int Get_Time_Zone( char *desc )
{
	int cx;

	for( cx = 0; time_zones[ cx ].gmt_offset != -1; cx ++ )
	{
		if( !strcmp( time_zones[ cx ].str, desc ) )
		{
			return time_zones[ cx ].gmt_offset;
		}
	}
	if( !strcmp( time_zones[ cx ].str, desc ) )
		return time_zones[ cx ].gmt_offset;
	return 0;
}

/* Convets a Status to a string */
char *Convert_Status_2_Str( int status )
{
	if ( STATUS_OFFLINE == status ) /* this because -1 & 0xFFFF is not -1 */
	{
		return "Offline";
	}
   
	switch ( status & 0xffff )
	{
	case STATUS_ONLINE:
		return "Online";
		break;
	case STATUS_DND:
		return "Do not disturb";
		break;
	case STATUS_AWAY:
		return "Away";
		break;
	case STATUS_OCCUPIED:
		return "Occupied";
		break;
	case STATUS_NA:
		return "Not available";
		break;
	case STATUS_INVISIBLE:
		return "Invisible";
		break;
	case STATUS_FREE_CHAT:
		return "Free for chat";
		break;
	default:
		return NULL;
		break;
	}
}


/* Convets a Status to a string (short version) */
char *Convert_Status_2_Short( int status )
{
	if ( STATUS_OFFLINE == status ) /* this because -1 & 0xFFFF is not -1 */
	{
		return "(OFF)";
	}
   
	switch ( status & 0xffff )
	{
		case STATUS_ONLINE:
			return "(ONLN)";
			break;
		case STATUS_DND:
			return "(DND)";
			break;
		case STATUS_AWAY:
			return "(AWAY)";
			break;
		case STATUS_OCCUPIED:
			return "(OCC)";
			break;
		case STATUS_NA:
			return "(N/A)";
			break;
		case STATUS_INVISIBLE:
			return "(INV)";
			break;
		case STATUS_FREE_CHAT:
			return "(FFC)";
			break;
		default:
			return NULL;
			break;
	}
}

/* Returns the status of 'new_status' as string */
char *Print_Status_Short( DWORD new_status  )
{
	if ( Convert_Status_2_Short( new_status ) != NULL )
	{
		return Convert_Status_2_Short( new_status );
	}
	else
	{
		return "(UNKN)";
	}
}

GdkPixmap *GetIcon_p( DWORD status )
{
	if ( STATUS_OFFLINE == status ) /* this because -1 & 0xFFFF is not -1 */
	{
		return icon_offline_pixmap;
	}
   
	switch ( status & 0xffff )
	{
	case STATUS_ONLINE:
		return icon_online_pixmap;
		break;
	case STATUS_DND:
		return icon_dnd_pixmap;
		break;
	case STATUS_AWAY:
		return icon_away_pixmap;
		break;
	case STATUS_OCCUPIED:
		return icon_occ_pixmap;
		break;
	case STATUS_NA:
		return icon_na_pixmap;
		break;
	case STATUS_INVISIBLE:
		return icon_inv_pixmap;
		break;
	case STATUS_FREE_CHAT:
		return icon_ffc_pixmap;
		break;
	default:
		return icon_offline_pixmap;
		break;
	}
}

GdkBitmap *GetIcon_b( DWORD status )
{
	if ( STATUS_OFFLINE == status ) /* this because -1 & 0xFFFF is not -1 */
	{
		return icon_offline_bitmap;
	}
   
	switch ( status & 0xffff )
	{
	case STATUS_ONLINE:
		return icon_online_bitmap;
		break;
	case STATUS_DND:
		return icon_dnd_bitmap;
		break;
	case STATUS_AWAY:
		return icon_away_bitmap;
		break;
	case STATUS_OCCUPIED:
		return icon_occ_bitmap;
		break;
	case STATUS_NA:
		return icon_na_bitmap;
		break;
	case STATUS_INVISIBLE:
		return icon_inv_bitmap;
		break;
	case STATUS_FREE_CHAT:
		return icon_ffc_bitmap;
		break;
	default:
		return icon_offline_bitmap;
		break;
	}
}
	

/* Returns the status of 'new_status' as string (short version) */
void Print_Status( DWORD new_status  )
{
	if ( Convert_Status_2_Str( new_status ) != NULL )
	{
		g_print( "%s", Convert_Status_2_Str( new_status ) );
	}
	else
	{
		g_print( "%08X", new_status );
	}
}

/* Returns the name of a User otherwise the UIN */
int Print_UIN_Name( DWORD uin )
{
	int i;
   
	for ( i=0; i < Num_Contacts; i++ )
	{
		if ( Contacts[i].uin == uin )
		{
			break;
		}
	}

	if ( i == Num_Contacts )
	{
		return -1 ;
	}
	else
	{
		return i;
	}
}

char *Get_UIN_Name( DWORD uin, char *buf )
{
	int i;
   
	for ( i = 0; i < Num_Contacts; i++ )
	{ 
		if ( Contacts[i].uin == uin )
		{
			break;
		}
	}

	if ( i == Num_Contacts )
	{
		sprintf( buf, "%u", uin );
	}
	else
	{
		sprintf( buf, "%s", Contacts[i].nick );
	}

	return buf;
}

/* Convert a name into a UIN from Contact List */
DWORD nick2uin( char *nick )
{
	int i;
	BOOL non_numeric = FALSE;
   
	for ( i=0; i< Num_Contacts; i++ )
	{
		if ( ! strncasecmp( nick, Contacts[i].nick, 19  ) )
		{
			if ( (S_DWORD) Contacts[i].uin > 0 )
			{
				return Contacts[i].uin;
			}
			else
			{
				return -Contacts[i].uin; /* alias */
			}
		}
	}

	for ( i=0; i < strlen( nick ); i++ )
	{
		if ( ! isdigit( GPOINTER_TO_INT( nick[i] ) ) )
		{
			non_numeric = TRUE;
			break;
		}
	}

	if ( non_numeric )
	{
		return -1; /* not found and not a number */
	}
	else
	{
		return atoi( nick );
	}
}

/*******************************************************
Gets config info from the rc file in the users home 
directory.
********************************************************/
void Get_Unix_Config_Info( void )
{
#ifdef TRACE_FUNCTION
	g_print( "Get_Unix_Config_Info\n" );
#endif

	gnome_config_push_prefix( configfilename );

	if ( gnome_config_get_string( "Existence/exists" ) == NULL )
		Initialize_RC_File();

	gnome_config_pop_prefix();

	Read_RC_File();
}

void Print_IP( DWORD uin )
{
	int i;
	DWORD t;

	for ( i=0; i< Num_Contacts; i++ )
	{
		if ( Contacts[i].uin == uin )
		{
			if ( Contacts[i].current_ip != 0xffffffff )
			{
				t = Contacts[i].current_ip;
				if ( Int_End )
					g_print( "%u.%u.%u.%u",(BYTE) (t>>24),(BYTE) (t>>16),(BYTE) (t>>8),(BYTE) (t) );
				else
					g_print( "%u.%u.%u.%u",(BYTE) (t),(BYTE) (t>>8),(BYTE) (t>>16),(BYTE) (t>>24) );
			}
			else
			{
				g_print( "unknown" );
			}
			return;
		}
	}
	g_print( "unknown" );
}

/************************************************
Gets the TCP port of the specified UIN
************************************************/
DWORD Get_Port( DWORD uin )
{
	int i;

	for ( i=0; i< Num_Contacts; i++ )
	{
		if ( Contacts[i].uin == uin )
		{
			return Contacts[i].port;
		}
	}
	return -1L;
}

/********************************************
Converts an intel endian character sequence to
a DWORD
*********************************************/
DWORD Chars_2_DW( unsigned char *buf )
{
	DWORD i;

	i= buf[3];
	i <<= 8;
	i+= buf[2];
	i <<= 8;
	i+= buf[1];
	i <<= 8;
	i+= buf[0];

	return i;
}

/********************************************
Converts an intel endian character sequence to
a WORD
*********************************************/
WORD Chars_2_Word( unsigned char *buf )
{
	WORD i;

	i= buf[1];
	i <<= 8;
	i += buf[0];

	return i;
}

/********************************************
Converts a DWORD to
an intel endian character sequence 
*********************************************/
void DW_2_Chars( unsigned char *buf, DWORD num )
{
	buf[3] = ( unsigned char ) ((num)>>24)& 0x000000FF;
	buf[2] = ( unsigned char ) ((num)>>16)& 0x000000FF;
	buf[1] = ( unsigned char ) ((num)>>8)& 0x000000FF;
	buf[0] = ( unsigned char ) (num) & 0x000000FF;
}

/********************************************
Converts a WORD to
an intel endian character sequence 
*********************************************/
void Word_2_Chars( unsigned char *buf, WORD num )
{
	buf[1] = ( unsigned char ) (((unsigned)num)>>8) & 0x00FF;
	buf[0] = ( unsigned char ) ((unsigned)num) & 0x00FF;
}

void Time_Stamp( void )
{
	struct tm *thetime;
	time_t p;

	p=time(NULL);
	thetime=localtime(&p);
}

void Add_User( SOK_T sok, DWORD uin, char *name )
{
	int cx;

#ifdef TRACE_FUNCTION
	g_print( "Add_User\n" );
#endif

	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( uin == Contacts[ cx ].uin )
			return;
	}

	Contacts[ Num_Contacts ].uin = uin;
	Contacts[ Num_Contacts ].icon_p = icon_offline_pixmap;
	Contacts[ Num_Contacts ].icon_b = icon_offline_bitmap;
	Contacts[ Num_Contacts ].log_window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	gtk_widget_set_usize( Contacts[ Num_Contacts ].log_window, 625, 250 );
	gtk_signal_connect( GTK_OBJECT( Contacts[ Num_Contacts ].log_window ), "delete_event",
	                    GTK_SIGNAL_FUNC( gtk_widget_hide_on_delete ),
	                    NULL );
	Contacts[ Num_Contacts ].log_list = gtk_text_new( NULL, NULL );
	gtk_text_set_editable( GTK_TEXT( Contacts[ Num_Contacts ].log_list ),
	                       FALSE );
	gtk_container_add( GTK_CONTAINER( Contacts[ Num_Contacts ].log_window ),
	                   Contacts[ Num_Contacts ].log_list );
	gtk_widget_show( Contacts[ Num_Contacts ].log_list );
	Contacts[ Num_Contacts ].message = NULL;
	Contacts[ Num_Contacts ].messages = 0;
	Contacts[ Num_Contacts ].need_update = TRUE;
	Contacts[ Num_Contacts ].status = STATUS_OFFLINE;
	Contacts[ Num_Contacts ].last_status = STATUS_OFFLINE;
	Contacts[ Num_Contacts ].last_time = -1L;
	Contacts[ Num_Contacts ].current_ip = -1L;
	Contacts[ Num_Contacts ].port = 0;
	Contacts[ Num_Contacts ].sok = (SOK_T ) -1L;
	Contacts[ Num_Contacts ].invis_list = FALSE;
	Contacts[ Num_Contacts ].lb_index = 2 + Num_Contacts;
	Contacts[ Num_Contacts ].gdk_input_tag = 0;
	Contacts[ Num_Contacts ].chat_away = 0;
	Contacts[ Num_Contacts ].chat_window = NULL;
	Contacts[ Num_Contacts ].chat_frame = NULL;
	Contacts[ Num_Contacts ].chat_history = NULL;
	Contacts[ Num_Contacts ].chat_seq = 0;
	Contacts[ Num_Contacts ].chat_sok = 0;
	Contacts[ Num_Contacts ].chat_active = FALSE;
	Contacts[ Num_Contacts ].chat_active2 = FALSE;
	Contacts[ Num_Contacts ].chat_port = 0;
	Contacts[ Num_Contacts ].chat_bg_red =
	Contacts[ Num_Contacts ].chat_bg_green =
	Contacts[ Num_Contacts ].chat_bg_blue = 255;
	Contacts[ Num_Contacts ].chat_fg_red =
	Contacts[ Num_Contacts ].chat_fg_green =
	Contacts[ Num_Contacts ].chat_fg_blue = 0;
	Contacts[ Num_Contacts ].tcp_gdk_input = 0;
	Contacts[ Num_Contacts ].chat_gdk_input = 0;
	Contacts[ Num_Contacts ].oneline = NULL;
	memcpy( Contacts[ Num_Contacts ].nick, name, sizeof( Contacts->nick )  );

	Contacts[ Num_Contacts ].pdata = NULL;
	Contacts[ Num_Contacts ].file_name = NULL;
	Contacts[ Num_Contacts ].file_short_name = NULL;
	Contacts[ Num_Contacts ].file_fd = 0;
	Contacts[ Num_Contacts ].file_offset = 0;
	Contacts[ Num_Contacts ].file_sending = FALSE;
	Contacts[ Num_Contacts ].file_info = NULL;
	Contacts[ Num_Contacts ].show_again = TRUE;
	Contacts[ Num_Contacts ].chat_reason = NULL;
	Contacts[ Num_Contacts ].info = (USER_INFO_PTR)g_malloc0( sizeof( USER_INFO_STRUCT ) );
	Contacts[ Num_Contacts ].info->sex = MALE;
	Contacts[ Num_Contacts ].info->country = 1;

	Num_Contacts++;

	send_info_req( sok, uin );
	snd_contact_list( sok );

	Show_Quick_Status( MainData );

	Save_RC();
}

void Init_New_User( void )
{
   SOK_T sok; 
   srv_net_icq_pak pak;
   int s;
   struct timeval tv;
   fd_set readfds;

	char str[32];

   sok = Connect_Remote( server, remote_port, STDERR );
   if ( ( sok == -1 ) || ( sok == 0 ) ) 
   {
		g_error( "Unable to create new user" );
   }

   reg_new_user( sok, passwd );
   for ( ; ; )
   {
      tv.tv_sec = 3;
      tv.tv_usec = 500000;

      FD_ZERO(&readfds);
      FD_SET(sok, &readfds);

      /* don't care about writefds and exceptfds: */
      select(sok+1, &readfds, NULL, NULL, &tv);

      if (FD_ISSET(sok, &readfds))
      {
         s = SOCKREAD( sok, &pak.head.ver, sizeof( pak ) - 2  );
         if ( Chars_2_Word( pak.head.cmd ) == SRV_NEW_UIN )
         {
            our_info->uin = Chars_2_DW( pak.head.UIN );
            sprintf( str, "Your new UIN is %u", our_info->uin );
				gtk_widget_show( gnome_message_box_new( _( str ),
				                                        GNOME_MESSAGE_BOX_INFO,
				                                        GNOME_STOCK_BUTTON_OK, NULL ) );
            return;
         }
         else
         {
/*            Hex_Dump( &pak.head.ver, s );*/
         }
      }
      reg_new_user( sok, passwd );
   }
}
