#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "gnomeicu.h"
#include "datatype.h"
#include "dialog.h"
#include <stdio.h>
#include <stdlib.h>

#include <unistd.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/time.h>

#include <fcntl.h>
#include <time.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include <assert.h>
#include <sys/wait.h>
#include <signal.h>

#ifdef HAVE_SOCKS5
#define SOCKS
#include <socks.h>
#endif

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "gtkfunc.h"

#include "tcp.h"
#include "chatdlg.h"

#include "filexfer.h"

#include "events.h"

GtkWidget *filesel, *chat_filesel;

typedef struct
{
	struct sokandlb *data;
	int i;
} dataandint;

const DWORD LOCALHOST = 0x0100007F;

int TCPChatReadServer( GtkWidget *widget, int sock, GdkInputCondition cond );
int TCPFileReadServer( GtkWidget *widget, int sock, GdkInputCondition cond );
int TCPChatReadClient( GtkWidget *widget, int sock, GdkInputCondition cond );
int TCPFileReadClient( GtkWidget *widget, int sock, GdkInputCondition cond );
int TCPChatHandshake( int cindex, int sock, GdkInputCondition cond );
int TCPFileHandshake( int cindex, int sock, GdkInputCondition cond );
int TCPConnectChat( DWORD port, DWORD uin, struct sokandlb *data );
int TCPConnectFile( DWORD port, DWORD uin, struct sokandlb *data );
int TCPAckPacket( int sock, int cindex, WORD cmd, int seq );
void TCPProcessPacket( BYTE *packet, int packet_length, int sock, struct sokandlb *data );
int TCPInitChannel( dataandint *data, int sock, GdkInputCondition cond );
int TCPGainConnection( DWORD ip, WORD port, int cindex, struct sokandlb *data );
int TCPSendPartFile( gpointer data );
void file_xfer_got_name( GtkWidget *widget, gpointer data );
void file_choose( void );
void file_place( char *prename, DWORD uin );
void save_incoming_file( GtkWidget *widget, gpointer data );
void cancel_transfer( GtkWidget *widget, gpointer data );

void packet_print( BYTE *packet, int size, int type )
{
	int cx;

#ifdef TRACE_FUNCTION
	g_print( "packet_print\n" );
#endif

#ifndef DEBUG
	if( !packet_toggle )
		return;
#endif

	switch( type )
	{
		case ( PACKET_TYPE_TCP | PACKET_DIRECTION_SEND ):
			g_print( "Sending packet (TCP) %d:\n", size );
			break;
		case( PACKET_TYPE_TCP | PACKET_DIRECTION_RECEIVE ):
			g_print( "Recieved packet (TCP) %d:\n", size );
			break;
		case ( PACKET_TYPE_UDP | PACKET_DIRECTION_SEND ):
			g_print( "Sending packet (UDP) %d:\n", size );
			break;
		case( PACKET_TYPE_UDP | PACKET_DIRECTION_RECEIVE ):
			g_print( "Recieved packet (UDP) %d:\n", size );
			break;
	}

	for( cx = 0; cx < size; cx ++ )
	{
		if( cx % 16 == 0 && cx )
			g_print( "\n" );
		g_print("%02x ", packet[cx] );
	}
	g_print( "\n\n" );
	fflush( stdout );
}

void TCPTerminateChat( GtkWidget *widget, gpointer data )
{
	gint sock = GPOINTER_TO_INT( data );
	int cx;
	char message[ 256 ];

#ifdef TRACE_FUNCTION
	g_print( "TCPTerminateChat\n" );
#endif
	
	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( sock == Contacts[ cx ].chat_sok )
			break;
	}
	
	if( cx == Num_Contacts )
		return;

	if( Contacts[ cx ].chat_gdk_input )
	{
		gdk_input_remove( Contacts[ cx ].chat_gdk_input );
		Contacts[ cx ].chat_gdk_input = 0;
	}
	
	sprintf( message, "Chat Session terminated:\n%s", Contacts[ cx ].nick );
	gtk_widget_show( gnome_message_box_new( _( message ),
	                                        GNOME_MESSAGE_BOX_INFO,
	                                        GNOME_STOCK_BUTTON_OK, NULL ) );
	close( sock );
	if( Contacts[ cx ].chat_file != NULL )
	{
		fclose( Contacts[ cx ].chat_file );
		Contacts[ cx ].chat_file = NULL;
	}
	Contacts[ cx ].chat_sok = 0;
	Contacts[ cx ].chat_port = 0;
	Contacts[ cx ].chat_active = Contacts[ cx ].chat_active2 = FALSE;
}

int TCPChatSend( GtkWidget *widget, GdkEventKey *ev, int sock )
{
	char c;
	int cx;
	char *chat_history_line;

#ifdef TRACE_FUNCTION
	g_print( "TCPChatSend\n" );
#endif
	
	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( sock == Contacts[ cx ].chat_sok )
			break;
	}

	if( ev == NULL )
		return FALSE;

	if( Contacts[ cx ].oneline == NULL )
	{
		Contacts[ cx ].oneline = (char *)g_malloc0( 1024 );
		strcpy( Contacts[ cx ].oneline, "" );
	}

	switch( ev->keyval )
	{
		case GDK_Shift_L:
		case GDK_Shift_R:
		case GDK_Control_L:
		case GDK_Control_R:
		case GDK_Alt_L:
		case GDK_Alt_R:
		case GDK_Up:
		case GDK_Down:
		case GDK_Right:
		case GDK_Left:
		case GDK_Home:
		case GDK_End:
		case GDK_Page_Up:
		case GDK_Page_Down:
			return FALSE;
		case 'g':
			if( ev->state & GDK_CONTROL_MASK )
			{
				gnomeicu_event( EV_CHATBEEP );

				c = 0x07;
			}
			else
				c = ev->keyval;
			break;
		case GDK_Return:
			c = 0x0D;
			break;
		case GDK_BackSpace:
			c = 0x08;
			Contacts[ cx ].oneline[ strlen( Contacts[ cx ].oneline ) - 1 ] = 0x00;
			break;
		case GDK_Tab:
			c = 0x09;
			break;
		default:
			c = ev->keyval;
	}

	if( c != 0x07 && c != 0x08 && c != 0x09 && c != 0x0D &&
	    strlen( Contacts[ cx ].oneline ) < 1023 )
	{
		Contacts[ cx ].oneline[ strlen( Contacts[ cx ].oneline ) + 1 ] = 0x00;
		Contacts[ cx ].oneline[ strlen( Contacts[ cx ].oneline ) ] = c;
	}

	if( c == 0x0D )
	{
/*
		if( Contacts[ cx ].chat_file != NULL )
		{
			fprintf( Contacts[ cx ].chat_file, "%s> %s\n", our_info->nick,
			         Contacts[ cx ].oneline );
			fflush( Contacts[ cx ].chat_file );
		}
*/
		chat_history_line = (char*)g_malloc0( strlen( our_info->nick ) + strlen( Contacts[ cx ].oneline ) + 4 );
		sprintf( chat_history_line, "%s> %s\n", our_info->nick, Contacts[ cx ].oneline );
		Contacts[ cx ].chat_history = g_slist_append( Contacts[ cx ].chat_history, chat_history_line );

		strcpy( Contacts[ cx ].oneline, "" );
	}

	write( sock, &c, 1 );
	return FALSE;
}

int TCPChatReadServer( GtkWidget *widget, int sock, GdkInputCondition cond )
{
	int cx = 0;
	unsigned short packet_size;
	BYTE *packet;
	BYTE buffer[1024];
	BYTE c;
	BYTE zero;

	WORD font_length, font_family;
	DWORD font_style;

	char *chat_history_line;

	char *font_copy, *font_copy2;
	char *font_name;
	WORD font_size = 12;

	char message[256];

	static GtkStyle *style;
	GdkColor *background = NULL;
	GdkColor *foreground = NULL;

	typedef struct
	{
		BYTE version[4];
		BYTE chat_port[4];
		BYTE ip_local[4];
		BYTE ip_remote[4];
		BYTE four;
		BYTE our_port[2];
		BYTE font_size[4];
		BYTE font_face[4];
		BYTE font_length[2];
	} begin_chat_a;
	
	typedef struct
	{
		BYTE one[2];
	} begin_chat_b;

	typedef struct
	{
		DWORD code;
		DWORD uin;
		WORD name_length;
		BYTE foreground[4];
		BYTE background[4];
		BYTE version[4];
		BYTE chat_port[4];
		BYTE ip_local[4];
		BYTE ip_remote[4];
		BYTE four;
		BYTE our_port[2];
		BYTE font_size[4];
		BYTE font_face[4];
		BYTE font_length[2];
	} read_pak;

	read_pak rpak;
	begin_chat_a paka;
	begin_chat_b pakb;

#ifdef TRACE_FUNCTION
	g_print( "TCPChatReadServer\n" );
#endif

	font_copy = (char*)g_malloc0( strlen( ChatFontString ) + 1 );
	strcpy( font_copy, ChatFontString );
	font_copy2 = font_copy;
	strtok( font_copy2, "-" );
	font_name = strtok( NULL, "-" );

	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( Contacts[ cx ].chat_sok == sock )
		break;
	}

	if( Contacts[ cx ].oneline == NULL )
		Contacts[ cx ].oneline = (char *)g_malloc0( 1024 );

	if( Contacts[ cx ].chat_active == FALSE )
	{
		read( sock, (char*)(&packet_size), 1 );
		read( sock, (char*)(&packet_size) + 1, 1 );

		packet = (BYTE *)g_malloc0( packet_size );
		read( sock, packet, packet_size );
		packet_print( packet, packet_size,
		              PACKET_TYPE_TCP | PACKET_DIRECTION_RECEIVE );

		memcpy( &rpak.code, packet, 4 );
		memcpy( &rpak.uin, packet + 4, 4 );

		memcpy( &rpak.name_length, packet + 8, 2 );
		/* Read in name here */
		memcpy( &rpak.foreground, ( packet + 10 + GPOINTER_TO_INT( rpak.name_length ) ), 4 );
		memcpy( &rpak.background, ( packet + 14 + GPOINTER_TO_INT( rpak.name_length ) ), 4 );
		Contacts[ cx ].chat_fg_red = rpak.foreground[0];
		Contacts[ cx ].chat_fg_green = rpak.foreground[1];
		Contacts[ cx ].chat_fg_blue = rpak.foreground[2];
		Contacts[ cx ].chat_bg_red = rpak.background[0];
		Contacts[ cx ].chat_bg_green = rpak.background[1];
		Contacts[ cx ].chat_bg_blue = rpak.background[2];

		DW_2_Chars( paka.version, 0x00000004 );
		DW_2_Chars( paka.chat_port, Contacts[ cx ].chat_port );
		DW_2_Chars( paka.ip_local, our_ip );
		DW_2_Chars( paka.ip_remote, our_ip );
		paka.four = 0x04;
		Word_2_Chars( paka.our_port, our_port );
		DW_2_Chars( paka.font_size, font_size );
		DW_2_Chars( paka.font_face, FONT_PLAIN );
		Word_2_Chars( paka.font_length, strlen( font_name ) + 1 );

		Word_2_Chars( pakb.one, 0x4200 );

		packet_size = sizeof( begin_chat_a ) + sizeof( begin_chat_b ) + strlen( font_name ) + 1;
		packet = (BYTE *)g_malloc0( packet_size );
		memcpy( &buffer[0], &packet_size, 2 );
		memcpy( &buffer[2], &paka, sizeof( begin_chat_a ) );
		memcpy( &buffer[2 + sizeof( begin_chat_a )], font_name, strlen( font_name ) + 1 );
		memcpy( &buffer[3 + sizeof( begin_chat_a ) + strlen( font_name )], &pakb, sizeof( begin_chat_b ) );
		write( sock, buffer, packet_size + 2 );
		packet_print( &buffer[2], packet_size,
		              PACKET_TYPE_TCP | PACKET_DIRECTION_SEND );

		g_free( packet );

		Contacts[ cx ].chat_active = TRUE;
	}
	else
	{

		foreground = (GdkColor *)g_malloc0( sizeof( GdkColor ) );
		background = (GdkColor *)g_malloc0( sizeof( GdkColor ) );
		
		foreground->red = 256 * Contacts[ cx ].chat_fg_red;
		foreground->green = 256 * Contacts[ cx ].chat_fg_green;
		foreground->blue = 256 * Contacts[ cx ].chat_fg_blue;
		foreground->pixel = (gulong)(
		                    Contacts[ cx ].chat_fg_red * 65536 +
		                    Contacts[ cx ].chat_fg_green * 256 +
		                    Contacts[ cx ].chat_fg_blue );
		
		background->red = 256 * Contacts[ cx ].chat_bg_red;
		background->green = 256 * Contacts[ cx ].chat_bg_green;
		background->blue = 256 * Contacts[ cx ].chat_bg_blue;
		background->pixel = (gulong)(
		                    Contacts[ cx ].chat_bg_red * 65536 +
		                    Contacts[ cx ].chat_bg_green * 256 +
		                    Contacts[ cx ].chat_bg_blue );

		gdk_color_alloc( gtk_widget_get_colormap( widget ), foreground );
		gdk_color_alloc( gtk_widget_get_colormap( widget ), background );

		if( style == NULL )
			style = gtk_style_new();
		memcpy( &style->fg[ GTK_STATE_NORMAL ], foreground, sizeof( GdkColor ) );
		memcpy( &style->text[ GTK_STATE_NORMAL ], foreground, sizeof( GdkColor ) );
		memcpy( &style->base[ GTK_STATE_NORMAL ], background, sizeof( GdkColor ) );

		gtk_widget_set_style( widget, style );

		if( ( read( sock, &c, 1 ) ) <= 0 )
		{
			if( Contacts[ cx ].chat_gdk_input )
			{
				gdk_input_remove( Contacts[ cx ].chat_gdk_input );
				Contacts[ cx ].chat_gdk_input = 0;
			}
			sprintf( message, "Chat Session terminated:\n%s", Contacts[ cx ].nick );
			gtk_widget_show( gnome_message_box_new( _( message ),
			                                        GNOME_MESSAGE_BOX_INFO,
			                                        GNOME_STOCK_BUTTON_OK,
			                                        NULL ) );
			close( sock );
			Contacts[ cx ].chat_sok = 0;
			Contacts[ cx ].chat_port = 0;
			Contacts[ cx ].chat_active = Contacts[ cx ].chat_active2 = FALSE;
			g_free( foreground );
			g_free( background );
			return TRUE;
		}

		g_free( font_copy );

		if( ChatFont == NULL )
			ChatFont = gdk_font_load( ChatFontString );
		if( ChatFont == NULL )
			ChatFont = gdk_font_load( "-adobe-courier-medium-r-normal-*-*-140-*-*-m-*-iso8859-1" );
		switch( c )
		{
			case 0x00: /* Change foreground color */
				read( sock, &Contacts[ cx ].chat_fg_red, 1 );
				read( sock, &Contacts[ cx ].chat_fg_green, 1 );
				read( sock, &Contacts[ cx ].chat_fg_blue, 1 );
				read( sock, &zero, 1 );
				g_free( foreground );
				g_free( background );
				return FALSE;

			case 0x01: /* Change background color */
				read( sock, &Contacts[ cx ].chat_bg_red, 1 );
				read( sock, &Contacts[ cx ].chat_bg_green, 1 );
				read( sock, &Contacts[ cx ].chat_bg_blue, 1 );
				read( sock, &zero, 1 );
				g_free( foreground );
				g_free( background );
				return FALSE;

			case 0x04:
				/* User is away */
				Contacts[ cx ].chat_away = time(NULL);
				g_free( foreground );
				g_free( background );
				return FALSE;
			case 0x03:
				/* User is back */
				Contacts[ cx ].chat_away = -1;
				g_free( foreground );
				g_free( background );
				return FALSE;

			case 0x07: /* Beep */
				gnomeicu_event( EV_CHATBEEP );

				g_free( foreground );
				g_free( background );
				return FALSE;

			case 0x08: /* Backspace */
				Contacts[ cx ].oneline[ strlen( Contacts[ cx ].oneline ) - 1 ] = 0x00;
				gtk_text_backward_delete( GTK_TEXT( widget ), 1 );
				break;

			case 0x0D: /* CR/LF */
/*
				if( Contacts[ cx ].chat_file != NULL )
				{
					fprintf( Contacts[ cx ].chat_file, "%s> %s\n", Contacts[ cx ].nick, Contacts[ cx ].oneline );
					fflush( Contacts[ cx ].chat_file );
				}
*/
				chat_history_line = (char*)g_malloc0( strlen( Contacts[ cx ].nick ) + strlen( Contacts[ cx ].oneline ) + 4 );
				sprintf( chat_history_line, "%s> %s\n", Contacts[ cx ].nick, Contacts[ cx ].oneline );
				Contacts[ cx ].chat_history = g_slist_append( Contacts[ cx ].chat_history, chat_history_line );

				strcpy( Contacts[ cx ].oneline, "" );

				gtk_text_insert( GTK_TEXT( widget ), NULL, foreground, background, "\n", 1 );
				break;

			case 0x10: /* Change font */
				read( sock, &font_length, 2 );
				font_name = (char*)g_malloc0( font_length );
				read( sock, font_name, font_length );
				read( sock, &font_family, 2 );
				g_free( font_name );
				g_free( foreground );
				g_free( background );
				return FALSE;

			case 0x11: /* Change font style */
				read( sock, &font_style, 4 );
				g_free( foreground );
				g_free( background );
				return FALSE;

			case 0x12: /* Change font size */
				read( sock, &font_size, 4 );
				g_free( foreground );
				g_free( background );
				return FALSE;

			default: /* Any other characters */
				if( c != 0x07 && c != 0x08 && c != 0x09 && c != 0x0D &&
	   			 strlen( Contacts[ cx ].oneline ) < 1023 )
				{
					Contacts[ cx ].oneline[ strlen( Contacts[ cx ].oneline ) + 1 ] = 0x00;
					Contacts[ cx ].oneline[ strlen( Contacts[ cx ].oneline ) ] = c;
				}

				gtk_text_insert( GTK_TEXT( widget ), ChatFont, foreground, background, &c, 1 );
				break;
		}

		if( foreground != NULL )
			g_free( foreground );
		if( background != NULL )
			g_free( background );
	}
	return TRUE;
}

int TCPChatReadClient( GtkWidget *widget, int sock, GdkInputCondition cond )
{
	int cx = 0;
	unsigned short packet_size;
	BYTE *packet;
	BYTE buffer[1024];
	BYTE c;
	BYTE zero;

	WORD font_length;
	WORD font_family;
	DWORD font_style;

	char *font_copy, *font_copy2;
	char *font_name;
	DWORD font_size = 12;

	char message[256];

	static GtkStyle *style;
	GdkColor *background = NULL;
	GdkColor *foreground = NULL;

	char *chat_history_line;

	typedef struct
	{
		BYTE code[4];
		BYTE uin[4];
		BYTE name_length[2];
	} begin_chat_a;
	
	typedef struct
	{
		BYTE foreground[4];
		BYTE background[4];
		BYTE version[4];
		BYTE chat_port[4];
		BYTE ip_local[4];
		BYTE ip_remote[4];
		BYTE four;
		BYTE our_port[2];
		BYTE font_size[4];
		BYTE font_face[4];
		BYTE font_length[2];
	} begin_chat_b;
	
	typedef struct
	{
		BYTE zeroa[2];
		BYTE zerob;
	} begin_chat_c;

	begin_chat_a paka;
	begin_chat_b pakb;
	begin_chat_c pakc;

	WORD name_length;

#ifdef TRACE_FUNCTION
	g_print( "TCPChatReadClient\n" );
#endif

	font_copy = (char*)g_malloc0( strlen( ChatFontString ) + 1 );
	strcpy( font_copy, ChatFontString );
	font_copy2 = font_copy;
	strtok( font_copy2, "-" );
	font_name = strtok( NULL, "-" );

	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( Contacts[ cx ].chat_sok == sock )
		break;
	}

	if( Contacts[ cx ].oneline == NULL )
		Contacts[ cx ].oneline = (char *)g_malloc0( 1024 );

	if( Contacts[ cx ].chat_active == FALSE )
	{
		read( sock, (char*)(&packet_size), 1 );
		read( sock, (char*)(&packet_size) + 1, 1 );

		packet = (BYTE *)g_malloc0( packet_size );
		read( sock, packet, packet_size );
		packet_print( packet, packet_size,
		              PACKET_TYPE_TCP | PACKET_DIRECTION_RECEIVE );

		if( Contacts[ cx ].chat_active2 == TRUE )
		{
			/* Put here interpretation of 0x040000000 packet */
		}

		g_free( packet );
	
		if( Contacts[ cx ].chat_active2 == FALSE )
		{
			read( sock, (char*)(&packet_size), 1 );
			read( sock, (char*)(&packet_size) + 1, 1 );
			if( packet_size < 1024 )
			{
				packet = (BYTE *)g_malloc0( packet_size );
				read( sock, packet, packet_size );
				packet_print( packet, packet_size,
				              PACKET_TYPE_TCP | PACKET_DIRECTION_RECEIVE );

				memcpy( &paka.code, packet, 4 );
				memcpy( &paka.uin, packet + 8, 4 );
				memcpy( &name_length, packet + 12, 2 );
				/* Read in name here */
				memcpy( &pakb.foreground, packet + 16 + GPOINTER_TO_INT( name_length ), 4 );
				memcpy( &pakb.background, packet + 20 + GPOINTER_TO_INT( name_length ), 4 );
				Contacts[ cx ].chat_fg_red = pakb.foreground[0];
				Contacts[ cx ].chat_fg_green = pakb.foreground[1];
				Contacts[ cx ].chat_fg_blue = pakb.foreground[2];
				Contacts[ cx ].chat_bg_red = pakb.background[0];
				Contacts[ cx ].chat_bg_green = pakb.background[1];
				Contacts[ cx ].chat_bg_blue = pakb.background[2];

				g_free( packet );
			}

			DW_2_Chars( paka.code, 0x00000064 );
			DW_2_Chars( paka.uin, our_info->uin );
			Word_2_Chars( paka.name_length, strlen( our_info->nick ) + 1 );
			DW_2_Chars( pakb.foreground, 0x00FFFFFF );
			DW_2_Chars( pakb.background, 0x00000000 );
			DW_2_Chars( pakb.version, 0x00000004 );
			DW_2_Chars( pakb.chat_port, Contacts[ cx ].chat_port );
			DW_2_Chars( pakb.ip_local, our_ip );
			DW_2_Chars( pakb.ip_remote, our_ip );
			pakb.four = 0x04;
			Word_2_Chars( pakb.our_port, our_port );
			DW_2_Chars( pakb.font_size, font_size );
			DW_2_Chars( pakb.font_face, FONT_PLAIN );
			Word_2_Chars( pakb.font_length, strlen( font_name ) + 1 );
			Word_2_Chars( pakc.zeroa, 0x4200 );
			pakc.zerob = 0x00;

			packet_size = sizeof( begin_chat_a ) + sizeof( begin_chat_b ) + sizeof( begin_chat_c ) + strlen( our_info->nick ) + 1 + strlen( font_name ) + 1;
			packet = (BYTE *)g_malloc0( packet_size );
			memcpy( &buffer[0], &packet_size, 2 );
			memcpy( &buffer[2], &paka, sizeof( begin_chat_a ) );
			memcpy( &buffer[2 + sizeof( begin_chat_a )], our_info->nick, strlen( our_info->nick ) + 1 );
			memcpy( &buffer[3 + sizeof( begin_chat_a ) + strlen( our_info->nick )], &pakb, sizeof( begin_chat_b ) );
			memcpy( &buffer[3 + sizeof( begin_chat_a ) + strlen( our_info->nick ) + sizeof( begin_chat_b )], font_name, strlen( font_name ) + 1 );
			memcpy( &buffer[4 + sizeof( begin_chat_a ) + strlen( our_info->nick ) + sizeof( begin_chat_b ) + strlen( font_name )], &pakc, sizeof( begin_chat_c ) );
			write( sock, buffer, packet_size + 2 );
			packet_print( &buffer[2], packet_size,
			              PACKET_TYPE_TCP | PACKET_DIRECTION_SEND );

			g_free( packet );
			Contacts[ cx ].chat_active2 = TRUE;
		}
		else
			Contacts[ cx ].chat_active = TRUE;

		g_free( font_copy );
	}
	else
	{
		g_free( font_copy );

		foreground = (GdkColor *)g_malloc0( sizeof( GdkColor ) );
		background = (GdkColor *)g_malloc0( sizeof( GdkColor ) );
		
		foreground->red = 256 * Contacts[ cx ].chat_fg_red;
		foreground->green = 256 * Contacts[ cx ].chat_fg_green;
		foreground->blue = 256 * Contacts[ cx ].chat_fg_blue;
		foreground->pixel = (gulong)(
		                    Contacts[ cx ].chat_fg_red * 65536 +
		                    Contacts[ cx ].chat_fg_green * 256 +
		                    Contacts[ cx ].chat_fg_blue );
		
		background->red = 256 * Contacts[ cx ].chat_bg_red;
		background->green = 256 * Contacts[ cx ].chat_bg_green;
		background->blue = 256 * Contacts[ cx ].chat_bg_blue;
		background->pixel = (gulong)(
		                    Contacts[ cx ].chat_bg_red * 65536 +
		                    Contacts[ cx ].chat_bg_green * 256 +
		                    Contacts[ cx ].chat_bg_blue );

		gdk_color_alloc( gtk_widget_get_colormap( widget ), foreground );
		gdk_color_alloc( gtk_widget_get_colormap( widget ), background );

		if( style == NULL )
			style = gtk_style_new();
		memcpy( &style->fg[ GTK_STATE_NORMAL ], foreground, sizeof( GdkColor ) );
		memcpy( &style->text[ GTK_STATE_NORMAL ], foreground, sizeof( GdkColor ) );
		memcpy( &style->base[ GTK_STATE_NORMAL ], background, sizeof( GdkColor ) );

		gtk_widget_set_style( widget, style );

		if( ( read( sock, &c, 1 ) ) <= 0 )
		{
			if( Contacts[ cx ].chat_gdk_input )
			{
				gdk_input_remove( Contacts[ cx ].chat_gdk_input );
				Contacts[ cx ].chat_gdk_input = 0;
			}
			sprintf( message, "Chat Session terminated:\n%s", Contacts[ cx ].nick );
			gtk_widget_show( gnome_message_box_new( _( message ),
			                                        GNOME_MESSAGE_BOX_INFO,
			                                        GNOME_STOCK_BUTTON_OK,
			                                        NULL ) );
			close( sock );
			Contacts[ cx ].chat_sok = 0;
			Contacts[ cx ].chat_port = 0;
			Contacts[ cx ].chat_active = Contacts[ cx ].chat_active2 = FALSE;
			g_free( foreground );
			g_free( background );
			return TRUE;
		}

		if( ChatFont == NULL )
			ChatFont = gdk_font_load( ChatFontString );
		switch( c )
		{
			case 0x00: /* Change foreground color */
				read( sock, &Contacts[ cx ].chat_fg_red, 1 );
				read( sock, &Contacts[ cx ].chat_fg_green, 1 );
				read( sock, &Contacts[ cx ].chat_fg_blue, 1 );
				read( sock, &zero, 1 );
				g_free( foreground );
				g_free( background );
				return FALSE;

			case 0x01: /* Change background color */
				read( sock, &Contacts[ cx ].chat_bg_red, 1 );
				read( sock, &Contacts[ cx ].chat_bg_green, 1 );
				read( sock, &Contacts[ cx ].chat_bg_blue, 1 );
				read( sock, &zero, 1 );
				g_free( foreground );
				g_free( background );
				return FALSE;

			case 0x04:
				/* User is away */
				Contacts[ cx ].chat_away = time(NULL);
				g_free( foreground );
				g_free( background );
				return FALSE;

			case 0x03:
				/* User is back */
				Contacts[ cx ].chat_away = -1;
				g_free( foreground );
				g_free( background );
				return FALSE;

			case 0x07: /* Beep */
				gnomeicu_event( EV_CHATBEEP );

				g_free( foreground );
				g_free( background );
				return FALSE;

			case 0x08: /* Backspace */
				Contacts[ cx ].oneline[ strlen( Contacts[ cx ].oneline ) - 1 ] = 0x00;
				gtk_text_backward_delete( GTK_TEXT( widget ), 1 );
				break;

			case 0x0D: /* CR/LF */
/*
				if( Contacts[ cx ].chat_file != NULL )
				{
					fprintf( Contacts[ cx ].chat_file, "%s> %s\n", Contacts[ cx ].nick, Contacts[ cx ].oneline );
					fflush( Contacts[ cx ].chat_file );
				}
*/
				chat_history_line = (char*)g_malloc0( strlen( Contacts[ cx ].nick ) + strlen( Contacts[ cx ].oneline ) + 4 );
				sprintf( chat_history_line, "%s> %s\n", Contacts[ cx ].nick, Contacts[ cx ].oneline );
				Contacts[ cx ].chat_history = g_slist_append( Contacts[ cx ].chat_history, chat_history_line );

				strcpy( Contacts[ cx ].oneline, "" );

				gtk_text_insert( GTK_TEXT( widget ), NULL, foreground, background, "\n", 1 );
				break;

			case 0x10: /* Change font */
				read( sock, &font_length, 2 );
				font_name = (char*)g_malloc0( font_length );
				read( sock, font_name, font_length );
				read( sock, &font_family, 2 );
				g_free( font_name );
				g_free( foreground );
				g_free( background );
				return FALSE;

			case 0x11: /* Change font style */
				read( sock, &font_style, 4 );
				g_free( foreground );
				g_free( background );
				return FALSE;

			case 0x12: /* Change font size */
				read( sock, &font_size, 4 );
				g_free( foreground );
				g_free( background );
				return FALSE;

			default: /* Any other characters */
				if( c != 0x07 && c != 0x08 && c != 0x09 && c != 0x0D &&
	   			 strlen( Contacts[ cx ].oneline ) < 1023 )
				{
					Contacts[ cx ].oneline[ strlen( Contacts[ cx ].oneline ) + 1 ] = 0x00;
					Contacts[ cx ].oneline[ strlen( Contacts[ cx ].oneline ) ] = c;
				}

				gtk_text_insert( GTK_TEXT( widget ), ChatFont, foreground, background, &c, 1 );
				break;
		}
	}

	g_free( foreground );
	g_free( background );

	return TRUE;
}

int TCPFileReadClient( GtkWidget *widget, int sock, GdkInputCondition cond )
{
	int cx;
	unsigned short packet_size;
	BYTE *packet;

	char message[256];
	int really_read;

	xfer1 pak1;
	BYTE *buf;
	int t;

#ifdef TRACE_FUNCTION
	g_print( "TCPFileReadClient\n" );
#endif

	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( Contacts[ cx ].file_sok == sock )
		break;
	}

	if( ( read( sock, (char*)(&packet_size), 1 ) ) <= 0 )
	{
		if( Contacts[ cx ].file_gdk_input )
		{
			gdk_input_remove( Contacts[ cx ].file_gdk_input );
			Contacts[ cx ].file_gdk_input = 0;
		}
		sprintf( message, "File transfer terminated:\n%s", Contacts[ cx ].nick );
		OK_Box( message, Contacts[ cx ].file_short_name );
		close( sock );

		Contacts[ cx ].file_sok = 0;
		Contacts[ cx ].file_port = 0;
		Contacts[ cx ].file_seq = 0;
		if( Contacts[ cx ].file_name != NULL )
			g_free( Contacts[ cx ].file_name );
		if( Contacts[ cx ].file_short_name != NULL )
			g_free( Contacts[ cx ].file_short_name );
		Contacts[ cx ].file_name = NULL;
		Contacts[ cx ].file_short_name = NULL;
		if( Contacts[ cx ].file_fd > 0 )
			close( Contacts[ cx ].file_fd );
		Contacts[ cx ].file_fd = 0;
		Contacts[ cx ].file_offset = 0;
		Contacts[ cx ].file_size = 0;

		if( Contacts[ cx ].file_info != NULL &&
		    Contacts[ cx ].file_info->window != NULL )
			gtk_widget_destroy( Contacts[ cx ].file_info->window );
		if( Contacts[ cx ].file_info != NULL )
			g_free( Contacts[ cx ].file_info );
		Contacts[ cx ].file_info = NULL;

		return TRUE;
	}

	read( sock, (char*)(&packet_size) + 1, 1 );

	really_read = 0;
	packet = (BYTE *)g_malloc0( packet_size );

	really_read = read( sock, packet, packet_size );

	while( really_read != packet_size )
		really_read += read( sock, packet + really_read,
		packet_size - really_read );

	packet_print( packet, packet_size,
	              PACKET_TYPE_TCP | PACKET_DIRECTION_RECEIVE );

	switch( packet[ 0 ] )
	{
		case 0x00:
			if( Contacts[ cx ].file_info == NULL )
			{
				Contacts[ cx ].file_info = create_file_xfer_dialog(
				                           Contacts[ cx ].file_short_name,
				                           Chars_2_DW( &packet[ 5 ] ),
				                           Contacts[ cx ].file_size,
				                           Chars_2_DW( &packet[ 9 ] ) );
				gtk_signal_connect( GTK_OBJECT( Contacts[ cx ].file_info->cancel ),
				                    "clicked", (GtkSignalFunc) cancel_transfer,
				                    GUINT_TO_POINTER( Contacts[ cx ].uin ) );
			}
			pak1.id = 0x01;
			DW_2_Chars( pak1.speed, 0x00000064 );
			Word_2_Chars( pak1.nick_len, strlen( our_info->nick ) + 1 );
			buf = (BYTE*)g_malloc0( sizeof( xfer1 ) + strlen( our_info->nick ) + 1 );
			Word_2_Chars( pak1.psize, sizeof( xfer1 ) - 1 + strlen( our_info->nick ) );
			memcpy( buf, &pak1, sizeof( xfer1 ) );
			memcpy( &buf[ sizeof( xfer1 ) ], our_info->nick, strlen( our_info->nick ) + 1 );
			write( Contacts[ cx ].file_sok, buf, sizeof( xfer1 ) + strlen( our_info->nick ) + 1 );
			packet_print( &buf[2], sizeof( xfer1 ) + strlen( our_info->nick ) - 1,
			              PACKET_TYPE_TCP | PACKET_DIRECTION_SEND );
			break;

		case 0x02:
			gtk_entry_set_text( GTK_ENTRY( Contacts[ cx ].file_info->current_file ),
			                    &packet[ 4 ] );
			sprintf( message, "%u", Chars_2_DW( &packet[ 8 + strlen( &packet[4] ) ] ) );
			gtk_entry_set_text( GTK_ENTRY( Contacts[ cx ].file_info->cf_size ),
			                    message );
			file_place( Contacts[ cx ].file_short_name, Contacts[ cx ].uin );
			break;
		case 0x06:
			if( Contacts[ cx ].file_fd <= 0 )
				break;
			write( Contacts[ cx ].file_fd, &packet[ 1 ], packet_size - 1 );

			Contacts[ cx ].file_info->cf_bytes_sent += packet_size - 1;
			Contacts[ cx ].file_info->b_bytes_sent += packet_size - 1;
			sprintf( message, "%d", Contacts[ cx ].file_info->cf_bytes_sent );
			gtk_entry_set_text( GTK_ENTRY( Contacts[ cx ].file_info->cf_trans ),
			                    message );
			sprintf( message, "%d", Contacts[ cx ].file_info->b_bytes_sent );
			gtk_entry_set_text( GTK_ENTRY( Contacts[ cx ].file_info->b_trans ),
			                    message );
			t = time( NULL ) - Contacts[ cx ].file_info->cf_starttime;
			sprintf( message, "%02d:%02d:%02d", t/3600, (t%3600)/60, t%60 );
			gtk_entry_set_text( GTK_ENTRY( Contacts[ cx ].file_info->cf_time ),
			                    message );
			t = time( NULL ) - Contacts[ cx ].file_info->b_starttime;
			sprintf( message, "%02d:%02d:%02d", t/3600, (t%3600)/60, t%60 );
			gtk_entry_set_text( GTK_ENTRY( Contacts[ cx ].file_info->b_time ),
			                    message );
			if( Contacts[ cx ].file_info->cf_bytes_sent && Contacts[ cx ].file_info->cf_starttime != time( NULL ) )
				sprintf( message, "%ld B/sec",
				         Contacts[ cx ].file_info->cf_bytes_sent /
				         ( time( NULL ) - Contacts[ cx ].file_info->cf_starttime ) );
			else
				strcpy( message, "0 B/sec" );
			gtk_entry_set_text( GTK_ENTRY( Contacts[ cx ].file_info->cf_bps ),
			                    message );
			if( Contacts[ cx ].file_info->b_bytes_sent && Contacts[ cx ].file_info->b_starttime != time( NULL ) )
				sprintf( message, "%ld B/sec",
				         Contacts[ cx ].file_info->b_bytes_sent /
				         ( time( NULL ) - Contacts[ cx ].file_info->b_starttime ) );
			else
				strcpy( message, "0 B/sec" );
			gtk_entry_set_text( GTK_ENTRY( Contacts[ cx ].file_info->b_bps ),
			                    message );
			if( Contacts[ cx ].file_info->cf_bytes_sent == 0 ||
			    Contacts[ cx ].file_info->cf_totbytes == 0 )
				gtk_progress_bar_update( GTK_PROGRESS_BAR( Contacts[ cx ].file_info->cf_progress ), 0.0F );
			else
				gtk_progress_bar_update( GTK_PROGRESS_BAR( Contacts[ cx ].file_info->cf_progress ),
				                         (float)( (float)Contacts[ cx ].file_info->cf_bytes_sent / (float)Contacts[ cx ].file_info->cf_totbytes ) );
			if( Contacts[ cx ].file_info->b_bytes_sent == 0 ||
			    Contacts[ cx ].file_info->b_totbytes == 0 )
				gtk_progress_bar_update( GTK_PROGRESS_BAR( Contacts[ cx ].file_info->b_progress ), 0.0F );
			else
				gtk_progress_bar_update( GTK_PROGRESS_BAR( Contacts[ cx ].file_info->b_progress ),
				                         (float)( (float)Contacts[ cx ].file_info->b_bytes_sent / (float)Contacts[ cx ].file_info->b_totbytes ) );

			if( packet_size < 2049 ) /* Last packet */
				close( Contacts[ cx ].file_fd );

			gdk_input_remove( Contacts[ cx ].file_gdk_input );
			while( gtk_events_pending() )
				gtk_main_iteration();
			Contacts[ cx ].file_gdk_input = gdk_input_add( sock, GDK_INPUT_READ, (GdkInputFunction) TCPFileReadClient, NULL );

		break;
	}

	return TRUE;
}

int TCPFileReadServer( GtkWidget *widget, int sock, GdkInputCondition cond )
{
	int cx;
	unsigned short packet_size;
	BYTE *packet;
	BYTE buffer[1024];

	int size, index;

	char message[256];


	xfer2a pak2a;
	xfer2b pak2b;

#ifdef TRACE_FUNCTION
	g_print( "TCPFileReadServer\n" );
#endif

	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( Contacts[ cx ].file_sok == sock )
		break;
	}

	if( ( read( sock, (char*)(&packet_size), 1 ) ) <= 0 )
	{
		if( Contacts[ cx ].file_gdk_input )
		{
			gdk_input_remove( Contacts[ cx ].file_gdk_input );
			Contacts[ cx ].file_gdk_input = 0;
		}
		sprintf( message, "File transfer terminated:\n%s", Contacts[ cx ].nick );
		OK_Box( message, Contacts[ cx ].file_short_name );
		close( sock );

		Contacts[ cx ].file_sok = 0;
		Contacts[ cx ].file_port = 0;
		Contacts[ cx ].file_seq = 0;
		if( Contacts[ cx ].file_name != NULL )
			g_free( Contacts[ cx ].file_name );
		if( Contacts[ cx ].file_short_name != NULL )
			g_free( Contacts[ cx ].file_short_name );
		Contacts[ cx ].file_name = NULL;
		Contacts[ cx ].file_short_name = NULL;
		if( Contacts[ cx ].file_fd > 0 )
			close( Contacts[ cx ].file_fd );
		Contacts[ cx ].file_fd = 0;
		Contacts[ cx ].file_offset = 0;
		Contacts[ cx ].file_size = 0;

		if( Contacts[ cx ].file_info != NULL &&
		    Contacts[ cx ].file_info->window != NULL )
			gtk_widget_destroy( Contacts[ cx ].file_info->window );
		if( Contacts[ cx ].file_info != NULL )
			g_free( Contacts[ cx ].file_info );
		Contacts[ cx ].file_info = NULL;

		return TRUE;
	}

	read( sock, (char*)(&packet_size) + 1, 1 );

	packet = (BYTE *)g_malloc0( packet_size );
	read( sock, packet, packet_size );
	packet_print( packet, packet_size,
	              PACKET_TYPE_TCP | PACKET_DIRECTION_RECEIVE );

	switch( packet[ 0 ] )
	{
		case 0x01: /* We need to send XFER2 now */
			pak2a.id = 0x02;
			pak2a.zero = 0x00;
			Word_2_Chars( pak2a.fn_len, strlen( Contacts[ cx ].file_short_name ) + 1 );
			Word_2_Chars( pak2b.one, 0x0001 );
			pak2b.zero = 0;
			DW_2_Chars( pak2b.file_size, Contacts[ cx ].file_size );
			DW_2_Chars( pak2b.longzero, 0x00000000 );
			DW_2_Chars( pak2b.speed, 0x00000064 );
			
			size = sizeof( xfer2a ) + sizeof( xfer2b ) + strlen( Contacts[ cx ].file_short_name ) + 1;
			index = 0;
			memcpy( &buffer[ index ], &size, 2 );
			index += 2;
			memcpy( &buffer[ index ], &pak2a, sizeof( xfer2a ) );
			index += sizeof( xfer2a );
			memcpy( &buffer[ index ], Contacts[ cx ].file_short_name, strlen( Contacts[ cx ].file_short_name ) + 1 );
			index += strlen( Contacts[ cx ].file_short_name ) + 1;
			memcpy( &buffer[ index ], &pak2b, sizeof( xfer2b ) );
			index += sizeof( xfer2b );

			packet_print( &buffer[2], size,
			              PACKET_TYPE_TCP | PACKET_DIRECTION_SEND );
			write( Contacts[ cx ].file_sok, buffer, size + 2 );
			break;
		case 0x03: /* Start sending the file :) */
		/* The best way to do this is to set up a timeout to send it so we don't
		   freeze the program, especially on large files */
			memcpy( &Contacts[ cx ].file_offset, &packet[ 1 ], 4 );
			Contacts[ cx ].file_fd = open( Contacts[ cx ].file_name, O_RDONLY,
			                               S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH );
			if( Contacts[ cx ].file_fd == -1 )
			{
				if( Contacts[ cx ].file_gdk_input )
				{
					gdk_input_remove( Contacts[ cx ].file_gdk_input );
					Contacts[ cx ].file_gdk_input = 0;
				}
				sprintf( message, "File transfer terminated:\n%s", Contacts[ cx ].nick );
				OK_Box( message, Contacts[ cx ].file_short_name );
				close( sock );

				Contacts[ cx ].file_sok = 0;
				Contacts[ cx ].file_port = 0;
				Contacts[ cx ].file_seq = 0;
				if( Contacts[ cx ].file_name != NULL )
					g_free( Contacts[ cx ].file_name );
				if( Contacts[ cx ].file_short_name != NULL )
					g_free( Contacts[ cx ].file_short_name );
				Contacts[ cx ].file_name = NULL;
				Contacts[ cx ].file_short_name = NULL;
				if( Contacts[ cx ].file_fd > 0 )
					close( Contacts[ cx ].file_fd );
				Contacts[ cx ].file_fd = 0;
				Contacts[ cx ].file_offset = 0;
				Contacts[ cx ].file_size = 0;

				if( Contacts[ cx ].file_info != NULL &&
				    Contacts[ cx ].file_info->window != NULL )
					gtk_widget_destroy( Contacts[ cx ].file_info->window );
				if( Contacts[ cx ].file_info != NULL )
					g_free( Contacts[ cx ].file_info );
				Contacts[ cx ].file_info = NULL;

				return TRUE;
			}

			g_free( packet );

			if( Contacts[ cx ].file_offset > 0 )
			{
				packet = (BYTE*)g_malloc0( Contacts[ cx ].file_offset );
				read( Contacts[ cx ].file_fd, packet, Contacts[ cx ].file_offset );
				g_free( packet );
			}

			Contacts[ cx ].file_info = create_file_xfer_dialog(
			                           Contacts[ cx ].file_short_name,
			                           1, Contacts[ cx ].file_size,
			                           Contacts[ cx ].file_size );

			gtk_timeout_add( 5, (GtkFunction)TCPSendPartFile,
			                 GUINT_TO_POINTER( Contacts[ cx ].uin ) );
			break;
	}

	return TRUE;
}

int TCPChatHandshake( int cindex, int sock, GdkInputCondition cond )
{
	GtkWidget *textbox;
	int new_sock;
	int size = sizeof( struct sockaddr );
	struct sockaddr_in their_addr;

#ifdef TRACE_FUNCTION
	g_print( "TCPChatHandshake\n" );
#endif
	
	new_sock = accept( sock, ( struct sockaddr * )&their_addr, &size );
	Contacts[ cindex ].chat_sok = new_sock;
	Contacts[ cindex ].chat_port = g_ntohs( their_addr.sin_port );

	textbox = ChatWindowNew( cindex, new_sock );

	if( Contacts[ cindex ].chat_gdk_input )
		gtk_input_remove( Contacts[ cindex ].chat_gdk_input );

	fcntl( new_sock, O_NONBLOCK );
	Contacts[ cindex ].chat_gdk_input = gdk_input_add( new_sock, GDK_INPUT_READ, (GdkInputFunction) TCPChatReadClient, textbox );
	return TRUE;
}

int TCPFileHandshake( int cindex, int sock, GdkInputCondition cond )
{
	int new_sock;
	int size = sizeof( struct sockaddr );
	struct sockaddr_in their_addr;

#ifdef TRACE_FUNCTION
	g_print( "TCPFileHandshake\n" );
#endif
	
	new_sock = accept( sock, ( struct sockaddr * )&their_addr, &size );
	Contacts[ cindex ].file_sok = new_sock;
	Contacts[ cindex ].file_port = g_ntohs( their_addr.sin_port );

	if( Contacts[ cindex ].file_gdk_input )
		gtk_input_remove( Contacts[ cindex ].file_gdk_input );

	fcntl( new_sock, O_NONBLOCK );
	Contacts[ cindex ].file_gdk_input = gdk_input_add( new_sock, GDK_INPUT_READ, (GdkInputFunction) TCPFileReadClient, NULL );

	return TRUE;
}

int TCPConnectChat( DWORD port, DWORD uin, struct sokandlb *data )
{
	GtkWidget *textbox;
	DWORD localport;
	struct sockaddr_in local, remote;
	int sizeofSockaddr = sizeof( struct sockaddr );
	int sock;
	int cindex;
	DWORD ip;
	unsigned short size;
	BYTE buffer[1024];

	typedef struct
	{
		BYTE code;
		BYTE version[4];
		BYTE chat_porta[4];
		BYTE uin[4];
		BYTE ip_local[4];
		BYTE ip_remote[4];
		BYTE four;
		BYTE chat_portb[4];
	} handshake_a;

	typedef struct
	{
		BYTE code[4];
		BYTE biga[4];
		BYTE uin[4];
		BYTE name_length[2];
	} handshake_b;
	
	typedef struct
	{
		BYTE revporta;
		BYTE revportb;
		BYTE foreground[4];
		BYTE background[4];
		BYTE zero;
	} handshake_c;

	handshake_a hsa;
	handshake_b hsb;
	handshake_c hsc;

#ifdef TRACE_FUNCTION
	g_print( "TCPConnectChat\n" );
#endif

	for( cindex = 0; cindex < Num_Contacts; cindex ++ )
	{
		if( Contacts[ cindex ].uin == uin )
			break;
	}

	if( Contacts[ cindex ].chat_sok > 0 )
		return Contacts[ cindex ].chat_sok;

	ip = Contacts[ cindex ].current_ip;

	if( ip == 0 )
	{
		return -1;
	}

	sock = socket( AF_INET, SOCK_STREAM, 0 );
	if( sock == -1 )
	{
		return -1;
	}

	fcntl( sock, O_NONBLOCK );

	memset( &local.sin_zero, 0x00, 8 );
	memset( &remote.sin_zero, 0x00, 8 );
	
	local.sin_family = AF_INET;
	remote.sin_family = AF_INET;
	local.sin_port = g_htons( 0 );
	local.sin_addr.s_addr = g_htonl( INADDR_ANY );

	remote.sin_port = g_htons( port );
	remote.sin_addr.s_addr = g_htonl( ip );

	if( connect( sock, (struct sockaddr *)&remote, sizeofSockaddr ) < 0 )
	{
		return -1;
	}

	getsockname( sock, (struct sockaddr*)&local, &sizeofSockaddr );
	localport = g_ntohs( local.sin_port );

	textbox = ChatWindowNew( cindex, sock );

	fcntl( sock, O_NONBLOCK );
	Contacts[ cindex ].chat_gdk_input = gdk_input_add( sock, GDK_INPUT_READ, (GdkInputFunction) TCPChatReadServer, textbox );

	Contacts[ cindex ].chat_sok = sock;
	Contacts[ cindex ].chat_port = localport;

	hsa.code = 0xFF;
	DW_2_Chars( hsa.version, 0x00000004 );
	DW_2_Chars( hsa.uin, our_info->uin );
	DW_2_Chars( hsa.ip_local, our_ip );
	DW_2_Chars( hsa.ip_remote, our_ip );
	hsa.four = 0x04;
	DW_2_Chars( hsa.chat_portb, (DWORD)localport );
	DW_2_Chars( hsa.chat_porta, (DWORD)localport );
	
	size = sizeof( handshake_a );
	memcpy( &buffer[0], &size, 2 );
	memcpy( &buffer[2], &hsa, size );
	write( sock, buffer, size + 2 );
	packet_print( &buffer[2], size,
	              PACKET_TYPE_TCP | PACKET_DIRECTION_SEND );
	
	DW_2_Chars( hsb.code, 0x00000064 );
	DW_2_Chars( hsb.biga, 0xFFFFFFFC );
	DW_2_Chars( hsb.uin, our_info->uin );
	Word_2_Chars( hsb.name_length, strlen( our_info->nick ) + 1 );
	hsc.revporta = ((char *)(&localport))[1];
	hsc.revportb = ((char *)(&localport))[0];
	DW_2_Chars( hsc.foreground, 0x00FFFFFF );
	DW_2_Chars( hsc.background, 0x00000000 );
	hsc.zero = 0x00;

	size = sizeof( handshake_b ) + sizeof( handshake_c ) + strlen( our_info->nick ) + 1;
	memset( (void *)buffer, 0x00, 1024 );
	memcpy( &buffer[0], &size, 2 );
	memcpy( &buffer[2], &hsb, sizeof( handshake_b ) );
	memcpy( &buffer[ 2 + sizeof( handshake_b ) ], our_info->nick, strlen( our_info->nick ) + 1 );
	memcpy( &buffer[ 3 + sizeof( handshake_b ) + strlen( our_info->nick ) ], &hsc, sizeof( handshake_c ) );
	write( sock, buffer, size + 2 );
	packet_print( &buffer[2], size,
	              PACKET_TYPE_TCP | PACKET_DIRECTION_SEND );

	return sock;
}

int TCPConnectFile( DWORD port, DWORD uin, struct sokandlb *data )
{
	DWORD localport;
	struct sockaddr_in local, remote;
	int sizeofSockaddr = sizeof( struct sockaddr );
	int sock;
	int cindex;
	DWORD ip;
	BYTE buffer[1024];
	int index, psize;

	struct stat file_stat;

	typedef struct
	{
		BYTE id; /* 0xff */
		BYTE version[4]; /* 0x00000003 */
		BYTE port[4]; /* TCP listen port */
		BYTE uin[4]; /* UIN */
		BYTE ipa[4]; /* IP A */
		BYTE ipb[4]; /* IP B */
		BYTE four; /* 0x04 */
		BYTE listenport[4]; /* File listen port */
	} handshake;

	handshake hs;
	xfer0 pak;

#ifdef TRACE_FUNCTION
	g_print( "TCPConnectFile\n" );
#endif

	for( cindex = 0; cindex < Num_Contacts; cindex ++ )
	{
		if( Contacts[ cindex ].uin == uin )
			break;
	}

	if( Contacts[ cindex ].file_sok > 0 )
		return Contacts[ cindex ].file_sok;

	ip = Contacts[ cindex ].current_ip;

	if( ip == 0 )
	{
		return -1;
	}

	sock = socket( AF_INET, SOCK_STREAM, 0 );
	if( sock == -1 )
	{
		return -1;
	}

	fcntl( sock, O_NONBLOCK );

	memset( &local.sin_zero, 0x00, 8 );
	memset( &remote.sin_zero, 0x00, 8 );
	
	local.sin_family = AF_INET;
	remote.sin_family = AF_INET;
	local.sin_port = g_htons( 0 );
	local.sin_addr.s_addr = g_htonl( INADDR_ANY );

	remote.sin_port = g_htons( port );
	remote.sin_addr.s_addr = g_htonl( ip );

	if( connect( sock, (struct sockaddr *)&remote, sizeofSockaddr ) < 0 )
	{
		return -1;
	}

	getsockname( sock, (struct sockaddr*)&local, &sizeofSockaddr );
	localport = g_ntohs( local.sin_port );

	if( stat( Contacts[ cindex ].file_name, &file_stat ) == -1 )
		return FALSE;

	Contacts[ cindex ].file_size = file_stat.st_size;

	hs.id = 0xff;
	DW_2_Chars( hs.version, 0x00000003 );
	DW_2_Chars( hs.port, our_port );
	DW_2_Chars( hs.uin, our_info->uin );
	DW_2_Chars( hs.ipa, our_ip );
	DW_2_Chars( hs.ipb, LOCALHOST );
	hs.four = 0x04;
	DW_2_Chars( hs.listenport, localport );

	Word_2_Chars( pak.psize, sizeof( xfer0 ) - 2 + strlen( our_info->nick ) + 1 );
	pak.id = 0x00;
	DW_2_Chars( pak.zero, 0x00000000 );
	DW_2_Chars( pak.n_files, 0x00000001 );
	DW_2_Chars( pak.n_bytes, file_stat.st_size );
	DW_2_Chars( pak.speed, 0x00000064 );
	Word_2_Chars( pak.nick_len, strlen( our_info->nick ) + 1 );

	fcntl( sock, O_NONBLOCK );
	Contacts[ cindex ].file_gdk_input = gdk_input_add( sock, GDK_INPUT_READ, (GdkInputFunction) TCPFileReadServer, NULL );

	Contacts[ cindex ].file_sok = sock;

	index = 0;
	psize = sizeof( handshake );
	memcpy( &buffer[ index ], &psize, 2 );
	index += 2;
	memcpy( &buffer[ index ], &hs, sizeof( handshake ) );

	packet_print( &buffer[2], psize,
	              PACKET_TYPE_TCP | PACKET_DIRECTION_SEND );
	write( sock, buffer, psize + 2 );

	index = 0;
	memcpy( &buffer[ index ], &pak, sizeof( xfer0 ) );
	psize = sizeof( xfer0 );
	index += sizeof( xfer0 );
	memcpy( &buffer[ index ], our_info->nick, strlen( our_info->nick ) + 1 );

	psize += strlen( our_info->nick ) + 1;

	packet_print( &buffer[2], psize - 2,
	              PACKET_TYPE_TCP | PACKET_DIRECTION_SEND );
	write( sock, buffer, psize );

	return sock;
}

int TCPRefuseChat( int sock, int cindex, DWORD seq )
{
	char buffer[1024];
	unsigned short intsize;

	typedef struct
	{
		BYTE uin1[4];
		BYTE version[2];
		BYTE command[2];
		BYTE zero[2];
		BYTE uin2[4];
		BYTE cmd[2];
		BYTE message_length[2];
	} tcp_head;

	typedef struct
	{
		BYTE ip[4];
		BYTE ip_real[4];
		BYTE porta[4];
		BYTE junk;
		BYTE status[4];
		BYTE zeroa[4];
		BYTE zerob[4];
		BYTE zeroc[2];
		BYTE zerod;
		BYTE seq[4];
	} tcp_tail;

	tcp_head pack_head;
	tcp_tail pack_tail;

#ifdef TRACE_FUNCTION
	g_print( "TCPRefuseChat\n" );
#endif

	DW_2_Chars( pack_head.uin1, our_info->uin );
	Word_2_Chars( pack_head.version, 0x0003 );
	Word_2_Chars( pack_head.command, ICQ_CMDxTCP_ACK );
	Word_2_Chars( pack_head.zero, 0x0000 );
	DW_2_Chars( pack_head.uin2, our_info->uin );
	DW_2_Chars( pack_head.cmd, ICQ_CMDxTCP_CHAT );
	DW_2_Chars( pack_head.message_length, 1 );
	
	DW_2_Chars( pack_tail.ip, our_ip );
	DW_2_Chars( pack_tail.ip_real, LOCALHOST );
	DW_2_Chars( pack_tail.porta, our_port );
	pack_tail.junk = 0x04;
	DW_2_Chars( pack_tail.status, ICQ_ACKxTCP_REFUSE );

	DW_2_Chars( pack_tail.zeroa, 0x00000001 );
	DW_2_Chars( pack_tail.zerob, 0x00000000 );
	DW_2_Chars( pack_tail.zeroc, 0x00000000 );
	pack_tail.zerod = 0x00;
	DW_2_Chars( pack_tail.seq, seq );

	if( sock != -1 )
	{
		intsize = sizeof( tcp_head ) + sizeof( tcp_tail ) + 1;
		memcpy( &buffer[0], &intsize, 2 );
		memcpy( &buffer[2], &pack_head, sizeof( pack_head ) );
		buffer[2 + sizeof( pack_head )] = 0x00;
		memcpy( &buffer[2 + sizeof( pack_head ) + 1 ],
		        &pack_tail, sizeof( pack_tail ) );
		write( sock, buffer, intsize + 2 );
		packet_print( &buffer[2], intsize,
		              PACKET_TYPE_TCP | PACKET_DIRECTION_SEND );
	}
	else
	{
		return -1;
	}
	return 1;
}

int TCPRefuseFile( int sock, int cindex, DWORD seq )
{
	char buffer[1024];
	unsigned short intsize;

	typedef struct
	{
		BYTE uin1[4];
		BYTE version[2];
		BYTE command[2];
		BYTE zero[2];
		BYTE uin2[4];
		BYTE cmd[2];
		BYTE message_length[2];
	} tcp_head;

	typedef struct
	{
		BYTE ip[4];
		BYTE ip_real[4];
		BYTE porta[4];
		BYTE junk;
		BYTE status[4];
		BYTE zeroa[4];
		BYTE zerob[4];
		BYTE zeroc[2];
		BYTE zerod;
		BYTE seq[4];
	} tcp_tail;

	tcp_head pack_head;
	tcp_tail pack_tail;

#ifdef TRACE_FUNCTION
	g_print( "TCPRefuseFile\n" );
#endif

	DW_2_Chars( pack_head.uin1, our_info->uin );
	Word_2_Chars( pack_head.version, 0x0003 );
	Word_2_Chars( pack_head.command, ICQ_CMDxTCP_ACK );
	Word_2_Chars( pack_head.zero, 0x0000 );
	DW_2_Chars( pack_head.uin2, our_info->uin );
	DW_2_Chars( pack_head.cmd, ICQ_CMDxTCP_FILE );
	DW_2_Chars( pack_head.message_length, 1 );
	
	DW_2_Chars( pack_tail.ip, our_ip );
	DW_2_Chars( pack_tail.ip_real, LOCALHOST );
	DW_2_Chars( pack_tail.porta, our_port );
	pack_tail.junk = 0x04;
	DW_2_Chars( pack_tail.status, ICQ_ACKxTCP_REFUSE );

	DW_2_Chars( pack_tail.zeroa, 0x00000001 );
	DW_2_Chars( pack_tail.zerob, 0x00000000 );
	DW_2_Chars( pack_tail.zeroc, 0x00000000 );
	pack_tail.zerod = 0x00;
	DW_2_Chars( pack_tail.seq, seq );

	if( sock != -1 )
	{
		intsize = sizeof( tcp_head ) + sizeof( tcp_tail ) + 1;
		memcpy( &buffer[0], &intsize, 2 );
		memcpy( &buffer[2], &pack_head, sizeof( pack_head ) );
		buffer[2 + sizeof( pack_head )] = 0x00;
		memcpy( &buffer[2 + sizeof( pack_head ) + 1 ],
		        &pack_tail, sizeof( pack_tail ) );
		write( sock, buffer, intsize + 2 );
		packet_print( &buffer[2], intsize,
		              PACKET_TYPE_TCP | PACKET_DIRECTION_SEND );
	}
	else
	{
		return -1;
	}
	return 1;
}

int TCPAcceptChat( int sock, int cindex, DWORD seq )
{
	char buffer[1024];
	unsigned short intsize;
	int chat_sock;
	unsigned short chat_port, backport, tempport;
	int length = sizeof( struct sockaddr );

	typedef struct
	{
		BYTE uin1[4];
		BYTE version[2];
		BYTE command[2];
		BYTE zero[2];
		BYTE uin2[4];
		BYTE cmd[2];
		BYTE message_length[2];
	} tcp_head;

	typedef struct
	{
		BYTE ip[4];
		BYTE ip_real[4];
		BYTE porta[4];
		BYTE junk;
		BYTE status[4];
		BYTE one[2];
		BYTE zero;
		BYTE back_port[4];
		BYTE portb[4];
		BYTE seq[4];
	} tcp_tail;

	tcp_head pack_head;
	tcp_tail pack_tail;

	struct sockaddr_in my_addr;

#ifdef TRACE_FUNCTION
	g_print( "TCPAcceptChat\n" );
#endif

	chat_sock = socket( AF_INET, SOCK_STREAM, 0 );
	if( chat_sock <= 0 )
		return FALSE;

	fcntl( chat_sock, O_NONBLOCK );
	
	my_addr.sin_family = AF_INET;
	my_addr.sin_port = 0;
	my_addr.sin_addr.s_addr = INADDR_ANY;
	memset(&(my_addr.sin_zero), 0x00, 8 );
	
	if( bind( chat_sock, (struct sockaddr *)&my_addr, sizeof( struct sockaddr ) ) == -1 )
		return FALSE;

	listen( chat_sock, 1 );
	Contacts[ cindex ].chat_gdk_input =
		gdk_input_add( chat_sock, GDK_INPUT_READ,
			       (GdkInputFunction) TCPChatHandshake,
			       GINT_TO_POINTER( cindex ) );

	getsockname( chat_sock, ( struct sockaddr * ) &my_addr, &length );
	
	chat_port = g_ntohs( my_addr.sin_port );

	tempport = chat_port;
	backport = ( tempport >> 8 ) + ( tempport << 8 );

	DW_2_Chars( pack_head.uin1, our_info->uin );
	Word_2_Chars( pack_head.version, 0x0003 );
	Word_2_Chars( pack_head.command, ICQ_CMDxTCP_ACK );
	Word_2_Chars( pack_head.zero, 0x0000 );
	DW_2_Chars( pack_head.uin2, our_info->uin );
	DW_2_Chars( pack_head.cmd, ICQ_CMDxTCP_CHAT );
	DW_2_Chars( pack_head.message_length, 1 );

	DW_2_Chars( pack_tail.ip, 0x00000000 );
	DW_2_Chars( pack_tail.ip_real, LOCALHOST );
	DW_2_Chars( pack_tail.porta, our_port );
	pack_tail.junk = 0x04;
	DW_2_Chars( pack_tail.status, ICQ_ACKxTCP_ONLINE );

	DW_2_Chars( pack_tail.one, 0x0001 );
	pack_tail.zero = 0x00;
	DW_2_Chars( pack_tail.back_port, backport );
	DW_2_Chars( pack_tail.portb, chat_port );
	DW_2_Chars( pack_tail.seq, seq );
	if( sock != -1 )
	{
		intsize = sizeof( tcp_head ) + sizeof( tcp_tail ) + 1;
		memcpy( &buffer[0], &intsize, 2 );
		memcpy( &buffer[2], &pack_head, sizeof( pack_head ) );
		buffer[2 + sizeof( pack_head )] = 0x00;
		memcpy( &buffer[2 + sizeof( pack_head ) + 1 ],
		        &pack_tail, sizeof( pack_tail ) );
		write( sock, buffer, intsize + 2 );
		packet_print( &buffer[2], intsize,
		              PACKET_TYPE_TCP | PACKET_DIRECTION_SEND );
	}
	else
	{
		return -1;
	}

	return 1;
}

int TCPAcceptFile( int sock, int cindex, DWORD seq )
{
	char buffer[1024];
	unsigned short intsize;
	int file_sock;
	unsigned short file_port, backport, tempport;
	int length = sizeof( struct sockaddr );

	typedef struct
	{
		BYTE uin1[4];
		BYTE version[2];
		BYTE command[2];
		BYTE zero[2];
		BYTE uin2[4];
		BYTE cmd[2];
		BYTE message_length[2];
	} tcp_head;

	typedef struct
	{
		BYTE ip[4];
		BYTE ip_real[4];
		BYTE porta[4];
		BYTE junk;
		BYTE status[4];
		BYTE back_port[4];
		BYTE one[2];
		BYTE zero;
		BYTE bigzero[4];
		BYTE portb[4];
		BYTE seq[4];
	} tcp_tail;

	tcp_head pack_head;
	tcp_tail pack_tail;

	struct sockaddr_in my_addr;

#ifdef TRACE_FUNCTION
	g_print( "TCPAcceptFile\n" );
#endif

	file_sock = socket( AF_INET, SOCK_STREAM, 0 );
	if( file_sock <= 0 )
		return FALSE;

	fcntl( file_sock, O_NONBLOCK );

	my_addr.sin_family = AF_INET;
	my_addr.sin_port = 0;
	my_addr.sin_addr.s_addr = INADDR_ANY;
	memset(&(my_addr.sin_zero), 0x00, 8);
	
	if( bind( file_sock, (struct sockaddr *)&my_addr, sizeof( struct sockaddr ) ) == -1 )
		return FALSE;

	listen( file_sock, 1 );
	Contacts[ cindex ].file_gdk_input =
		gdk_input_add( file_sock, GDK_INPUT_READ,
			       (GdkInputFunction) TCPFileHandshake,
			       GINT_TO_POINTER( cindex ) );

	getsockname( file_sock, ( struct sockaddr * ) &my_addr, &length );

	file_port = g_ntohs( my_addr.sin_port );

	tempport = file_port;
	backport = ( tempport >> 8 ) + ( tempport << 8 );

	DW_2_Chars( pack_head.uin1, our_info->uin );
	Word_2_Chars( pack_head.version, 0x0003 );
	Word_2_Chars( pack_head.command, ICQ_CMDxTCP_ACK );
	Word_2_Chars( pack_head.zero, 0x0000 );
	DW_2_Chars( pack_head.uin2, our_info->uin );
	DW_2_Chars( pack_head.cmd, ICQ_CMDxTCP_FILE );
	DW_2_Chars( pack_head.message_length, 1 );

	DW_2_Chars( pack_tail.ip, our_ip );
	DW_2_Chars( pack_tail.ip_real, LOCALHOST );
	DW_2_Chars( pack_tail.porta, our_port );
	pack_tail.junk = 0x04;
	DW_2_Chars( pack_tail.status, ICQ_ACKxTCP_ONLINE );
	DW_2_Chars( pack_tail.portb, tempport );
	DW_2_Chars( pack_tail.one, 0x0001 );
	pack_tail.zero = 0x00;
	DW_2_Chars( pack_tail.bigzero, backport );
	DW_2_Chars( pack_tail.back_port, backport );
	DW_2_Chars( pack_tail.seq, seq );
	if( sock != -1 )
	{
		intsize = sizeof( tcp_head ) + sizeof( tcp_tail ) + 1;
		memcpy( &buffer[0], &intsize, 2 );
		memcpy( &buffer[2], &pack_head, sizeof( pack_head ) );
		buffer[2 + sizeof( pack_head )] = 0x00;
		memcpy( &buffer[2 + sizeof( pack_head ) + 1 ],
		        &pack_tail, sizeof( pack_tail ) );
		write( sock, buffer, intsize + 2 );
		packet_print( &buffer[2], intsize,
		              PACKET_TYPE_TCP | PACKET_DIRECTION_SEND );
	}
	else
	{
		return -1;
	}

	return 1;
}

int TCPAckPacket( int sock, int cindex, WORD cmd, int seq )
{
	char buffer[1024];
	unsigned short intsize;
	char *sent_message;

	typedef struct
	{
		BYTE uin1[4];
		BYTE version[2];
		BYTE command[2];
		BYTE zero[2];
		BYTE uin2[4];
		BYTE cmd[2];
		BYTE message_length[2];
	} tcp_head;

	typedef struct
	{
		BYTE ip[4];
		BYTE ip_real[4];
		BYTE port[4];
		BYTE junk;
		BYTE status[4];
		BYTE seq[4];
	} tcp_tail;

	tcp_head pack_head;
	tcp_tail pack_tail;

#ifdef TRACE_FUNCTION
	g_print( "TCPAckPacket\n" );
#endif

	sent_message = "";
	if( Current_Status != STATUS_ONLINE && Current_Status != STATUS_FREE_CHAT )
		sent_message = Away_Message;
	
	DW_2_Chars( pack_head.uin1, our_info->uin );
	Word_2_Chars( pack_head.version, 0x0003 );
	Word_2_Chars( pack_head.command, ICQ_CMDxTCP_ACK );
	Word_2_Chars( pack_head.zero, 0x0000 );
	DW_2_Chars( pack_head.uin2, our_info->uin );
	DW_2_Chars( pack_head.cmd, cmd );
	DW_2_Chars( pack_head.message_length, strlen( sent_message ) + 1 );
	
	DW_2_Chars( pack_tail.ip, our_ip );
	DW_2_Chars( pack_tail.ip_real, LOCALHOST );
	DW_2_Chars( pack_tail.port, our_port );
	pack_tail.junk = 0x04;
	DW_2_Chars( pack_tail.seq, seq );

	switch( Current_Status )
	{
		DWORD status;
		case STATUS_ONLINE:
			DW_2_Chars( pack_tail.status, ICQ_ACKxTCP_ONLINE );
			break;
		case STATUS_AWAY:
			DW_2_Chars( pack_tail.status, ICQ_ACKxTCP_AWAY );
			break;
		case STATUS_DND:
			DW_2_Chars( pack_tail.status, ICQ_ACKxTCP_DND );
			break;
		case STATUS_OCCUPIED:
			/* Don't ask me why this is - I just follow precedent */
			DW_2_Chars( pack_tail.status, ICQ_ACKxTCP_ONLINE );
			break;
		case STATUS_NA:
			DW_2_Chars( pack_tail.status, ICQ_ACKxTCP_NA );
			break;
		case STATUS_INVISIBLE:
			/* only refuse those not in our visible list */
			if( Contacts[ cindex ].vis_list )
				status = ICQ_ACKxTCP_ONLINE;
			else
				status = ICQ_ACKxTCP_REFUSE;
			DW_2_Chars( pack_tail.status, status );
			break;

		}

	if( sock != -1 )
	{
		intsize = sizeof( tcp_head ) + sizeof( tcp_tail ) + strlen( sent_message ) + 1;
		memcpy( &buffer[0], &intsize, 2 );
		memcpy( &buffer[2], &pack_head, sizeof( pack_head ) );
		memcpy( &buffer[2 + sizeof( pack_head )], sent_message,
		        strlen( sent_message ) + 1 );
		memcpy( &buffer[2 + sizeof( pack_head ) + strlen( sent_message ) + 1 ],
		        &pack_tail, sizeof( pack_tail ) );
		write( sock, buffer, intsize + 2 );
		packet_print( &buffer[2], intsize,
		              PACKET_TYPE_TCP | PACKET_DIRECTION_SEND );
	}
	else
	{
		return -1;
	}
	return 1;
}


void TCPProcessPacket( BYTE *packet, int packet_length, int sock, struct sokandlb *data )
{
	int chat_sock;
	int file_sock;
	int cx;
	BYTE *size;

	typedef struct
	{
		DWORD uin1;
		WORD version;
		WORD command;
		WORD zero;
		DWORD uin2;
		WORD cmd;
		WORD message_length;
	} tcp_head;

	typedef struct
	{
		DWORD ip_sender;
		DWORD ip_local;
		DWORD port;
		BYTE junk;
		DWORD status;
		DWORD chat_port;
		DWORD seq;
	} tcp_tail;

	typedef struct
	{
		WORD name_len;
		char *name;
		DWORD size;
		DWORD zero;
		DWORD seq;
	} tcp_file;

	char *message;
	char *away_message;
	tcp_head pack_head;
	tcp_tail pack_tail;
	tcp_file pack_file;

	int cindex;

	DWORD i;

#ifdef TRACE_FUNCTION
	g_print( "TCPProcessPacket\n" );
#endif

	if( packet[0] == 0xFF ) /* 0xFF means it's just a "Hello" packet; ignore */
		return;

	size = packet;
	memcpy( &pack_head.uin1, size, 4 );
	size += 4;
	memcpy( &pack_head.version, size, 2 );
	size += 2;
	memcpy( &pack_head.command, size, 2 );
	size += 2;
	memcpy( &pack_head.zero, size, 2 );
	size += 2;
	memcpy( &pack_head.uin2, size, 4 );
	size += 4;
	memcpy( &pack_head.cmd, size, 2 );
	size += 2;
	memcpy( &pack_head.message_length, size, 2 );
	size += 2;

	message = (char *)g_malloc0( pack_head.message_length );
	memcpy( message, size,
	        pack_head.message_length );
	size += pack_head.message_length;
	memcpy( &pack_tail.ip_sender, size, 4 );
	size += 4;
	memcpy( &pack_tail.ip_local, size, 4 );
	size += 4;
	memcpy( &pack_tail.port, size, 4 );
	size += 4;
	memcpy( &pack_tail.junk, size, 1 );
	size ++;
	memcpy( &pack_tail.status, size, 4 );
	size += 4;
	if( pack_head.command == ICQ_CMDxTCP_ACK && pack_head.cmd == ICQ_CMDxTCP_FILE )
	{
		size += 11;
		memcpy( &pack_tail.chat_port, size, 4 );
		size += 4;
	}
	if( pack_head.cmd == ICQ_CMDxTCP_CHAT )
	{
		size += 7; /* What is this supposed to be? */
		memcpy( &pack_tail.chat_port, size, 4 );
		size += 4;
	}
	memcpy( &pack_tail.seq, size, 4 );
	size += 4;

	i = pack_tail.ip_sender;
	pack_tail.ip_sender = ( ( i << 24 ) | ( ( i & 0xff00 ) << 8 ) | ( ( i & 0xff0000 ) >> 8 ) | ( i >> 24 ) );
	i = pack_tail.ip_local;
	pack_tail.ip_local = ( ( i << 24 ) | ( ( i & 0xff00 ) << 8 ) | ( ( i & 0xff0000 ) >> 8 ) | ( i >> 24 ) );

   switch( pack_head.command )
   {
   case ICQ_CMDxTCP_START:
      switch( pack_head.cmd )
      {
      case ICQ_CMDxTCP_MSG:
			cindex = Do_Msg( 0, message, pack_head.uin1, data, 'm' );
			log_window_add( "Received Message (TCP)", 1, pack_head.uin1 );
			TCPAckPacket( sock, cindex, pack_head.cmd, pack_tail.seq );
         break;
      case ICQ_CMDxTCP_READxAWAYxMSG:
      case ICQ_CMDxTCP_READxOCCxMSG:
      case ICQ_CMDxTCP_READxDNDxMSG:
      case ICQ_CMDxTCP_READxNAxMSG:
			for( cindex = 0; cindex < Num_Contacts; cindex ++ )
			{
				if( Contacts[ cindex ].uin == pack_head.uin1 )
					break;
			}
			if( Current_Status != STATUS_ONLINE &&
			    Current_Status != STATUS_FREE_CHAT && cindex != Num_Contacts )
				TCPAckPacket( sock, cindex, ICQ_CMDxTCP_READxAWAYxMSG,
				              pack_tail.seq );
         break;

      case ICQ_CMDxTCP_URL:  /* url sent */
			cindex = Do_Msg( 0, message, pack_head.uin1, data, 'u' );
			TCPAckPacket( sock, cindex, pack_head.cmd, pack_tail.seq );
         break;

      case ICQ_CMDxTCP_CHAT:
			cindex = Do_Chat( 0, message, pack_head.uin1, data, pack_tail.seq );
			if( Current_Status == STATUS_FREE_CHAT )
				TCPAcceptChat( sock, cindex, pack_tail.seq );
			break;

      case ICQ_CMDxTCP_FILE:
			memcpy( &pack_file.name_len, size, 2 );
			size += 2;
			pack_file.name = (char*)g_malloc0( pack_file.name_len );
			memcpy( pack_file.name, size, pack_file.name_len );
			size += pack_file.name_len;
			memcpy( &pack_file.size, size, 4 );
			size += 4;
			memcpy( &pack_file.zero, size, 4 );
			size += 4;
			memcpy( &pack_file.seq, size, 4 );
			
			cindex = Do_File( 0, message, pack_head.uin1, data, pack_file.seq );
			Contacts[ cindex ].file_short_name = (char*)g_malloc0( strlen( pack_file.name ) + 1 );
			strcpy( Contacts[ cindex ].file_short_name, pack_file.name );
			Contacts[ cindex ].file_size = pack_file.size;
			gnomeicu_event( EV_FILEREQ );

         break;      

      default:
         break;
      }
      break;

   case ICQ_CMDxTCP_ACK:
      
      switch ( pack_head.cmd )
      {
			case ICQ_CMDxTCP_MSG:
      	case ICQ_CMDxTCP_READxAWAYxMSG:
      	case ICQ_CMDxTCP_READxOCCxMSG:
      	case ICQ_CMDxTCP_READxDNDxMSG:
      	case ICQ_CMDxTCP_READxNAxMSG:
			case ICQ_CMDxTCP_URL:
				for( cx = 0; cx < Num_Contacts; cx ++ )
				{
					if( Contacts[ cx ].uin == pack_head.uin1 )
						break;
				}

				if( cx != Num_Contacts && ( pack_head.cmd == ICQ_CMDxTCP_MSG ||
				                            pack_head.cmd == ICQ_CMDxTCP_URL ) )
				{
					gtk_timeout_remove( Contacts[ cx ].wait );
					gtk_statusbar_pop( GTK_STATUSBAR( statusbar ),
					                   2 + Contacts[ cx ].wait );
				}

				if( pack_tail.status == ICQ_ACKxTCP_AWAY ||
				    pack_tail.status == ICQ_ACKxTCP_NA   ||
				    pack_tail.status == ICQ_ACKxTCP_DND  ||
				    pack_tail.status == ICQ_ACKxTCP_OCC )
				{
					away_message = (char*)g_malloc0( strlen( Contacts[ cx ].nick ) + 27 );
					switch( pack_tail.status )
					{
						case ICQ_ACKxTCP_AWAY:
							sprintf( away_message, "User %s is Away:", Contacts[ cx ].nick );
							break;
						case ICQ_ACKxTCP_NA:
							sprintf( away_message, "User %s is Not Available:", Contacts[ cx ].nick );
							break;
						case ICQ_ACKxTCP_DND:
							sprintf( away_message, "User %s cannot be disturbed:", Contacts[ cx ].nick );
							break;
						case ICQ_ACKxTCP_OCC:
							sprintf( away_message, "User %s is Occupied:", Contacts[ cx ].nick );
							break;
					}
	
					AMessage_Box( away_message, message, Contacts[ cx ].uin );
					g_free( away_message );
				}
        	 break;
			case ICQ_CMDxTCP_CHAT:
				if( pack_tail.chat_port > 0 )
					chat_sock = TCPConnectChat( pack_tail.chat_port, pack_head.uin1, data );
      	   break;
			case ICQ_CMDxTCP_FILE:
				if( pack_tail.chat_port > 0 )
					file_sock = TCPConnectFile( pack_tail.chat_port, pack_head.uin1, data );
      	   break;
			default:
				break;
		}
		break;
      
	case ICQ_CMDxTCP_CANCEL:
      switch ( pack_head.cmd )
      {
      case ICQ_CMDxTCP_CHAT:
			OK_Box( "Chat Request Cancelled", message );
         break;
      
      case ICQ_CMDxTCP_FILE:
			OK_Box( "File Transfer Cancelled", message );
         break;
      
      default:
         break;
      }
      break;
   
   default:
      break;
   }

	g_free( message );
} 

int TCPInitChannel( dataandint *data, int sock, GdkInputCondition cond )
{
	DWORD uin;
	int cx;
	unsigned short packet_size;
	BYTE *packet;

	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( Contacts[ cx ].sok == sock )
		break;
	}

#ifdef TRACE_FUNCTION
	g_print( "TCPInitChannel\n" );
#endif
	
	read( sock, (char*)(&packet_size), 1 );
	if( ( read( sock, (char*)(&packet_size) + 1, 1 ) ) <= 0 )
	{
		Contacts[ cx ].sok = 0;
		if( Contacts[ cx ].tcp_gdk_input )
		{
			gdk_input_remove( Contacts[ cx ].tcp_gdk_input );
			Contacts[ cx ].tcp_gdk_input = 0;
		}
		close( sock );
		return TRUE;
	}

	packet = (BYTE *)g_malloc0( packet_size );
	read( sock, packet, packet_size );

	memcpy( &uin, ( packet + 9 ), 4 );
	
	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( Contacts[ cx ].uin == uin )
		{
			Contacts[ cx ].sok = sock;
			break;
		}
	}

	if( packet_size < 1024 )
	{
		packet_print( packet, packet_size,
		              PACKET_TYPE_TCP | PACKET_DIRECTION_RECEIVE );
		TCPProcessPacket( packet, packet_size, sock, data->data );
	}

	gdk_input_remove( data->i );
	Contacts[ cx ].tcp_gdk_input = gdk_input_add( sock, GDK_INPUT_READ, (GdkInputFunction) TCPReadPacket, data->data );

	g_free( data );
	g_free( packet );
	return TRUE;
}

int TCPAcceptIncoming( struct sokandlb *data, int sock, GdkInputCondition cond )
{
	dataandint *pass_data = (dataandint *)g_malloc0( sizeof( dataandint ) );
	struct sockaddr_in addr;
	int size = sizeof( struct sockaddr_in );
	int new_sock;

#ifdef TRACE_FUNCTION
	g_print( "TCPAcceptIncoming\n" );
#endif
	
	new_sock = accept( sock, (struct sockaddr *)&addr, &size );
	if( new_sock == -1 )
	{
		return 0;
	}

	pass_data->data = data;
	pass_data->i = gdk_input_add( new_sock, GDK_INPUT_READ, (GdkInputFunction) TCPInitChannel, pass_data );

	return 1;
}

int TCPReadPacket( struct sokandlb *data, int sock, GdkInputCondition cond )
{
	DWORD uin;
	int cx;
	unsigned short packet_size;
	BYTE *packet;

#ifdef TRACE_FUNCTION
	g_print( "TCPReadPacket\n" );
#endif

	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( Contacts[ cx ].sok == sock )
		break;
	}
	
	read( sock, (char*)(&packet_size), 1 );
	if( ( read( sock, (char*)(&packet_size) + 1, 1 ) ) <= 0 )
	{
		if( cx != Num_Contacts )
		{
			Contacts[ cx ].sok = 0;
		}
		if( Contacts[ cx ].tcp_gdk_input )
		{
			gdk_input_remove( Contacts[ cx ].tcp_gdk_input );
			Contacts[ cx ].tcp_gdk_input = 0;
		}
		close( sock );
		return TRUE;
	}

	packet = (BYTE *)g_malloc0( packet_size );
	read( sock, packet, packet_size );

	memcpy( &uin, packet, 4 );
	
	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( Contacts[ cx ].uin == uin )
		{
			Contacts[ cx ].sok = sock;
			break;
		}
	}

	if( packet_size < 4096 )
	{
		packet_print( packet, packet_size,
		              PACKET_TYPE_TCP | PACKET_DIRECTION_RECEIVE );
		TCPProcessPacket( packet, packet_size, sock, data );
	}
	g_free( packet );
	return TRUE;
}

int TCPGainConnection( DWORD ip, WORD port, int cindex, struct sokandlb *data )
{
	struct
	{
		BYTE size[2];
		BYTE command;
		BYTE version[4];
		BYTE szero[4];
		BYTE uin[4];
		BYTE ip[4];
		BYTE real_ip[4];
		BYTE four;
		BYTE port[4];
	} hello_packet;

	struct sockaddr_in local, remote;
	int sizeofSockaddr = sizeof( struct sockaddr );
	int sock;

#ifdef TRACE_FUNCTION
	g_print( "TCPGainConnection\n" );
#endif

	if( Contacts[ cindex ].sok > 0 )
		return Contacts[ cindex ].sok;

	if( Contacts[ cindex ].force != 0x04 )
	{
/*		icq_reverse_tcp( Contacts[ cindex ].uin, our_port );*/
		return -1;
	}

	Word_2_Chars( hello_packet.size, 0x001A );
	hello_packet.command = 0xFF;
	DW_2_Chars( hello_packet.version, 0x00000003 );
	DW_2_Chars( hello_packet.szero, 0x00000000 );
	DW_2_Chars( hello_packet.uin, our_info->uin );
	DW_2_Chars( hello_packet.ip, LOCALHOST );
	DW_2_Chars( hello_packet.real_ip, LOCALHOST );
	hello_packet.four = 0x04;
	DW_2_Chars( hello_packet.port, (DWORD)our_port );

	if( ip == 0 )
	{
		return -1;
	}

	sock = socket( AF_INET, SOCK_STREAM, 0 );
	if( sock == -1 )
	{
		return -1;
	}

	fcntl( sock, O_NONBLOCK );

	memset( &local.sin_zero, 0x00, 8 );
	memset( &remote.sin_zero, 0x00, 8 );
	
	local.sin_family = AF_INET;
	remote.sin_family = AF_INET;
	local.sin_port = g_htons( 0 );
	local.sin_addr.s_addr = g_htonl( INADDR_ANY );
	if( ( bind( sock, (struct sockaddr*)&local, sizeof( struct sockaddr ) ) )== -1 )
	{
		return -1;
	}
	getsockname( sock, (struct sockaddr*)&local, &sizeofSockaddr );

	remote.sin_port = g_htons( port );
	remote.sin_addr.s_addr = g_htonl( ip );
/*
 *	localport = g_ntohs( local.sin_port );
 *	localip = g_ntohl( local.sin_addr.s_addr );
 */
	if( connect( sock, (struct sockaddr *)&remote, sizeofSockaddr ) < 0 )
	{
		return -1;
	}

	write( sock, &hello_packet, sizeof( hello_packet ) );
	packet_print( (BYTE *)&hello_packet, sizeof( hello_packet ),
	              PACKET_TYPE_TCP | PACKET_DIRECTION_SEND );

	Contacts[ cindex ].sok = sock;

	Contacts[ cindex ].tcp_gdk_input = gdk_input_add( sock, GDK_INPUT_READ, (GdkInputFunction) TCPReadPacket, data );
	
	return sock;
}

int TCPSendMessage( DWORD uin, char *msg, struct sokandlb *data )
{
	int cx;
	int sock;
	unsigned short intsize;
	BYTE *buffer;

	typedef struct
	{
		BYTE uin_a[4];
		BYTE version[2];
		BYTE cmd[2];
		BYTE zero[2];
		BYTE uin_b[4];
		BYTE command[2];
		BYTE msg_length[2];
	} tcp_head;

	typedef struct
	{
		BYTE ip[4];
		BYTE real_ip[4];
		BYTE port[4];
		BYTE four;
		BYTE zero[4];
		BYTE seq[4];
	} tcp_tail;

	struct
	{
		tcp_head head;
		char *body;
		tcp_tail tail;
	} packet;

#ifdef TRACE_FUNCTION
	g_print( "TCPSendMessage\n" );
#endif

	DW_2_Chars( packet.head.uin_a, our_info->uin );
	Word_2_Chars( packet.head.version, 0x0003 );
	Word_2_Chars( packet.head.cmd, ICQ_CMDxTCP_START );
	Word_2_Chars( packet.head.zero, 0x0000 );
	DW_2_Chars( packet.head.uin_b, our_info->uin );
	Word_2_Chars( packet.head.command, ICQ_CMDxTCP_MSG );
	Word_2_Chars( packet.head.msg_length, ( strlen( msg ) + 1 ) );

	packet.body = msg;

	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( Contacts[ cx ].uin == uin )
			break;
	}

	DW_2_Chars( packet.tail.ip, our_ip );
	DW_2_Chars( packet.tail.real_ip, our_ip );
	DW_2_Chars( packet.tail.port, our_port );
	packet.tail.four = 0x04;
	if( Contacts[ cx ].status == STATUS_DND || Contacts[ cx ].status == STATUS_OCCUPIED )
		DW_2_Chars( packet.tail.zero, 0x00200000 );
	else
		DW_2_Chars( packet.tail.zero, 0x00100000 );
	DW_2_Chars( packet.tail.seq, seq_num ++ );

	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( Contacts[ cx ].uin == uin )
			break;
	}
	if( cx == Num_Contacts )
		return 0;

	/* If the user is offline, we use UDP to avoid hanging */
	if( Contacts[ cx ].status == STATUS_OFFLINE )
		return 0;

	sock = TCPGainConnection( Contacts[ cx ].current_ip, Contacts[ cx ].port, cx, data );

	if( sock != -1 )
	{
		buffer = (BYTE*)g_malloc0( 2 + sizeof( packet.head ) + strlen( packet.body ) + 1 + sizeof( packet.tail ) );
		intsize = sizeof( tcp_head ) + sizeof( tcp_tail ) + strlen( msg ) + 1;

		memcpy( &buffer[0], &intsize, 2 );
		memcpy( &buffer[2], &packet.head, sizeof( packet.head ) );
		memcpy( &buffer[2 + sizeof( packet.head )], packet.body,
		        strlen( packet.body ) + 1 );
		memcpy( &buffer[2 + sizeof( packet.head ) +
		        strlen( packet.body ) + 1 ],
		        &packet.tail, sizeof( packet.tail ) );
		write( sock, buffer, intsize + 2 );
		packet_print( &buffer[2], intsize,
		              PACKET_TYPE_TCP | PACKET_DIRECTION_SEND );
		free( buffer );
	}
	else
		return 0;

	Contacts[ cx ].wait = show_wait( "Sending Message",
	                                 Contacts[ cx ].pdata );
	gtk_statusbar_push( GTK_STATUSBAR( statusbar ), 2 + Contacts[ cx ].wait,
	                    " Sending Message..." );

	return 1;
}

int TCPSendURL( DWORD uin, char *msg, struct sokandlb *data )
{
	int cx;
	int sock;
	unsigned short intsize;
	char buffer[1024];

	typedef struct
	{
		BYTE uin_a[4];
		BYTE version[2];
		BYTE cmd[2];
		BYTE zero[2];
		BYTE uin_b[4];
		BYTE command[2];
		BYTE msg_length[2];
	} tcp_head;

	typedef struct
	{
		BYTE ip[4];
		BYTE real_ip[4];
		BYTE port[4];
		BYTE four;
		BYTE zero[4];
		BYTE seq[4];
	} tcp_tail;

	struct
	{
		tcp_head head;
		char *body;
		tcp_tail tail;
	} packet;

#ifdef TRACE_FUNCTION
	g_print( "TCPSendURL\n" );
#endif

	DW_2_Chars( packet.head.uin_a, our_info->uin );
	Word_2_Chars( packet.head.version, 0x0003 );
	Word_2_Chars( packet.head.cmd, ICQ_CMDxTCP_START );
	Word_2_Chars( packet.head.zero, 0x0000 );
	DW_2_Chars( packet.head.uin_b, our_info->uin );
	Word_2_Chars( packet.head.command, ICQ_CMDxTCP_URL );
	Word_2_Chars( packet.head.msg_length, ( strlen( msg ) + 1 ) );

	packet.body = msg;

	DW_2_Chars( packet.tail.ip, our_ip );
	DW_2_Chars( packet.tail.real_ip, our_ip );
	DW_2_Chars( packet.tail.port, our_port );
	packet.tail.four = 0x04;
	DW_2_Chars( packet.tail.zero, 0x00100000 );
	DW_2_Chars( packet.tail.seq, seq_num ++ );

	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( Contacts[ cx ].uin == uin )
			break;
	}
	if( cx == Num_Contacts )
		return 0;

	sock = TCPGainConnection( Contacts[ cx ].current_ip, Contacts[ cx ].port, cx, data );

	if( sock != -1 )
	{
		intsize = sizeof( tcp_head ) + sizeof( tcp_tail ) + strlen( msg ) + 1;

		memcpy( &buffer[0], &intsize, 2 );
		memcpy( &buffer[2], &packet.head, sizeof( packet.head ) );
		memcpy( &buffer[2 + sizeof( packet.head )], packet.body,
		        strlen( packet.body ) + 1 );
		memcpy( &buffer[2 + sizeof( packet.head ) + strlen( packet.body ) + 1 ],
		        &packet.tail, sizeof( packet.tail ) );
		write( sock, buffer, intsize + 2 );
		packet_print( &buffer[2], intsize,
		              PACKET_TYPE_TCP | PACKET_DIRECTION_SEND );
	}
	else
	{
		return 0;
	}

	Contacts[ cx ].wait = show_wait( "Sending URL",
	                                 Contacts[ cx ].pdata );
	gtk_statusbar_push( GTK_STATUSBAR( statusbar ), 2 + Contacts[ cx ].wait,
	                    " Sending URL..." );

	return 1;
}

int TCPRetrieveAwayMessage( int cindex, struct sokandlb *data )
{
	int sock;
	unsigned short intsize;
	char buffer[1024];
	int status_type;

	typedef struct
	{
		BYTE uin_a[4];
		BYTE version[2];
		BYTE cmd[2];
		BYTE zero[2];
		BYTE uin_b[4];
		BYTE command[2];
		BYTE msg_length[2];
	} tcp_head;

	typedef struct
	{
		BYTE ip[4];
		BYTE real_ip[4];
		BYTE port[4];
		BYTE four;
		BYTE zero[4];
		BYTE seq[4];
	} tcp_tail;

	struct
	{
		tcp_head head;
		char *body;
		tcp_tail tail;
	} packet;

#ifdef TRACE_FUNCTION
	g_print( "TCPRetrieveAwayMessage\n" );
#endif

	switch( Contacts[ cindex ].status & 0xffff )
	{
		case STATUS_AWAY:
			status_type = ICQ_CMDxTCP_READxAWAYxMSG;
			break;
		case STATUS_NA:
			status_type = ICQ_CMDxTCP_READxNAxMSG;
			break;
		case STATUS_OCCUPIED:
			status_type = ICQ_CMDxTCP_READxOCCxMSG;
			break;
		case STATUS_DND:
			status_type = ICQ_CMDxTCP_READxDNDxMSG;
			break;
		default:
			status_type = ICQ_CMDxTCP_READxAWAYxMSG;
			break;
	}

	DW_2_Chars( packet.head.uin_a, our_info->uin );
	Word_2_Chars( packet.head.version, 0x0003 );
	Word_2_Chars( packet.head.cmd, ICQ_CMDxTCP_START );
	Word_2_Chars( packet.head.zero, 0x0000 );
	DW_2_Chars( packet.head.uin_b, our_info->uin );
	Word_2_Chars( packet.head.command, status_type );
	Word_2_Chars( packet.head.msg_length, 0x0001 );

	packet.body = "";

	DW_2_Chars( packet.tail.ip, our_ip );
	DW_2_Chars( packet.tail.real_ip, LOCALHOST );
	DW_2_Chars( packet.tail.port, our_port );
	packet.tail.four = 0x04;
	DW_2_Chars( packet.tail.zero, 0x00001000 );
	DW_2_Chars( packet.tail.seq, seq_num ++ );

	sock = TCPGainConnection( Contacts[ cindex ].current_ip, Contacts[ cindex ].port, cindex, data );

	if( sock != -1 )
	{
		intsize = sizeof( tcp_head ) + sizeof( tcp_tail ) + 1;

		memcpy( &buffer[0], &intsize, 2 );
		memcpy( &buffer[2], &packet.head, sizeof( packet.head ) );
		memcpy( &buffer[2 + sizeof( packet.head )], packet.body,
		        strlen( packet.body ) + 1 );
		memcpy( &buffer[2 + sizeof( packet.head ) + strlen( packet.body ) + 1 ],
		        &packet.tail, sizeof( packet.tail ) );
		write( sock, buffer, intsize + 2 );
		packet_print( &buffer[2], intsize,
		              PACKET_TYPE_TCP | PACKET_DIRECTION_SEND );
	}
	else
	{
		return 0;
	}

	return 1;
}

int TCPSendChatRequest( DWORD uin, char *msg, struct sokandlb *data )
{
	int cx;
	int sock;
	unsigned short intsize;
	char buffer[1024];

	typedef struct
	{
		BYTE uin_a[4];
		BYTE version[2];
		BYTE cmd[2];
		BYTE zero[2];
		BYTE uin_b[4];
		BYTE command[2];
		BYTE msg_length[2];
	} tcp_head;

	typedef struct
	{
		BYTE ip[4];
		BYTE real_ip[4];
		BYTE port[4];
		BYTE trail1[4];
		BYTE trail2[4];
		BYTE trail3[4];
		BYTE trail4[4];
		BYTE seq[4];
	} tcp_tail;

	struct
	{
		tcp_head head;
		char *body;
		tcp_tail tail;
	} packet;

#ifdef TRACE_FUNCTION
	g_print( "TCPSendChatRequest\n" );
#endif

	DW_2_Chars( packet.head.uin_a, our_info->uin );
	Word_2_Chars( packet.head.version, 0x0003 );
	Word_2_Chars( packet.head.cmd, ICQ_CMDxTCP_START );
	Word_2_Chars( packet.head.zero, 0x0000 );
	DW_2_Chars( packet.head.uin_b, our_info->uin );
	Word_2_Chars( packet.head.command, ICQ_CMDxTCP_CHAT );
	Word_2_Chars( packet.head.msg_length, ( strlen( msg ) + 1 ) );

	packet.body = msg;

	DW_2_Chars( packet.tail.ip, our_ip );
	DW_2_Chars( packet.tail.real_ip, LOCALHOST );
	DW_2_Chars( packet.tail.port, our_port );
	DW_2_Chars( packet.tail.trail1, 0x10000004 );
	DW_2_Chars( packet.tail.trail2, 0x00000100 );
	DW_2_Chars( packet.tail.trail3, 0x00000000 );
	DW_2_Chars( packet.tail.trail4, 0x00000000 );
	DW_2_Chars( packet.tail.seq, seq_num ++ );

	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( Contacts[ cx ].uin == uin )
			break;
	}
	if( cx == Num_Contacts )
		return 0;

	sock = TCPGainConnection( Contacts[ cx ].current_ip, Contacts[ cx ].port, cx, data );

	if( sock != -1 )
	{
		intsize = sizeof( tcp_head ) + sizeof( tcp_tail ) + strlen( msg ) + 1;

		memcpy( &buffer[0], &intsize, 2 );
		memcpy( &buffer[2], &packet.head, sizeof( packet.head ) );
		memcpy( &buffer[2 + sizeof( packet.head )], packet.body,
		        strlen( packet.body ) + 1 );
		memcpy( &buffer[2 + sizeof( packet.head ) + strlen( packet.body ) + 1 ],
		        &packet.tail, sizeof( packet.tail ) );
		write( sock, buffer, intsize + 2 );
		packet_print( &buffer[2], intsize,
		              PACKET_TYPE_TCP | PACKET_DIRECTION_SEND );
	}
	else
	{
		return -1;
	}

	return 1;
}

int TCPSendFileRequest( DWORD uin, char *msg, char *file, struct sokandlb *data )
{
	int cx;
	int cindex;
	int sock;
	unsigned short intsize;
	char buffer[1024];
	int size;

	typedef struct
	{
		BYTE uin_a[4]; /* Sender's UIN */
		BYTE version[2]; /* 0x0003 */
		BYTE cmd[2]; /* 0x07ee */
		BYTE zero[2]; /* 0x0000 (duh) */
		BYTE uin_b[4]; /* Sender's UIN */
		BYTE type[2]; /* 0x0003 */
		BYTE msg_length[2];
	} tcp_head;

	typedef struct
	{
		BYTE ip[4];
		BYTE real_ip[4];
		BYTE port[4];
		BYTE four; /* 0x04 */
		BYTE status[2];
		BYTE type[2]; /* Always 0x0010 */
		BYTE zero[4]; /* Always 0x00000000 */
		BYTE filename_len[2];
	} tcp_mid;

	typedef struct
	{
		BYTE flen[4]; /* Length of file */
		BYTE zero[4]; /* Always 0x00000000 */
		BYTE seq[4];
	} tcp_tail;

	struct
	{
		tcp_head head;
		char *body;
		tcp_mid mid;
		char *filename;
		tcp_tail tail;
	} packet;

	struct stat file_stat;
	char *nopathfile;

#ifdef TRACE_FUNCTION
	g_print( "TCPSendFileRequest\n" );
#endif

	nopathfile = file;

	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( Contacts[ cx ].uin == uin )
			break;
	}
	
	if( cx == Num_Contacts )
		return FALSE;

	cindex = cx;

	Contacts[ cx ].file_name = (char*)g_malloc0( strlen( file ) + 1 );
	strcpy( Contacts[ cx ].file_name, file );

	for( cx = 0; cx < strlen( file ); cx ++ )
	{
		if( file[ cx ] == '/' )
			nopathfile = &file[ cx + 1 ];
	}

	Contacts[ cindex ].file_short_name = (char*)g_malloc0( strlen( nopathfile ) + 1 );
	strcpy( Contacts[ cindex ].file_short_name, nopathfile );

	if( strlen( nopathfile ) == 0 )
		return FALSE;

	if( stat( file, &file_stat ) == -1 )
		return FALSE;

	DW_2_Chars( packet.head.uin_a, our_info->uin );
	Word_2_Chars( packet.head.version, 0x0003 );
	Word_2_Chars( packet.head.cmd, ICQ_CMDxTCP_START );
	Word_2_Chars( packet.head.zero, 0x0000 );
	DW_2_Chars( packet.head.uin_b, our_info->uin );
	Word_2_Chars( packet.head.type, ICQ_CMDxTCP_FILE );
	Word_2_Chars( packet.head.msg_length, ( strlen( msg ) + 1 ) );

	packet.body = msg;

	DW_2_Chars( packet.mid.ip, our_ip );
	DW_2_Chars( packet.mid.real_ip, LOCALHOST );
	DW_2_Chars( packet.mid.port, our_port );
	packet.mid.four = 0x04;

	switch( Current_Status )
	{
		case STATUS_ONLINE:
			Word_2_Chars( packet.mid.status, ICQ_ACKxTCP_ONLINE );
			break;
		case STATUS_AWAY:
			Word_2_Chars( packet.mid.status, ICQ_ACKxTCP_AWAY );
			break;
		case STATUS_DND:
			Word_2_Chars( packet.mid.status, ICQ_ACKxTCP_DND );
			break;
		case STATUS_OCCUPIED:
			Word_2_Chars( packet.mid.status, ICQ_ACKxTCP_OCC );
			break;
		case STATUS_NA:
			Word_2_Chars( packet.mid.status, ICQ_ACKxTCP_NA );
			break;
		case STATUS_INVISIBLE:
			Word_2_Chars( packet.mid.status, ICQ_ACKxTCP_REFUSE );
			break;
		}

	Word_2_Chars( packet.mid.type, 0x0010 );
	DW_2_Chars( packet.mid.zero, 0x00000000 );
	Word_2_Chars( packet.mid.filename_len, strlen( nopathfile ) + 1 );

	packet.filename = nopathfile;

	DW_2_Chars( packet.tail.flen, file_stat.st_size );
	DW_2_Chars( packet.tail.zero, 0x00000000 );
	DW_2_Chars( packet.tail.seq, seq_num ++ );

	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( Contacts[ cx ].uin == uin )
			break;
	}
	if( cx == Num_Contacts )
		return 0;

	sock = TCPGainConnection( Contacts[ cx ].current_ip, Contacts[ cx ].port, cx, data );

	if( sock != -1 )
	{
		intsize = sizeof( tcp_head ) + sizeof( tcp_mid ) + sizeof( tcp_tail ) + strlen( msg ) + strlen( packet.filename ) + 2;

		size = 0;

		memcpy( &buffer[ size ], &intsize, 2 );
		size += 2;
		memcpy( &buffer[ size ], &packet.head, sizeof( packet.head ) );
		size += sizeof( packet.head );
		memcpy( &buffer[ size ], packet.body,
		        strlen( packet.body ) + 1 );
		size += strlen( packet.body ) + 1;
		memcpy( &buffer[ size ], &packet.mid, sizeof( packet.mid ) );
		size += sizeof( packet.mid );
		memcpy( &buffer[ size ], packet.filename, strlen( packet.filename ) + 1 );
		size += strlen( packet.filename ) + 1;
		memcpy( &buffer[ size ],
		        &packet.tail, sizeof( packet.tail ) );
		size += sizeof( packet.tail );
		write( sock, buffer, intsize + 2 );
		packet_print( &buffer[2], intsize,
		              PACKET_TYPE_TCP | PACKET_DIRECTION_SEND );
	}
	else
	{
		return -1;
	}

	return 1;
}

void chat_save( GtkWidget *widget, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "chat_save\n" );
#endif

	chat_filesel = gtk_file_selection_new("GnomeICU: Save Chat Session");
	gtk_signal_connect(GTK_OBJECT(chat_filesel), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);
	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(chat_filesel)->ok_button), "clicked", GTK_SIGNAL_FUNC(chat_save_got_name), data );
	gtk_signal_connect_object(GTK_OBJECT (GTK_FILE_SELECTION (chat_filesel)->cancel_button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT( chat_filesel ) );
	gtk_widget_show(chat_filesel);
}

void chat_save_got_name( GtkWidget *widget, gpointer data )
{
	char *fn;
	int chat_file_fd;
	GSList *list;
	int cx;
	guint32 uin = GPOINTER_TO_UINT( data );

	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( uin == Contacts[ cx ].uin )
			break;
	}

	if( cx == Num_Contacts )
		return;

#ifdef TRACE_FUNCTION
	g_print( "chat_save_got_name\n" );
#endif

	fn = gtk_file_selection_get_filename( GTK_FILE_SELECTION( chat_filesel ) );

	if( ( chat_file_fd = open( fn, O_WRONLY | O_CREAT | O_APPEND, S_IRUSR | S_IWUSR ) ) == -1 )
		return;

	list = Contacts[ cx ].chat_history;

	while( list )
	{
		write( chat_file_fd, list->data, strlen( list->data ) );
		list = list->next;
	}
	
	write( chat_file_fd, "\n\n\n", 3 );
	close( chat_file_fd );

	g_slist_free( Contacts[ cx ].chat_history );

	gtk_widget_destroy( chat_filesel );
}

int TCPSendPartFile( gpointer data )
{
	guint uin;
	int cx;
	int bytes;
	xfer6 pak;
	char message[256];
	int t;

	uin = GPOINTER_TO_UINT( data );

	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( Contacts[ cx ].uin == uin )
			break;
	}

	if( cx == Num_Contacts )
		return FALSE;

	pak.id = 0x06;

	bytes = read( Contacts[ cx ].file_fd, pak.data, 2048 );

	Word_2_Chars( pak.psize, 1 + bytes );
	
	write( Contacts[ cx ].file_sok, &pak, 3 + bytes );
	packet_print( &pak.id, bytes + 1, PACKET_TYPE_TCP | PACKET_DIRECTION_SEND );

	if( bytes < 2048 )
	{
		if( Contacts[ cx ].file_gdk_input )
		{
			gdk_input_remove( Contacts[ cx ].file_gdk_input );
			Contacts[ cx ].file_gdk_input = 0;
		}
		sprintf( message, "File transfer complete:\n%s", Contacts[ cx ].nick );
		OK_Box( message, Contacts[ cx ].file_short_name );
		close( Contacts[ cx ].file_sok );

		Contacts[ cx ].file_sok = 0;
		Contacts[ cx ].file_port = 0;
		Contacts[ cx ].file_seq = 0;
		if( Contacts[ cx ].file_name != NULL )
			g_free( Contacts[ cx ].file_name );
		if( Contacts[ cx ].file_short_name != NULL )
			g_free( Contacts[ cx ].file_short_name );
		Contacts[ cx ].file_name = NULL;
		Contacts[ cx ].file_short_name = NULL;
		if( Contacts[ cx ].file_fd > 0 )
			close( Contacts[ cx ].file_fd );
		Contacts[ cx ].file_fd = 0;
		Contacts[ cx ].file_offset = 0;
		Contacts[ cx ].file_size = 0;

		if( Contacts[ cx ].file_info != NULL &&
		    Contacts[ cx ].file_info->window != NULL )
			gtk_widget_destroy( Contacts[ cx ].file_info->window );
		if( Contacts[ cx ].file_info != NULL )
			g_free( Contacts[ cx ].file_info );
		Contacts[ cx ].file_info = NULL;

		return FALSE;
	}

	Contacts[ cx ].file_info->cf_bytes_sent += bytes;
	Contacts[ cx ].file_info->b_bytes_sent += bytes;
	sprintf( message, "%d", Contacts[ cx ].file_info->cf_bytes_sent );
	gtk_entry_set_text( GTK_ENTRY( Contacts[ cx ].file_info->cf_trans ),
	                    message );
	sprintf( message, "%d", Contacts[ cx ].file_info->b_bytes_sent );
	gtk_entry_set_text( GTK_ENTRY( Contacts[ cx ].file_info->b_trans ),
	                    message );
	t = time( NULL ) - Contacts[ cx ].file_info->cf_starttime;
	sprintf( message, "%02d:%02d:%02d", t/3600, (t%3600)/60, t%60 );
	gtk_entry_set_text( GTK_ENTRY( Contacts[ cx ].file_info->cf_time ),
	                    message );
	t = time( NULL ) - Contacts[ cx ].file_info->b_starttime;
	sprintf( message, "%02d:%02d:%02d", t/3600, (t%3600)/60, t%60 );
	gtk_entry_set_text( GTK_ENTRY( Contacts[ cx ].file_info->b_time ),
	                    message );
	if( Contacts[ cx ].file_info->cf_bytes_sent && Contacts[ cx ].file_info->cf_starttime != time( NULL ) )
		sprintf( message, "%ld B/sec",
		         Contacts[ cx ].file_info->cf_bytes_sent /
		         ( time( NULL ) - Contacts[ cx ].file_info->cf_starttime ) );
	else
		strcpy( message, "0 B/sec" );
	gtk_entry_set_text( GTK_ENTRY( Contacts[ cx ].file_info->cf_bps ),
	                    message );
	if( Contacts[ cx ].file_info->b_bytes_sent && Contacts[ cx ].file_info->b_starttime != time( NULL ) )
		sprintf( message, "%ld B/sec",
		         Contacts[ cx ].file_info->b_bytes_sent /
		         ( time( NULL ) - Contacts[ cx ].file_info->b_starttime ) );
	else
		strcpy( message, "0 B/sec" );
	gtk_entry_set_text( GTK_ENTRY( Contacts[ cx ].file_info->b_bps ),
	                    message );
	if( Contacts[ cx ].file_info->cf_bytes_sent == 0 ||
	    Contacts[ cx ].file_info->cf_totbytes == 0 )
		gtk_progress_bar_update( GTK_PROGRESS_BAR( Contacts[ cx ].file_info->cf_progress ), 0.0F );
	else
		gtk_progress_bar_update( GTK_PROGRESS_BAR( Contacts[ cx ].file_info->cf_progress ),
		                         (float)( (float)Contacts[ cx ].file_info->cf_bytes_sent / (float)Contacts[ cx ].file_info->cf_totbytes ) );
	if( Contacts[ cx ].file_info->b_bytes_sent == 0 ||
	    Contacts[ cx ].file_info->b_totbytes == 0 )
		gtk_progress_bar_update( GTK_PROGRESS_BAR( Contacts[ cx ].file_info->b_progress ), 0.0F );
	else
		gtk_progress_bar_update( GTK_PROGRESS_BAR( Contacts[ cx ].file_info->b_progress ),
		                         (float)( (float)Contacts[ cx ].file_info->b_bytes_sent / (float)Contacts[ cx ].file_info->b_totbytes ) );
	return TRUE;
}

void file_place( char *prename, DWORD uin )
{
	GtkWidget *filesel;
#ifdef TRACE_FUNCTION
	g_print( "file_choose\n" );
#endif

	filesel = gtk_file_selection_new( "GnomeICU: File Transfer" );

	gtk_file_selection_set_filename( GTK_FILE_SELECTION( filesel ), prename );
	gtk_signal_connect(GTK_OBJECT(filesel), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);
	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filesel)->ok_button),
	                   "clicked", GTK_SIGNAL_FUNC( save_incoming_file ), GUINT_TO_POINTER( uin ) );
	gtk_signal_connect_object(GTK_OBJECT (GTK_FILE_SELECTION
	                   (filesel)->cancel_button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy),
	                   GTK_OBJECT( filesel ) );

	gtk_widget_show(filesel);
}

void save_incoming_file( GtkWidget *widget, gpointer data )
{
	guint32 uin = GPOINTER_TO_UINT( data );
	int cx;
	struct stat file_stat;
	xfer3 pak;
	
	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( Contacts[ cx ].uin == uin )
			break;
	}

	Contacts[ cx ].file_name = (char*)g_malloc0( strlen( gtk_file_selection_get_filename( GTK_FILE_SELECTION( widget->parent->parent->parent ) ) ) + 1 );
	strcpy( Contacts[ cx ].file_name, gtk_file_selection_get_filename( GTK_FILE_SELECTION( widget->parent->parent->parent ) ) );
	gtk_entry_set_text( GTK_ENTRY( Contacts[ cx ].file_info->local_filename ), Contacts[ cx ].file_name );
	gtk_widget_destroy( GTK_WIDGET( widget->parent->parent->parent ) );

	Contacts[ cx ].file_info->cf_starttime = time( NULL );
	if( Contacts[ cx ].file_info->b_starttime == 0 )
		Contacts[ cx ].file_info->b_starttime = time( NULL );
	Contacts[ cx ].file_info->cf_bytes_sent = 0;

	Contacts[ cx ].file_fd = open( Contacts[ cx ].file_name, O_WRONLY | O_CREAT | O_APPEND, S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH | S_IWOTH );
	if( Contacts[ cx ].file_fd > 0 )
	{
		Word_2_Chars( pak.psize, 0x0d );
		pak.id = 0x03;
		if( stat( Contacts[ cx ].file_name, &file_stat ) == -1 )
			DW_2_Chars( pak.resume_loc, 0x00000000 );
		else
			DW_2_Chars( pak.resume_loc, file_stat.st_size );
		DW_2_Chars( pak.longzero, 0x00000000 );
		DW_2_Chars( pak.speed, 0x00000064 );
		write( Contacts[ cx ].file_sok, &pak, sizeof( pak ) );
	}

	return;
}

void cancel_transfer( GtkWidget *widget, gpointer data )
{
	guint32 uin;
	int cx;

	char message[256];

	uin = GPOINTER_TO_UINT( data );
	
	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( Contacts[ cx ].uin == uin )
			break;
	}
	
	if( Contacts[ cx ].file_gdk_input )
	{
		gdk_input_remove( Contacts[ cx ].file_gdk_input );
		Contacts[ cx ].file_gdk_input = 0;
	}
	sprintf( message, "File transfer terminated:\n%s", Contacts[ cx ].nick );
	OK_Box( message, Contacts[ cx ].file_short_name );
	close( Contacts[ cx ].file_sok );

	Contacts[ cx ].file_sok = 0;
	Contacts[ cx ].file_port = 0;
	Contacts[ cx ].file_seq = 0;
	if( Contacts[ cx ].file_name != NULL )
		g_free( Contacts[ cx ].file_name );
	if( Contacts[ cx ].file_short_name != NULL )
		g_free( Contacts[ cx ].file_short_name );
	Contacts[ cx ].file_name = NULL;
	Contacts[ cx ].file_short_name = NULL;
	if( Contacts[ cx ].file_fd > 0 )
		close( Contacts[ cx ].file_fd );
	Contacts[ cx ].file_fd = 0;
	Contacts[ cx ].file_offset = 0;
	Contacts[ cx ].file_size = 0;

	if( Contacts[ cx ].file_info != NULL &&
	    Contacts[ cx ].file_info->window != NULL )
		gtk_widget_destroy( Contacts[ cx ].file_info->window );
	if( Contacts[ cx ].file_info != NULL )
		g_free( Contacts[ cx ].file_info );
	Contacts[ cx ].file_info = NULL;

	return;
}
