#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "datatype.h"
#include "gnomeicu.h"
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <unistd.h>
#include <netdb.h>
#include <time.h>
#include <string.h>

#include "gtkfunc.h"

#include "events.h"

#include "applet.h"

/*
 * This function is called every 2 minutes
 * so that the server doesn't force disconnect
 */
void Keep_Alive( int sok )
{
	net_icq_pak pak;

#ifdef TRACE_FUNCTION
	g_print( "Keep_Alive\n" );
#endif

	if( !Done_Login )
		return;

	Word_2_Chars( pak.head.ver, ICQ_VER );
	Word_2_Chars( pak.head.cmd, CMD_KEEP_ALIVE );
	Word_2_Chars( pak.head.seq, seq_num++ );
	DW_2_Chars( pak.head.UIN, our_info->uin );
	DW_2_Chars( pak.data, rand() );
   
/*
	packet_print( (pak.head.ver), sizeof( pak.head ) - 2,
	              PACKET_TYPE_UDP | PACKET_DIRECTION_SEND );
*/
	SOCKWRITE( sok, &(pak.head.ver), sizeof( pak.head ) + 2 );
/*
	Word_2_Chars( pak.head.ver, ICQ_VER );
	Word_2_Chars( pak.head.cmd, CMD_KEEP_ALIVE2 );
	Word_2_Chars( pak.head.seq, seq_num++ );
	DW_2_Chars( pak.head.UIN, our_info->uin );
	DW_2_Chars( pak.data, rand() );
   
/-
	packet_print( (pak.head.ver), sizeof( pak.head ) - 2,
	              PACKET_TYPE_UDP | PACKET_DIRECTION_SEND );
-/
	SOCKWRITE( sok, &(pak.head.ver), sizeof( pak.head ) + 2 );
*/
}

void Recv_Message( int sok, srv_net_icq_pak pak, struct sokandlb *data )
{
	RECV_MESSAGE_PTR r_mesg;
	unsigned short int year;

#ifdef TRACE_FUNCTION
	g_print( "Recv_Message\n" );
#endif

	r_mesg = ( RECV_MESSAGE_PTR )pak.data;
	last_recv_uin = Chars_2_DW( r_mesg->uin );

	memcpy( (BYTE *)(&year), &r_mesg->year[0], 2 );

/*
	g_print( "%d %d %d %d %d\n", year,
	        r_mesg->month, r_mesg->day, r_mesg->hour, r_mesg->minute );
*/	
	Do_Msg( Chars_2_Word( r_mesg->type ), ( r_mesg->len + 2 ), last_recv_uin, data, 'm' );

	ack_srv( sok, Chars_2_Word( pak.head.seq ) );
}

/*
 * This is called to remove messages
 * from the server
 */
void snd_got_messages( int sok )
{
	net_icq_pak pak;

#ifdef TRACE_FUNCTION
	g_print( "snd_got_messages\n" );
#endif
   
	Word_2_Chars( pak.head.ver, ICQ_VER );
	Word_2_Chars( pak.head.cmd, CMD_ACK_MESSAGES );
	Word_2_Chars( pak.head.seq, seq_num++ );
	DW_2_Chars( pak.head.UIN, our_info->uin );
	DW_2_Chars( pak.data, rand() );
/*
	packet_print( (pak.head.ver), sizeof( pak.head ) - 2,
	              PACKET_TYPE_UDP | PACKET_DIRECTION_SEND );
*/
	SOCKWRITE( sok, &(pak.head.ver), sizeof( pak.head ) + 2 );
}

/* Sends contact list */
void snd_contact_list( int sok )
{
	net_icq_pak pak;
	int num_used;
	int i, size;
	char *tmp;

#ifdef TRACE_FUNCTION
	g_print( "snd_contact_list\n" );
#endif
   
	Word_2_Chars( pak.head.ver, ICQ_VER );
	Word_2_Chars( pak.head.cmd, CMD_CONT_LIST );
	Word_2_Chars( pak.head.seq, seq_num++ );
	DW_2_Chars( pak.head.UIN, our_info->uin );
   
	tmp = pak.data;
	tmp++;

	for ( i = 0, num_used = 0; i < Num_Contacts; i++ )
	{
		if ( (S_DWORD) Contacts[ i ].uin >  0 )
		{
			DW_2_Chars( tmp, Contacts[ i ].uin );
			tmp += 4;
			num_used++;
		}
	}
	
	pak.data[0] = num_used;
	size = GPOINTER_TO_INT(tmp) - GPOINTER_TO_INT(pak.data);
	size += sizeof( pak.head ) - 2;
/*
	packet_print( (pak.head.ver), size,
	              PACKET_TYPE_UDP | PACKET_DIRECTION_SEND );
*/
	SOCKWRITE( sok, &( pak.head.ver ), size );
}

/* Send second login command to finish logging in */
void snd_login_1( int sok )
{
	net_icq_pak pak;

#ifdef TRACE_FUNCTION
	g_print( "snd_login_1\n" );
#endif
   
	Word_2_Chars( pak.head.ver, ICQ_VER );
	Word_2_Chars( pak.head.cmd, CMD_LOGIN_1 );
	Word_2_Chars( pak.head.seq, seq_num++ );
	DW_2_Chars( pak.head.UIN, our_info->uin );
	DW_2_Chars( pak.data, rand() );
   
	SOCKWRITE( sok, &(pak.head.ver), sizeof( pak.head ) + 2 );

	if( is_new_user )
		change_info_window( NULL, NULL );
}

/* Called when user goes Offline */
void User_Offline( int sok, srv_net_icq_pak pak )
{
	int remote_uin;
	int index;

#ifdef TRACE_FUNCTION
	g_print( "User_Offline\n" );
#endif

	remote_uin = pak.data[3];
	remote_uin <<=8;
	remote_uin += pak.data[2];
	remote_uin <<=8;
	remote_uin += pak.data[1];
	remote_uin <<=8;
	remote_uin += pak.data[0];

	index = Print_UIN_Name( remote_uin );
	log_window_add( "Logout", 1, remote_uin );
	Time_Stamp();

	if ( index != -1 )
	{
		Contacts[ index ].status = STATUS_OFFLINE;
		Contacts[ index ].true_status = STATUS_OFFLINE;
		Contacts[ index ].last_time = time( NULL );
	}
	ack_srv( sok, Chars_2_Word( pak.head.seq ) );

	Show_Quick_Status( MainData );

	if( applet_toggle )
		applet_update( Current_Status, NULL, MainData );
}

void User_Online( int sok, srv_net_icq_pak pak )
{
	int remote_uin, new_status;
	int index;

#ifdef TRACE_FUNCTION
	g_print( "User_Online\n" );
#endif

/**************************************
dw uin
dw ip
word pord
word zero
dw ip
byte 04/06
dw status
word TCP version
**************************************/

	remote_uin = Chars_2_DW( &pak.data[0] );

	new_status = Chars_2_DW( &pak.data[17] ) & 0x00ff;
   
	index = Print_UIN_Name( remote_uin );
	log_window_add( "Login", 1, remote_uin );
	Time_Stamp();

	if ( index != -1 )
	{
		Contacts[ index ].status = new_status;
		Contacts[ index ].true_status = Chars_2_DW( &pak.data[17] );
		Contacts[ index ].force = pak.data[16];
		Contacts[ index ].current_ip = g_ntohl( Chars_2_DW( &pak.data[4] ) );
		Contacts[ index ].port = Chars_2_DW( &pak.data[8] );
		Contacts[ index ].last_time = time( NULL );
	}

	Time_Stamp();

	if( !Done_Login )
	{
		for ( index = 0; index < Num_Contacts; index++ )
		{
			if ( Contacts[index].uin == remote_uin )
			{
				Contacts[ index ].status = new_status;
				Contacts[ index ].current_ip = g_ntohl( Chars_2_DW( &pak.data[4] ) );
				Contacts[ index ].port = Chars_2_DW( &pak.data[8] );
				Contacts[ index ].last_time = time( NULL );
				break;
			}
		}
	 }
	ack_srv( sok, Chars_2_Word( pak.head.seq ) );

	Show_Quick_Status( MainData );

	if( applet_toggle )
		applet_update( Current_Status, NULL, MainData );
}

void Status_Update( int sok, srv_net_icq_pak pak )
{
	char buf[64];
	char sts[ 64 ];
	int remote_uin, new_status;
	int index;

#ifdef TRACE_FUNCTION
	g_print( "Status_Update\n" );
#endif

	remote_uin = pak.data[3];
	remote_uin <<=8;
	remote_uin += pak.data[2];
	remote_uin <<=8;
	remote_uin += pak.data[1];
	remote_uin <<=8;
	remote_uin += pak.data[0];

	new_status = pak.data[7];
	new_status <<=8;
	new_status += pak.data[6];
	new_status <<=8;
	new_status += pak.data[5];
	new_status <<=8;
	new_status += pak.data[4];

	index = Print_UIN_Name( remote_uin );

	if( index != -1 )
		Contacts[ index ].true_status = new_status;

	new_status = new_status & 0x01ff;

	if( new_status == STATUS_OCCUPIED_MAC )
		new_status = STATUS_OCCUPIED;
	if( new_status == STATUS_NA_99A )
		new_status = STATUS_NA;

	if ( new_status == STATUS_OFFLINE ) /* this because -1 & 0xFFFF is not -1 */
	{
		strcpy( sts, "Offline" );
	}
   
	switch ( new_status & 0xffff )
	{
		case STATUS_ONLINE:
			strcpy( sts,  "Online" );
			break;
		case STATUS_DND:
			strcpy( sts, "Do Not Disturb" );
			break;
		case STATUS_AWAY:
			strcpy( sts, "Away" );
			break;
		case STATUS_OCCUPIED:
			strcpy( sts, "Occupied" );
			break;
		case STATUS_NA:
			strcpy( sts, "Not Available" );
			break;
		case STATUS_INVISIBLE:
			strcpy( sts, "Invisible" );
			break;
		case STATUS_FREE_CHAT:
			strcpy( sts, "Free for Chat" );
			break;
		default:
			strcpy( sts, "" );
			break;
	}

	sprintf( buf, "Status Change: %s", sts );
	log_window_add( buf, 1, remote_uin );

	if ( index != -1 )
	{
		Contacts[ index ].status = new_status;
	}

	if( applet_toggle )
		applet_update( Current_Status, NULL, MainData );
}


/*
 * Login with UIN and password.
 * Gives IP and Port
 * Does NOT wait for any kind of response
 */
void Login( int sok, char *pass, int ip, int port )
{
	net_icq_pak pak;
	int size;
	login_1 s1;
	login_2 s2;
	struct sockaddr_in sin;  /* used to store inet addr stuff  */

#ifdef TRACE_FUNCTION
	g_print( "Login\n" );
#endif

	Word_2_Chars( pak.head.ver, ICQ_VER );
	Word_2_Chars( pak.head.cmd, CMD_LOGIN );
	Word_2_Chars( pak.head.seq, seq_num++ );
	DW_2_Chars( pak.head.UIN, our_info->uin );
   
	DW_2_Chars( s1.port, port );
	Word_2_Chars( s1.len, strlen( pass ) + 1 );
   DW_2_Chars( s1.time, time( NULL ) );

	DW_2_Chars( s2.ip, ip );
	sin.sin_addr.s_addr = Chars_2_DW( s2.ip );
	DW_2_Chars( s2.status, Current_Status );

	DW_2_Chars( s2.X1, LOGIN_X1_DEF );
	s2.X2[0] = LOGIN_X2_DEF;
	DW_2_Chars( s2.X3, LOGIN_X3_DEF );
	DW_2_Chars( s2.X4, LOGIN_X4_DEF );
	DW_2_Chars( s2.X5, LOGIN_X5_DEF );
   
	memcpy( pak.data, &s1, sizeof( s1 ) );
	size = sizeof( s1 );
	memcpy( &pak.data[size], pass, Chars_2_Word( s1.len ) );
	size += Chars_2_Word( s1.len );
	memcpy( &pak.data[size], &s2.X1, sizeof( s2.X1 ) );
	size += sizeof( s2.X1 );
	memcpy( &pak.data[size], &s2.ip, sizeof( s2.ip ) );
	size += sizeof( s2.ip );
	memcpy( &pak.data[size], &s2.X2, sizeof( s2.X2 ) );
	size += sizeof( s2.X2 );
	memcpy( &pak.data[size], &s2.status, sizeof( s2.status ) );
	size += sizeof( s2.status );
	memcpy( &pak.data[size], &s2.X3, sizeof( s2.X3 ) );
	size += sizeof( s2.X3 );
	memcpy( &pak.data[size], &s2.X4, sizeof( s2.X4 ) );
	size += sizeof( s2.X4 );
	memcpy( &pak.data[size], &s2.X5, sizeof( s2.X5 ) );
	size += sizeof( s2.X5 );
	SOCKWRITE( sok, &(pak.head.ver), size + sizeof( pak.head )- 2 );
} 

/*
 * Sends aknowlegment to server
 * Appears that this must be done after
 * everything the server sends us
 */
void ack_srv( SOK_T sok, DWORD seq )
{
	net_icq_pak pak;

#ifdef TRACE_FUNCTION
	g_print( "ack_srv\n" );
#endif
   
	Word_2_Chars( pak.head.ver, ICQ_VER );
	Word_2_Chars( pak.head.cmd, CMD_ACK );
	DW_2_Chars( pak.head.seq2, seq );
	DW_2_Chars( pak.head.UIN, our_info->uin );
	DW_2_Chars( pak.data, rand() );
/*
	packet_print( (pak.head.ver), sizeof( pak.head ) - 2,
	              PACKET_TYPE_UDP | PACKET_DIRECTION_SEND );
*/
	SOCKWRITE( sok, &(pak.head.ver), sizeof( pak.head ) + 2 );
}

void Display_Info_Reply( int sok, srv_net_icq_pak pak, struct sokandlb *data )
{
	char *tmp;
	int len;
	int cx;
	Contact_Member *DestContact;

#ifdef TRACE_FUNCTION
	g_print( "Display_Info_Reply\n" );
#endif

	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( Contacts[ cx ].uin == Chars_2_DW( &pak.data[ 0 ] ) )
			break;
	}

	if( cx == Num_Contacts )
		DestContact = &New_Contact;
	else
		DestContact = &Contacts[ cx ];

	if( DestContact->info->nick != NULL )
		g_free( DestContact->info->nick );
	if( DestContact->info->first != NULL )
		g_free( DestContact->info->first );
	if( DestContact->info->last != NULL )
		g_free( DestContact->info->last );
	if( DestContact->info->email != NULL )
		g_free( DestContact->info->email );

	len = Chars_2_Word( &pak.data[4] );
	DestContact->info->nick = (char*)g_malloc( strlen( &pak.data[6] ) + 1 );
	strcpy( DestContact->info->nick, &pak.data[6] );

	if( atoi( DestContact->nick ) == DestContact->uin && DestContact->uin &&
	    strlen( &pak.data[ 6 ] ) )
	{
		strcpy( DestContact->nick , &pak.data[6] );
		gtk_clist_set_text( GTK_CLIST( data->lb_userwin ),
		                    DestContact->lb_index, 1, &pak.data[ 6 ] );
		Save_RC();
	}

	tmp = &pak.data[ 6 + len ];

	len = Chars_2_Word( tmp );
	DestContact->info->first = (char*)g_malloc( strlen( tmp+2 ) + 1 );
	strcpy( DestContact->info->first, tmp+2 );
	tmp += len + 2;
	
	len = Chars_2_Word( tmp );
	DestContact->info->last = (char*)g_malloc( strlen( tmp+2 ) + 1 );
	strcpy( DestContact->info->last, tmp+2 );
	tmp += len + 2;
   
	len = Chars_2_Word( tmp );
	DestContact->info->email = (char*)g_malloc( strlen( tmp+2 ) + 1 );
	strcpy( DestContact->info->email, tmp+2 );
	tmp += len + 2;

	if ( *tmp == 1 )
	{
		DestContact->info->auth = FALSE;
	}
	else
	{
		DestContact->info->auth = TRUE;
	}

	ack_srv( sok, Chars_2_Word( pak.head.seq ) );
}

void Display_Search_Reply( int sok, srv_net_icq_pak pak )
{
	char *data[6];
	char dsr_uin[32];
	char auth_msg[32];
	char *titles[] = { "UIN", "Nick", "F. Name", "L. Name", "E-mail", "Authorization" };

	char *tmp;
	int len;
	int row;

#ifdef TRACE_FUNCTION
	g_print( "Display_Search_Reply\n" );
#endif

	sprintf( dsr_uin, "%u", Chars_2_DW( &pak.data[ 0 ] ) );
	data[ 0 ] = dsr_uin;
	len = Chars_2_Word( &pak.data[4] );

	/* Nick Name */
	data[ 1 ] = &pak.data[ 6 ];
	tmp = &pak.data[ 6 + len ];
	len = Chars_2_Word( tmp );
	
	/* First Name */
	data[ 2 ] = tmp + 2;
	tmp += len + 2;
	len = Chars_2_Word( tmp );
	
	/* Last Name */
	data[ 3 ] = tmp + 2;
	tmp += len + 2;
	len = Chars_2_Word( tmp );
	
	/* E-Mail Address */
	data[ 4 ] = tmp + 2;
	tmp += len + 2;

	if ( *tmp == 1 )
	{
		sprintf( auth_msg, "No auth needed" );
	}
	else
	{
		sprintf( auth_msg, "Must request auth" );
	}

	data[ 5 ] = auth_msg;

	if( !found_list )
	{
		found_list = gtk_clist_new_with_titles( 6, titles );
	}
	
	row = gtk_clist_append( GTK_CLIST( found_list ), data );

	gtk_clist_set_row_data( GTK_CLIST( found_list ), row, GUINT_TO_POINTER(Chars_2_DW( &pak.data[ 0 ] )) );

	ack_srv( sok, Chars_2_Word( pak.head.seq ) );
}

int Do_Msg( DWORD type, char *data, DWORD uin, struct sokandlb *sldata, char message_type )
{
	char sender[50];
	char *tmp;
	char *logbuf;
	int cx = 0;

	struct sokandlb passdata;

#ifdef TRACE_FUNCTION
	g_print( "Do_Msg\n" );
#endif

	/* Mask off the 0x8xxx that's been causing problems */
	type &= 0xFF;

	passdata.sok = sldata->sok;
	passdata.lb_userwin = NULL;

	switch( type )
	{
		case USER_ADDED_MESS:
			tmp = strchr( data, '\xFE' );
			if ( tmp == NULL )
			{
				/* Bad Packet */
				return 0;
			}

			*tmp = '\0';
			rus_conv( RUS_WIN_KOI, data );
			tmp++;
			data = tmp;
			tmp = strchr( tmp, '\xFE' );

			if ( tmp == NULL )
			{
				/* Bad Packet */
				return 0;
			}
		
			*tmp = '\0';
			rus_conv ( RUS_WIN_KOI, data );
			tmp++;
			data = tmp;
			tmp = strchr( tmp, '\xFE' );
			if ( tmp == NULL )
			{
				/* Bad Packet */
				return 0;
			}
	
			*tmp = '\0';
			rus_conv ( RUS_WIN_KOI, data );
			tmp++;
			data = tmp;
			Do_Msg( 0, data, uin, sldata, 'n' );
			break;
		case AUTH_REQ_MESS:
			tmp = strchr( data, '\xFE' );
			if ( tmp == NULL )
			{
				/* Bad Packet */
				return 0;
			}

			*tmp = '\0';
			rus_conv( RUS_WIN_KOI, data );
			tmp++;
			data = tmp;
			tmp = strchr( tmp, '\xFE' );
			if ( tmp == NULL )
			{
				/* Bad Packet */
				return 0;
			}

			*tmp = '\0';
			rus_conv( RUS_WIN_KOI, data );
			tmp++;
			data = tmp;
			tmp = strchr( tmp, '\xFE' );
			if ( tmp == NULL )
			{
				/* Bad Packet */
				return 0;
			}
	
			*tmp = '\0';
			rus_conv( RUS_WIN_KOI, data );
			tmp++;
			data = tmp;
			tmp = strchr( tmp, '\xFE' );
			if ( tmp == NULL )
			{
				/* Bad Packet */
				return 0;
			}
	
			*tmp = '\0';
			rus_conv( RUS_WIN_KOI, data );
			tmp++;
			data = tmp;
			tmp = strchr( tmp, '\xFE' );
	
			if ( tmp == NULL )
			{
				/* Bad Packet */
				return 0;
			}
			*tmp = '\0';
			tmp ++;
			data = tmp;
			Do_Msg( 0, data, uin, sldata, 'a' );
			break;

		case URL_MESS:
			Do_Msg( 0, data, uin, sldata, 'u' );
			break;

	        case AUTH_MESS:
			Do_Msg( 0, data, uin, sldata, 'v' );
			break;
			
		default:
			switch( message_type )
			{
				case 'v':
					gnomeicu_event( EV_AUTH );
					break;
				case 'f':
					gnomeicu_event( EV_FILEREQ );
					break;
				case 'c':
					gnomeicu_event( EV_CHATREQ );
					break;
				case 'u':
					gnomeicu_event( EV_URLRECV );
					break;
				case 'a':
					gnomeicu_event( EV_AUTHREQ );
					break;
				case 'n':
					gnomeicu_event( EV_LISTADD );
					break;
				default:
					gnomeicu_event( EV_MSGRECV );
			}

			if( uin != 0 )
			{
				for( cx = 0; cx < Num_Contacts; cx ++ )
				{
					if( uin == Contacts[ cx ].uin )
						break;
				}

				if( cx == Num_Contacts )
				{
					sprintf( Contacts[ cx ].nick, "%u", uin );
					Add_User( sldata->sok, uin, Contacts[ cx ].nick );
				}

				strcpy( sender, Contacts[ cx ].nick );

				if( message_type == 'c' && Current_Status == STATUS_FREE_CHAT )
					return cx;

				if( Contacts[ cx ].read_next &&
				    GTK_IS_WIDGET( Contacts[ cx ].read_next ) &&
				    GTK_WIDGET_VISIBLE( Contacts[ cx ].read_next ) )
					gtk_widget_set_sensitive( Contacts[ cx ].read_next, TRUE );
		
				Contacts[ cx ].messages ++;
				Contacts[ cx ].need_update = 1;
				rus_conv( RUS_WIN_KOI, data );

				/* Add to personal history file */
				if( uin > 0 )
				{
					add_incoming_to_history( uin, data );
				}

				logbuf = (char *)g_malloc( 19 );
				sprintf( logbuf, "Received Message" );
				log_window_add( logbuf, 1, uin );
				g_free( logbuf );

				Contacts[ cx ].message = realloc( Contacts[ cx ].message, sizeof( char ** ) * Contacts[ cx ].messages );
				Contacts[ cx ].message[ Contacts[ cx ].messages - 1 ] = (char *)g_malloc( strlen( data ) + 2 );
				Contacts[ cx ].message[ Contacts[ cx ].messages - 1 ][ 0 ] = message_type;
				strcpy( ( Contacts[ cx ].message[ Contacts[ cx ].messages - 1 ] + 1 ), data );

				if( applet_toggle )
					applet_update( Current_Status, NULL, sldata );
				Show_Quick_Status( sldata );
			}
	}
	return cx;
}

int Do_Chat( DWORD type, char *data, DWORD uin, struct sokandlb *sldata, DWORD seq )
{
	char sender[50];
	char *logbuf;
	int cx = 0;

	struct sokandlb passdata;

#ifdef TRACE_FUNCTION
	g_print( "Do_Chat\n" );
#endif

	passdata.sok = sldata->sok;
	passdata.lb_userwin = NULL;

	if( uin != 0 )
	{
		for( cx = 0; cx < Num_Contacts; cx ++ )
		{
			if( uin == Contacts[ cx ].uin )
				break;
		}

		if( cx == Num_Contacts )
		{
			sprintf( Contacts[ cx ].nick, "%u", uin );
			Add_User( sldata->sok, uin, Contacts[ cx ].nick );
		}

		strcpy( sender, Contacts[ cx ].nick );
		if( Current_Status == STATUS_FREE_CHAT )
			return cx;

		Contacts[ cx ].messages ++;

		/* Add to personal history file */
		if( uin > 0 )
		{
			add_incoming_to_history( uin, data );
		}

		logbuf = (char *)g_malloc( 22 );
		sprintf( logbuf, "Received Chat Request" );
		log_window_add( logbuf, 1, uin );
		g_free( logbuf );

		Contacts[ cx ].chat_reason = (char*)g_malloc( strlen( data ) + 1 );
		strcpy( Contacts[ cx ].chat_reason, data );

		Contacts[ cx ].chat_seq = seq;
		Contacts[ cx ].message = realloc( Contacts[ cx ].message, sizeof( char ** ) * Contacts[ cx ].messages );
		Contacts[ cx ].message[ Contacts[ cx ].messages - 1 ] = (char *)g_malloc( strlen( data ) + 2 );
		Contacts[ cx ].message[ Contacts[ cx ].messages - 1 ][ 0 ] = 'c';
		strcpy( ( Contacts[ cx ].message[ Contacts[ cx ].messages - 1 ] + 1 ), data );

		if( applet_toggle )
			applet_update( Current_Status, NULL, sldata );
		Show_Quick_Status( sldata );

		gnomeicu_event( EV_CHATREQ );
	}

	return cx;
}

int Do_File( DWORD type, char *data, DWORD uin, struct sokandlb *sldata, DWORD seq )
{
	char sender[50];
	char *logbuf;
	int cx = 0;

	struct sokandlb passdata;

#ifdef TRACE_FUNCTION
	g_print( "Do_File\n" );
#endif

	passdata.sok = sldata->sok;
	passdata.lb_userwin = NULL;

	if( uin != 0 )
	{
		for( cx = 0; cx < Num_Contacts; cx ++ )
		{
			if( uin == Contacts[ cx ].uin )
				break;
		}

		if( cx == Num_Contacts )
		{
			sprintf( Contacts[ cx ].nick, "%u", uin );
			Add_User( sldata->sok, uin, Contacts[ cx ].nick );
		}

		strcpy( sender, Contacts[ cx ].nick );

		Contacts[ cx ].messages ++;

		/* Add to personal history file */
		if( uin > 0 )
		{
			add_incoming_to_history( uin, data );
		}

		logbuf = (char *)g_malloc( 22 );
		sprintf( logbuf, "Received File Request" );
		log_window_add( logbuf, 1, uin );
		g_free( logbuf );

		Contacts[ cx ].file_seq = seq;
		Contacts[ cx ].message = realloc( Contacts[ cx ].message, sizeof( char ** ) * Contacts[ cx ].messages );
		Contacts[ cx ].message[ Contacts[ cx ].messages - 1 ] = (char *)g_malloc( strlen( data ) + 2 );
		Contacts[ cx ].message[ Contacts[ cx ].messages - 1 ][ 0 ] = 'f';
		strcpy( ( Contacts[ cx ].message[ Contacts[ cx ].messages - 1 ] + 1 ), data );

		if( applet_toggle )
			applet_update( Current_Status, NULL, sldata );
		Show_Quick_Status( sldata );

		gnomeicu_event( EV_CHATREQ );
	}

	return cx;
}

void Display_Ext_Info_Reply( int sok, srv_net_icq_pak pak )
{
	char *tmp;
	int len;
	int cx;
	Contact_Member *DestContact;

#ifdef TRACE_FUNCTION
	g_print( "Display_Ext_Info_Reply\n" );
#endif

	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( Contacts[ cx ].uin == Chars_2_DW( &pak.data[ 0 ] ) )
			break;
	}

	if( cx == Num_Contacts )
		DestContact = &New_Contact;
	else
		DestContact = &Contacts[ cx ];

	if( DestContact->info->city != NULL )
		g_free( DestContact->info->city );
	if( DestContact->info->state != NULL )
		g_free( DestContact->info->state );
	if( DestContact->info->phone != NULL )
		g_free( DestContact->info->phone );
	if( DestContact->info->homepage != NULL )
		g_free( DestContact->info->homepage );
	if( DestContact->info->about != NULL )
		g_free( DestContact->info->about );

	DestContact->info->uin = DestContact->uin;

	len = Chars_2_Word( &pak.data[4] );
	DestContact->info->city = (char*)g_malloc( strlen( &pak.data[6] ) + 1 );
	strcpy( DestContact->info->city, &pak.data[6] );
	tmp = &pak.data[6 + len ];

	tmp += 2; /* Bypass COUNTRY_CODE */
	tmp += 1; /* Bypass COUNTRY_STATUS */

	len = Chars_2_Word( tmp );
	DestContact->info->state = (char*)g_malloc( strlen( tmp+2 ) + 1 );
	strcpy( DestContact->info->state, tmp+2 );
	tmp += len + 2;

	DestContact->info->age = Chars_2_Word( tmp );
	tmp += 2;

	if( tmp[0] == 0x00 )
	{
		DestContact->info->sex = NOT_SPECIFIED;
	}
	else if( tmp[0] == 0x01 )
	{
		DestContact->info->sex = FEMALE;
	}
	else if( tmp[0] == 0x02 )
	{
		DestContact->info->sex = MALE;
	}
	tmp += 1;

	len = Chars_2_Word( tmp );
	DestContact->info->phone = (char*)g_malloc( strlen( tmp+2 ) + 1 );
	strcpy( DestContact->info->phone, tmp+2 );
	tmp += len + 2;

	len = Chars_2_Word( tmp );
	DestContact->info->homepage = (char*)g_malloc( strlen( tmp+2 ) + 1 );
	strcpy( DestContact->info->homepage, tmp+2 );
	tmp += len + 2;

	len = Chars_2_Word( tmp );
	DestContact->info->about = (char*)g_malloc( strlen( tmp+2 ) + 1 );
	strcpy( DestContact->info->about, tmp+2 );

	ack_srv( sok, Chars_2_Word( pak.head.seq ) );

	if( cx != Num_Contacts )
		dump_personal_info( DestContact->uin );
	else
	{
		start_new_info = FALSE;
		show_info_new( MainData->sok, DestContact->uin );
	}
}


/*
 * Sends Invisible List that makes you
 * permanantly invisible to certain users
 */
void snd_invis_list( int sok )
{
	net_icq_pak pak;
	int num_used;
	int i, size;
	char *tmp;

#ifdef TRACE_FUNCTION
	g_print( "snd_invis_list\n" );
#endif
	
	Word_2_Chars( pak.head.ver, ICQ_VER );
	Word_2_Chars( pak.head.cmd, CMD_INVIS_LIST );
	Word_2_Chars( pak.head.seq, seq_num );
	DW_2_Chars( pak.head.UIN, our_info->uin );
	
	tmp = pak.data;
	tmp ++;
	for( i = 0, num_used = 0; i < Num_Contacts; i ++ )
	{
		if( (S_DWORD) Contacts[ i ].uin > 0 )
		{
			if( Contacts[ i ].invis_list )
			{
				DW_2_Chars( tmp, Contacts[ i ].uin );
				tmp += 4;
				num_used ++;
			}
		}
	}
	if( num_used )
	{
		pak.data[ 0 ] = num_used;
		size = GPOINTER_TO_INT(tmp) - GPOINTER_TO_INT(pak.data);
		size += sizeof( pak.head ) - 2;
/*
		packet_print( (pak.head.ver), size,
		              PACKET_TYPE_UDP | PACKET_DIRECTION_SEND );
*/
		SOCKWRITE( sok, &(pak.head.ver), size );
		seq_num ++;
	}
}

/*
 * Sends Visible List that allows certain
 * users to see you if you are invisible
 */
void snd_vis_list( int sok )
{
	net_icq_pak pak;
	int num_used;
	int i, size;
	char *tmp;

#ifdef TRACE_FUNCTION
	g_print( "snd_vis_list\n" );
#endif
	
	Word_2_Chars( pak.head.ver, ICQ_VER );
	Word_2_Chars( pak.head.cmd, CMD_VIS_LIST );
	Word_2_Chars( pak.head.seq, seq_num );
	DW_2_Chars( pak.head.UIN, our_info->uin );
	
	tmp = pak.data;
	tmp ++;
	for( i = 0, num_used = 0; i < Num_Contacts; i ++ )
	{
		if( (S_DWORD) Contacts[ i ].uin > 0 )
		{
			if( Contacts[ i ].vis_list )
			{
				DW_2_Chars( tmp, Contacts[ i ].uin );
				tmp += 4;
				num_used ++;
			}
		}
	}
	if( num_used )
	{
		pak.data[ 0 ] = num_used;
		size = GPOINTER_TO_INT(tmp) - GPOINTER_TO_INT(pak.data);
		size += sizeof( pak.head ) - 2;
/*
		packet_print( (pak.head.ver), size,
		              PACKET_TYPE_UDP | PACKET_DIRECTION_SEND );
*/
		SOCKWRITE( sok, &(pak.head.ver), size );
		seq_num ++;
	}
}
