# This file is part of the FreeType project.
#
# It builds the library and test programs for emx-gcc and djgpp under MSDOS.
#
# You will need dmake.
#
# Use this file while in the 'test' directory with the following statement:
#
#   dmake -r -f arch/msdos/Makefile.dm

ARCH = arch/msdos
FT_MAKEFILE = $(ARCH)/Makefile.dm
FT_MAKE = dmake -r

.IMPORT: COMSPEC
SHELL := $(COMSPEC)
SHELLFLAGS := /c
GROUPSHELL := $(SHELL)
GROUPFLAGS := $(SHELLFLAGS)
GROUPSUFFIX := .bat
SHELLMETAS := *"?<>&|

CC = gcc

LIBDIR = ../lib
LIBDIR_DOS = ..\lib
INCDIRS = -I$(LIBDIR) -I$(LIBDIR)/$(ARCH) -I. -I$(LIBDIR)/extend

CFLAGS = -Wall -ansi -O2 -g $(INCDIRS)
# CFLAGS = -ansi -Wall -O2 -s $(INCDIRS)

# full-screen MSDOS driver
GDRIVER = $(ARCH)/gfs_dos.c

SRC = ftlint.c fttimer.c ftview.c ftzoom.c ftdump.c ftstring.c \
      common.c

GSRC = gmain.c display.c $(GDRIVER)
GOBJ = $(GSRC:.c=.o)


%.o: %.c
	$(CC) $(CFLAGS) -c -o $@ $<

%.exe:
	$(CC) $(CFLAGS) -o $@ @$(mktmp $(&:t"\n")\n)


EXEFILES = ftview.exe ftlint.exe fttimer.exe ftdump.exe \
           ftstring.exe ftzoom.exe

.PHONY: all debug freetype freetype_debug \
        clean distclean do_clean do_distclean depend


all: freetype $(EXEFILES)

debug: freetype_debug $(EXEFILES)

freetype:
[
	cd $(LIBDIR_DOS)
	$(FT_MAKE) -f $(FT_MAKEFILE) all
	cd $(MAKEDIR)
]

freetype_debug:
[
	cd $(LIBDIR_DOS)
	$(FT_MAKE) -f $(FT_MAKEFILE) debug
	cd $(MAKEDIR)
]

ftzoom.exe: $(GOBJ) ftzoom.o common.o $(LIBDIR)/libttf.a
ftview.exe: $(GOBJ) ftview.o common.o $(LIBDIR)/libttf.a
ftlint.exe: ftlint.o common.o $(LIBDIR)/libttf.a
ftdump.exe: ftdump.o common.o $(LIBDIR)/libttf.a
ftstring.exe: $(GOBJ) ftstring.o common.o $(LIBDIR)/libttf.a
fttimer.exe: $(GOBJ) fttimer.o common.o $(LIBDIR)/libttf.a


clean: do_clean
[
	cd $(LIBDIR_DOS)
	$(FT_MAKE) -f $(FT_MAKEFILE) clean
	cd $(MAKEDIR)
]

distclean: do_clean do_distclean
[
	cd $(LIBDIR_DOS)
	$(FT_MAKE) -f $(FT_MAKEFILE) distclean
	cd $(MAKEDIR)
]

do_distclean:
-[
	del dep.end
	del *.exe
	del core
]

do_clean:
-[
	del *.o
	del arch\msdos\gfs_dos.o
]

#depend: $(SRC) $(GSRC)
#[
#	cd $(LIBDIR_DOS)
#	$(FT_MAKE) -f $(FT_MAKEFILE) depend
#	cd $(MAKEDIR)
#	$(CC) -E -M $(INCDIRS) @$(mktmp $(<:t"\n")\n) > dep.end
#]
#
#ifeq (dep.end,$(wildcard dep.end))
#  include dep.end
#endif

# end of Makefile.dm
