/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.CORBA.dynamic;

import com.visigenic.vbroker.CORBA.GiopInputStream;
import com.visigenic.vbroker.CORBA.GiopOutputStream;
import com.visigenic.vbroker.CORBA.ORB;
import com.visigenic.vbroker.CORBA.OrbHelper;
import com.visigenic.vbroker.CORBA.OrbObject;
import com.visigenic.vbroker.CORBA.ServiceResolver;
import com.visigenic.vbroker.WebNaming.CommFailure;
import com.visigenic.vbroker.WebNaming.InvalidURL;
import com.visigenic.vbroker.WebNaming.ReqFailure;
import com.visigenic.vbroker.WebNaming.Resolver;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.Contained;
import org.omg.CORBA.Context;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTF_REPOS;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.OperationDef;
import org.omg.CORBA.OperationDescription;
import org.omg.CORBA.OperationDescriptionHelper;
import org.omg.CORBA.ParameterDescription;
import org.omg.CORBA.ParameterMode;
import org.omg.CORBA.Repository;
import org.omg.CORBA.RepositoryHelper;
import org.omg.CORBA.Request;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;

public class OrbHelperImpl
implements OrbHelper,
OrbObject {
    private ORB _orb;
    private Context _default_context;
    private Repository _ir;
    private Hashtable _initial_services;
    private TypeCode[] _primitives;
    private Vector _requests = new Vector();
    private Resolver _resolver;
    private static final char[] OCTET_TO_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public void init(ORB oRB, java.lang.Object[] objectArray) {
        this._orb = oRB;
    }

    public String[] list_initial_services() {
        Enumeration enumeration = this.initial_services().keys();
        String[] stringArray = new String[this._initial_services.size()];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public Object resolve_initial_references(String string) throws InvalidName {
        ServiceResolver serviceResolver = (ServiceResolver)this.initial_services().get(string);
        if (serviceResolver == null) {
            throw new InvalidName();
        }
        return serviceResolver.resolve(this._orb);
    }

    private Hashtable initial_services() {
        if (this._initial_services == null) {
            this._initial_services = new Hashtable();
            int n = 0;
            String string = this._orb.getString("InitSVCS");
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    try {
                        String string2 = stringTokenizer.nextToken();
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "=");
                        String string3 = stringTokenizer2.nextToken();
                        String string4 = stringTokenizer2.nextToken();
                        Class<?> clazz = Class.forName(String.valueOf(string4) + ".Resolver");
                        ServiceResolver serviceResolver = (ServiceResolver)clazz.newInstance();
                        this._initial_services.put(string3, serviceResolver);
                        ++n;
                    }
                    catch (Exception exception) {
                        throw new INITIALIZE(exception.toString());
                    }
                }
            }
        }
        return this._initial_services;
    }

    public Repository interface_repository() {
        if (this._ir == null) {
            try {
                ServiceResolver serviceResolver = (ServiceResolver)Class.forName("com.visigenic.vbroker.ir.Resolver").newInstance();
                this._ir = RepositoryHelper.narrow((Object)serviceResolver.resolve(this._orb));
            }
            catch (Exception exception) {
                throw new INTF_REPOS("Could not locate the interface repository: " + exception);
            }
        }
        return this._ir;
    }

    public InterfaceDef get_interface(String string) {
        InterfaceDef interfaceDef;
        Contained contained = this.interface_repository().lookup_id(string);
        if (contained == null) {
            if (contained == null) {
                contained = this.interface_repository().lookup(string);
            }
            if (contained == null) {
                throw new INTF_REPOS("The id is undefined: " + string);
            }
        }
        if ((interfaceDef = InterfaceDefHelper.narrow((Object)contained)) == null) {
            throw new INTF_REPOS("The id is not an interface: " + string);
        }
        return interfaceDef;
    }

    public NVList create_list(int n) {
        NVList nVList = (NVList)this._orb.create(6);
        int n2 = 0;
        while (n2 < n) {
            nVList.add(0);
            ++n2;
        }
        return nVList;
    }

    private int parModeToArgMode(ParameterMode parameterMode) {
        switch (parameterMode.value()) {
            case 0: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 1: {
                return 2;
            }
        }
        throw new BAD_PARAM();
    }

    public NVList create_operation_list(OperationDef operationDef) {
        if (operationDef == null) {
            throw new BAD_PARAM();
        }
        NVList nVList = (NVList)this._orb.create(6);
        OperationDescription operationDescription = OperationDescriptionHelper.extract((Any)operationDef.describe().value);
        int n = 0;
        while (n < operationDescription.parameters.length) {
            ParameterDescription parameterDescription = operationDescription.parameters[n];
            Any any = this._orb.create_any();
            any.type(parameterDescription.type);
            nVList.add_value(parameterDescription.name, any, this.parModeToArgMode(parameterDescription.mode));
            ++n;
        }
        return nVList;
    }

    public NamedValue create_named_value(String string, Any any, int n) {
        java.lang.Object[] objectArray = new java.lang.Object[]{string, any, new Integer(n)};
        NamedValue namedValue = (NamedValue)this._orb.create(7, objectArray);
        return namedValue;
    }

    public Context get_default_context() {
        if (this._default_context == null) {
            this._default_context = (Context)this._orb.create(10);
        }
        return this._default_context;
    }

    public Context create_context(InputStream inputStream) {
        java.lang.Object[] objectArray = new java.lang.Object[]{inputStream};
        return (Context)this._orb.create(10, objectArray);
    }

    public void send_multiple_requests_oneway(Request[] requestArray) {
        int n = 0;
        while (n < requestArray.length) {
            requestArray[n].send_oneway();
            ++n;
        }
    }

    public void send_multiple_requests_deferred(Request[] requestArray) {
        Vector vector = this._requests;
        synchronized (vector) {
            int n = 0;
            while (n < requestArray.length) {
                this._requests.addElement(requestArray[n]);
                requestArray[n].send_deferred();
                ++n;
            }
            return;
        }
    }

    public boolean poll_next_response() {
        Vector vector = this._requests;
        synchronized (vector) {
            Enumeration enumeration = this._requests.elements();
            while (enumeration.hasMoreElements()) {
                if (!((Request)enumeration.nextElement()).poll_response()) continue;
                boolean bl = true;
                java.lang.Object var3_5 = null;
                return bl;
            }
            boolean bl = false;
            java.lang.Object var3_6 = null;
            return bl;
        }
    }

    public Request get_next_response() {
        Vector vector = this._requests;
        synchronized (vector) {
            Enumeration enumeration = this._requests.elements();
            while (enumeration.hasMoreElements()) {
                Request request = (Request)enumeration.nextElement();
                if (!request.poll_response()) continue;
                this._requests.removeElement(request);
                Request request2 = request;
                java.lang.Object var3_6 = null;
                return request2;
            }
            Request request = null;
            java.lang.Object var3_7 = null;
            return request;
        }
    }

    public TypeCode get_primitive_tc(TCKind tCKind) {
        try {
            java.lang.Object object;
            if (this._primitives == null) {
                object = this;
                synchronized (object) {
                    this._primitives = new TypeCode[32];
                    this._primitives[0] = this._orb.create_tc().init_primitive(TCKind.tk_null);
                    this._primitives[1] = this._orb.create_tc().init_primitive(TCKind.tk_void);
                    this._primitives[2] = this._orb.create_tc().init_primitive(TCKind.tk_short);
                    this._primitives[3] = this._orb.create_tc().init_primitive(TCKind.tk_long);
                    this._primitives[4] = this._orb.create_tc().init_primitive(TCKind.tk_ushort);
                    this._primitives[5] = this._orb.create_tc().init_primitive(TCKind.tk_ulong);
                    this._primitives[6] = this._orb.create_tc().init_primitive(TCKind.tk_float);
                    this._primitives[7] = this._orb.create_tc().init_primitive(TCKind.tk_double);
                    this._primitives[8] = this._orb.create_tc().init_primitive(TCKind.tk_boolean);
                    this._primitives[9] = this._orb.create_tc().init_primitive(TCKind.tk_char);
                    this._primitives[10] = this._orb.create_tc().init_primitive(TCKind.tk_octet);
                    this._primitives[11] = this._orb.create_tc().init_primitive(TCKind.tk_any);
                    this._primitives[12] = this._orb.create_tc().init_primitive(TCKind.tk_TypeCode);
                    this._primitives[13] = this._orb.create_tc().init_primitive(TCKind.tk_Principal);
                    this._primitives[23] = this._orb.create_tc().init_primitive(TCKind.tk_longlong);
                    this._primitives[24] = this._orb.create_tc().init_primitive(TCKind.tk_ulonglong);
                    this._primitives[25] = this._orb.create_tc().init_primitive(TCKind.tk_longdouble);
                    this._primitives[26] = this._orb.create_tc().init_primitive(TCKind.tk_wchar);
                    this._primitives[18] = this._orb.create_tc().init_string(0);
                    this._primitives[27] = this._orb.create_tc().init_wstring(0);
                    this._primitives[14] = this._orb.create_tc().init_interface("IDL:omg.org/CORBA/Object:1.0", "CORBA::Object");
                }
            }
            if ((object = this._primitives[tCKind.value()]) == null) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return object;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new BAD_PARAM("Invlalid primitive type code kind: " + tCKind);
        }
    }

    public Object string_to_object(String string) {
        RuntimeException runtimeException;
        try {
            int n = string.length();
            char[] cArray = string.toCharArray();
            if (cArray[0] != 'I' || cArray[1] != 'O' || cArray[2] != 'R' || cArray[3] != ':') {
                throw new INV_OBJREF("IOR prefix must be \"IOR:\"");
            }
            byte[] byArray = new byte[(n - 4) / 2];
            byte[] byArray2 = new byte[2];
            int n2 = 4;
            int n3 = 0;
            while (n2 < n) {
                int n4 = 0;
                while (n4 < 2) {
                    char c = cArray[n2++];
                    switch (c) {
                        case '0': {
                            byArray2[n4] = 0;
                            break;
                        }
                        case '1': {
                            byArray2[n4] = 1;
                            break;
                        }
                        case '2': {
                            byArray2[n4] = 2;
                            break;
                        }
                        case '3': {
                            byArray2[n4] = 3;
                            break;
                        }
                        case '4': {
                            byArray2[n4] = 4;
                            break;
                        }
                        case '5': {
                            byArray2[n4] = 5;
                            break;
                        }
                        case '6': {
                            byArray2[n4] = 6;
                            break;
                        }
                        case '7': {
                            byArray2[n4] = 7;
                            break;
                        }
                        case '8': {
                            byArray2[n4] = 8;
                            break;
                        }
                        case '9': {
                            byArray2[n4] = 9;
                            break;
                        }
                        case 'A': 
                        case 'a': {
                            byArray2[n4] = 10;
                            break;
                        }
                        case 'B': 
                        case 'b': {
                            byArray2[n4] = 11;
                            break;
                        }
                        case 'C': 
                        case 'c': {
                            byArray2[n4] = 12;
                            break;
                        }
                        case 'D': 
                        case 'd': {
                            byArray2[n4] = 13;
                            break;
                        }
                        case 'E': 
                        case 'e': {
                            byArray2[n4] = 14;
                            break;
                        }
                        case 'F': 
                        case 'f': {
                            byArray2[n4] = 15;
                            break;
                        }
                        default: {
                            throw new MARSHAL("Invalid IOR character: " + c);
                        }
                    }
                    byArray[n3] = (byte)(byArray2[0] << 4 | byArray2[1]);
                    ++n4;
                }
                ++n3;
            }
            GiopInputStream giopInputStream = this._orb.newGiopInputStream(byArray);
            giopInputStream.byteOrder(giopInputStream.read_boolean());
            return giopInputStream.read_Object();
        }
        catch (MARSHAL mARSHAL) {
            runtimeException = mARSHAL;
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
            runtimeException = cOMM_FAILURE;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            runtimeException = arrayIndexOutOfBoundsException;
        }
        throw new INV_OBJREF(runtimeException.toString());
    }

    public String object_to_string(Object object) {
        GiopOutputStream giopOutputStream = this._orb.newGiopOutputStream();
        giopOutputStream.write_boolean(false);
        giopOutputStream.write_Object(object);
        byte[] byArray = giopOutputStream.toByteArray();
        char[] cArray = new char[4 + byArray.length * 2];
        int n = 0;
        cArray[n++] = 73;
        cArray[n++] = 79;
        cArray[n++] = 82;
        cArray[n++] = 58;
        int n2 = 0;
        while (n2 < byArray.length) {
            byte by = byArray[n2];
            cArray[n++] = OCTET_TO_CHAR[by >> 4 & 0xF];
            cArray[n++] = OCTET_TO_CHAR[by & 0xF];
            ++n2;
        }
        return new String(cArray);
    }

    public InterfaceDef object_to_interface(Object object) {
        return InterfaceDefHelper.narrow((Object)object);
    }

    public Object resolve_web_name(String string) {
        if (this._resolver == null) {
            this._resolver = (Resolver)this._orb.create(12);
        }
        try {
            return this._resolver.locate(string);
        }
        catch (InvalidURL invalidURL) {
            throw new BAD_PARAM("Bad URL format passed in http-type object name");
        }
        catch (ReqFailure reqFailure) {
            throw new INV_OBJREF("Invalid object ref returned by URL resolver");
        }
        catch (CommFailure commFailure) {
            throw new COMM_FAILURE("Http-server communication problem");
        }
    }
}

