/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Integer
extends Number {
    public static final int MIN_VALUE = -2147483648;
    public static final int MAX_VALUE = 0x7FFFFFFF;
    public static final Class TYPE = Class.getPrimitiveClass("int");
    private int value;
    private static final long serialVersionUID = 1360826667806852920L;

    public static String toString(int n, int n2) {
        boolean bl;
        if (n2 < 2 || n2 > 36) {
            n2 = 10;
        }
        StringBuffer stringBuffer = new StringBuffer(n2 >= 8 ? 12 : 33);
        boolean bl2 = bl = n < 0;
        if (!bl) {
            n = -n;
        }
        while (n <= -n2) {
            stringBuffer.append(Character.forDigit(-(n % n2), n2));
            n /= n2;
        }
        stringBuffer.append(Character.forDigit(-n, n2));
        if (bl) {
            stringBuffer.append('-');
        }
        return stringBuffer.reverse().toString();
    }

    public static String toHexString(int n) {
        return Integer.toUnsignedString(n, 4);
    }

    public static String toOctalString(int n) {
        return Integer.toUnsignedString(n, 3);
    }

    public static String toBinaryString(int n) {
        return Integer.toUnsignedString(n, 1);
    }

    private static String toUnsignedString(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2 >= 3 ? 11 : 32);
        int n3 = 1 << n2;
        int n4 = n3 - 1;
        do {
            stringBuffer.append(Character.forDigit(n & n4, n3));
        } while ((n >>>= n2) != 0);
        return stringBuffer.reverse().toString();
    }

    public static String toString(int n) {
        return Integer.toString(n, 10);
    }

    public static int parseInt(String string, int n) throws NumberFormatException {
        if (string == null) {
            throw new NumberFormatException("null");
        }
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        int n4 = string.length();
        if (n4 > 0) {
            int n5;
            int n6;
            if (string.charAt(0) == '-') {
                bl = true;
                n6 = Integer.MIN_VALUE;
                ++n3;
            } else {
                n6 = -2147483647;
            }
            int n7 = n6 / n;
            if (n3 < n4) {
                if ((n5 = Character.digit(string.charAt(n3++), n)) < 0) {
                    throw new NumberFormatException(string);
                }
                n2 = -n5;
            }
            while (n3 < n4) {
                if ((n5 = Character.digit(string.charAt(n3++), n)) < 0) {
                    throw new NumberFormatException(string);
                }
                if (n2 < n7) {
                    throw new NumberFormatException(string);
                }
                if ((n2 *= n) < n6 + n5) {
                    throw new NumberFormatException(string);
                }
                n2 -= n5;
            }
        } else {
            throw new NumberFormatException(string);
        }
        if (bl) {
            if (n3 > 1) {
                return n2;
            }
            throw new NumberFormatException(string);
        }
        return -n2;
    }

    public static int parseInt(String string) throws NumberFormatException {
        return Integer.parseInt(string, 10);
    }

    public static Integer valueOf(String string, int n) throws NumberFormatException {
        return new Integer(Integer.parseInt(string, n));
    }

    public static Integer valueOf(String string) throws NumberFormatException {
        return new Integer(Integer.parseInt(string, 10));
    }

    public Integer(int n) {
        this.value = n;
    }

    public Integer(String string) throws NumberFormatException {
        this.value = Integer.parseInt(string, 10);
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Integer) {
            return this.value == (Integer)object;
        }
        return false;
    }

    public static Integer getInteger(String string) {
        return Integer.getInteger(string, null);
    }

    public static Integer getInteger(String string, int n) {
        Integer n2 = Integer.getInteger(string, null);
        if (n2 == null) {
            return new Integer(n);
        }
        return n2;
    }

    public static Integer getInteger(String string, Integer n) {
        SecurityManager.enablePrivilege("UniversalPropertyRead");
        String string2 = System.getProperty(string);
        if (string2 != null) {
            try {
                return Integer.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return n;
    }

    public static Integer decode(String string) throws NumberFormatException {
        if (string.startsWith("0x")) {
            return Integer.valueOf(string.substring(2), 16);
        }
        if (string.startsWith("#")) {
            return Integer.valueOf(string.substring(1), 16);
        }
        if (string.startsWith("0") && string.length() > 1) {
            return Integer.valueOf(string.substring(1), 8);
        }
        return Integer.valueOf(string);
    }
}

