/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Event;
import java.awt.FocusManager;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.peer.WindowPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Locale;

public class Window
extends Container {
    String warningString;
    boolean isSecure;
    static final int OPENED = 1;
    int state;
    transient WindowListener windowListener;
    private FocusManager focusMgr;
    private static final String base = "win";
    private static int nameCounter;
    private static final long serialVersionUID = 4497834738069338734L;
    private int windowSerializedDataVersion = 1;

    private void init() {
        if (this instanceof Frame || this instanceof Dialog) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null && !securityManager.checkTopLevelWindow(this)) {
                this.warningString = securityManager.getNonSystemPrincipalFromStack(this);
                this.isSecure = securityManager.isSecurePrincipalFromStack(this);
                return;
            }
        } else {
            this.warningString = null;
            this.isSecure = true;
        }
    }

    Window() {
        this.name = base + nameCounter++;
        this.init();
        this.focusMgr = new FocusManager(this);
        this.visible = false;
    }

    public Window(Frame frame) {
        this();
        if (frame == null) {
            throw new IllegalArgumentException("null parent frame");
        }
        this.parent = frame;
        frame.addOwnedWindow(this);
        this.setLayout(new BorderLayout());
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createWindow(this);
        }
        super.addNotify();
    }

    public void pack() {
        Container container = this.parent;
        if (container != null && container.getPeer() == null) {
            container.addNotify();
        }
        if (this.peer == null) {
            this.addNotify();
        }
        this.setSize(this.getPreferredSize());
        this.validate();
    }

    public void show() {
        if (this instanceof Dialog) {
            ((Dialog)this).__showDialog();
            return;
        }
        Container container = this.parent;
        if (container != null && container.getPeer() == null) {
            container.addNotify();
        }
        if (this.peer == null) {
            this.addNotify();
        }
        this.validate();
        if (this.visible) {
            this.toFront();
        } else {
            super.show();
        }
        if ((this.state & 1) == 0) {
            this.postWindowEvent(200);
            this.state |= 1;
        }
    }

    synchronized void postWindowEvent(int n) {
        if (this.windowListener != null || (this.eventMask & 0x40L) != 0L) {
            WindowEvent windowEvent = new WindowEvent(this, n);
            Toolkit.getEventQueue().postEvent(windowEvent);
        }
    }

    public void dispose() {
        this.hide();
        this.removeNotify();
        if (this.parent != null) {
            Frame frame = (Frame)this.parent;
            frame.removeOwnedWindow(this);
        }
        this.postWindowEvent(202);
    }

    public void toFront() {
        WindowPeer windowPeer = (WindowPeer)this.peer;
        if (windowPeer != null) {
            windowPeer.toFront();
            return;
        }
        this.show();
    }

    public void toBack() {
        WindowPeer windowPeer = (WindowPeer)this.peer;
        if (windowPeer != null) {
            windowPeer.toBack();
        }
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    public final String getWarningString() {
        return this.warningString;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    public synchronized void addWindowListener(WindowListener windowListener) {
        this.windowListener = AWTEventMulticaster.add(this.windowListener, windowListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeWindowListener(WindowListener windowListener) {
        this.windowListener = AWTEventMulticaster.remove(this.windowListener, windowListener);
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        switch (aWTEvent.id) {
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: {
                return (this.eventMask & 0x40L) != 0L || this.windowListener != null;
            }
        }
        return super.eventEnabled(aWTEvent);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof WindowEvent) {
            this.processWindowEvent((WindowEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (this.windowListener != null) {
            switch (windowEvent.getID()) {
                case 200: {
                    this.windowListener.windowOpened(windowEvent);
                    return;
                }
                case 201: {
                    this.windowListener.windowClosing(windowEvent);
                    return;
                }
                case 202: {
                    this.windowListener.windowClosed(windowEvent);
                    return;
                }
                case 203: {
                    this.windowListener.windowIconified(windowEvent);
                    return;
                }
                case 204: {
                    this.windowListener.windowDeiconified(windowEvent);
                    return;
                }
                case 205: {
                    this.windowListener.windowActivated(windowEvent);
                    return;
                }
                case 206: {
                    this.windowListener.windowDeactivated(windowEvent);
                    return;
                }
            }
        }
    }

    private boolean handleTabEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() != 9 || keyEvent.getSource() instanceof TextArea) {
            return false;
        }
        if ((keyEvent.getModifiers() & 0xFFFFFFFE) > 0) {
            return false;
        }
        int n = keyEvent.getID();
        if (n == 402 || n == 400) {
            return true;
        }
        if (keyEvent.isShiftDown()) {
            return this.focusMgr.focusPrevious();
        }
        return this.focusMgr.focusNext();
    }

    void preProcessKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.isActionKey() && keyEvent.getKeyCode() == 112 && keyEvent.isControlDown() && keyEvent.isShiftDown()) {
            this.list(System.out, 0);
        }
    }

    void postProcessKeyEvent(KeyEvent keyEvent) {
        if (this.handleTabEvent(keyEvent)) {
            keyEvent.consume();
            return;
        }
    }

    void setFocusOwner(Component component) {
        this.focusMgr.setFocusOwner(component);
    }

    void transferFocus(Component component) {
        this.nextFocus(component);
    }

    public Component getFocusOwner() {
        return this.focusMgr.getFocusOwner();
    }

    void nextFocus(Component component) {
        this.focusMgr.focusNext(component);
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        switch (aWTEvent.getID()) {
            case 1004: {
                this.setFocusOwner(this);
                break;
            }
            case 101: {
                this.invalidate();
                this.validate();
                this.repaint();
                break;
            }
        }
        super.dispatchEventImpl(aWTEvent);
    }

    public boolean postEvent(Event event) {
        if (this.handleEvent(event)) {
            event.consume();
            return true;
        }
        return false;
    }

    public boolean isShowing() {
        return this.visible;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "windowL", this.windowListener);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        objectInputStream.defaultReadObject();
        while ((object = objectInputStream.readObject()) != null) {
            String string = ((String)object).intern();
            if (string == "windowL") {
                this.addWindowListener((WindowListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
    }
}

