/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.ber.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BERTagDecoder;

public class BEROctetString
extends BERElement {
    private byte[] m_value;

    public BEROctetString(String string) {
        if (string == null) {
            return;
        }
        try {
            this.m_value = string.getBytes("UTF8");
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public BEROctetString(byte[] byArray) {
        this.m_value = byArray;
    }

    public BEROctetString(byte[] byArray, int n, int n2) {
        this.m_value = new byte[n2 - n];
        int n3 = 0;
        while (n3 < n2 - n) {
            this.m_value[n3] = byArray[n + n3];
            ++n3;
        }
    }

    public BEROctetString(BERTagDecoder bERTagDecoder, InputStream inputStream, int[] nArray) throws IOException {
        int n = BERElement.readLengthOctets(inputStream, nArray);
        int[] nArray2 = new int[1];
        BERElement bERElement = null;
        if (n == -1) {
            do {
                nArray2[0] = 0;
                bERElement = BERElement.getElement(bERTagDecoder, inputStream, nArray2);
                if (bERElement == null) continue;
                BEROctetString bEROctetString = (BEROctetString)bERElement;
                byte[] byArray = bEROctetString.getValue();
                if (this.m_value == null) {
                    this.m_value = new byte[byArray.length];
                    System.arraycopy(byArray, 0, this.m_value, 0, byArray.length);
                    continue;
                }
                byte[] byArray2 = new byte[this.m_value.length + byArray.length];
                System.arraycopy(this.m_value, 0, byArray2, 0, this.m_value.length);
                System.arraycopy(byArray, 0, byArray2, this.m_value.length, byArray.length);
                this.m_value = byArray2;
            } while (bERElement != null);
            return;
        }
        nArray[0] = nArray[0] + n;
        this.m_value = new byte[n];
        inputStream.read(this.m_value, 0, n);
    }

    public BEROctetString(InputStream inputStream, int[] nArray) throws IOException {
        int n = BERElement.readLengthOctets(inputStream, nArray);
        if (n > 0) {
            this.m_value = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                this.m_value[n2] = (byte)inputStream.read();
                ++n2;
            }
            nArray[0] = nArray[0] + n;
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(4);
        if (this.m_value == null) {
            BERElement.sendDefiniteLength(outputStream, 0);
            return;
        }
        BERElement.sendDefiniteLength(outputStream, this.m_value.length);
        outputStream.write(this.m_value, 0, this.m_value.length);
    }

    public byte[] getValue() {
        return this.m_value;
    }

    public int getType() {
        return 4;
    }

    public String toString() {
        if (this.m_value == null) {
            return "OctetString (null)";
        }
        String string = "";
        int n = 0;
        while (n < this.m_value.length) {
            if (n != 0) {
                string = String.valueOf(string) + " ";
            }
            string = String.valueOf(string) + this.byteToHexString(this.m_value[n]);
            ++n;
        }
        return "OctetString {" + string + "}";
    }
}

