#ifndef lint
static char sccsid[] = "@(#)husker.c	3.11h 96/09/30 xlockmore";

#endif
/*-
 * husker.c - xpm husker image bouncer for xlock, the X Window System
 * lockscreen.
 *
 * Copyright (c) 1995 by Skip Burrell <Skip_Burrell@sterling.com>.
 *
 * See xlock.c for copying information.
 *
 * Revision History:
 * 25-May-95: Written. Originally derived from image.c.
 */

#include "xlock.h"
#ifdef HAS_XPM
#include <X11/xpm.h>
#include "pixmaps/husker.xpm"
#include "pixmaps/husker_tiny.xpm"
#else
#include "bitmaps/husker.xbm"
#include "bitmaps/husker_tiny.xbm"
#endif

ModeSpecOpt husker_opts =
{0, NULL, 0, NULL, NULL};

static XImage *Logo = NULL;
static XImage *Small_logo = NULL;

#ifndef HAS_XPM
static unsigned long RWcolors[2];

static XImage BmLogo =
{
	0, 0,			/* width, height */
	0, XYBitmap, 0,		/* xoffset, format, data */
	LSBFirst, 8,		/* byte-order, bitmap-unit */
	LSBFirst, 8, 1		/* bitmap-bit-order, bitmap-pad, depth */
};
static XImage BmSmall_logo =
{
	0, 0,			/* width, height */
	0, XYBitmap, 0,		/* xoffset, format, data */
	LSBFirst, 8,		/* byte-order, bitmap-unit */
	LSBFirst, 8, 1		/* bitmap-bit-order, bitmap-pad, depth */
};

#endif

#define MAXICONS 64

typedef struct {
	int         x;
	int         y;
} point;

typedef struct {
	int         width;
	int         height;
	int         nrows;
	int         ncols;
	int         xb;
	int         yb;
	int         xoff;
	int         yoff;
	int         iconmode;
	int         iconcount;
	point       icons[MAXICONS];
} imagestruct;

static imagestruct ims[MAXSCREENS];


void
draw_husker(ModeInfo * mi)
{
	Display    *display = MI_DISPLAY(mi);
	GC          gc = MI_GC(mi);
	imagestruct *ip = &ims[MI_SCREEN(mi)];
	int         i;
	XImage     *logo;

	logo = ip->iconmode ? Small_logo : Logo;

	XSetForeground(display, gc, MI_WIN_BLACK_PIXEL(mi));
	for (i = 0; i < ip->iconcount; i++) {
		if (!ip->iconmode)
			XFillRectangle(display, MI_WINDOW(mi), gc,
			    ip->xb + logo->width * ip->icons[i].x + ip->xoff,
			   ip->yb + logo->height * ip->icons[i].y + ip->yoff,
				       logo->width, logo->height);

		ip->icons[i].x = (ip->ncols ? NRAND(ip->ncols) : 0);
		ip->icons[i].y = (ip->nrows ? NRAND(ip->nrows) : 0);
	}
	if (MI_NPIXELS(mi) <= 2)
		XSetForeground(display, gc, MI_WIN_WHITE_PIXEL(mi));
	for (i = 0; i < ip->iconcount; i++) {
#ifndef HAS_XPM
		if (MI_NPIXELS(mi) > 2)
			XSetForeground(display, gc, RWcolors[LRAND() & 1]);
#endif

		XPutImage(display, MI_WINDOW(mi), gc, logo,
			  0, 0,
			  ip->xb + logo->width * ip->icons[i].x + ip->xoff,
			  ip->yb + logo->height * ip->icons[i].y + ip->yoff,
			  logo->width, logo->height);
	}
}


void
init_husker(ModeInfo * mi)
{
	Display    *display = MI_DISPLAY(mi);
	imagestruct *ip = &ims[MI_SCREEN(mi)];
	XImage     *logo;

#ifndef HAS_XPM
	static int  initialized = 0;

	if (!initialized) {
		XColor      xcolor, rgbcolor;
		Screen     *scr;

		scr = ScreenOfDisplay(display, MI_SCREEN(mi));
		(void) XAllocNamedColor(display, DefaultColormapOfScreen(scr),
					"Red", &xcolor, &rgbcolor);
		RWcolors[0] = xcolor.pixel;
		RWcolors[1] = MI_WIN_WHITE_PIXEL(mi);
		initialized = 1;
	}
	if (!Logo) {
		BmLogo.data = (char *) husker_bits;
		BmLogo.width = husker_width;
		BmLogo.height = husker_height;
		BmLogo.bytes_per_line = (husker_width + 7) / 8;
		Logo = &BmLogo;
	}
	if (!Small_logo) {
		BmSmall_logo.data = (char *) husker_tiny_bits;
		BmSmall_logo.width = husker_tiny_width;
		BmSmall_logo.height = husker_tiny_height;
		BmSmall_logo.bytes_per_line = (husker_tiny_width + 7) / 8;
		Small_logo = &BmSmall_logo;
	}
#else
	if (!Logo)
		XpmCreateImageFromData(display, (char **) husker_xpm,
			    &Logo, (XImage **) NULL, (XpmAttributes *) NULL);
	if (!Small_logo)
		XpmCreateImageFromData(display, (char **) husker_tiny_xpm,
		      &Small_logo, (XImage **) NULL, (XpmAttributes *) NULL);
#endif

	ip->width = MI_WIN_WIDTH(mi);
	ip->height = MI_WIN_HEIGHT(mi);
	if ((ip->width < Logo->width) || (ip->height < Logo->height)) {
		logo = Small_logo;
	} else {
		logo = Logo;
	}

	ip->ncols = ip->width / logo->width;
	ip->nrows = ip->height / logo->height;
	ip->xoff = (ip->width - ip->ncols * logo->width) / 2;
	ip->yoff = (ip->height - ip->nrows * logo->height) / 2;
	ip->iconmode = (ip->ncols < 2 || ip->nrows < 2);
	if (ip->iconmode) {
		ip->xb = 0;
		ip->yb = 0;
		ip->iconcount = 1;	/* icon mode */
	} else {
		ip->xb = (ip->width - logo->width * ip->ncols) / 2;
		ip->yb = (ip->height - logo->height * ip->nrows) / 2;
		ip->iconcount = MI_BATCHCOUNT(mi);
		if (ip->iconcount > MAXICONS)
			ip->iconcount = 16;
	}
	XClearWindow(display, MI_WINDOW(mi));
}

void
release_husker(ModeInfo * mi)
{
}
