#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include "msdos.h"
#include "mtools.h"
#include "patchlevel.h"

const char *mversion = VERSION;
const char *mdate = DATE;

#define DISPATCH(cmd,fn,type) if (!strcmp(name,cmd)) fn(argc, argv, type)


void main(int argc,char **argv)
{
	char *name;
	
	if ((name = strrchr(argv[0],'/')))
		name++;
	else name = argv[0];
	argv[0] = name;
	
	read_config();
	setup_signal();
	
	DISPATCH("mattrib",mattrib, 0);
	DISPATCH("mbadblocks",mbadblocks, 0);
	DISPATCH("mcd",mcd, 0);
	DISPATCH("mcopy",mcopy, 0);
	DISPATCH("mdel",mdel, 0);
	DISPATCH("mdeltree",mdel, 2);
	DISPATCH("mdir",mdir, 0);
	DISPATCH("mformat",mformat, 0);
	DISPATCH("mlabel",mlabel, 0);
	DISPATCH("mmd",mmd, 0);
	DISPATCH("mmount",mmount, 0);
	DISPATCH("mrd",mdel, 1);
	DISPATCH("mread",mcopy, 0);
	DISPATCH("mmove",mmove, 0);
	DISPATCH("mren",mmove, 1);
	DISPATCH("mtest", mtest, 0);
	DISPATCH("mtype",mcopy, 1);
	DISPATCH("mwrite",mcopy, 0);
	fprintf(stderr,"Unknown mtools command '%s'\n",name);
	exit(1);
}
