/*
 * $Id: params.h,v 1.5 1995/06/30 09:42:12 coleman Exp coleman $
 *
 * params.h - header file for parameter handling code
 *
 * This file is part of zsh, the Z shell.
 *
 * Copyright (c) 1992-1995 Paul Falstad
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * In no event shall Paul Falstad or the Zsh Development Group be liable
 * to any party for direct, indirect, special, incidental, or consequential
 * damages arising out of the use of this software and its documentation,
 * even if Paul Falstad and the Zsh Development Group have been advised of
 * the possibility of such damage.
 *
 * Paul Falstad and the Zsh Development Group specifically disclaim any
 * warranties, including, but not limited to, the implied warranties of
 * merchantability and fitness for a particular purpose.  The software
 * provided hereunder is on an "as is" basis, and Paul Falstad and the
 * Zsh Development Group have no obligation to provide maintenance,
 * support, updates, enhancements, or modifications.
 *
 */

struct iparam {
    struct hashnode *next;
    char *nam;			/* hash data                             */
    void *value;
    int (*func1) ();		/* set func                              */
    int (*func2) ();		/* get func                              */
    int ct;			/* output base or field width            */
    int flags;			/* PM_* flags (defined in zsh.h)         */
    void *data;			/* used by getfns                        */
    char *env;			/* location in environment, if exported  */
    char *ename;		/* name of corresponding environment var */
    Param old;			/* old struct for use with local         */
    int level;			/* if (old != NULL), level of localness  */
};

#define IFN(X) ((int (*)())(X))

struct iparam special_param[] =
    {
#define IPDEF1(A,B,C,D) {NULL,A,NULL,IFN(C),IFN(B),10,\
		PM_INTEGER|PM_SPECIAL|D,NULL,NULL,NULL,NULL,0}
	IPDEF1("#", poundgetfn, IFN(nullsetfn), PM_READONLY),
	IPDEF1("ARGC", poundgetfn, IFN(nullsetfn), PM_READONLY),
	IPDEF1("ERRNO", errnogetfn, IFN(nullsetfn), PM_READONLY),
	IPDEF1("GID", gidgetfn, gidsetfn, 0),
	IPDEF1("EGID", egidgetfn, egidsetfn, 0),
	IPDEF1("HISTSIZE", histsizegetfn, histsizesetfn, 0),
	IPDEF1("LITHISTSIZE", lithistsizegetfn, lithistsizesetfn, 0),
	IPDEF1("RANDOM", randomgetfn, randomsetfn, 0),
	IPDEF1("SECONDS", secondsgetfn, secondssetfn, 0),
	IPDEF1("UID", uidgetfn, uidsetfn, 0),
	IPDEF1("EUID", euidgetfn, euidsetfn, 0),

#define IPDEF2(A,B,C,D) {NULL,A,NULL,IFN(C),IFN(B),0,\
		PM_SCALAR|PM_SPECIAL|D,NULL,NULL,NULL,NULL,0}
	IPDEF2("USERNAME", usernamegetfn, usernamesetfn, 0),
	IPDEF2("-", dashgetfn, IFN(nullsetfn), PM_READONLY),
	IPDEF2("histchars", histcharsgetfn, histcharssetfn, 0),
	IPDEF2("HOME", homegetfn, homesetfn, 0),
	IPDEF2("TERM", termgetfn, termsetfn, 0),
	IPDEF2("WORDCHARS", wordcharsgetfn, wordcharssetfn, 0),
	IPDEF2("IFS", ifsgetfn, ifssetfn, 0),
	IPDEF2("_", underscoregetfn, IFN(nullsetfn), PM_READONLY),
#ifdef LC_ALL
	IPDEF2("LANG", strgetfn, langsetfn, 0),
#endif

#define IPDEF4(A,B) {NULL,A,NULL,IFN(nullsetfn),IFN(intvargetfn),10,\
		PM_INTEGER|PM_READONLY|PM_SPECIAL,(void *)B,NULL,NULL,NULL,0}
	IPDEF4("!", &lastpid),
	IPDEF4("$", &mypid),
	IPDEF4("?", &lastval),
	IPDEF4("status", &lastval),
	IPDEF4("LINENO", &lineno),
	IPDEF4("PPID", &ppid),

#define IPDEF5(A,B) {NULL,A,NULL,IFN(intvarsetfn),IFN(intvargetfn),10,\
		PM_INTEGER|PM_SPECIAL,(void *)B,NULL,NULL,NULL,0}
	IPDEF5("BAUD", &baud),
	IPDEF5("COLUMNS", &columns),
	IPDEF5("DIRSTACKSIZE", &dirstacksize),
	IPDEF5("KEYTIMEOUT", &keytimeout),
	IPDEF5("LINES", &lines),
	IPDEF5("LISTMAX", &listmax),
	IPDEF5("LOGCHECK", &logcheck),
	IPDEF5("MAILCHECK", &mailcheck),
	IPDEF5("OPTIND", &zoptind),
	IPDEF5("PERIOD", &period),
	IPDEF5("REPORTTIME", &reporttime),
	IPDEF5("SAVEHIST", &savehist),
	IPDEF5("SHLVL", &shlvl),
	IPDEF5("TMOUT", &tmout),

#define IPDEF6(A,B) {NULL,A,NULL,IFN(nullsetfn),IFN(strvargetfn),0,\
		PM_SCALAR|PM_READONLY|PM_SPECIAL,(void *)B,NULL,NULL,NULL,0}
	IPDEF6("LOGNAME", &login_name),
	IPDEF6("PWD", &pwd),
	IPDEF6("TTY", &ttystrname),

#define IPDEF7(A,B) {NULL,A,NULL,IFN(strvarsetfn),IFN(strvargetfn),0,\
		PM_SCALAR|PM_SPECIAL,(void *)B,NULL,NULL,NULL,0}
	IPDEF7("FCEDIT", &fceditparam),
	IPDEF7("HOST", &hostvar),
	IPDEF7("OLDPWD", &oldpwd),
	IPDEF7("OPTARG", &zoptarg),
	IPDEF7("MAIL", &mailfile),
	IPDEF7("NULLCMD", &nullcmd),
	IPDEF7("POSTEDIT", &postedit),
	IPDEF7("prompt", &prompt),
	IPDEF7("PROMPT", &prompt),
	IPDEF7("PROMPT2", &prompt2),
	IPDEF7("PROMPT3", &prompt3),
	IPDEF7("PROMPT4", &prompt4),
	IPDEF7("READNULLCMD", &readnullcmd),
	IPDEF7("RPROMPT", &rprompt),
	IPDEF7("PS1", &prompt),
	IPDEF7("PS2", &prompt2),
	IPDEF7("PS3", &prompt3),
	IPDEF7("PS4", &prompt4),
	IPDEF7("RPS1", &rprompt),
	IPDEF7("SPROMPT", &sprompt),
	IPDEF7("TIMEFMT", &timefmt),
	IPDEF7("TMPPREFIX", &tmpprefix),
	IPDEF7("WATCHFMT", &watchfmt),
	IPDEF7("0", &argzero),

#define IPDEF8(A,B,C) {NULL,A,NULL,IFN(colonarrsetfn),IFN(colonarrgetfn),0,\
		PM_SCALAR|PM_SPECIAL,(void *)B,NULL,C,NULL,0}
	IPDEF8("CDPATH", &cdpath, "cdpath"),
	IPDEF8("FIGNORE", &fignore, "fignore"),
	IPDEF8("FPATH", &fpath, "fpath"),
	IPDEF8("MAILPATH", &mailpath, "mailpath"),
	IPDEF8("MANPATH", &manpath, "manpath"),
	IPDEF8("WATCH", &watch, "watch"),
	IPDEF8("PSVAR", &psvar, "psvar"),

	{NULL, "PATH", NULL, IFN(colonpathsetfn), IFN(colonpathgetfn), 0,
	 PM_SPECIAL, (void *) NULL, NULL, "path", NULL, 0},

#define IPDEF9(A,B,C,D) {NULL,A,NULL,IFN(arrvarsetfn),IFN(arrvargetfn),0,\
		PM_ARRAY|PM_SPECIAL|B,(void *)C,NULL,D,NULL,0}
	IPDEF9("cdpath", 0, &cdpath, "CDPATH"),
	IPDEF9("fignore", 0, &fignore, "FIGNORE"),
	IPDEF9("fpath", 0, &fpath, "FPATH"),
	IPDEF9("mailpath", 0, &mailpath, "MAILPATH"),
	IPDEF9("manpath", 0, &manpath, "MANPATH"),
	IPDEF9("watch", 0, &watch, "WATCH"),
	IPDEF9("psvar", 0, &psvar, "PSVAR"),
	IPDEF9("signals", PM_READONLY, &sigptr, NULL),
	IPDEF9("argv", 0, &pparams, NULL),
	IPDEF9("*", 0, &pparams, NULL),
	IPDEF9("@", 0, &pparams, NULL),

	{NULL, "path", NULL, IFN(pathsetfn), IFN(pathgetfn), 0,
	 PM_ARRAY | PM_SPECIAL, NULL, NULL, "PATH", NULL, 0},

	{NULL,}
    };

