/*
 * Mount an MSDOS disk
 *
 * written by:
 *
 * Alain L. Knaff			
 * Alain.Knaff@imag.fr
 *
 */

#include <sys/types.h>
#include <fcntl.h>
#include <stdio.h>

#ifdef linux
#include <errno.h>
#include <unistd.h>
#include <stdlib.h>
#include "msdos.h"
#include "mtools.h"
#include "patchlevel.h"
#include <linux/fd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include "streamcache.h"
#include "fs.h"

extern int errno;

void mmount(int argc, char **argv, int type)
{
	char drive;
	int pid;
	int status;
	struct device dev;
	char name[EXPAND_BUF];
	int media;
	struct bootsector boot;
	Stream_t *Stream;
	
	if (argc<2 && !argv[1][0])
		fprintf(stderr,"Usage: %s drive:\n", argv[0]);
	drive = argv[1][0];
	Stream = find_device(drive, O_RDONLY, &dev, &boot, name, &media);
	if(!Stream)
		exit(1);
	FREE(&Stream);

	/* and finally mount it */
	switch((pid=fork())){
	case -1:
		fprintf(stderr,"fork failed\n");
		exit(1);
	case 0:
		close(2);
		open("/dev/null", O_RDWR);
		argv[1] = "mount" ;
		if ( argc > 2 )
			execvp("mount", argv + 1 );
		else
			execlp("mount", "mount", name, 0);
		perror("exec mount");
		exit(1);
	default:
		while ( wait(&status) != pid );
	}	
	if ( WEXITSTATUS(status) == 0 )
		exit(0);
	argv[0] = "mount";
	argv[1] = "-r";
	if ( argc > 2 )
		execvp("mount", argv);
	else
		execlp("mount", "mount","-r", name, 0);
	exit(1);
}

#else /* linux */

#include "msdos.h"

void
mmount()
{
  fprintf(stderr,"This command is only available for LINUX \n");
  exit(1);
}
#endif /* linux */

