%% 
%% This is file `exam.cls', generated 
%% on <1994/7/28> with the docstrip utility (2.2h).
%% 
%% The original source files were:
%% 
%% exam.dtx  (with options: `exam')
%% 
%% IMPORTANT NOTICE: 
%% 
%% Please do not request updates from us directly. Distribution is 
%% done through Mail-Servers and TeX organizations. 
%% 
%% You are not allowed to change this file. 
%% 
%% You are NOT ALLOWED to distribute this file alone. You are NOT 
%% ALLOWED to take money for the distribution or use of either this 
%% file or a changed version, except for a nominal charge for copying 
%% etc. 
%% \CharacterTable
%%  {Upper-case    \A\B\C\D\E\F\G\H\I\J\K\L\M\N\O\P\Q\R\S\T\U\V\W\X\Y\Z
%%   Lower-case    \a\b\c\d\e\f\g\h\i\j\k\l\m\n\o\p\q\r\s\t\u\v\w\x\y\z
%%   Digits        \0\1\2\3\4\5\6\7\8\9
%%   Exclamation   \!     Double quote  \"     Hash (number) \#
%%   Dollar        \$     Percent       \%     Ampersand     \&
%%   Acute accent  \'     Left paren    \(     Right paren   \)
%%   Asterisk      \*     Plus          \+     Comma         \,
%%   Minus         \-     Point         \.     Solidus       \/
%%   Colon         \:     Semicolon     \;     Less than     \<
%%   Equals        \=     Greater than  \>     Question mark \?
%%   Commercial at \@     Left bracket  \[     Backslash     \\
%%   Right bracket \]     Circumflex    \^     Underscore    \_
%%   Grave accent  \`     Left brace    \{     Vertical bar  \|
%%   Right brace   \}     Tilde         \~}
\NeedsTeXFormat{LaTeX2e}[1993/12/01]
\def\fileversion{3.0a}
\def\filedate{1994/02/13}
\def\filename{exam.dtx}
\ProvidesClass{exam}[\filedate\space Production of exams]
\typeout{Standard Document Class `exam' <\filedate>.}
\newif\ifanswers
\DeclareOption{answers}{\answerstrue\newwrite\listfile}
\newif\ifseries
\DeclareOption{series}{\seriestrue\answerstrue}
\newcommand\parentclass{artikel1}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{\parentclass}}
\PassOptionsToClass{titlepage,12pt}{\parentclass}
\ProcessOptions
\LoadClass{\parentclass}
\newcounter{examnum}
\newenvironment{exam}[2][0]{%
  \stepcounter{examnum}%
  \@ifemptyarg{#2}{}{\date{#2}}%
  \ifseries\SRset{0}\maketitle\else\SRset{#1}%
    \ifanswers
      \immediate\openout\listfile=\jobname.lst
      \immediate\write\listfile{\Exam\space\@date}%
      \immediate\write\listfile{Random generator = \SRvalue}%
  \fi\fi
  \setcounter{page}{1}}{%
  \ifseries\else
    \ifanswers\makelist\fi
    \maketitle
  \fi}
\newcommand\makelist{%
  \immediate\closeout\listfile
  \immediate\openin\listfile=\jobname.lst
  \newpage
  \begin{ttfamily}
    \parskip=\z@skip\parindent=\z@
    \obeylines
    \makeatletter
    \InputIfFileExists{\jobname.lst}%
      {}{\typeout{ERROR! File \jobname.lst not found}}%
    \makeatother
  \end{ttfamily}
  \immediate\closein\listfile
  \newpage}
\newcounter{problemnum}[examnum]
\newtoks\problemid
\newcommand\question[3][]{%
  \renewcommand\parameter{#1}%
  \ifseries
    \uppercase{\def\@namesection{#2}}%
    \ifx\namesection\@namesection
    \else
      \newpage
      \global\let\namesection=\@namesection
      \addcontentsline{toc}{subsection}{\namesection}%
      \setcounter{problemnum}{0}%
    \fi
  \fi
  \problemid={\uppercase{#3}}%
  \ifseries
    \noindent\underbar{\emph{File\,:}~\texttt{\the\problemid}}\par
    \nobreak\medskip\nobreak
  \fi
  \stepcounter{problemnum}%
  \IfFileExists{\mainfolder#2:#3}{\@@input \mainfolder#2:#3}%
    {\typeout{ERROR! File \mainfolder#2:#3 not found \on@line}}%
  \ifseries\else
    \addtocounter{totalscore}{\value{scorecounter}}%
    \typeout{\Problem\ \theproblemnum: %
      score=\thescorecounter (\thetotalscore)}%
  \fi
  \ifseries\else\ifanswers
    \immediate\write\listfile{\hbox to\textwidth{%
      \hbox to1cm{\theproblemnum:~\hfil}%
      \hbox to8cm{#2:#3\hfil}%
      \hbox to3cm{score=\thetotalscore (\thescorecounter)\hfil}%
      \hfil}}%
  \fi\fi}
\newcommand\namesection{}
\newcommand\parameter{}
\newcommand\parameterproblem[2][1]{%
  \ifseries
    \begin{center}%
    \fbox{\parbox{.9\linewidth}{%
      \hangafter1
      \settowidth{\hangindent}{\emph{Parameter \Problem\,:}~}%
      \strut\emph{Parameter \Problem\,:}~#2}}%
    \end{center}\addvspace{5mm}%
  \fi
  \ifx\parameter\@empty
    \typeout{ERROR! Missing parameter \on@line}%
    \def\parameter{#1}% supplies a default
  \fi}
\newtoks\everyproblem
\newenvironment{problem}[1][]{%
  \@tagsforbidfalse\compact\the\everyproblem#1\@tagsforbidtrue
  \@boxing\bgroup\noindent\problemstart\ignorespaces}%
  {\par\nobreak\smallskip\nobreak
  \hbox to\linewidth{\hrulefill
    \ifseries\emph{\footnotesize\thinspace\the\@problemdate}\fi}%
  \egroup\par\bigskip\@resetproblemdate}
\newcommand\compact{\@chktag\compact\def\@boxing{\noindent\vbox}\fi}
\newcommand\split{\@chktag\split\def\@boxing{}\@empty\fi}
\newif\if@tagsforbid \@tagsforbidtrue
\providecommand\@chktag[1]{%
  \if@tagsforbid\@warning{tag \string#1\space ignored here}\else}
\newcommand\@problemstart{%
  \textbo{\Problem\,\ifnum\value{problemnum}<10 \phantom{0}\fi
  \theproblemnum}.\enskip}
\newcommand\problemstart{%
  \hangafter-2\settowidth\hangindent{\@problemstart}%
  \noindent\llap{\@problemstart}}
\newtoks\@problemdate
\newcommand\problemdate[1]{\global\@problemdate={#1}\ignorespaces}
\newcommand\@resetproblemdate{\global\@problemdate={}}
\newcounter{totalscore}[examnum]
\newcounter{scorecounter}[problemnum]
\newcommand\scoreboxsize{7mm}
\newcommand\scorebox[1]{%
  \fbox{\vbox to\scoreboxsize{\vss\hbox to\scoreboxsize{\hss#1\hss}\vss}}}
\newcommand\score[1]{%
  \addtocounter{scorecounter}{#1}%
  \rightnote[-\normalbaselineskip]{\scorebox{\ifanswers#1\fi}}%
  \ignorespaces}
\providecommand\leftnote[1][\z@skip]{\@rlnote l{#1}}
\providecommand\rightnote[1][\z@skip]{\@rlnote r{#1}}
\providecommand\@rlnote[3]{%
  \noindent\vadjust{\vbox to\z@{%
    \vskip#2\leftskip\z@skip\rightskip\z@skip\noindent
    \if#1l\llap{#3\hskip\marginparsep}%
    \else\hfill\rlap{\hskip\marginparsep#3}\fi
    \vss\vskip\z@skip}}}
\newcommand\longwhite{25mm}
\newcommand\shortwhite{8mm}
\newcommand\answerstart{\emph{\Answer}:\enspace}

\newcommand\answer[2][]{\altanswer[#1]{}{#2}}
\newcommand\altanswer[3][]{%
  \@ifemptyarg{#1}%
    {\mbox{\ifanswers#3\fi}}%
    {\leavevmode\hbox to#1{\hss\ifanswers#3\else#2\fi\hss}}%
  }
\newcommand\shortanswer[2][.75\linewidth]{\par
  \ifanswers
    \addvspace{\smallskipamount}%
    \noindent\answerstart\parbox[t]{#1}{#2}%
  \else
    \addvspace{\shortwhite}%
    \noindent\answerstart\hbox to#1{\dotfill}\fi
  \par}
\newenvironment{longanswer}[1][\longwhite]{
  \par\addvspace{\medskipamount}%
  \noindent\answerstart\par\nobreak
  \ifanswers\else
    \hrule\@height#1\@width\z@\par
    \setbox\z@\vbox\bgroup
       \leavevmode
   \fi}
      {\ifanswers\else\egroup\setbox\z@\hbox{}\fi}
\newcount\loadcounter
\newcommand\resetloadcounter{\global\loadcounter\z@}
\newcommand\incloadcounter{\global\advance\loadcounter\@ne}
\newcommand\decloadcounter{\global\advance\loadcounter\m@ne}
\newcommand\@listk{%
  \settowidth{\leftmargin}{\@problemstart}%
  \topsep\medskipamount
  \partopsep\z@
  \itemsep\smallskipamount
  \parsep\z@}
\newenvironment{choice}[1][]{%
  \@tagsforbidfalse\ifanswers\ordered\else\random\fi#1\@tagsforbidtrue
  \resetloadcounter
  \ifnum\@itemdepth>3 \@toodeep \else
  \advance\@itemdepth\@ne
  \expandafter\let
    \csname @list\romannumeral\the\@itemdepth\endcsname=\@listk
  \list{\badmark}{\def\makelabel##1{\hss\llap{##1}}}%
  \fi}%
  {\@dumpitems\endlist}
\newcommand\random{\@chktag\random
    \def\@loaditem{\loaditem}%
    \def\@dumpitems{\shuffle\dumpitems}%
  \fi}
\newcommand\ordered{\@chktag\ordered
    \def\@loaditem{}%
    \def\@dumpitems{}%
  \fi}
\providecommand\square{\bigcirc}
\providecommand\checksquare{\surd}
\newcommand\badmark{$\square$}
\newcommand\goodmark{\ifanswers$\checksquare$\else\badmark\fi}
\newcommand\baditem[1]{\@loaditem{\item[\badmark]#1}}
\newcommand\gooditem[1]{\@loaditem{\item[\goodmark]#1}}
\newtoks\@itemA
\newtoks\@itemB
\newtoks\@itemC
\newtoks\@itemD
\newtoks\@itemE
\newcommand\@itemstore{5}
\newcommand\loaditem[1]{%
  \ifcase\loadcounter
    \@itemA={#1}%
    \or\@itemB={#1}%
    \or\@itemC={#1}%
    \or\@itemD={#1}%
    \or\@itemE={#1}%
  \fi
  \ifnum\loadcounter<\@itemstore \incloadcounter
  \else\typeout{ERROR! previous item dumped, too many\on@line}\fi}
\newcommand\dumpitem{%
  \ifcase\loadcounter
    \or\the\@itemA
    \or\the\@itemB
    \or\the\@itemC
    \or\the\@itemD
    \or\the\@itemE
  \fi\decloadcounter}
\newcommand\dumpitems{\@whilenum\loadcounter>\z@\do{\dumpitem}}
\newcommand\shuffle{%
  \ifcase\loadcounter
    \or
    \or\shuffle@ii
    \or\shuffle@\@itemA\@itemC \shuffle@ii \shuffle@\@itemB\@itemC
    \or\shuffle@iv
    \or\shuffle@\@itemD\@itemE \shuffle@iv \shuffle@\@itemD\@itemE
    \fi
  }
\newtoks\@item@
\newcommand\shuffle@[2]{\SRtest{}{\@item@=#1 #1=#2 #2=\@item@}}
\newcommand\shuffle@ii{\shuffle@\@itemA\@itemB}
\newcommand\shuffle@iv{%
  \SRtest{\shuffle@\@itemA\@itemB}{\shuffle@\@itemC\@itemD}%
  \SRtest{\shuffle@\@itemA\@itemC}{\shuffle@\@itemB\@itemD}}
\ifx\@SR\undefined\newcount\@SR\fi
\providecommand\@SRconst{2097152}
\providecommand\SRset[1]{\global\@SR#1\relax}
\providecommand\@SRadvance{%
  \begingroup
  \ifnum\@SR<\@SRconst\relax\count@\z@\else\count@\@ne\fi
  \ifodd\@SR\advance\count@\@ne\fi
  \global\divide\@SR\tw@
  \ifodd\count@\global\advance\@SR\@SRconst\relax\fi
  \endgroup}
\providecommand\SRbit{\@SRadvance\ifodd\@SR1\else0\fi}
\providecommand\SRtest[2]{\@SRadvance\ifodd\@SR#2\else#1\fi}
\providecommand\SRvalue{\number\@SR }
\SRset{0}
\newcommand\thehead{%
  \slshape\@title\enspace\upshape:\enspace
  \ifseries\namesection\else\@date\fi}
\renewcommand\ps@headings{%
  \let\@oddfoot\@empty
  \let\@evenfoot\@empty
  \renewcommand\@oddhead{%
    \vbox{%
    \hbox to\textwidth{\headerfont\thehead\hfil\upshape\thepage}%
    \vskip1.5\p@
    \hrule\@height.5\p@\@width\textwidth
    }}%
  \let\@evenhead\@oddhead}
\newcommand\target[1]{\gdef\@target{#1}}\def\@target{}
\newcommand\Copyright{}
\renewcommand\maketitle{%
\if@titlepage\begin{titlepage}
  \begin{center}\titlefont
    \vspace*{1cm}%
    \mbox{}\rule{2cm}{0.4pt}\mbox{}\par
    \addvspace{1cm}%
    \begin{Large}
      \textbf{\ifseries\Collection\else\Exam\fi}\\[10mm]
    \end{Large}
    \begin{large}
      \@title\\[5mm]
      \ifseries\@author\else\@target\fi\\[5mm]
      \@date\\[10mm]
    \end{large}
    \mbox{}\rule{2cm}{0.4pt}\mbox{}\par
    \addvspace{2cm}%
  \ifseries
    \vfill\vfill
    \begin{flushleft}%
      \Copyright
    \end{flushleft}%
  \else\ifanswers
      \begin{huge}\Answers\end{huge}\par
    \else
      \begin{minipage}{.75\textwidth}%
      \raggedright\parindent\medskipamount
        Naam:\enspace\dotfill\null\par
        Adres:\enspace\dotfill\null\par
        Plaats:\enspace\dotfill\null\par
        Collegekaart:\enspace\dotfill\null\par
        \vspace{1cm}%
        \begin{itemize}%
        \item Zonder geldige collegekaart wordt geen
          tentamenbriefje uitgereikt.
        \item U wordt met nadruk verzocht om een
          \emph{leesbaar} schrift; wat niet leesbaar
          is, wordt fout gerekend.
        \item Denk erom losse vellen tentamenpapier
          van Uw naam en collegekaartnummer te voorzien;
          gebruik blokletters voor de leesbaarheid.
        \item Dit tentamen telt \theproblemnum\ opgaven
        \end{itemize}%
      \end{minipage}\\[10mm]
      \GoodLuck\par
    \fi
  \fi
  \end{center}%
\end{titlepage}\fi}
\newcommand\onlanguage[4]{% {current}{existing}{not existing}
  \expandafter\ifx\csname l@#1\endcsname\relax
  #4\else
    \ifnum\csname l@#1\endcsname=\language #2%
    \else#3\fi
  \fi}
\newcommand\englishExamNames{%
  \newcommand\Answers{ANSWERS}%
  \newcommand\Answer{Answer}%
  \newcommand\GoodLuck{Good luck!}%
  \newcommand\Exam{EXAM}%
  \newcommand\Collection{COLLECTION OF EXAMS}%
  \newcommand\Problem{Problem}%
  }
\AtBeginDocument{\onlanguage{english}{\englishExamNames}{}{}}
\AtBeginDocument{\onlanguage{american}{\englishExamNames}{}{}}
\newcommand\dutchExamNames{%
  \newcommand\Answers{ANTWOORDEN}%
  \newcommand\Answer{Antwoord}%
  \newcommand\GoodLuck{Veel succes!}%
  \newcommand\Exam{TENTAMEN}%
  \newcommand\Collection{TENTAMENBUNDEL}%
  \newcommand\Problem{Opgave}%
  }
\AtBeginDocument{\onlanguage{dutch}{\dutchExamNames}{}{}}
\newcommand\fullanswer{Geef de volledige afleiding; %
  slechts het antwoord vermelden wordt \emph{niet} goed gerekend.}
\providecommand\textbo{\textbf}
\providecommand\@ifemptyarg[1]{% {absence}{presence}
  \ifx\@empty#1\@empty
  \expandafter\@firstoftwo\else\expandafter\@secondoftwo\fi}
\pagestyle{headings}
\addtolength{\topmargin}{-15mm}
\addtolength{\textheight}{35mm}
\tolerance=2000
\hbadness=2000
\emergencystretch=2mm
\interlinepenalty=1000
\widowpenalty 1000
\newcommand\headerfont{\rmfamily\small}
\newcommand\bodyfont{\sffamily}
\newcommand\titlefont{\rmfamily\upshape}
\bodyfont
\newcommand\Mainfolder[1]{\def\mainfolder{#1}}
\newcommand\Commonfolder[1]{\def\commonfolder{#1}}
\newcommand\Figuresfolder[1]{\def\figuresfolder{#1}}
\Mainfolder{\@currdir}
\Commonfolder{\@currdir}
\Figuresfolder{\@currdir}
\InputIfFileExists{exam.cfg}{}{}
\endinput
%% 
%% End of file `exam.cls'.
