#ifndef _BYTESEX_H
#define _BYTESEX_H

#undef __BYTE_ORDER

#include <linux/version.h>

#if LINUX_VERSION_CODE >= 66054
/* The kernel version >= 1.2.6. We include it here to prevent
   <asm/byteorder.h> to included later and remove those
   bogus macros if they are defined. */
#include <asm/byteorder.h>
#undef BIG_ENDIAN
#undef LITTLE_ENDIAN
#endif

#if defined(__i386__) || defined(__alpha__) \
	|| (defined(__mips__) && (defined(MIPSEL) || defined (__MIPSEL__)))
# define __BYTE_ORDER	1234
#elif defined(__mc68000__) || defined (__sparc__) \
	|| (defined(__mips__) && (defined(MIPSEB) || defined (__MIPSEB__)))
# define __BYTE_ORDER	4321
#else
# error architecture not supported by Linux C library
#endif

#endif /* _BYTESEX_H */
