// Copyright 1994 Brad Pitzel
//
// Feel free to use/distribute/modify as long as credit/copyrights for myself 
// are included.

// Classes: Sprite

// File   : Sprite.h[1.0]
// Name   : gamelib1.0
// Status : proposed
// Changed: Sun Jun 12 22:18:14 1994


#ifndef __Sprite__
#define __Sprite__

#include <stdlib.h>
#include <math.h>
#include <vgagl.h>

#include "SBitmap.h"
#include "ObjTools.h"
#include "FastMath.h"

//////////////////////////////////////////////////////////////////////////////
// Note: bitmaps should be square: width=height
// Objects drawn in bitmap should be approx. round
// since the collision detection method used in this prog is
// pretty simple/dumb.  

class Sprite : public Life, public Trajectory {
    public:
    
    	Sprite( int sh, FixedPoint m, const SBitmap *b=NULL) : 
    		Vbitmap(NULL), shape(sh), Fmass(m), Vsize(0), 
    		Life(), Trajectory()
    		{
    		if (b!=NULL)
    			setBitmap(*b);
    		};

    	Sprite( int sh, FixedPoint m, const SBitmap &b) : 
    		Vbitmap(NULL), shape(sh), Fmass(m), Vsize(0), 
    		Life(), Trajectory()
    		{
    		setBitmap(b);
    		};

    	inline virtual void draw()
    		{
		Vbitmap->put( FP2INT(VFx)-Vsize, FP2INT(VFy)-Vsize );
    		}

    	inline virtual void intDraw( int x, int y)
    		{
		Vbitmap->put( x-Vsize, y-Vsize );
    		}


	// do the stuff that should happen in one 'frame' of time, i.e.
	// move the obj, etc..
    	inline virtual void tick()		
    		{	
		Life::tick();

		Trajectory::move();
		}

	inline void setBitmap( const SBitmap &b );

	//Bitmap& bitmap() { return b; }

	inline int	size() const { return Vsize; }

	inline void	towards( const Sprite& b, FixedPoint Fspeed )
			{ Trajectory::towards( b.VFx, b.VFy, Fspeed ); }

	friend int	distance( const Sprite& b1, const Sprite& b2 );

	// determine if 2 Sprites have collided
	friend int collide(const Sprite& b1, const Sprite& b2);


    	int shape;
	Angle Vangle;	// Angles from 0-255, not 0-359
	FixedPoint Fmass;

	
    protected:
	const SBitmap *Vbitmap;
	int		Vsize;
     };

inline void Sprite::setBitmap( const SBitmap &b ) 
	{ 
	Vbitmap=&b; 
	Vsize = b.width() >> 1;
	// size is 1/2 of the width of the *square* bitmap.
	}


// *Friend Function*
inline int	distance( const Sprite& b1, const Sprite& b2 )
	{ 
	FixedPoint Fdx= b1.VFx - b2.VFx;
	FixedPoint Fdy= b1.VFy - b2.VFy;
	
	Fdx = FP2INT( FPMULT(Fdx,Fdx) + FPMULT(Fdy,Fdy) );
	return (Fdx<SQRTSIZE) ? FastMath::intSqrt(Fdx) : (int)sqrt(Fdx);
 	}

#endif
