// This is C++ code.

// For each module this file is to be compiled with -DMODULE=modulename
// and linked to the code of the module proper.

// This file provides an initializer which gets called by __main when the
// program starts up - in case of statically linked modules - or when the
// module gets loaded - in case of dynamically loaded modules.

// Idea by Marcus Daniels.
// Bruno Haible 18.12.1994

#ifdef NO_CLISP_H
#include "lispbibl.c"
#else
#include "clisp.h"
#endif

#ifdef DYNAMIC_MODULES

extern "C" subr_ CONCAT3(module__,MODULE,__subr_tab)[];
extern "C" uintC CONCAT3(module__,MODULE,__subr_tab_size);

// Assume a struct consisting of objects has the same shape than an array of objects.
extern "C" object CONCAT3(module__,MODULE,__object_tab)[];
extern "C" uintC CONCAT3(module__,MODULE,__object_tab_size);

extern "C" subr_initdata CONCAT3(module__,MODULE,__subr_tab_initdata)[];
extern "C" void CONCAT3(module__,MODULE,__init_function) (module_ * module);

static module_ this_module = {
  /* name */           STRINGIFY(MODULE),
  /* stab */           & CONCAT3(module__,MODULE,__subr_tab) [0],
  /* stab_size */      & CONCAT3(module__,MODULE,__subr_tab_size),
  /* otab */           & CONCAT3(module__,MODULE,__object_tab) [0],
  /* otab_size */      & CONCAT3(module__,MODULE,__object_tab_size),
  /* initialized */    FALSE,
  /* stab_initdata */  & CONCAT3(module__,MODULE,__subr_tab_initdata) [0],
  /* initfunction */   & CONCAT3(module__,MODULE,__init_function),
  /* next */           NULL
};

// Now this is really getting C++.
// The only effect of this is to achieve that
//   add_module(&this_module);
// gets called at startup time or load time.

#define CLASSNAME  CONCAT3(module__,MODULE,__initializer_class)

class CLASSNAME
  { public:
      // Constructor, must have the same name as the class.
      // Its return type defaults to the class, not `int' or `void'.
      CLASSNAME (void);
  };

CLASSNAME::CLASSNAME (void)
{ add_module(&this_module); }

static CLASSNAME CONCAT3(module__,MODULE,__initializer_dummy);

#endif

