#include <mbase.h>
#include "example7.h"


/*
 * PROTOTYPES -----------------------------------------------------------------
 *
 */

   void main XARGS( (void) );


/*
 * CODE -----------------------------------------------------------------------
 *
 */

void
main ()
{
   relation *rel;
   example7  rec;    /* typedef example7 is defined in example7.h */
   int       num;

   if ((rel = mb_inc ("example7", "books")) == RNULL)
      {
      fprintf (stderr, "mb_inc() failed: %s\n", mb_error);
      mb_exit (1);
      }


/*
 * Before we can do a sweeping change like this, we oughta lock the
 * relation to keep anyone else from working with any of the records
 * we might delete...
 *
 */

   if (mb_lck (rel) != MB_OKAY)
      {
      fprintf (stderr, "couldn't lock: %s\n", mb_error);
      mb_exit (2);
      }

   if (recInit (rel, &rec) != MB_OKAY)
      {
      fprintf (stderr, "recInit() failed: %s\n", mb_error);
      mb_exit (3); /* will unlock/close relation automatically */
      }

   for (num = 0; ; num++)
      {
      strcpy (rec.author, "Heinlein");

      if (mb_sel (rel, idxnum(rel,"ix_author"), &rec, EQUAL, NULL) != MB_OKAY)
         break;

      printf ("deleting title '%s'\n", rec.title);

      if (mb_del (rel) != MB_OKAY)
         {
         fprintf (stderr, "mb_del() failed: %s\n", mb_error);
         mb_exit (3);
         }
      }


   recFree (rel, &rec);

/*
 * Now unlock the relation and exit.
 *
 */

   mb_unl (rel);

   if (num == 0)
      {
      printf ("couldn't find any Heinlein books to delete.\n");
      printf ("use VR to add some records to example7.rel, with the \n");
      printf ("author set to \"Heinlein\", and re-run this example.\n");
      printf ("\n");
      printf ("use the encryption key 'books' to access this relation.\n");
      }

   mb_exit (0);
}

