------------------------------------------------------------------------------
--                                                                          --
--                GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS                --
--                                                                          --
--                S Y S T E M . T A S K _ P R I M I T I V E S               --
--                                                                          --
--                                  S p e c                                 --
--                               (OS/2 version)                             --
--                                                                          --
--                             $Revision: 1.4 $                             --
--                                                                          --
--             Copyright (c) 1993,1994 NYU, All Rights Reserved             --
--                                                                          --
--  GNARL is free software; you can redistribute it and/or modify it  under --
--  terms  of  the  GNU  Library General Public License as published by the --
--  Free Software Foundation; either version 2, or (at  your  option)  any  --
--  later  version.   GNARL is distributed in the hope that it will be use- --
--  ful, but but WITHOUT ANY WARRANTY; without even the implied warranty of --
--  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Gen- --
--  eral Library Public License for more details.  You should have received --
--  a  copy of the GNU Library General Public License along with GNARL; see --
--  file COPYING. If not, write to the Free Software Foundation,  675  Mass --
--  Ave, Cambridge, MA 02139, USA.                                          --
--                                                                          --
------------------------------------------------------------------------------

with System.Task_Clock;
with System.OS2Lib.Threads;
with System.OS2Lib.Synchronization;

package System.Task_Primitives is
--  Cannot be preelaborated, because body requires initialization
--  of Test_And_Set lock
--  pragma Preelaborate (Task_Primitives);

   type LL_Task_Procedure_Access is new System.OS2Lib.Threads.PFNTHREAD;
   --  type LL_Task_Procedure_Access is private; -- should be private ???

   type Pre_Call_State     is private;
   type Task_Storage_Size  is range 0 .. Integer'Last;
   type Machine_Exceptions is range 0 .. Integer'Last;
   type Interrupt_ID       is range 0 .. Integer'Last;
   type Interrupt_Info     is new String;
   type Error_information  is new String;

   Task_Wrapper_Frame : constant Integer := 72;
   --  This is the size of the frame for the Pthread_Wrapper procedure.

   -----------
   -- Tasks --
   -----------

   type Task_Control_Block is private;
   type TCB_Ptr is access all Task_Control_Block;

   procedure Initialize_LL_Tasks (T : TCB_Ptr);

   procedure Create_LL_Task
      (Priority       : Priority;
       Stack_Size     : Task_Storage_Size;
       LL_Entry_Point : LL_Task_Procedure_Access;
       Arg            : Address;
       T              : TCB_Ptr);

   procedure Exit_LL_Task;

   function Self return TCB_Ptr;

   -----------
   -- Locks --
   -----------

   type Lock is private;

   procedure Initialize_Lock (Prio : Integer; L : in out Lock);

   procedure Finalize_Lock (L : in out Lock);

   procedure Write_Lock (L : in out Lock; Ceiling_Violation : out Boolean);

   procedure Read_Lock (L : in out Lock; Ceiling_Violation : out Boolean);

   procedure Unlock (L : in out Lock);

   -------------------------
   -- Condition Variables --
   -------------------------

   type Condition_Variable is private;

   procedure Initialize_Cond (Cond : in out Condition_Variable);

   procedure Finalize_Cond (Cond : in out Condition_Variable);

   procedure Cond_Wait (Cond : in out Condition_Variable; L : in out Lock);

   procedure Cond_Timed_Wait
     (Cond      : in out Condition_Variable;
      L         : in out Lock;
      Abs_Time  : System.Task_Clock.Stimespec;
      Timed_Out : out Boolean);

   procedure Cond_Signal (Cond : in out Condition_Variable);

   ----------------
   -- Priorities --
   ----------------

   procedure Set_Priority (T : TCB_Ptr; Prio : Integer);

   procedure Set_Own_Priority (Prio : Integer);

   function Get_Priority (T : TCB_Ptr) return Integer;

   function Get_Own_Priority return Integer;

   -----------------------------
   -- Signals, Errors, Aborts --
   -----------------------------

   procedure Abort_Task (T : TCB_Ptr);

   procedure Test_Abort;

   type Abort_Handler_Pointer is access procedure (Context : Pre_Call_State);

   procedure Install_Abort_Handler (Handler : Abort_Handler_Pointer);

   procedure Install_Error_Handler (Handler : Address);

   procedure Signal_Task (T : TCB_Ptr; I : Interrupt_ID);

   procedure Wait_for_Signal (I : Interrupt_ID);

   function Reserved_Signal (I : Interrupt_ID) return Boolean;

   procedure Test_And_Set (Flag_Add : System.Address; Result : out Boolean);
   --  Flag_Add is the address of a variable of type Boolean

   procedure LL_Assert (B : Boolean; M : String);

private
   use System.OS2Lib,
       System.OS2Lib.Threads,
       System.OS2Lib.Synchronization;

   --  type LL_Task_Procedure_Access is new PFNTHREAD; ???

   type Pre_Call_State is new Integer;
   --  Unused for OS/2

   type Task_Control_Block is record
      LL_Entry_Point  : LL_Task_Procedure_Access;
      LL_Arg          : Address;
      Thread          : TID;
      Active_Priority : Priority;
      Aborted         : Boolean := False;
   end record;

   type Lock is
      record
         Mutex          : aliased HMTX;
         Priority       : Integer;
         Owner_Priority : Integer;
      end record;

   type Condition_Variable is new HEV;

end System.Task_Primitives;
