/****************************************************************************/
/*                                                                          */
/*                         GNAT COMPILER COMPONENTS                         */
/*                                                                          */
/*                              A - A R G V                                 */
/*                                                                          */
/*                          C Implementation File                           */
/*                                                                          */
/*                            $Revision: 1.5 $                              */
/*                                                                          */
/*        Copyright (c) 1992,1993,1994.1995 NYU, All Rights Reserved        */
/*                                                                          */
/* The GNAT library is free software; you can redistribute it and/or modify */
/* it under terms of the GNU Library General Public License as published by */
/* the Free Software  Foundation; either version 2, or (at your option) any */
/* later version.  The GNAT library is distributed in the hope that it will */
/* be useful, but WITHOUT ANY WARRANTY;  without even  the implied warranty */
/* of MERCHANTABILITY  or  FITNESS FOR  A PARTICULAR PURPOSE.  See the  GNU */
/* Library  General  Public  License for  more  details.  You  should  have */
/* received  a copy of the GNU  Library  General Public License  along with */
/* the GNAT library;  see the file  COPYING.LIB.  If not, write to the Free */
/* Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.        */
/*                                                                          */
/****************************************************************************/

/* Routines for accessing command line arguments from both the runtime
   library and from the compiler itself. In the former case, gnat_argc
   and gnat_argv are the original argc and argv values as stored by the
   binder generated main program, and these routines are accessed from
   the Ada.Command_Line package. In the compiler case, gnat_argc and
   gnat_argv are the values as modified by toplev, and these routines
   are accessed from the Osint package. */

#include <string.h>

/* argc and argv of the main program are saved under gnat_argc and gnat_argv */
int gnat_argc = 0;
char **gnat_argv = (char **) 0;

/* ???old names kept for bootstrap problem issues (to be remove after 1.84) */
int static_argc;
char **static_argv;

int arg_count () {

  /* ??? next line to be removed after 1.84 */
  if (gnat_argv == 0) { gnat_argv = static_argv; gnat_argc = static_argc;}

  return gnat_argc;
}
char * *gnat_argval () {

  /* ??? next line to be removed after 1.84 */
  if (gnat_argv == 0) { gnat_argv = static_argv; gnat_argc = static_argc;}

 return  gnat_argv;
}

int len_arg (arg_num)
   int arg_num;
{
  /* ??? next line to be removed after 1.84 */
  if (gnat_argv == 0) { gnat_argv = static_argv; gnat_argc = static_argc;}

  return strlen(gnat_argv[arg_num]);
}

int fill_arg (a, i)
   char * a;
   int i;
{
  /* ??? next line to be removed after 1.84 */
  if (gnat_argv == 0) { gnat_argv = static_argv; gnat_argc = static_argc;}

  strncpy (a, gnat_argv[i], strlen(gnat_argv[i]));
}
