.TH CTAGS 1
.SH NAME
ctags - Generates "tags" and (optionally) "refs" files
.SH SYNOPSIS
\fBctags\fP [\fB-BSstvraT\fP] \fIfilesnames\fP...
.SH DESCRIPTION
\fIctags\fP generates the "tags" and "refs" files
from a group of C source files.
The "tags" file is used by Elvis' ":tag" command,
control-] command,
and -t option.
The "refs" file is sometimes used by the \fIref(1)\fP program.
.PP
Each C source file is scanned for #define statements and
global function definitions.
The name of the macro or function becomes the name of a tag.
For each tag, a line is added to the "tags" file which contains:
.RS
.nf
       - the name of the tag
       - a tab character
       - the name of the file containing the tag
       - a tab character
       - a way to find the particular line within the file.
.RE
.fi
.PP
The filenames list will typically be the names of all C source
files in the current directory, like this:
.RS
.nf
$ ctags -stv *.[ch]
.RE
.fi
.SH OPTIONS
.IP \fB-B\fR
Normally, ctags encloses regular expressions in slashes (/regexp/) which
causes \fIelvis\fR to search from the top of the file.
The \fB-B\fR flag causes ctags to enclose the regular expressions in
question marks (?regexp?) so \fIelvis\fR will search backward from the
bottom of the file.
This rarely matters.
.IP \fB-t\fR
Include typedefs.
A tag will be generated for each user-defined type.
Also tags will be generated for struct and enum names.
Types are considered to be global if they are defined in a header file,
and static if they are defined in a C source file.
.IP \fB-v\fR
Include variable declarations.
A tag will be generated for each variable, except for those that are declared
inside the body of a function.
.IP \fB-s\fR
Include static tags.
\fICtags\fR will normally put global tags in the "tags" file, and silently ignore
the static tags.
This flag causes both global and static tags to be added.
The name of a static tag is generated by prefixing the name of the declared
item with the name of the file where it is defined, with a colon in between.
For example, "static foo(){}" in "bar.c" results in a tag named "bar.c:foo".
.IP \fB-S\fR
Include static tags, but make them look like global tags.
Most tags-aware programs don't like the "filename:tagname" tags produced
by the -s flag, so -S was added as an alternative.
If \fIelvis\fR and \fIref\fR are the only programs that read the tags file,
then you don't need -S; otherwise you do.
.IP \fB-r\fP
This causes \fIctags\fP to generate both "tags" and "refs".
Without \fB-r\fP, it would only generate "tags".
.IP \fB-a\fR
Append to "tags", and maybe "refs".
Normally, \fIctags\fR overwrites these files each time it is invoked.
This flag is useful when you have to many files in the current directory
for you to list them on a single command-line;
it allows you to split the arguments among several invocations.
.IP \fB-T\fR
This flag isn't available on all systems.
UNIX has it, but most others don't.
The \fB-T\fR flag prevents ctags from generating a "tags" file.
This is useful when you want to generate a "refs" without changing "tags".
.SH FILES
.IP tags
A cross-reference that lists each tag name, the name of the source file that
contains it, and a way to locate a particular line in the source file.
.IP refs
The "refs" file contains the definitions for each tag in the "tags" file,
and very little else.
This file can be useful, for example, when licensing restrictions prevent
you from making the source code to the standard C library readable by everybody,
but you still everybody to know what arguments the library functions need.
.SH BUGS
.PP
\fIctags\fR is sensitive to indenting and line breaks.
Consequently, it might not discover all of the tags in a file that
is formatted in an unusual way.
.SH "SEE ALSO"
elvis(1), refs(1)
.SH AUTHOR
.nf
Steve Kirkendall
kirkenda@cs.pdx.edu
.fi
