
%{
#define YYSTYPE char *
#include "sesh.h"


#undef YYLMAX
#define YYLMAX 10240
#include <string.h>
#include <strings.h>
#include <stdio.h>

#define G(x) {yylval=g(x); return HIEROGLYPHE;}
#define Commence(x) BEGIN(x); etat=x;

extern char * genere();
extern char * yylval ;

#include "hache.h"
extern TABLE definitions;

void traite();
char *g();
char * nomdefine;

int dieze=0;
int couleur=0;
int etat= INITIAL;
extern int numligne;
%}

entier    ([0-9]+)
gardiner  (([A-Z]|Aa){entier}a*)
ident     ([a-zA-Z0-9.']+)
ESPS	  ([ \t\n]+)
ESP	  ([ \t\n])

%s DEFINE0 DEFINE1 HieroText TEXTEIMBR
%p 4000

%%
                 switch(etat)
		 	{ case INITIAL: BEGIN(INITIAL);break;
			  case HieroText: BEGIN(HieroText);break;
                        }

<INITIAL>(.)			{ECHO; return TEXTE;}
<INITIAL>(\n)			{ECHO; numligne++; return TEXTE;}
<INITIAL>"\\begin{hieroglyph}"[ \n\t]*	{ printf("\\begin{hieroglyph}%%\n");
                                          TLIGNE();
                              					  Commence(HieroText); 
                                          return DEBUTHIEROGS;}

<DEFINE0>{ESPS}			        BEGIN(DEFINE1);
<DEFINE1>[^#]*"#"{ESP}*            		{ char *pt;
						  char *s= strdup(yytext);
						  TLIGNE();
						  pt= s + yyleng;
						  while (*(--pt) != '#');
						  *pt= 0;
						  stocke(nomdefine, s); 
						  Commence(HieroText);}

<HieroText>{ESP}*"\\end{hieroglyph}"   { TLIGNE(); Commence(INITIAL); return FINHIEROGS;}

<HieroText>{ESPS}		    |
<HieroText>{ESPS}"-"    {TLIGNE(); return ESPACE;}
<HieroText>\n		 {numligne++; return ESPACE;}

<HieroText>D:d	       		{yylval= genere("\\ligAROBDd%\n", NULL);
					return HIEROGLYPHE;}
<HieroText>D	       		{yylval= genere("\\ligAROBD%\n", NULL);
					return HIEROGLYPHE;}
<HieroText>D:t			{yylval= genere("\\ligAROBDt%\n", NULL);		
					return HIEROGLYPHE;}
<HieroText>D:ra			{yylval= genere("\\ligAROBDra%\n", NULL);		
					return HIEROGLYPHE;}
<HieroText>200			{yylval= genere("\\hierCC%\n", NULL);
					return HIEROGLYPHE;}
<HieroText>20			{yylval= genere("\\hierXX%\n", NULL);
					return HIEROGLYPHE;}
<HieroText>{ident}		|
<HieroText>([A-Z]|Aa){entier}A*	{if (!(yylval =g(yytext,0))) {REJECT } else return HIEROGLYPHE;}

<HieroText>\\{ident}		|
<HieroText>\\([A-Z]|Aa){entier}A*	{if (!(yylval =g(yytext+1,1))) {REJECT } else return HIEROGLYPHE;}

<HieroText>","{ident}	        {traite(yytext+1);}
<HieroText>"#def"{ESPS}{ident} { int i;
                                  for (i=4; yytext[i]
				   && (yytext[i] == ' ' || yytext[i]== '\t');
				   i++);
			 	   if  (yytext[i])
			 	     {
			               nomdefine=strdup(yytext+i);
			               BEGIN (DEFINE0);
			             }
				   else
				     yyerror("Mauvaise definition");
		                }
<HieroText>\-?"<"\-?        return CARTO;
<HieroText>\-?"<b"{ESPS}\-?	return DEBCARTO;
<HieroText>\-?"<m"{ESPS}\-?	return MILCARTO;
<HieroText>\-?"<e"{ESPS}\-?	return FINCARTO;
<HieroText>\-?">"		return CARTF;
<HieroText>"="			return '-';
<HieroText>"-="			return '-';
<HieroText>":="			return ':';
<HieroText>"*="			return '*';
<HieroText>{ESP}*"*"{ESP}*			return '*';
<HieroText>{ESP}*":"{ESP}*		  {return ':'; }
<HieroText>"+l"			BEGIN(TEXTEIMBR);
<HieroText>"+dg"		return DROITEGAUCHE;
<HieroText>"+gd"		return GAUCHEDROITE;
<HieroText>"|"[^-]+             { yylval= strdup(yytext+1);
                                  return TEXTESUPER;
                                }
<HieroText>\\!			return KERNING;
<HieroText>"."			return POINT;
<HieroText>".."			return POINTPOINT;
<HieroText>{ident}		{traite(yytext);}
<HieroText>[- \t\n]?"!"[\n \t]*      {TLIGNE(); return FINLIGNE;}
<HieroText>"-"?"!!"[\n \t]*     { TLIGNE(); return FINPAGE;}
<HieroText>"//"                 return HACHUREG;
<HieroText>"h/"                 return HACHUREH;
<HieroText>"v/"                 return HACHUREV;
<HieroText>"/"                  return HACHURET;
<HieroText>"#//"                return HACHUREGA ;
<HieroText>"#h/"                return HACHUREHA ;
<HieroText>"#v/"                return HACHUREVA;
<HieroText>"#/"                 return HACHURETA;
<HieroText>"o"                  return POINTROUGE;
<HieroText>"O"                  return POINTNOIR;
<HieroText>"^"                  return HAPLOGRAPHIE;
<HieroText>"?"                  return LACUNE;
<HieroText>"??"                 return  LIGNELACUNE;
<HieroText>"[&"                 return DSTSUPERFETATOIRE;
<HieroText>"&]"                 return FSTSUPERFETATOIRE;
<HieroText>"[{"                 return DSTEFFACE;
<HieroText>"}]"                 return FSTEFFACE;
<HieroText>"[["                 return  DSTDISPARU ;
<HieroText>"]]"                 return  FSTDISPARU ;
<HieroText>"[\""                return  DSTRAJOUTSCRIBE;
<HieroText>"\"]"                return  FSTRAJOUTSCRIBE;
<HieroText>"['"                 return  DSTRAJOUTAUTEUR;
<HieroText>"']"                 return  FSTRAJOUTAUTEUR;
<HieroText>"<S"                 return SEREKH;
<HieroText>"<F"                 return ENCEINTE;
<HieroText>"<H"                 return CHATEAU;
<HieroText>"<Sb"                return DEBSEREKH;
<HieroText>"<Sm"                return MILSEREKH;
<HieroText>"<Se"                return FINSEREKH;
<HieroText>"<Fb"                return DEBENCEINTE;
<HieroText>"<Fm"                return MILENCEINTE;
<HieroText>"<Fe"                return FINENCEINTE;
<HieroText>"<Hb"                return DEBCHATEAU;
<HieroText>"<Hm"                return MILCHATEAU;
<HieroText>"<He"                return FINCHATEAU;
<HieroText>\-?"#"\-?		{ dieze=1-dieze; /* ne compliquons pas la grammaire */
				  if (dieze==1) return DIEZE0;
				     else return DIEZE1;}
<HieroText>\-?"$"\-?            { couleur=1-couleur; /* ne compliquons pas la grammaire */
				  if (couleur==1) return COULEUR0;
				     else return COULEUR1;}
<HieroText>\\			yymore();
<HieroText>(.)		return yytext[0];

<TEXTEIMBR>"+s"			{yylval= strdup(yytext); 
				 yylval[strlen(yylval)-2]=0;
				 return ROMAIN;
                                }
<TEXTEIMBR>(.|\n)	        {TLIGNE(); yymore(); }
%%

void traite(texte)
     char * texte;
{
  int i;
  char *result;
  if ((result= trouve(texte, definitions)))
    {
      for (i=strlen(result) -1; i> -1; i--)
	unput(result[i]);		
    }
  else
    {
			char toto[300];
			sprintf(toto, "texte non reconnu: %s", texte);
     	yyerror(toto);
    }
}

TLIGNE()
{
	char *s;
	int i=0;
	s= yytext;
	while (s= strchr(s, '\n'))
	{
		numligne++;
		s++;
	}
	return i;
}
