;;; ENGLISH: Site specific definitions, to be modified on installation
;;; DEUTSCH: Funktionen, die beim Transportieren zu ndern sind
;;; FRANCAIS: Fonctions dpendantes de l'installation

(in-package "LISP")
(mapcar #'fmakunbound '(machine-type machine-version machine-instance
                        short-site-name long-site-name editor-tempfile))

(defun machine-type () "Atari ST")
(defun machine-version () "1040 ST/F")
(defun machine-instance () "Heimgert Bruno Haible")

(defun short-site-name () "Karlsruhe")
(defun long-site-name () "Augartenstrae 40, D-76137 Karlsruhe, Deutschland")

;; ENGLISH: The name of the editor:
;; DEUTSCH: Der Name des Editors:
;; FRANCAIS: Nom de l'diteur :
(defparameter *editor* "TEMPUS.PRG")

;; ENGLISH: The temporary file LISP creates for editing:
;; DEUTSCH: Das temporre File, das LISP beim Editieren anlegt:
;; FRANCAIS: Fichier temporaire cr par LISP pour l'dition :
(defun editor-tempfile () "LISPTEMP.LSP")

;; ENGLISH: The list of directories where programs are searched on LOAD etc.
;;          if device and directory are unspecified:
;; DEUTSCH: Die Liste von Directories, in denen Programme bei LOAD etc. gesucht
;;          werden, wenn dabei Laufwerk und Directory nicht angegeben ist:
;; FRANCAIS: Liste de rpertoires o chercher un fichier lorsqu'un rpertoire
;;           particulier n'est pas indiqu :
(defparameter *load-paths*
  '(#"A:"        ; erst im Current-Directory von Laufwerk A:
    #"A:\\"      ; dann im Root-Directory von Laufwerk A:
    #"A:\\...\\" ; dann in allen Directories von Laufwerk A:
   )
)

;; ENGLISH: Also set the variable *default-time-zone* in DEFS1.LSP according
;;          to your time zone.
;; DEUTSCH: Setzen Sie auch die Variable *default-time-zone* in DEFS1.LSP
;;          auf die bei Ihnen gltige Zeitzone.
;; FRANCAIS: Dans DEFS1.LSP, affectez  *default-time-zone* la valeur
;;           correspondante  votre fuseau horaire.

