dnl local autoconf macros
dnl Bruno Haible 30.12.1994
dnl
define(CL_CC_GCC,
[AC_BEFORE([AC_PROG_CPP], [$0])AC_PROVIDE([$0])dnl
AC_MSG_CHECKING(whether using GNU C)
AC_PROGRAM_EGREP(yes,[#ifdef __GNUC__
  yes
#endif
],
AC_MSG_RESULT(yes)
CC_GCC=true,
AC_MSG_RESULT(no)
CC_GCC=false)dnl
AC_SUBST(CC_GCC)dnl
])dnl
dnl
define(CL_CC_ANSI,
[AC_BEFORE([AC_PROG_CPP], [$0])AC_PROVIDE([$0])dnl
AC_MSG_CHECKING(whether using ANSI C)
AC_PROGRAM_EGREP(yes,[#ifdef __STDC__
  yes
#endif
],
AC_MSG_RESULT(yes)
CC_ANSI=true,
AC_MSG_RESULT(no)
CC_ANSI=false)dnl
AC_SUBST(CC_ANSI)dnl
])dnl
dnl
define(CL_CC_NEED_CCPAUX,
[AC_BEFORE([AC_PROG_CPP], [$0])AC_PROVIDE([$0])dnl
AC_MSG_CHECKING(whether CPP likes indented directives)
AC_PROGRAM_EGREP([#.*foo],[ #define foo],
AC_MSG_RESULT(no)
CC_NEED_CCPAUX=true,
AC_MSG_RESULT(yes)
CC_NEED_CCPAUX=false)dnl
AC_SUBST(CC_NEED_CCPAUX)dnl
])dnl
dnl
define(CL_CC_NEED_DEELIF,
[AC_BEFORE([AC_PROG_CPP], [$0])AC_PROVIDE([$0])dnl
AC_MSG_CHECKING([whether CPP understands #elif])
AC_TEST_CPP([#if 0
#elif 1
#else
#endif],
AC_MSG_RESULT(yes)
CC_NEED_DEELIF=false,
AC_MSG_RESULT(no)
CC_NEED_DEELIF=true)dnl
AC_SUBST(CC_NEED_DEELIF)dnl
])dnl
dnl
define(CL_CC_NEED_DEERROR,
[AC_BEFORE([AC_PROG_CPP], [$0])AC_PROVIDE([$0])dnl
AC_MSG_CHECKING([whether CPP understands #error])
AC_TEST_CPP([#if 0
#error "bla"
#endif],
AC_MSG_RESULT(yes)
CC_NEED_DEERROR=false,
AC_MSG_RESULT(no)
CC_NEED_DEERROR=true)dnl
AC_SUBST(CC_NEED_DEERROR)dnl
])dnl
dnl
define(CL_CC_NEED_DEEMA,
[AC_BEFORE([AC_PROG_CPP], [$0])AC_PROVIDE([$0])dnl
AC_MSG_CHECKING(whether CPP likes empty macro arguments)
AC_TEST_CPP([#define divide(x,y,q_zuw,r_zuw) (r_zuw(x)-(q_zuw(x)/(y))*(y))
foo(x,y) int x,y; { int q; divide(x,y,q=,); return q; }],
AC_MSG_RESULT(yes)
CC_NEED_DEEMA=false,
AC_MSG_RESULT(no)
CC_NEED_DEEMA=true)dnl
AC_SUBST(CC_NEED_DEEMA)dnl
])dnl
dnl
define(CL_CC_NEED_MERGESTRINGS,
[AC_BEFORE([AC_PROG_CPP], [$0])AC_PROVIDE([$0])dnl
AC_MSG_CHECKING(whether CC merges adjacent strings)
changequote(,)dnl
echo "char foo [] = \"abc\" \"def\"; main() { exit(0); }" > conftest.c
changequote([,])dnl
if eval $compile; then
  AC_MSG_RESULT(yes)
  CC_NEED_MERGESTRINGS=false
else
  AC_MSG_RESULT(no)
  CC_NEED_MERGESTRINGS=true
fi
AC_SUBST(CC_NEED_MERGESTRINGS)dnl
rm -f conftest*
])dnl
dnl
define(CL_AS_UNDERSCORE,
[AC_MSG_CHECKING(for underscore in external names)
cat > conftest.c <<EOF
int foo() { return 0; }
EOF
${CC-cc} -c conftest.c >/dev/null 2>&1
# check whether nm exists
if (nm conftest.o) >/dev/null 2>&1 ; then
  # use nm to see the assembly language name
  if nm conftest.o | grep _foo >/dev/null 2>&1 ; then
    AS_UNDERSCORE=true
  else
    AS_UNDERSCORE=false
  fi
else
  # look for the assembly language name in the .s file
  ${CC-cc} -S conftest.c >/dev/null 2>&1
  if grep _foo conftest.s >/dev/null ; then
    AS_UNDERSCORE=true
  else
    AS_UNDERSCORE=false
  fi
fi
if test $AS_UNDERSCORE = true; then
  AC_MSG_RESULT(yes)
else
  AC_MSG_RESULT(no)
fi
AC_SUBST(AS_UNDERSCORE)dnl
rm -f conftest*
])dnl
dnl
define(CL_PROG_RANLIB, [AC_PROGRAM_CHECK(RANLIB, ranlib, ranlib, [echo not executing ranlib])])dnl
dnl
define(CL_PROG_INSTALL,
[AC_PROG_INSTALL()])dnl
dnl
define(CL_CP,
[AC_MSG_CHECKING(how to copy files)
echo "blabla" > conftest.x
err=`/bin/sh -c "cp -p conftest.x conftest.y 2>&1"`
if test -z "$err"; then
  CP='cp -p'
else
  CP='cp'
fi
rm -f conftest*
AC_MSG_RESULT($CP)
AC_SUBST(CP)dnl
])dnl
dnl
define(CL_FIND_X,
[echo checking for X11
X_INCLUDES=''
X_LIBS=''
dnl First check for xmkmf.
AC_PROGRAM_CHECK(HAVE_XMKMF, xmkmf, yes)dnl
if test "$HAVE_XMKMF" = yes; then
  AC_DEFINE(HAVE_X11)
  X_LIBS='-lX11'
  AC_FIND_X()dnl
  if test -n "$x_includes"; then
    # Adding -I/usr/include may override gcc's private include hierarchy.
    if test "$x_includes" != "/usr/include"; then
      X_INCLUDES="-I$x_includes"
    fi
  fi
  if test -n "$x_libraries"; then
    X_LIBS="-L$x_libraries "$X_LIBS
  fi
else
  dnl From John Ousterhout <ouster@allspice.berkeley.edu>
  dnl There are some X11 installations around that don't have xmkmf.
  AC_MSG_CHECKING(for X11 header files)
  AC_TEST_CPP([#include <X11/Intrinsic.h>], have_x_includes=1)
  if test -z "$have_x_includes"; then
    for dir in /usr/X11/include /usr/openwin/include /usr/include/X11R5 /usr/X11R5/include /usr/include/X11R4 /usr/X386/include /usr/x386/include /usr/local/include /usr/unsupported/include; do
      if test -z "$have_x_includes"; then
        if test -r $dir/X11/Intrinsic.h; then
          x_includes="$dir"
          have_x_includes=1
        fi
      fi
    done
  fi
  if test -n "$x_includes"; then
    X_INCLUDES="-I$x_includes"
  fi
  AC_MSG_RESULT($X_INCLUDES)
  AC_MSG_CHECKING(for X11 library)
  AC_HAVE_LIBRARY(libX11.a, have_x_libraries=1)dnl
  if test -z "$have_x_libraries"; then
    for dir in /usr/X11/lib /usr/openwin/lib /usr/lib/X11R5 /usr/X11R5/lib /usr/lib/X11R4 /usr/X386/lib /usr/x386/lib /usr/local/lib /usr/unsupported/lib; do
      if test -z "$have_x_libraries"; then
        if test -r $dir/libX11.a; then
          x_libraries="$dir"
          have_x_libraries=1
        fi
      fi
    done
  fi
  if test -n "$have_x_libraries"; then
    X_LIBS='-lX11'
    if test -n "$x_libraries"; then
      X_LIBS="-L$x_libraries "$X_LIBS
    fi
  else
    AC_HAVE_LIBRARY(libXwindow.a, X_LIBS='-lXwindow' have_x_libraries=1)dnl
  fi
  AC_MSG_RESULT($X_LIBS)
  dnl Don't use X if either the header files or the libraries were not found.
  if test -n "$have_x_includes" -a -n "$have_x_libraries"; then
    AC_DEFINE(HAVE_X11)
  else
    X_INCLUDES=''
    X_LIBS=''
  fi
fi
AC_SUBST(X_INCLUDES)dnl
AC_SUBST(X_LIBS)dnl
])dnl
dnl
define(CL_DYNIX_SEQ,
[AC_MSG_CHECKING(for DYNIX/ptx libseq or libsocket)
AC_PROGRAM_EGREP(yes,
[#if defined(_SEQUENT_)
  yes
#endif
], SEQUENT=1)dnl
if test -n "$SEQUENT"; then
test -f /usr/lib/libseq.a &&
  LIBS="$LIBS -lseq"
dnl libsocket is needed for select()
test -f /usr/lib/libsocket.a &&
  LIBS="$LIBS -lsocket"
AC_MSG_RESULT(yes)
else
AC_MSG_RESULT(no)
fi
])dnl
dnl
define(CL_SOCKET,
[dnl check whether -lsocket is needed for the functions gethostbyname(),
dnl connect(), socket(), inet_addr(), setsockopt().
AC_MSG_CHECKING(whether gethostbyname requires -lsocket)
AC_COMPILE_CHECK(, [extern char gethostbyname();], [gethostbyname();], have_gethostbyname=1)dnl
if test -z "$have_gethostbyname"; then
LIBS_old="$LIBS"
LIBS="$LIBS -lsocket"
AC_COMPILE_CHECK(, [extern char gethostbyname();], [gethostbyname();], AC_MSG_RESULT(yes), AC_MSG_RESULT(no)
LIBS="$LIBS_old")dnl
else
AC_MSG_RESULT(no)
fi
])dnl
dnl
define(CL_CC_WORKS,
[AC_MSG_CHECKING(whether CC works at all)
AC_TEST_PROGRAM([main() { exit(0); }], AC_MSG_RESULT(yes)
,
AC_MSG_RESULT(no)
echo "Installation or configuration problem: C compiler cannot create executables."; exit 1)
])dnl
dnl
define(CL_SHELLARGS,
[AC_MSG_CHECKING([for broken HP/UX, A/UX and OSF/1 shell])
# A program that outputs its argument count:
cat > conftest.c <<EOF
#include "confdefs.h"
#include <stdio.h>
#ifdef __STDC__
main (int argc, char** argv)
#else
main (argc,argv) int argc; char** argv;
#endif
{ printf("%d\n",argc); exit(0); }
EOF
eval $compile
# How can a shell script forward its arguments to another program?
#                                    $ * "$ *" "$ @"
# conftest.sh                         1    2     1 (*)
# conftest.sh foo                     2    2     2
# conftest.sh foo bar                 3    2     3
# conftest.sh "foo bar"               3    2     2
# (*): 2 with HP-UX /bin/sh. We must use /bin/ksh instead.
#      2 as well with NeXTstep /bin/sh. No /bin/ksh. Examine $# first.
psubs='"$''@"'
cat > conftest.sh <<EOF
#!/bin/sh
exec ./conftest $psubs
EOF
chmod a+x conftest.sh
if test `./conftest.sh` = "1"; then
  AC_MSG_RESULT(no)
  GOOD_SH='/bin/sh'
else
  AC_MSG_RESULT(yes)
  if test -x /bin/ksh; then
    GOOD_SH='/bin/ksh'
    AC_DEFINE(UNIX_USE_KSH)
  else
    GOOD_SH=''
    AC_DEFINE(UNIX_BROKEN_SH)
  fi
fi
AC_SUBST(GOOD_SH)dnl
rm -f conftest*
])dnl
dnl
define(CL_NOWARN,
[AC_REQUIRE([AC_PROG_CC])if test -n "$GCC"; then
AC_COMPILE_CHECK([__nowarn__], [int x;], [__nowarn__ x;], have_nowarn=1)dnl
fi
if test -z "$have_nowarn"; then
AC_DEFINE(__nowarn__,)
fi
])dnl
dnl
define(RL_VOID,
[AC_COMPILE_CHECK([working void], ,
[void f();
typedef void x; x g();
typedef void* y; y a;
], , AC_DEFINE(void,char))dnl
])dnl
dnl
define(CL_VOID,
[AC_COMPILE_CHECK([working void], ,
[void f();
typedef void x; x g();
typedef void* y; y a;
], have_void=1, AC_DEFINE(void,char))dnl
if test -n "$have_void"; then
AC_COMPILE_CHECK([working \"return void\"],
[void f() {} typedef void x; x g() { return f(); }], [;],
AC_DEFINE(return_void,[return]))dnl
fi
])dnl
dnl
define(CL_LONGLONG,
[AC_MSG_CHECKING(for long long type)
AC_TEST_PROGRAM([main()
{ long x = 944938507; long y = 737962842; long z = 162359677;
  exit(!(((long long) x)*((long long) y)>>32 == z)); }],
AC_MSG_RESULT(yes)
AC_DEFINE(HAVE_LONGLONG),
AC_MSG_RESULT(no))
])dnl
dnl
define(CL_STDC_HEADERS,
dnl This is AC_STDC_HEADERS from Autoconf 1.2. The AC_STDC_HEADERS from
dnl Autoconf 1.3 fails on 386BSD because it checks for correct ANSI ctype
dnl macros and 386BSD (as well as SGI's /bin/cc from Irix-4.0.5) doesn't
dnl have them. But we don't need them!
dnl The same holds for the mem* functions in <string.h> and SunOS.
[AC_MSG_CHECKING(for ANSI C header files)
AC_TEST_CPP([#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <float.h>
#include <limits.h>], AC_MSG_RESULT(yes)
AC_DEFINE(STDC_HEADERS),
AC_MSG_RESULT(no))
])dnl
dnl
define(CL_STDLIB_H,
[AC_HAVE_HEADERS(stdlib.h)]
)dnl
dnl
define(CL_UNISTD_H,
[AC_HAVE_HEADERS(unistd.h)]
)dnl
dnl
define(CL_OPENFLAGS,
dnl BSD systems require #include <sys/file.h> for O_RDWR etc. being defined.
[AC_BEFORE([$0], [CL_MMAP])AC_PROVIDE([$0])dnl
AC_HEADER_CHECK(sys/file.h, have_sysfile=1)dnl
if test -n "$have_sysfile"; then
openflags_decl='#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <sys/types.h>
#include <unistd.h>
#endif
#include <fcntl.h>
'
openflags_prog='int x = O_RDWR | O_RDONLY | O_WRONLY | O_CREAT | O_TRUNC;'
AC_COMPILE_CHECK([O_RDWR in fcntl.h], $openflags_decl, $openflags_prog, openflags_ok=1)dnl
if test -z "$openflags_ok"; then
dnl AC_COMPILE_CHECK([O_RDWR in sys/file.h], $openflags_decl[#include <sys/file.h>], $openflags_prog,
AC_DEFINE(NEED_SYS_FILE_H)
dnl openflags_ok=1)dnl
fi
fi
])dnl
dnl
define(CL_DIR_HEADER,
[AC_DIR_HEADER()dnl
AC_XENIX_DIR()dnl
])dnl
dnl
define(CL_UTSNAME,
[AC_COMPILE_CHECK([sys/utsname.h and struct utsname],
[#include <sys/utsname.h>],
[struct utsname u;], AC_DEFINE(HAVE_SYS_UTSNAME_H))dnl
])dnl
dnl
define(CL_NETDB,
[AC_BEFORE([$0], [CL_GETHOSTBYNAME])AC_PROVIDE([$0])dnl
AC_HAVE_HEADERS(netdb.h)]
)dnl
dnl
define(CL_SHM,
[AC_HEADER_CHECK(sys/shm.h, , no_shm=1)dnl
if test -z "$no_shm"; then
AC_HEADER_CHECK(sys/ipc.h, , no_shm=1)dnl
fi
if test -z "$no_shm"; then
dnl This test is from Marcus Daniels
AC_MSG_CHECKING(for working shared memory)
AC_TEST_PROGRAM([#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
/* try attaching a single segment to multiple addresses */
#define segsize 0x10000
#define attaches 128
#define base_addr 0x01000000
main ()
{ int shmid, i; char* addr; char* result;
  if ((shmid = shmget(IPC_PRIVATE,segsize,0400)) < 0) exit(1);
  for (i=0, addr = (char*)0x01000000; i<attaches; i++, addr += segsize)
    { if ((result = shmat(shmid,addr,SHM_RDONLY)) == (char*)(-1)) break; }
  for (i=0, addr = (char*)0x01000000; i<attaches; i++, addr += segsize)
    shmdt(addr);
  shmctl(shmid,IPC_RMID,0);
  exit(result == (char*)(-1));
}], , no_shm=1)
fi
if test -z "$no_shm"; then
AC_MSG_RESULT(yes)
AC_DEFINE(HAVE_SHM)
AC_HAVE_HEADERS(sys/sysmacros.h)dnl
else
AC_MSG_RESULT(no)
fi
])dnl
dnl
define(RL_TERM,
[AC_HAVE_HEADERS(termios.h termio.h sys/termio.h sgtty.h)dnl
case "$DEFS" in
  *HAVE_TERMIOS_H*)
AC_HAVE_FUNCS(tcgetattr tcflow)dnl
  ;;
  *) ;;
esac
AC_HAVE_HEADERS(sys/stream.h sys/ptem.h)dnl
ioctl_decl='#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <sys/types.h>
#include <unistd.h>
#endif
#if defined(HAVE_TERMIOS_H) && defined(HAVE_TCGETATTR) && defined(HAVE_TCFLOW)
#include <termios.h>
#else
#if defined(HAVE_TERMIO_H) || defined(HAVE_SYS_TERMIO_H)
#ifdef HAVE_SYS_TERMIO_H
#include <sys/termio.h>
#else
#include <termio.h>
#endif
#else
#include <sgtty.h>
#include <sys/ioctl.h>
#endif
#endif
#ifdef HAVE_SYS_STREAM_H
#include <sys/stream.h>
#endif
#ifdef HAVE_SYS_PTEM_H
#include <sys/ptem.h>
#endif
'
ioctl_prog='int x = FIONREAD;'
AC_COMPILE_CHECK([FIONREAD], $ioctl_decl, $ioctl_prog, ioctl_ok=1)dnl
if test -z "$ioctl_ok"; then
AC_COMPILE_CHECK([FIONREAD in sys/filio.h],
$ioctl_decl[#include <sys/filio.h>], $ioctl_prog,
AC_DEFINE(NEED_SYS_FILIO_H)
ioctl_ok=1)dnl
fi
if test -z "$ioctl_ok"; then
AC_COMPILE_CHECK([FIONREAD in sys/ioctl.h],
$ioctl_decl[#include <sys/ioctl.h>], $ioctl_prog,
AC_DEFINE(NEED_SYS_IOCTL_H)
ioctl_ok=1)dnl
fi
])dnl
dnl
define(CL_TERM,
[AC_BEFORE([$0], [CL_IOCTL])AC_PROVIDE([$0])dnl
AC_HAVE_HEADERS(termios.h termio.h sys/termio.h sgtty.h)dnl
case "$DEFS" in
  *HAVE_TERMIOS_H*)
dnl A/UX has <termios.h> but is lacking tcgetattr etc.
AC_COMPILE_CHECK([tcgetattr], [#include <termios.h>],
[struct termios t; tcgetattr(0,&t);], AC_DEFINE(HAVE_TCGETATTR))dnl
AC_COMPILE_CHECK([TCSAFLUSH in termios.h], [#include <termios.h>],
[int x = TCSAFLUSH;], AC_DEFINE(HAVE_TCSAFLUSH))dnl
  ;;
  *) ;;
esac
])dnl
dnl
define(CL_CADDR_T,
[AC_MSG_CHECKING(for caddr_t in sys/types.h)
AC_HEADER_EGREP(caddr_t, sys/types.h,
AC_MSG_RESULT(yes)
AC_DEFINE(CADDR_T, caddr_t),
AC_MSG_RESULT(no)
AC_DEFINE(CADDR_T, void*))]
)dnl
dnl
define(CL_CLOCK_T,
[AC_MSG_CHECKING(for clock_t in sys/types.h etc.)
AC_HEADER_EGREP(clock_t, sys/types.h, have_clock=1)dnl
if test -z "$have_clock"; then
AC_HEADER_EGREP(clock_t, sys/times.h, have_clock=1)dnl
fi
if test -z "$have_clock"; then
AC_HEADER_EGREP(clock_t, time.h, have_clock=1)dnl
fi
if test -z "$have_clock"; then
AC_MSG_RESULT(no)
AC_DEFINE(CLOCK_T, int)
else
AC_MSG_RESULT(yes)
AC_DEFINE(CLOCK_T, clock_t)
fi
])dnl
dnl
define(CL_DIRENT_WITHOUT_NAMLEN,
[AC_COMPILE_CHECK([d_namlen in struct dirent], [#include <dirent.h>],
[struct dirent d; d.d_namlen;], , AC_DEFINE(DIRENT_WITHOUT_NAMLEN))]
)dnl
dnl
define(CL_STRUCT_TM,
[AC_PROVIDE([$0])dnl
AC_COMPILE_CHECK([struct tm in sys/time.h],
[#include <sys/types.h>
#include <sys/time.h>],
[struct tm *tp; tp->tm_sec;], AC_DEFINE(TM_IN_SYS_TIME))])dnl
dnl
define(CL_STRLEN,
[AC_MSG_CHECKING(for strlen declaration)
dnl This is a bit tricky since strlen is a gcc2 built-in function, and
dnl gcc's criterion when to reject a prototype for it is extremely mysterious.
dnl   extern int strlen (char * s); extern unsigned int strlen (char * s);
dnl produces an error, while
dnl   extern unsigned int strlen (char * s); extern int strlen (char * s);
dnl compiles well.
AC_PROGRAM_EGREP([is a macro], [#include <string.h>
#ifdef strlen
is a macro
#endif
], strlen_macro=1)dnl
if test -n "$strlen_macro"; then
AC_MSG_RESULT(macro)
else
AC_TEST_PROGRAM([#define strlen foo
#include <string.h>
extern
#ifdef __cplusplus
"C"
#endif
int strlen();
main() { exit(0); }], x="int", x="size_t")
AC_DEFINE_UNQUOTED(RETSTRLENTYPE,$x)
AC_TEST_PROGRAM([#define strlen foo
#include <string.h>
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
RETSTRLENTYPE strlen (char* s);
#else
RETSTRLENTYPE strlen();
#endif
main() { exit(0); }], y="", y="const")
AC_DEFINE_UNQUOTED(STRLEN_CONST,$y)
AC_MSG_RESULTPROTO([extern $x strlen ($y char*);])
fi
])dnl
dnl
define(CL_MEMSET,
[AC_HAVE_FUNCS(memset)])dnl
dnl
define(CL_GMALLOC,
[dnl Invented by Franois Pinard <pinard@iro.umontreal.ca>
AC_MSG_CHECKING(for broken HP/UX and SunOS malloc)
# Note that HP-UX has two different malloc() implementations.
# Both are broken. When used with CLISP, the one in the default libc.a
# leads to a SIGSEGV, the one in libmalloc.a leads to a SIGBUS.
# The SunOS 4.1.1 malloc() breaks when used by CLISP's generational GC.
os_name=`(uname -s) 2> /dev/null`
if test "$os_name" = HP-UX -o "$os_name" = SunOS ; then
AC_MSG_RESULT(yes)
# Remedy: Use GNU malloc.
GMALLOC=gmalloc
else
AC_MSG_RESULT(no)
GMALLOC=''
fi
AC_SUBST(GMALLOC)
])dnl
dnl
define(CL_MALLOC,
[AC_MSG_CHECKING(for malloc declaration)
AC_HEADER_EGREP([void.*\*.*malloc], stdlib.h, malloc_void=1)dnl
if test -z "$malloc_void"; then
AC_TEST_PROGRAM([
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
extern
#ifdef __cplusplus
"C"
#endif
void* malloc();
main() { exit(0); }],
malloc_void=1)
fi
if test -n "$malloc_void"; then
retmalloctype="void*"
else
retmalloctype="char*"
fi
AC_DEFINE_UNQUOTED(RETMALLOCTYPE,$retmalloctype)
AC_TEST_PROGRAM([
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
RETMALLOCTYPE malloc (unsigned int size);
#else
RETMALLOCTYPE malloc();
#endif
main() { exit(0); }], y="unsigned int", y="size_t")
AC_DEFINE_UNQUOTED(MALLOC_SIZE_T,$y)
AC_MSG_RESULTPROTO([extern $retmalloctype malloc ($y);])
])dnl
dnl
define(CL_FREE,
[AC_MSG_CHECKING(for free declaration)
AC_TEST_PROGRAM([
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
extern
#ifdef __cplusplus
"C"
#endif
int free();
main() { exit(0); }], x="int", x="void")
AC_DEFINE_UNQUOTED(RETFREETYPE,$x)
AC_MSG_RESULTPROTO([extern $x free ($retmalloctype);])
])dnl
dnl
define(CL_ALLOCA,
[# The Ultrix 4.2 mips builtin alloca declared by alloca.h only works
# for constant arguments.  Useless!
AC_COMPILE_CHECK(working alloca.h, [#include <alloca.h>],
  [char *p = alloca(2 * sizeof(int));], AC_DEFINE(HAVE_ALLOCA_H))dnl
decl="#ifdef __GNUC__
#define alloca __builtin_alloca
#else
#ifdef HAVE_ALLOCA_H
#include <alloca.h>
#else
#ifdef _AIX
 #pragma alloca
#else
char *alloca ();
#endif
#endif
#endif
"
AC_COMPILE_CHECK([alloca], $decl,
[char *p = (char *) alloca(1);], , [alloca_missing=1])dnl
if test -n "$alloca_missing"; then
  # The SVR3 libPW and SVR4 libucb both contain incompatible functions
  # that cause trouble.  Some versions do not even contain alloca or
  # contain a buggy version.  If you still want to use their alloca,
  # use ar to extract alloca.o from them instead of compiling alloca.c.
  ALLOCA=alloca.o
  AC_DEFINE(NO_ALLOCA)
fi
AC_SUBST(ALLOCA)dnl
])dnl
dnl
define(CL_SETJMP,
[AC_FUNC_CHECK(_setjmp, , no__jmp=1)dnl
if test -z "$no__jmp"; then
AC_FUNC_CHECK(_longjmp, , no__jmp=1)dnl
fi
if test -z "$no__jmp"; then
AC_DEFINE(HAVE__JMP)
fi
AC_HEADER_EGREP([void.* longjmp], setjmp.h, , AC_DEFINE(LONGJMP_RETURNS))
])dnl
dnl
define(RL_RETSIGTYPE,
[AC_MSG_CHECKING(return type of signal handlers)
AC_COMPILE_CHECK(,
[#include <sys/types.h>
#include <signal.h>
#ifdef signal
#undef signal
#endif
extern
#ifdef __cplusplus
"C"
#endif
int (*signal ()) ();],
[int i;], AC_MSG_RESULT(int)
AC_DEFINE(RETSIGTYPE,int),
AC_MSG_RESULT(void)
AC_DEFINE(RETSIGTYPE,void)
AC_DEFINE(RETSIGTYPE_VOID))
])dnl
dnl
define(CL_SIGNAL_REINSTALL,
[AC_MSG_CHECKING(whether signal handlers need to be reinstalled)
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <signal.h>
/* volatile */ int gotsig=0;
RETSIGTYPE sigalrm_handler() { gotsig=1; }
int got_sig () { return gotsig; }
typedef RETSIGTYPE (*signal_handler) ();
main() { /* returns 0 if they need not to be reinstalled */
  signal(SIGALRM,(signal_handler)sigalrm_handler); alarm(1); while (!got_sig());
  exit(!( (signal_handler)signal(SIGALRM,(signal_handler)sigalrm_handler)
          == (signal_handler)sigalrm_handler
      ) );
}], AC_MSG_RESULT(no),
AC_MSG_RESULT(yes)
AC_DEFINE(SIGNAL_NEED_REINSTALL))
])dnl
dnl
define(CL_SIGNALBLOCK,
[AC_FUNC_CHECK(sighold, AC_DEFINE(SIGNALBLOCK_SYSV), )dnl
AC_HEADER_EGREP(sigset_t, signal.h, , signals_not_posix=1)dnl
if test -z "$signals_not_posix"; then
AC_FUNC_CHECK(sigprocmask, AC_DEFINE(SIGNALBLOCK_POSIX), )dnl
fi
AC_FUNC_CHECK(sigblock, AC_DEFINE(SIGNALBLOCK_BSD), )dnl
])dnl
dnl
define(CL_SIGNAL_UNBLOCK,
[case "$DEFS" in
  *SIGNALBLOCK_BSD*)
AC_MSG_CHECKING(whether signals are blocked when signal handlers are entered)
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <signal.h>
int gotsig=0;
int wasblocked=0;
typedef RETSIGTYPE (*signal_handler) ();
RETSIGTYPE sigalrm_handler()
{ gotsig=1;
#ifdef SIGNAL_NEED_REINSTALL
  signal(SIGALRM,(signal_handler)sigalrm_handler);
#endif
#ifdef SIGNALBLOCK_POSIX
  { sigset_t blocked;
    sigprocmask(SIG_BLOCK, (sigset_t *) 0, &blocked);
    wasblocked = sigismember(&blocked,SIGALRM) ? 1 : 0;
  }
#else
  wasblocked = ((sigblock(0) & sigmask(SIGALRM)) != 0);
#endif
}
int got_sig () { return gotsig; }
main() { /* returns 0 if they need not to be unblocked */
  signal(SIGALRM,(signal_handler)sigalrm_handler); alarm(1); while (!got_sig());
  exit(wasblocked);
}], AC_MSG_RESULT(no),
AC_MSG_RESULT(yes)
AC_DEFINE(SIGNAL_NEED_UNBLOCK))
  ;;
  *) ;;
esac
])dnl
dnl
define(CL_SIGPROCMASK,
[case "$DEFS" in
  *SIGNALBLOCK_POSIX*)
AC_MSG_CHECKING(for sigprocmask declaration)
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <signal.h>
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
int sigprocmask (int how, sigset_t* set, sigset_t* oset);
#else
int sigprocmask();
#endif
main() { exit(0); }], x="", x="const")
AC_DEFINE_UNQUOTED(SIGPROCMASK_CONST,$x)
AC_MSG_RESULTPROTO([extern int sigprocmask (int, $x sigset_t*, sigset_t*);])
  ;;
  *) ;;
esac
])dnl
dnl
define(CL_SIGACTION,
[AC_BEFORE([$0], [CL_SIGINTERRUPT])AC_PROVIDE([$0])dnl
AC_FUNC_CHECK(sigaction, AC_DEFINE(HAVE_SIGACTION)
have_sigaction=1)])dnl
dnl
define(CL_SIGINTERRUPT,
[AC_REQUIRE([CL_SIGACTION])dnl
AC_FUNC_CHECK(siginterrupt, AC_DEFINE(HAVE_SIGINTERRUPT)
have_siginterrupt=1)dnl
if test -z "$have_siginterrupt" -a -z "$have_sigaction"; then
AC_HAVE_FUNCS(sigvec)dnl
fi
])dnl
dnl
define(CL_ABORT,
[AC_MSG_CHECKING(for abort declaration)
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
extern
#ifdef __cplusplus
"C"
#endif
int abort();
main() { exit(0); }], x="int", x="void")
AC_DEFINE_UNQUOTED(RETABORTTYPE,$x)
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
extern
#ifdef __cplusplus
"C"
#endif
RETABORTTYPE abort();
main() { exit(0); }], y="", y="__volatile__")
AC_DEFINE_UNQUOTED(ABORT_VOLATILE,$y)
AC_MSG_RESULTPROTO([extern $y $x abort (void);])
])dnl
dnl
define(CL_SYS_ERRLIST,
[AC_MSG_CHECKING(for sys_errlist declaration)
changequote(,)dnl
brackets='[]'
changequote([,])dnl
AC_TEST_PROGRAM([
/* Most systems declare sys_errlist in <errno.h>, NetBSD 1.0 in <stdio.h>. */
#include <stdio.h>
#include <errno.h>
extern char* sys_errlist $brackets ;
main() { exit(0); }], x="", x="const")
AC_DEFINE_UNQUOTED(SYS_ERRLIST_CONST,$x)
AC_MSG_RESULTPROTO([extern $x char* $x sys_errlist$brackets;])
])dnl
dnl
define(CL_GETENV,
[AC_MSG_CHECKING(for getenv declaration)
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
char* getenv (char* name);
#else
char* getenv();
#endif
main() { exit(0); }], x="", x="const")
AC_DEFINE_UNQUOTED(GETENV_CONST,$x)
AC_MSG_RESULTPROTO([extern char* getenv ($x char*);])
])dnl
dnl
define(CL_VFORK,
[AC_MSG_CHECKING(for vfork declaration)
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_VFORK_H
#include <vfork.h>
#endif
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
pid_t vfork (void);
#else
pid_t vfork();
#endif
main() { exit(0); }], x="pid_t", x="int")
AC_DEFINE_UNQUOTED(RETVFORKTYPE,$x)
AC_MSG_RESULTPROTO([extern $x vfork (void);])
])dnl
dnl
define(CL_SETSID,
[AC_HAVE_FUNCS(setsid setpgid)])dnl
dnl
define(CL_EXECV,
[AC_MSG_CHECKING(for execv declaration)
changequote(,)dnl
brackets='[]'
changequote([,])dnl
for z in '' 'const'; do
for y in '' 'const'; do
for x in '' 'const'; do
if test -z "$have_execv"; then
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
int execv ($x char* path, $y char* $z argv[]);
#else
int execv();
#endif
main() { exit(0); }],
AC_DEFINE_UNQUOTED(EXECV_CONST,$x)
AC_DEFINE_UNQUOTED(EXECV1_CONST,$y)
AC_DEFINE_UNQUOTED(EXECV2_CONST,$z)
AC_MSG_RESULTPROTO([extern int execv ($x char*, $y char* $z$brackets);])
execv_const="$x"
have_execv=1)
fi
done
done
done
])dnl
dnl
define(CL_EXECL,
[AC_MSG_CHECKING(for execl declaration)
for x in '' 'const'; do
if test -z "$have_execl"; then
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
int execl (EXECV_CONST char* path, $x char* arg, ...);
#else
int execl();
#endif
main() { exit(0); }],
AC_DEFINE_UNQUOTED(EXECL_CONST,$x)
AC_DEFINE(EXECL_DOTS)
AC_MSG_RESULTPROTO([extern int execl ($execv_const char*, $x char*, ...);])
have_execl=1)
fi
done
for x in '' 'const'; do
if test -z "$have_execl"; then
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
int execl (EXECV_CONST char* path, $x char* arg0, $x char* arg1, $x char* arg2, $x char* arg3);
#else
int execl();
#endif
main() { exit(0); }],
AC_DEFINE_UNQUOTED(EXECL_CONST,$x)
AC_MSG_RESULTPROTO([extern int execl ($execv_const char*, $x char*, $x char*, $x char*, $x char*);])
have_execl=1)
fi
done
])dnl
dnl
define(CL_WAITPID,
[AC_FUNC_CHECK(waitpid, AC_DEFINE(HAVE_WAITPID)
have_waitpid=1, )dnl
if test -n "$have_waitpid"; then
AC_MSG_CHECKING(for waitpid declaration)
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
pid_t waitpid (pid_t pid, int* statusp, int options);
#else
pid_t waitpid();
#endif
main() { exit(0); }], x="pid_t", x="int")
AC_DEFINE_UNQUOTED(PID_T,$x)
AC_MSG_RESULTPROTO([extern pid_t waitpid ($x, int*, int);])
else
AC_HAVE_HEADERS(sys/wait.h)dnl
fi
])dnl
dnl
define(CL_RUSAGE,
[AC_HAVE_HEADERS(sys/resource.h sys/times.h)dnl
case "$DEFS" in
  *HAVE_SYS_RESOURCE_H*)
    AC_COMPILE_CHECK([getrusage], [#include <sys/types.h> /* NetBSD 1.0 needs this */
#include <sys/time.h>
#include <sys/resource.h>],
      [struct rusage x; int y = RUSAGE_SELF; getrusage(y,&x); x.ru_utime.tv_sec;],
      AC_DEFINE(HAVE_GETRUSAGE))dnl
    ;;
  *) ;;
esac
])dnl
dnl
define(CL_GETWD,
[AC_COMPILE_CHECK([getwd], , [getwd();], AC_DEFINE(HAVE_GETWD), )]
)dnl
dnl
define(CL_GETCWD,
[case "$DEFS" in
  *HAVE_GETWD*) ;;
  *)
AC_MSG_CHECKING(for getcwd declaration)
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
char* getcwd (char* buf, int bufsize);
#else
char* getcwd();
#endif
main() { exit(0); }], x="int", x="size_t")
AC_DEFINE_UNQUOTED(GETCWD_SIZE_T,$x)
AC_MSG_RESULTPROTO([extern char* getcwd (char*, $x);])
  ;;
esac
])dnl
dnl
define(CL_CHDIR,
[AC_MSG_CHECKING(for chdir declaration)
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
int chdir (char* path);
#else
int chdir();
#endif
main() { exit(0); }], x="", x="const")
AC_DEFINE_UNQUOTED(CHDIR_CONST,$x)
AC_MSG_RESULTPROTO([extern int chdir ($x char*);])
])dnl
dnl
define(CL_MKDIR,
[AC_MSG_CHECKING(for mkdir declaration)
AC_HEADER_EGREP(mode_t, sys/types.h,
dnl mode_t defined. check if it is really used by mkdir() :
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
int mkdir (char* path, mode_t mode);
#else
int mkdir();
#endif
main() { exit(0); }],
mode_t_unneeded=1)
if test -z "$mode_t_unneeded"; then
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
int mkdir (const char* path, mode_t mode);
#else
int mkdir();
#endif
main() { exit(0); }],
mode_t_unneeded=1)
fi)dnl
if test -n "$mode_t_unneeded"; then
mode_t="mode_t"
else
mode_t="int"
fi
AC_DEFINE_UNQUOTED(MODE_T,$mode_t)
dnl Now MODE_T should be correct, check for const:
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
int mkdir (char* path, MODE_T mode);
#else
int mkdir();
#endif
main() { exit(0); }], x="", x="const")
AC_DEFINE_UNQUOTED(MKDIR_CONST,$x)
AC_MSG_RESULTPROTO([extern int mkdir ($x char*, $mode_t);])
])dnl
dnl
define(CL_RMDIR,
[AC_MSG_CHECKING(for rmdir declaration)
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
int rmdir (char* path);
#else
int rmdir();
#endif
main() { exit(0); }], x="", x="const")
AC_DEFINE_UNQUOTED(RMDIR_CONST,$x)
AC_MSG_RESULTPROTO([extern int rmdir ($x char*);])
])dnl
dnl
define(CL_STAT,
[AC_MSG_CHECKING(for stat declaration)
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
int stat (char* path, struct stat * buf);
#else
int stat();
#endif
main() { exit(0); }], x="", x="const")
AC_DEFINE_UNQUOTED(STAT_CONST,$x)
AC_MSG_RESULTPROTO([extern int stat ($x char*, struct stat *);])
])dnl
dnl
define(CL_LSTAT,
[AC_FUNC_CHECK(lstat, AC_DEFINE(HAVE_LSTAT)
have_lstat=1, )dnl
if test -n "$have_lstat"; then
AC_MSG_CHECKING(for lstat declaration)
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
int lstat (char* path, struct stat * buf);
#else
int lstat();
#endif
main() { exit(0); }], x="", x="const")
AC_DEFINE_UNQUOTED(LSTAT_CONST,$x)
AC_MSG_RESULTPROTO([extern int lstat ($x char*, struct stat *);])
fi
])dnl
dnl
define(CL_READLINK,
[AC_FUNC_CHECK(readlink, AC_DEFINE(HAVE_READLINK)
have_readlink=1, )dnl
if test -n "$have_readlink"; then
AC_MSG_CHECKING(for readlink declaration)
for z in 'int' 'size_t'; do
for y in 'char*' 'void*'; do
for x in '' 'const'; do
if test -z "$have_rl"; then
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
int readlink ($x char* path, $y buf, $z bufsiz);
#else
int readlink();
#endif
main() { exit(0); }],
AC_DEFINE_UNQUOTED(READLINK_CONST,$x)
AC_DEFINE_UNQUOTED(READLINK_BUF_T,$y)
AC_DEFINE_UNQUOTED(READLINK_SIZE_T,$z)
AC_MSG_RESULTPROTO([extern int readlink ($x char*, $y, $z);])
have_rl=1)
fi
done
done
done
fi
])dnl
dnl
define(CL_ELOOP,
[AC_MSG_CHECKING(for ELOOP)
cat > conftest.c <<EOF
#include "confdefs.h"
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <errno.h>
#include <stdio.h>
#ifdef ELOOP
main () { printf("ELOOP\n"); exit(0); }
#else
extern int errno;
#define foo "conflink"
#define foobar "conflink/somefile"
main()
{ /* If a system goes into an endless loop on this, it must be really broken. */
  if (symlink(foo,foo)<0) exit(1);
  if (unlink(foobar)>=0) { unlink(foo); exit(1); }
  printf("%d\n",errno); unlink(foo); exit(0);
}
#endif
EOF
eval $compile
eloop=`./conftest`
AC_DEFINE_UNQUOTED(ELOOP_VALUE,$eloop)
if test "$eloop" = "ELOOP"; then
  AC_MSG_RESULT(yes)
else
  AC_MSG_RESULT($eloop)
fi
rm -f conftest*
])dnl
dnl
define(CL_OPENDIR,
[case "$DEFS" in
  *DIRENT*)
AC_MSG_CHECKING(for opendir declaration)
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <dirent.h>
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
DIR* opendir (char* dirname);
#else
DIR* opendir();
#endif
main() { exit(0); }], x="", x="const")
AC_DEFINE_UNQUOTED(OPENDIR_CONST,$x)
AC_MSG_RESULTPROTO([extern DIR* opendir ($x char*);])
  ;;
  *) ;;
esac
])dnl
dnl
define(CL_OPEN,
[AC_MSG_CHECKING(for open declaration)
for y in 'MODE_T mode' '...'; do
for x in '' 'const'; do
if test -z "$have_open"; then
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <fcntl.h>
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
int open ($x char* path, int flags, $y);
#else
int open();
#endif
main() { exit(0); }],
AC_DEFINE_UNQUOTED(OPEN_CONST,$x)
if test "$y" = "..."; then
AC_DEFINE(OPEN_DOTS)
AC_MSG_RESULTPROTO([extern int open ($x char*, int, ...);])
else
AC_MSG_RESULTPROTO([extern int open ($x char*, int, $mode_t);])
fi
have_open=1)
fi
done
done
])dnl
dnl
define(CL_READ_WRITE,
[AC_MSG_CHECKING(for read declaration)
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
extern
#ifdef __cplusplus
"C"
#endif
int read();
main() { exit(0); }], retrwtype="int", retrwtype="long")
AC_DEFINE_UNQUOTED(RETRWTYPE,$retrwtype)
for y in 'int' 'size_t' 'unsigned RETRWTYPE' 'off_t'; do
for x in 'char*' 'void*'; do
if test -z "$have_rw"; then
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
RETRWTYPE read (int fd, $x buf, $y count);
#else
RETRWTYPE read();
#endif
main() { exit(0); }],
AC_DEFINE_UNQUOTED(RW_BUF_T,$x)
AC_DEFINE_UNQUOTED(RW_SIZE_T,$y)
rw_buf_t="$x"
rw_size_t="$y"
AC_MSG_RESULTPROTO([extern $retrwtype read (int, $rw_buf_t, $rw_size_t);])
have_rw=1)
fi
done
done
])dnl
dnl
define(CL_WRITE,
[AC_MSG_CHECKING(for write declaration)
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
RETRWTYPE write (int fd, RW_BUF_T buf, RW_SIZE_T count);
#else
RETRWTYPE write();
#endif
main() { exit(0); }], x="", x="const")
AC_DEFINE_UNQUOTED(WRITE_CONST,$x)
AC_MSG_RESULTPROTO([extern $retrwtype write (int, $x $rw_buf_t, $rw_size_t);])
])dnl
dnl
dnl define(CL_CHMOD,
dnl [AC_MSG_CHECKING(for chmod declaration)
dnl AC_TEST_PROGRAM([
dnl #ifdef STDC_HEADERS
dnl #include <stdlib.h>
dnl #endif
dnl #ifdef HAVE_UNISTD_H
dnl #include <unistd.h>
dnl #endif
dnl #include <sys/types.h>
dnl #include <sys/stat.h>
dnl extern
dnl #ifdef __cplusplus
dnl "C"
dnl #endif
dnl #ifdef __STDC__
dnl int chmod (char* path, mode_t mode);
dnl #else
dnl int chmod();
dnl #endif
dnl main() { exit(0); }], x="", x="const")
dnl AC_DEFINE_UNQUOTED(CHMOD_CONST,$x)
dnl AC_MSG_RESULTPROTO([extern int chmod ($x char*, mode_t);])
dnl AC_FUNC_CHECK(fchmod, AC_DEFINE(HAVE_FCHMOD))dnl
dnl ])dnl
dnl dnl
define(CL_RENAME,
[AC_FUNC_CHECK(rename, AC_DEFINE(HAVE_RENAME)
have_rename=1, )dnl
if test -n "$have_rename"; then
AC_MSG_CHECKING(for rename declaration)
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <stdio.h>
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
int rename (char* oldpath, char* newpath);
#else
int rename();
#endif
main() { exit(0); }], x="", x="const")
AC_DEFINE_UNQUOTED(RENAME_CONST,$x)
AC_MSG_RESULTPROTO([extern int rename ($x char*, $x char*);])
fi
])dnl
dnl
define(CL_UNLINK,
[AC_MSG_CHECKING(for unlink declaration)
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
int unlink (char* path);
#else
int unlink();
#endif
main() { exit(0); }], x="", x="const")
AC_DEFINE_UNQUOTED(UNLINK_CONST,$x)
AC_MSG_RESULTPROTO([extern int unlink ($x char*);])
])dnl
dnl
define(CL_FSYNC,
[AC_FUNC_CHECK(fsync, AC_DEFINE(HAVE_FSYNC), )]
)dnl
dnl
define(CL_IOCTL,
[AC_REQUIRE([CL_TERM])dnl
AC_MSG_CHECKING(for ioctl declaration)
ioctl_decl1='#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <sys/types.h>
#include <unistd.h>
#endif
#ifndef HAVE_TCSAFLUSH
#undef HAVE_TERMIOS_H
#endif
#ifdef HAVE_TERMIOS_H
#include <termios.h>
#else
#ifdef HAVE_SYS_TERMIO_H
#include <sys/termio.h>
#else
#ifdef HAVE_TERMIO_H
#include <termio.h>
#else
#ifdef HAVE_SGTTY_H
#include <sgtty.h>
#include <sys/ioctl.h>
#endif
#endif
#endif
#endif
'
dnl First find out whether this set of includes declares ioctl(), or whether
dnl we shall use <sys/ioctl.h> instead.
dnl Note: we must not include <sys/ioctl.h> deliberately since it is
dnl incompatible to <termios.h> (and doesn't even declare ioctl()) on SunOS 4.
AC_TEST_PROGRAM($ioctl_decl1[
extern
#ifdef __cplusplus
"C"
#endif
char* ioctl();
main() { exit(0); }], try_sys_ioctl=1, ioctl_decl="$ioctl_decl1")
if test -n "try_sys_ioctl"; then
ioctl_decl2='#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <sys/types.h>
#include <unistd.h>
#endif
#include <sys/ioctl.h>
'
AC_TEST_PROGRAM($ioctl_decl2[
extern
#ifdef __cplusplus
"C"
#endif
char* ioctl();
main() { exit(0); }], ioctl_decl="$ioctl_decl1", ioctl_decl="$ioctl_decl2")
fi
dnl Then find out about the correct ioctl declaration:
for y in 'caddr_t arg' '...'; do
for x in 'int' 'unsigned long' 'long'; do
if test -z "$have_ioctl"; then
AC_TEST_PROGRAM($ioctl_decl[
#ifdef INCLUDE_SYS_IOCTL_H
#include <sys/ioctl.h>
#endif
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
int ioctl (int fd, $x request, $y);
#else
int ioctl();
#endif
main() { exit(0); }],
AC_DEFINE_UNQUOTED(IOCTL_REQUEST_T,$x)
if test "$y" = "..."; then
AC_DEFINE(IOCTL_DOTS)
AC_MSG_RESULTPROTO([extern int ioctl (int, $x, ...);])
else
AC_MSG_RESULTPROTO([extern int ioctl (int, $x, caddr_t);])
fi
have_ioctl=1)
fi
done
done
ioctl_decl="$ioctl_decl1"
ioctl_prog='int x = FIONREAD;'
AC_COMPILE_CHECK([FIONREAD], $ioctl_decl, $ioctl_prog, ioctl_ok=1)dnl
if test -z "$ioctl_ok"; then
AC_COMPILE_CHECK([FIONREAD in sys/filio.h],
$ioctl_decl[#include <sys/filio.h>], $ioctl_prog,
AC_DEFINE(NEED_SYS_FILIO_H)
ioctl_ok=1)dnl
fi
if test -z "$ioctl_ok"; then
AC_COMPILE_CHECK([FIONREAD in sys/ioctl.h],
$ioctl_decl[#include <sys/ioctl.h>], $ioctl_prog,
AC_DEFINE(NEED_SYS_IOCTL_H)
ioctl_ok=1)dnl
fi
if test -n "$ioctl_ok"; then
AC_DEFINE(HAVE_FIONREAD)
fi
])dnl
dnl
define(CL_FCNTL,
[AC_MSG_CHECKING(for fcntl declaration)
for x in 'int arg' '...'; do
if test -z "$have_fcntl"; then
AC_TEST_PROGRAM([
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <fcntl.h>
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
int fcntl (int fd, int cmd, $x);
#else
int fcntl();
#endif
main() { exit(0); }],
if test "$x" = "..."; then
AC_DEFINE(FCNTL_DOTS)
AC_MSG_RESULTPROTO([extern int fcntl (int, int, ...);])
else
AC_MSG_RESULTPROTO([extern int fcntl (int, int, int);])
fi
have_fcntl=1)
fi
done
])dnl
dnl
define(RL_SELECT,
[AC_FUNC_CHECK(select, AC_DEFINE(HAVE_SELECT), have_select=1)dnl
if test -z "$have_select"; then
AC_HAVE_HEADERS(sys/select.h)dnl
fi
])dnl
dnl
define(CL_SELECT,
[AC_FUNC_CHECK(select, AC_DEFINE(HAVE_SELECT), have_select=1)dnl
if test -z "$have_select"; then
AC_HAVE_HEADERS(sys/select.h)dnl
AC_MSG_CHECKING(for select declaration)
for z in '' 'const'; do
for y in 'fd_set' 'int' 'void'; do
for x in 'int' 'size_t'; do
if test -z "$have_select"; then
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/time.h>
#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
int select ($x width, $y * readfds, $y * writefds, $y * exceptfds, $z struct timeval * timeout);
#else
int select();
#endif
main() { exit(0); }],
AC_DEFINE_UNQUOTED(SELECT_WIDTH_T,$x)
AC_DEFINE_UNQUOTED(SELECT_SET_T,$y)
AC_DEFINE_UNQUOTED(SELECT_CONST,$z)
AC_MSG_RESULTPROTO([extern int select ($x, $y *, $y *, $y *, $z struct timeval *);])
have_select=1)
fi
done
done
done
else
AC_HAVE_FUNCS(poll)dnl
fi
])dnl
dnl
define(CL_UALARM,
[AC_FUNC_CHECK(ualarm, AC_DEFINE(HAVE_UALARM), )]
)dnl
dnl
define(CL_SETITIMER,
[AC_FUNC_CHECK(setitimer, AC_DEFINE(HAVE_SETITIMER)
have_setitimer=1)dnl
if test -n "$have_setitimer"; then
AC_MSG_CHECKING(for setitimer declaration)
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/time.h>
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
int setitimer (int which, struct itimerval * ivalue, struct itimerval * ovalue);
#else
int setitimer();
#endif
main() { exit(0); }], x="", x="const")
AC_DEFINE_UNQUOTED(SETITIMER_CONST,$x)
AC_MSG_RESULTPROTO([extern int setitimer (int, $x struct itimerval *, struct itimerval *);])
fi
])dnl
dnl
define(CL_USLEEP,
[AC_FUNC_CHECK(usleep, AC_DEFINE(HAVE_USLEEP), )]
)dnl
dnl
define(CL_LOCALTIME,
[AC_MSG_CHECKING(for localtime declaration)
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef TM_IN_SYS_TIME
#include <sys/time.h>
#else
#include <time.h>
#endif
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
struct tm * localtime (time_t* clock);
#else
struct tm * localtime();
#endif
main() { exit(0); }], x="", x="const")
AC_DEFINE_UNQUOTED(LOCALTIME_CONST,$x)
AC_MSG_RESULTPROTO([extern struct tm * localtime ($x time_t*);])
])dnl
dnl
define(CL_GETTIMEOFDAY,
[AC_BEFORE([$0], [CL_TIMES_CLOCK])AC_PROVIDE([$0])dnl
AC_HAVE_FUNCS(gettimeofday)dnl
case "$DEFS" in
  *HAVE_GETTIMEOFDAY*)
AC_MSG_CHECKING(for gettimeofday declaration)
AC_TEST_PROGRAM([
#include <sys/types.h>
#include <sys/time.h>
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
int gettimeofday (struct timeval * tp, struct timezone * tzp);
#else
int gettimeofday();
#endif
main() { exit(0); }],
AC_MSG_RESULTPROTO([extern int gettimeofday (struct timeval *, struct timezone *);]),
AC_MSG_RESULTPROTO([extern int gettimeofday (struct timeval *, ...);])
AC_DEFINE(GETTIMEOFDAY_DOTS))
  ;;
  *) ;;
esac
])dnl
dnl
define(CL_FTIME,
[AC_BEFORE([$0], [CL_TIMES_CLOCK])AC_PROVIDE([$0])dnl
AC_HAVE_FUNCS(ftime)])dnl
dnl
define(CL_TIMES_CLOCK,
[AC_REQUIRE([CL_GETTIMEOFDAY])dnl
AC_REQUIRE([CL_FTIME])dnl
case "$DEFS" in
  *HAVE_GETTIMEOFDAY*) ;;
  *HAVE_FTIME*) ;;
  *)
AC_FUNC_CHECK(times, , no_times=1)dnl
if test -z "$no_times"; then
AC_MSG_CHECKING(for times return value)
AC_TEST_PROGRAM([
#include <sys/types.h>
#include <time.h> /* needed for CLK_TCK */
#ifndef CLK_TCK
#include <sys/time.h> /* needed for CLK_TCK on SYSV PTX */
#endif
#include <sys/times.h>
main ()
{ struct tms buffer;
  clock_t result1;
  clock_t result2;
  int ticks;
  result1 = times(&buffer);
  if ((result1 == (clock_t)0) || (result1 == (clock_t)(-1))) exit(1);
  sleep(1);
  result2 = times(&buffer);
  if ((result2 == (clock_t)0) || (result2 == (clock_t)(-1))) exit(1);
  ticks = result2 - result1;
  exit(!((ticks >= CLK_TCK/2) && (ticks <= 3*CLK_TCK/2)));
}],
AC_MSG_RESULT(yes)
AC_DEFINE(HAVE_TIMES_CLOCK),
AC_MSG_RESULT(no))
fi
  ;;
esac
])dnl
dnl
define(CL_GETPWNAM,
[AC_MSG_CHECKING(for getpwnam declaration)
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <pwd.h>
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
struct passwd * getpwnam (char* name);
#else
struct passwd * getpwnam();
#endif
main() { exit(0); }], x="", x="const")
AC_DEFINE_UNQUOTED(GETPWNAM_CONST,$x)
AC_MSG_RESULTPROTO([extern struct passwd * getpwnam ($x char*);])
])dnl
dnl
define(CL_GETPWUID,
[AC_MSG_CHECKING(for getpwuid declaration)
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <pwd.h>
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
struct passwd * getpwuid (uid_t uid);
#else
struct passwd * getpwuid();
#endif
main() { exit(0); }], x="uid_t", x="int")
AC_DEFINE_UNQUOTED(GETPWUID_UID_T,$x)
AC_MSG_RESULTPROTO([extern struct passwd * getpwuid ($x);])
])dnl
dnl
define(CL_GETHOSTNAME,
[AC_FUNC_CHECK(gethostname, AC_DEFINE(HAVE_GETHOSTNAME)
have_gethostname=1, )dnl
if test -n "$have_gethostname"; then
AC_MSG_CHECKING(for gethostname declaration)
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
int gethostname (char* name, int namelen);
#else
int gethostname();
#endif
main() { exit(0); }], x="int", x="size_t")
AC_DEFINE_UNQUOTED(GETHOSTNAME_SIZE_T,$x)
AC_MSG_RESULTPROTO([extern int gethostname (char*, $x);])
fi
])dnl
dnl
define(CL_GETHOSTBYNAME,
[AC_REQUIRE([CL_NETDB])dnl
case "$DEFS" in
  *HAVE_NETDB_H*) have_netdb=1 ;;
  *) AC_HEADER_CHECK(sun/netdb.h, have_netdb=1) ;;
esac
if test -n "$have_netdb"; then
AC_DEFINE(HAVE_GETHOSTBYNAME)
AC_MSG_CHECKING(for gethostbyname declaration)
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#ifdef HAVE_NETDB_H
#include <sys/socket.h>
#include <netdb.h>
#else
#include <sun/netdb.h>
#endif
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
struct hostent * gethostbyname (char* name);
#else
struct hostent * gethostbyname();
#endif
main() { exit(0); }], x="", x="const")
AC_DEFINE_UNQUOTED(GETHOSTBYNAME_CONST,$x)
AC_MSG_RESULTPROTO([extern struct hostent * gethostbyname ($x char*);])
fi
])dnl
dnl
define(CL_CONNECT,
[AC_MSG_CHECKING(for connect declaration)
for x in '' 'const'; do
for y in 'struct sockaddr *' 'void*'; do
if test -z "$have_connect"; then
AC_TEST_PROGRAM([
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/socket.h>
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
int connect (int fd, $x $y name, int namelen);
#else
int connect();
#endif
main() { exit(0); }],
AC_DEFINE_UNQUOTED(CONNECT_CONST,$x)
AC_DEFINE_UNQUOTED(CONNECT_NAME_T,$y)
AC_MSG_RESULTPROTO([extern int connect (int, $x $y, int);])
have_connect=1)
fi
done
done
])dnl
dnl
define(CL_UNIXCONN,
[AC_HAVE_HEADERS(sys/un.h)dnl
case "$DEFS" in
  *HAVE_SYS_UN_H*)
AC_COMPILE_CHECK([sun_len in struct sockaddr_un], [#include <sys/types.h> /* NetBSD 1.0 needs this */
#include <sys/un.h>],
[struct sockaddr_un unaddr; unaddr.sun_len;], AC_DEFINE(HAVE_SOCKADDR_UN_LEN))dnl
  ;;
  *) ;;
esac
])dnl
dnl
define(CL_TCPCONN,
[AC_HAVE_HEADERS(netinet/in.h arpa/inet.h)dnl
AC_MSG_CHECKING(for inet_addr declaration)
AC_TEST_PROGRAM([
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <netinet/in.h>
#ifdef HAVE_ARPA_INET_H
#include <arpa/inet.h>
#endif
extern
#ifdef __cplusplus
"C"
#endif
struct in_addr inet_addr();
main() { exit(0); }],
ret_inet_addr_type="struct in_addr"
AC_DEFINE(INET_ADDR_SUFFIX,[.s_addr])
have_inet_addr=1)
if test -z "$have_inet_addr"; then
AC_TEST_PROGRAM([
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <netinet/in.h>
#ifdef HAVE_ARPA_INET_H
#include <arpa/inet.h>
#endif
extern
#ifdef __cplusplus
"C"
#endif
unsigned long inet_addr();
main() { exit(0); }],
ret_inet_addr_type="unsigned long", ret_inet_addr_type="unsigned int")
AC_DEFINE(INET_ADDR_SUFFIX,[])
fi
AC_DEFINE_UNQUOTED(RET_INET_ADDR_TYPE,$ret_inet_addr_type)
AC_TEST_PROGRAM([
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <netinet/in.h>
#ifdef HAVE_ARPA_INET_H
#include <arpa/inet.h>
#endif
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
RET_INET_ADDR_TYPE inet_addr (char* cp);
#else
RET_INET_ADDR_TYPE inet_addr();
#endif
main() { exit(0); }], x="", x="const")
AC_DEFINE_UNQUOTED(INET_ADDR_CONST,$x)
AC_MSG_RESULTPROTO([extern $ret_inet_addr_type inet_addr ($x char*);])
AC_HAVE_HEADERS(netinet/tcp.h)dnl
])dnl
dnl
define(CL_GETPAGESIZE,
[AC_BEFORE([$0], [CL_MPROTECT])AC_PROVIDE([$0])dnl
AC_COMPILE_CHECK([getpagesize], , [getpagesize();],
AC_DEFINE(HAVE_GETPAGESIZE)
have_getpagesize=1)dnl
if test -n "$have_getpagesize"; then
AC_MSG_CHECKING(for getpagesize declaration)
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
extern
#ifdef __cplusplus
"C"
#endif
int getpagesize();
main() { exit(0); }], x="int", x="size_t")
AC_DEFINE_UNQUOTED(RETGETPAGESIZETYPE,$x)
AC_MSG_RESULTPROTO([extern $x getpagesize (void);])
fi
])dnl
dnl
define(CL_VADVISE,
[AC_COMPILE_CHECK([vadvise], [#include <sys/vadvise.h>], [vadvise(0);],
AC_DEFINE(HAVE_VADVISE)dnl
)])dnl
dnl
define(CL_MACH_VM,
[AC_COMPILE_CHECK([vm_allocate], , [vm_allocate(); task_self();],
AC_DEFINE(HAVE_MACH_VM)dnl
)])dnl
dnl
define(CL_MMAP,
[AC_REQUIRE([CL_OPENFLAGS])dnl
AC_BEFORE([$0], [CL_MUNMAP])AC_BEFORE([$0], [CL_MPROTECT])AC_PROVIDE([$0])dnl
AC_HEADER_CHECK(sys/mman.h, , no_mmap=1)dnl
if test -z "$no_mmap"; then
AC_FUNC_CHECK(mmap, , no_mmap=1)dnl
if test -z "$no_mmap"; then
AC_DEFINE(HAVE_MMAP)
AC_MSG_CHECKING(for mmap declaration)
# Note: gcc2 does not consider
#   void* mmap (void*, size_t, int, int, int, off_t);
#   char* mmap();
# to be an error, if the first declaration comes from a system include file.
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/mman.h>
extern
#ifdef __cplusplus
"C"
#endif
void* mmap();
main() { exit(0); }], retmmaptype="void*", retmmaptype="caddr_t")
AC_DEFINE_UNQUOTED(RETMMAPTYPE,$retmmaptype)
for y in 'int' 'size_t'; do
for x in 'void*' 'caddr_t'; do
if test -z "$have_mmap_decl"; then
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/mman.h>
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
RETMMAPTYPE mmap ($x addr, $y length, int prot, int flags, int fd, off_t off);
#else
RETMMAPTYPE mmap();
#endif
main() { exit(0); }],
AC_DEFINE_UNQUOTED(MMAP_ADDR_T,$x)
AC_DEFINE_UNQUOTED(MMAP_SIZE_T,$y)
AC_MSG_RESULTPROTO([extern $retmmaptype mmap ($x, $y, int, int, int, off_t);])
mmap_addr_type="$x"
mmap_size_type="$y"
have_mmap_decl=1)
fi
done
done
AC_MSG_CHECKING(for working mmap)
mmap_prog_1='
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <fcntl.h>
#ifdef NEED_SYS_FILE_H
#include <sys/file.h>
#endif
#include <sys/types.h>
#include <sys/mman.h>
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
RETMMAPTYPE mmap (MMAP_ADDR_T addr, MMAP_SIZE_T length, int prot, int flags, int fd, off_t off);
#else
RETMMAPTYPE mmap();
#endif
main () {
'
mmap_prog_2='
#define my_shift 24
#define my_low   1
#ifdef FOR_SUN4_29
#define my_high  31
#define my_size  32768 /* hope that 32768 is a multiple of the page size */
/* i*32 KB for i=1..31 gives a total of 15.5 MB, which is close to what we need */
#else
#define my_high  64
#define my_size  8192 /* hope that 8192 is a multiple of the page size */
/* i*8 KB for i=1..64 gives a total of 16.25 MB, which is close to what we need */
#endif
 {long i;
  for (i=my_low; i<=my_high; i++)
    { caddr_t addr = (caddr_t)(i << my_shift);
#if 0 /* Check for 16 MB. */
      long size = i*my_size;
#else /* Check for 8 MB. This is more likely to work on Solaris 2. */
      long size = ((i+1)/2)*my_size;
#endif
      if (mmap(addr,size,PROT_READ|PROT_WRITE,flags|MAP_FIXED,fd,0) == (RETMMAPTYPE)-1) exit(1);
    }
#define x(i)  *(unsigned char *) ((i<<my_shift) + (i*i))
#define y(i)  (unsigned char)((3*i-4)*(7*i+3))
  for (i=my_low; i<=my_high; i++) { x(i) = y(i); }
  for (i=my_high; i>=my_low; i--) { if (x(i) != y(i)) exit(1); }
  exit(0);
}}
'
AC_TEST_PROGRAM([$mmap_prog_1
  int flags = MAP_ANON | MAP_PRIVATE;
  int fd = -1;
$mmap_prog_2
], AC_DEFINE(HAVE_MMAP_ANON), rm -f core)
AC_TEST_PROGRAM([$mmap_prog_1
  int flags = MAP_ANONYMOUS | MAP_PRIVATE;
  int fd = -1;
$mmap_prog_2
], AC_DEFINE(HAVE_MMAP_ANONYMOUS), rm -f core)
AC_TEST_PROGRAM([$mmap_prog_1
#ifndef MAP_FILE
#define MAP_FILE 0
#endif
  int flags = MAP_FILE | MAP_PRIVATE;
  int fd = open("/dev/zero",O_RDONLY,0666);
  if (fd<0) exit(1);
$mmap_prog_2
], AC_DEFINE(HAVE_MMAP_DEVZERO), rm -f core
retry_mmap=1)
if test -n "$retry_mmap"; then
AC_TEST_PROGRAM([#define FOR_SUN4_29
$mmap_prog_1
#ifndef MAP_FILE
#define MAP_FILE 0
#endif
  int flags = MAP_FILE | MAP_PRIVATE;
  int fd = open("/dev/zero",O_RDONLY,0666);
  if (fd<0) exit(1);
$mmap_prog_2
], AC_DEFINE(HAVE_MMAP_DEVZERO_SUN4_29), rm -f core)
fi
case "$DEFS" in
  *HAVE_MMAP_ANON* | *HAVE_MMAP_DEVZERO*) AC_MSG_RESULT(yes)
  ;;
  *)                                      AC_MSG_RESULT(no)
  ;;
esac
fi
fi
])dnl
dnl
define(CL_MUNMAP,
[AC_REQUIRE([CL_MMAP])dnl
if test -z "$no_mmap"; then
AC_FUNC_CHECK(munmap, AC_DEFINE(HAVE_MUNMAP), )dnl
fi
])dnl
dnl
define(CL_MPROTECT,
[AC_REQUIRE([CL_GETPAGESIZE])dnl
AC_REQUIRE([CL_MMAP])dnl
AC_FUNC_CHECK(mprotect, AC_DEFINE(HAVE_MPROTECT), )dnl
AC_MSG_CHECKING(for mprotect declaration)
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/mman.h>
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
int mprotect (MMAP_ADDR_T addr, MMAP_SIZE_T len, int prot);
#else
int mprotect();
#endif
main() { exit(0); }], x="", x="const")
AC_DEFINE_UNQUOTED(MPROTECT_CONST,$x)
AC_MSG_RESULTPROTO([extern int mprotect ($x $mmap_addr_type, $mmap_size_type, int);])
mprotect_prog='
#include <sys/types.h>
/* declare malloc() */
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifndef malloc
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
RETMALLOCTYPE malloc (MALLOC_SIZE_T size);
#else
RETMALLOCTYPE malloc();
#endif
#endif
/* declare getpagesize() and mprotect() */
#include <sys/mman.h>
#ifndef HAVE_GETPAGESIZE
#include <sys/param.h>
#define getpagesize() PAGESIZE
#else
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
RETGETPAGESIZETYPE getpagesize (void);
#else
RETGETPAGESIZETYPE getpagesize();
#endif
#endif
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
int mprotect (MPROTECT_CONST MMAP_ADDR_T addr, MMAP_SIZE_T len, int prot);
#else
int mprotect();
#endif
char foo;
main () {
  unsigned long pagesize = getpagesize();
#define page_align(address)  (char*)((unsigned long)(address) & -pagesize)
'
AC_TEST_PROGRAM([$mprotect_prog
  if ((pagesize-1) & pagesize) exit(1);
  exit(0); }], , no_mprotect=1)
mprotect_prog="$mprotect_prog"'
  char* area = malloc(6*pagesize);
  char* fault_address = area + pagesize*7/2;
'
if test -z "$no_mprotect"; then
AC_TEST_PROGRAM([$mprotect_prog
  if (mprotect(page_align(fault_address),pagesize,PROT_NONE) < 0) exit(0);
  foo = *fault_address; /* this should cause a core dump */
  exit(0); }],
  no_mprotect=1, rm -f core)
fi
if test -z "$no_mprotect"; then
AC_TEST_PROGRAM([$mprotect_prog
  if (mprotect(page_align(fault_address),pagesize,PROT_NONE) < 0) exit(0);
  *fault_address = 'z'; /* this should cause a core dump */
  exit(0); }],
  no_mprotect=1, rm -f core)
fi
if test -z "$no_mprotect"; then
AC_TEST_PROGRAM([$mprotect_prog
  if (mprotect(page_align(fault_address),pagesize,PROT_READ) < 0) exit(0);
  *fault_address = 'z'; /* this should cause a core dump */
  exit(0); }],
  no_mprotect=1, rm -f core)
fi
if test -z "$no_mprotect"; then
AC_TEST_PROGRAM([$mprotect_prog
  if (mprotect(page_align(fault_address),pagesize,PROT_READ) < 0) exit(1);
  if (mprotect(page_align(fault_address),pagesize,PROT_READ|PROT_WRITE) < 0) exit(1);
  *fault_address = 'z'; /* this should not cause a core dump */
  exit(0); }], , no_mprotect=1
rm -f core)
fi
if test -z "$no_mprotect"; then
  AC_DEFINE(HAVE_WORKING_MPROTECT)
fi]
)dnl
dnl
define(CL_SHMGET,
[case "$DEFS" in
  *HAVE_SHM*)
AC_MSG_CHECKING(for shmget declaration)
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
int shmget (key_t key, int size, int shmflg);
#else
int shmget();
#endif
main() { exit(0); }], x="int", x="size_t")
AC_DEFINE_UNQUOTED(SHMGET_SIZE_T,$x)
AC_MSG_RESULTPROTO([extern int shmget (key_t, $x, int);])
  ;;
  *) ;;
esac
])dnl
dnl
define(CL_SHMAT,
[case "$DEFS" in
  *HAVE_SHM*)
AC_MSG_CHECKING(for shmat declaration)
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
extern
#ifdef __cplusplus
"C"
#endif
void* shmat();
main() { exit(0); }], x="void*", x="char*")
AC_DEFINE_UNQUOTED(RETSHMATTYPE,$x)
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
RETSHMATTYPE shmat (int shmid, RETSHMATTYPE shmaddr, int shmflg);
#else
RETSHMATTYPE shmat();
#endif
main() { exit(0); }], y="", y="const")
AC_DEFINE_UNQUOTED(SHMAT_CONST,$y)
AC_MSG_RESULTPROTO([extern $retshmattype shmat (int, $y $x, int);])
  ;;
  *) ;;
esac
])dnl
dnl
define(CL_SHMCTL,
[case "$DEFS" in
  *HAVE_SHM*)
AC_MSG_CHECKING(for shmctl declaration)
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
extern
#ifdef __cplusplus
"C"
#endif
#ifdef __STDC__
int shmctl (int shmid, int cmd, struct shmid_ds * buf);
#else
int shmctl();
#endif
main() { exit(0); }],
AC_MSG_RESULTPROTO([extern int shmctl (int, int, struct shmid_ds *);]),
AC_MSG_RESULTPROTO([extern int shmctl (int, int, ...);])
AC_DEFINE(SHMCTL_DOTS))
  ;;
  *) ;;
esac
])dnl
dnl
define(CL_SHM_RMID,
[case "$DEFS" in
  *HAVE_SHM*)
AC_MSG_CHECKING(for attachability of removed shared memory)
AC_TEST_PROGRAM([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#ifdef HAVE_SYS_SYSMACROS_H
#include <sys/sysmacros.h>
#endif
#ifdef __STDC__
extern
#ifdef __cplusplus
"C"
#endif
int shmget (key_t key, SHMGET_SIZE_T size, int shmflg);
extern
#ifdef __cplusplus
"C"
#endif
RETSHMATTYPE shmat (int shmid, SHMAT_CONST RETSHMATTYPE shmaddr, int shmflg);
extern
#ifdef __cplusplus
"C"
#endif
#ifdef SHMCTL_DOTS
int shmctl (int shmid, int cmd, ...);
#else
int shmctl (int shmid, int cmd, struct shmid_ds * buf);
#endif
#else
extern int shmget();
extern RETSHMATTYPE shmat();
extern int shmctl();
#endif
main ()
{ unsigned int pagesize = 8192; /* should be a multiple of SHMLBA */
  unsigned long addr = (unsigned long) malloc(2*pagesize);
  addr += pagesize-1; addr = (addr/pagesize)*pagesize;
 {unsigned long addr1 = addr + 0x10000;
  unsigned long addr2 = addr + 0x20000;
  int id = shmget(IPC_PRIVATE,pagesize,IPC_CREAT|0600);
  if (id<0)
    { exit(1); }
  if (shmat(id,(RETSHMATTYPE)addr1,0) == (RETSHMATTYPE)(-1))
    { shmctl(id,IPC_RMID,NULL); exit(1); }
  if (shmctl(id,IPC_RMID,NULL) < 0)
    { exit(1); }
  if (shmat(id,(RETSHMATTYPE)addr2,0) == (RETSHMATTYPE)(-1))
    { shmctl(id,IPC_RMID,NULL); exit(1); }
  shmctl(id,IPC_RMID,NULL);
  exit(0);
}}
], AC_MSG_RESULT(yes)
AC_DEFINE(SHM_RMID_VALID),
AC_MSG_RESULT(no))
  ;;
  *) ;;
esac
])dnl
dnl
define(CL_CHAR_UNSIGNED,
[AC_MSG_CHECKING(whether characters are unsigned)
AC_TEST_PROGRAM(
[/* volatile prevents gcc2 from optimizing the test away on sparcs.  */
#if !__STDC__
#define volatile
#endif
main() { volatile char c = 255; exit(c < 0); }],
AC_MSG_RESULT(yes)
AC_DEFINE(__CHAR_UNSIGNED__),
AC_MSG_RESULT(no))]
)dnl
dnl
define(CL_MACHINE,
[echo checking for integer types and behaviour
cat > conftest.c <<EOF
#include "confdefs.h"
EOF
cat ${srcdir}/machine.c >> conftest.c
ORIGCC="$CC"
if test -n "$GCC"; then
# gcc -O (gcc version <= 2.3.2) crashes when compiling long long shifts for
# target 80386. Strip "-O".
CC=`echo "$CC " | sed -e 's/-O //g'`
fi
eval $compile
CC="$ORIGCC"
if test -s conftest; then
  echo creating machine.h
  ./conftest > conftest.h
  if cmp -s machine.h conftest.h 2>/dev/null; then
    # The file exists and we would not be changing it
    rm -f conftest.h
  else
    rm -f machine.h
    mv conftest.h machine.h
  fi
else
  echo creation of machine.h failed
fi
rm -f conftest*
])dnl
dnl
define(CL_WORDS_LITTLEENDIAN,
[echo checking byte ordering
AC_TEST_PROGRAM([main () {
  /* Are we little or big endian?  From Harbison&Steele.  */
  union
  {
    long l;
    char c[sizeof (long)];
  } u;
  u.l = 1;
  exit (u.c[0] == 1);
}], , AC_DEFINE(WORDS_LITTLEENDIAN))])dnl
dnl
