------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                              S E M _ C H 8                               --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.15 $                             --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

with Types; use Types;
package Sem_Ch8  is

   procedure Analyze_Exception_Renaming                 (N : Node_Id);
   procedure Analyze_Generic_Function_Renaming          (N : Node_Id);
   procedure Analyze_Generic_Package_Renaming           (N : Node_Id);
   procedure Analyze_Generic_Procedure_Renaming         (N : Node_Id);
   procedure Analyze_Object_Renaming                    (N : Node_Id);
   procedure Analyze_Package_Renaming                   (N : Node_Id);
   procedure Analyze_Subprogram_Renaming                (N : Node_Id);
   procedure Analyze_Use_Package                        (N : Node_Id);
   procedure Analyze_Use_Type                           (N : Node_Id);

   procedure End_Scope;
   --  Called at end of scope. On exit On exit from blocks and bodies
   --  (subprogram, package, task, and protected bodies), the name of the
   --  current scope must be removed from the scope stack, and the local
   --  entities must be removed from their homonym chains. On exit from
   --  record declarations, from package specifications, and from tasks
   --  and protected type specifications, more specialized procedures
   --  are invoked.

   procedure End_Use (L : List_Id);
   --  Find use clauses that are declarative items, and reset
   --  the direct visibility flags of the imported entities.

   procedure End_Use_Package (N : Node_Id);
   procedure End_Use_Type    (N : Node_Id);
   --  Subsidiaries of End_Use. Also called for use clauses in
   --  context clauses.

   procedure Find_Direct_Name (N : Node_Id);
   --  Given a direct name (Identifier or Operator_Symbol), this routine
   --  scans the homonym chain for the name searching for corresponding
   --  visible entities to find the referenced entity (or in the case of
   --  overloading), entities. On return, the Entity, and Etype fields
   --  are set. In the non-overloaded case, these are the correct final
   --  entries. In the overloaded case, Is_Overloaded is set, Etype and
   --  Entity refer to an arbitrary element of the overloads set, and
   --  an appropriate list of entries has been made in the overload
   --  interpretation table (to be disambiguated in the resolve phase).

   procedure Find_Expanded_Name (N : Node_Id);
   --  Selected component is known to be expanded name. Verify legality
   --  of selector given the scope denoted by prefix.

   procedure Find_Selected_Component (N : Node_Id);
   --  Resolve various cases of selected components, recognize expanded names

   procedure Find_Type (N : Node_Id);
   --  Perform name resolution, and verify that the name found is that of a
   --  type. On return the Entity and Etype fields of the node N are set
   --  appropriately. If it is an incomplete type whose full declaration has
   --  been seen, return the entity in the full declaration. Similarly, if
   --  the type is private, it has receivd a full declaration, and we are
   --  in the private part or body of the package, return the full
   --  declaration as well. Special processing for Class types as well.

   function Has_Implicit_Operator (N : Node_Id) return Boolean;
   --  N is an expanded name whose selector is an operator name (eg P."+").
   --  A declarative part contains an implicit declaration of an operator
   --  if it has a declaration of a type to which one of the predefined
   --  operators apply. The existence of this routine is an artifact of
   --  our implementation: a more straightforward but more space-consuming
   --  choice would be to make all inherited operators explicit in the
   --  symbol table.

   procedure Initialize;
   --  Initializes data structures used for visibility analysis. Must be
   --  called before analyzing each new main source program.

   function In_Open_Scopes (S : Entity_Id) return Boolean;
   --  S is the entity of a scope. This function determines if this scope
   --  is currently open (i.e. it appears somewhere in the scope stack).

   function Is_Appropriate_For_Record (T : Entity_Id) return Boolean;
   --  Prefix is appropriate for record if it is of a record type, or
   --  an access to such.

   function Is_Appropriate_For_Entry_Prefix (T : Entity_Id) return Boolean;
   --  True if it is of a task type, a protected type,  or else
   --  an access to such.

   procedure New_Scope (S : Entity_Id);
   --  Make new scope stack entry, pushing S, the entity for a scope
   --  onto the top of the scope table. The current setting of the scope
   --  suppress flags is saved for restoration on exit.

   procedure Pop_Scope;
   --  Remove top entry from scope stack, restoring the saved setting
   --  of the scope suppress flags.

   procedure Restore_Scope_Stack;
   procedure Save_Scope_Stack;
   --  These two procedures are called from Semantics, when a unit U1 is
   --  to be compiled in the course of the compilation of another unit U2.
   --  This happens whenever Rtsfind is called. U1, the unit retrieved by
   --  Rtsfind, must be compiled in its own context, and the current scope
   --  stack containing U2 and local scopes must be made unreachable. On
   --  return, the contents of the scope stack must be made accessible again.

   procedure Set_Use (L : List_Id);
   --  Find use clauses that are declarative items in a package declaration
   --  and  set the potentially use-visible flags of imported entities before
   --  analyzing the corresponding package body.

end Sem_Ch8;


----------------------
-- REVISION HISTORY --
----------------------

--  ----------------------------
--  revision 1.13
--  date: Wed Jun 29 15:05:20 1994;  author: dewar
--  Remove junk comments for obsolete routine (Establish_Transient_Scope)
--  ----------------------------
--  revision 1.14
--  date: Fri Jul 22 11:42:26 1994;  author: dewar
--  Change comments (directly visible -> immediately visible)
--  (Initialize): New procedure
--  (Find_Direct_Name): New name for Find_Simple_Name
--  ----------------------------
--  revision 1.15
--  date: Thu Jul 28 08:52:02 1994;  author: schonber
--  Remove Find_Name, now obsolete.
--  ----------------------------
--  New changes after this line.  Each line starts with: "--  "
