------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                              E X P _ C H 4                               --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.18 $                             --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

--  Expand routines for chapter 4 constructs

with Types; use Types;

package Exp_Ch4 is

   procedure Expand_N_Allocator                   (N : Node_Id);
   procedure Expand_N_Concat_Multiple             (N : Node_Id);
   procedure Expand_N_Op_Abs                      (N : Node_Id);
   procedure Expand_N_Op_Add                      (N : Node_Id);
   procedure Expand_N_Op_And                      (N : Node_Id);
   procedure Expand_N_Op_Concat                   (N : Node_Id);
   procedure Expand_N_Op_Divide                   (N : Node_Id);
   procedure Expand_N_Op_Expon                    (N : Node_Id);
   procedure Expand_N_Op_Eq                       (N : Node_Id);
   procedure Expand_N_Op_Ge                       (N : Node_Id);
   procedure Expand_N_Op_Gt                       (N : Node_Id);
   procedure Expand_N_Op_In                       (N : Node_Id);
   procedure Expand_N_Op_Le                       (N : Node_Id);
   procedure Expand_N_Op_Lt                       (N : Node_Id);
   procedure Expand_N_Op_Minus                    (N : Node_Id);
   procedure Expand_N_Op_Mod                      (N : Node_Id);
   procedure Expand_N_Op_Multiply                 (N : Node_Id);
   procedure Expand_N_Op_Not                      (N : Node_Id);
   procedure Expand_N_Op_Not_In                   (N : Node_Id);
   procedure Expand_N_Op_Or                       (N : Node_Id);
   procedure Expand_N_Op_Rem                      (N : Node_Id);
   procedure Expand_N_Op_Subtract                 (N : Node_Id);
   procedure Expand_N_Op_Xor                      (N : Node_Id);
   procedure Expand_N_Slice                       (N : Node_Id);
   procedure Expand_N_Type_Conversion             (N : Node_Id);

   procedure Expand_Literal_To_Fixed (Lit : Node_Id; Typ : Entity_Id);
   --  Transform any real literal node into the corresponding fixed type value
   --  The conversion algorithm is:
   --            Typ! (Int_Typ (Lit / Small_Value (Typ)))
   --  where Int_Typ is the corresponding integer type of the fixed point type.

   function Expand_Record_Equality (
     Loc : Source_Ptr;
     Typ : Entity_Id;
     Lhs : Node_Id;
     Rhs : Node_Id)
     return Node_Id;
   --  Expand a record equality into an expression that compares the fields
   --  individually to yield the required Boolean result. Loc is the location
   --  for the generated nodes. Typ is the type of the record, and Lhs, Rhs
   --  are the record expressions to be compared. Note that the case of
   --  variant records is not implemented yet ???.

end Exp_Ch4;


----------------------
-- REVISION HISTORY --
----------------------

--  ----------------------------
--  revision 1.16
--  date: Wed May 18 18:19:23 1994;  author: comar
--  (Expand_Class_Wide_Allocator): Removed.
--  ----------------------------
--  revision 1.17
--  date: Sat Jun  4 19:41:32 1994;  author: dewar
--  (Expand_N_Op_Abs): New procedure
--  (Expand_N_Op_Add): New procedure
--  (Expand_N_Op_Minus): New procedure
--  (Expand_N_Op_Mod): New procedure
--  (Expand_N_Op_Rem): New procedure
--  (Expand_N_Op_Subtract): New procedure
--  ----------------------------
--  revision 1.18
--  date: Fri Jul  1 11:05:22 1994;  author: crozes
--  (Expand_Literal_To_Fixed) : New procedure.
--  ----------------------------
--  New changes after this line.  Each line starts with: "--  "
