------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                                A L L O C                                 --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.11 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

package Alloc is

--  This package contains definitions for initial sizes and growth increments
--  for the various dynamic arrays used for principle compiler data strcutures.
--  The indicated initial size is allocated for the start of each file, and
--  the increment factor is a percentage used to increase the table size when
--  it needs expanding (e.g. a value of 100 = 100% increase = double)

   Alloc_Elists_Initial : constant := 1_000;
   --  Initial allocation in Elist headers for tree (Elists)

   Alloc_Elists_Increment : constant := 150;
   --  Incremental allocation factor for Elist headers table (Elists)

   Alloc_Elmts_Initial : constant := 4_000;
   --  Initial allocation in Elmts table (Elists)

   Alloc_Elmts_Increment : constant := 150;
   --  Incremental allocation factor for Elmts table (Elists)

   Alloc_Feature_List_Initial : constant := 100;
   --  Initial allocation for Feature_List table (Features)

   Alloc_Feature_List_Increment : constant := 300;
   --  Incremental allocation factor for Feature_List table (Features)

   Alloc_Hash_Sub_Initial : constant := 2048;
   --  Initial allocation in tree substitution hash table (Atree)

   Alloc_Hash_Sub_Increment : constant := 300;
   --  Incremental allocation factor in tree substitution hash table (Atree)

   Alloc_Lines_Initial : constant := 4_000;
   --  Initial allocation for lines table (Lib, Lib.Load)

   Alloc_Lines_Increment : constant := 150;
   --  Incremental allocation factor for lines table (Sinput)

   Alloc_Lists_Initial : constant := 4_000;
   --  Initial allocation in list headers for tree (Nlists)

   Alloc_Lists_Increment : constant := 200;
   --  Incremental allocation factor for list table (Nlists)

   Alloc_Name_Chars_Initial : constant := 64_000;
   --  Initial allocation for name characters table (Namet)

   Alloc_Name_Chars_Increment : constant := 100;
   --  Incremental allocation factor for name characters table (Namet)

   Alloc_Names_Initial : constant := 4_000;
   --  Initial allocation of entries in names table (Namet)

   Alloc_Names_Increment : constant := 100;
   --  Incremental allocation factor of entries in names table (Namet)

   Alloc_Nodes_Initial : constant := 8_000;
   --  Initial allocation in nodes for tree (Atree)

   Alloc_Nodes_Increment : constant := 200;
   --  Incremental allocation factor for nodes table (Atree)

   Alloc_String_Chars_Initial : constant := 64_000;
   --  Initial allocation for name characters table (Stringt)

   Alloc_String_Chars_Increment : constant := 150;
   --  Incremental allocation factor for name characters table (Stringt)

   Alloc_Strings_Initial : constant := 500;
   --  Initial allocation of entries in names table (Stringt)

   Alloc_Strings_Increment : constant := 150;
   --  Incremental allocation factor of entries in names table (Stringt)

   Alloc_Udigits_Initial : constant := 5000;
   --  Initial allocation for Uint digits table (Uintp)

   Alloc_Udigits_Increment : constant := 100;
   --  Incremental allocation factor Uint digits table (Uintp)

   Alloc_Uints_Initial : constant := 2000;
   --  Initial allocation for uint table in digits (Uintp)

   Alloc_Uints_Increment : constant := 100;
   --  Incremental allocation factor for Uint table in digits (Uintp)

   Alloc_Ureals_Initial : constant := 500;
   --  Initial allocation for universal real table in entries (Urealp)

   Alloc_Ureals_Increment : constant := 100;
   --  Incremental allocation factor for universal real table (Urealp)

   Alloc_With_List_Initial : constant := 100;
   --  Initial allocation for With_List table (Features)

   Alloc_With_List_Increment : constant := 300;
   --  Incremental allocation factor for With_List table (Features)

end Alloc;


----------------------
-- REVISION HISTORY --
----------------------

--  ----------------------------
--  revision 1.9
--  date: Sun Jan 16 11:32:01 1994;  author: dewar
--  Put entries in alphabetical order
--  Add entries for Elists and Elmts tables
--  Correct comments of what packages use what constants (some obsolete junk
--   in comments, such as references to Tree package)
--  Update comments for new arrangement of separate Nlists package
--  ----------------------------
--  revision 1.10
--  date: Fri May 20 13:10:20 1994;  author: crozes
--  Change value of Alloc_Uints_Initial from 500 to  2000.
--  Add Alloc_Ureals_Initial and Alloc_Ureals Increment.
--  ----------------------------
--  revision 1.11
--  date: Fri Jul 22 11:31:30 1994;  author: dewar
--  Remove obsolete comment references to Atree.Tree_Sub
--  Add Alloc_Feature_List_Initial, Alloc_Feature_List_Increment
--  Add Alloc_With_List_Initial, Alloc_With_List_Increment
--  ----------------------------
--  New changes after this line.  Each line starts with: "--  "
