/*
 *	pop3d		- IP/TCP/POP3 server for UNIX 4.3BSD
 *			  Post Office Protocol - Version 3 (RFC1081)
 *
 *	Katie Stevens
 *	dkstevens@ucdavis.edu
 * 	Computing Services
 *	University of California, Davis
 *
 **************************************
 *
 *	util.c
 *
 *	REVISIONS:
 *		02-27-90 [ks]	original implementation
 *	1.000	03-04-90 [ks]
 */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <pwd.h>
#include "pop3.h"

char flash_buf[SVR_BUFSIZ];

#if DEBUG
extern FILE *logfp;
#endif

/**************************************************************************/

/* Verify a usercode/password */
int
verify_user(user,pass)
char *user;
char *pass;
{
	struct passwd *pwd;
	char *cp;

	pwd = getpwnam(user);
	if (pwd == NULL) return -1;
	cp = crypt(pass,pwd->pw_passwd);
	if (strcmp(cp,pwd->pw_passwd) == 0) {
		return(setuid(pwd->pw_uid));
	} else {
		return(-1);
	}
}

/**************************************************************************/

/* Read a line of text from a stream. If more than n-1  */
/* characters are read without a line terminator (LF),  */
/* discard characters until line terminator is located. */
char *
fgetl(buf,n,fp)
char *buf;	/* Buffer for text */
int n;		/* Size of buffer */
FILE *fp;	/* Stream to read from */
{
	if (fgets(buf,n,fp) == NULL)
		return(NULL);
	if ((strlen(buf) == (n-1))&&(buf[n-1] != LF_CHAR)) {
		buf[n-1] = LF_CHAR;
		while (fgets(flash_buf,SVR_BUFSIZ,fp) != NULL) {
			if (strlen(flash_buf) != (SVR_BUFSIZ-1))
				break;
			if (flash_buf[SVR_BUFSIZ-1] == LF_CHAR)
				break;
		}
	}
	return(buf);
}

/* Prepare client command for server */
void
cmd_prepare(buf)
char *buf;
{
	char *cp;

	if (buf == NULL)
		return;
	/* Convert command verb to lowercase */
	while (*buf != NULL_CHAR) {
		if (isupper(*buf))
			*buf = tolower(*buf);
		else if (isspace(*buf))
			break;
		++buf;
	}
	/* Strip trailing whitespace from client command */
	if ((cp = strchr(buf,CR_CHAR)) != NULL) {
		while ((cp != buf)&&(isspace(*cp))) --cp;
		if (!isspace(*cp)) ++cp;
		*cp = NULL_CHAR;
	}
	if ((cp = strchr(buf,LF_CHAR)) != NULL) {
		while ((cp != buf)&&(isspace(*cp))) --cp;
		if (!isspace(*cp)) ++cp;
		*cp = NULL_CHAR;
	}
	return;
}

/**************************************************************************/

/* Send an error message and exit POP3 server */
void
fail(err)
int err;
{
	char *cp;

	switch(err) {
	case FAIL_FILE_ERROR:			/* File I/O error */
		cp = "File I/O error";
		break;
	case FAIL_HANGUP:			/* Client hung up on us */
		cp = "Lost connectino to client";
		break;
	case FAIL_LOST_CLIENT:			/* Timeout waiting for client */
		cp = "Timeout waiting for command from client";
		break;
	case FAIL_OUT_OF_MEMORY:		/* Failed malloc() */
		cp = "Out of memory!";
		break;
	case FAIL_PROGERR:			/* Fatal program error */
		cp = "Fatal program error!";
		break;
	case FAIL_CONFUSION:			/* Shouldnt happen */
	default:
		cp = "Complete confusion!";
		break;
	}
	fprintf(stdout,"-ERR POP3 Server Abnormal Shutdown: %s\r\n",cp);
	fflush(stdout);
#if DEBUG
	fprintf(logfp,"-ERR POP3 Server Abnormal Shutdown: %s\r\n",cp);
	fclose(logfp);
#endif
	exit(err);				/* Exit with error */
}
