#ifndef UMSDOS_TEST_H
#define UMSDOS_TEST_H

#define MAXSIZ_PATH		200		// Longest path

class UMSDOS_REGISTER{	// All UMSDOS_REGISTER object must be static
						// So the link list will be initialised before
						// main.
	int nberr;		// Number of error signal so far
	int intro_shown;	// Have we print the heading of the test
					// once ?
public:
	UMSDOS_REGISTER *next;
	const char *path;
	const char *desc;
	int (*fct)(const char *);
	/*~PROTOBEG~ UMSDOS_REGISTER */
public:
	UMSDOS_REGISTER (int (*_fct)(const char *),
		 const char *_path,
		 const char *_desc);
	int call (const char *path);
	int getnberr (void);
	void intro (void);
	void prterr (const char *ctl, ...);
	void verbose (const char *ctl, ...);
	void warning (const char *ctl, ...);
	/*~PROTOEND~ UMSDOS_REGISTER */
};

extern int register_verbose;
extern UMSDOS_REGISTER *first;

#define REGISTER(f,d) \
static int f(const char*); \
UMSDOS_REGISTER R##f(f,__FILE__ "/" #f,d);

#include <stdio.h>
#include <sys/types.h>

#include "umsdos_test.p"

#endif

