#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <pwd.h>
#include <grp.h>
#include <linux/umsdos_fs.h>
#include "umsdos_progs.h"

int main (int argc, char *argv[])
{
	int ret = -1;
	if (argc == 1){
		fprintf (stderr,"umssetup %d.%d\n",UMSDOS_VERSION,UMSDOS_RELEASE);
		fprintf (stderr,
			"umssetup [ options ] dir_path\n"
			"\n"
			"\tSet the default permissions and owner of files in DOS\n"
			"\tdirectories. UMSDOS directory are not affected.\n"
			"\n"
			" -ggroup : group id for entry creation\n"
			" -mmode  : Permission bits (in octal)\n"
			" -uuser  : user id for entry creation\n"
			"\n"
			"dir_path is normally a mount point. It does not matter.\n"
			"Note that the change apply to all DOS directories\n"
			"(and files in those) of the same partition as dir_path.\n"
			);
	}else{
		int uid = 0;
		int gid = 0;
		mode_t mode = 0666;
		ret = 0;
		for (int i=1; i<argc; i++){
			char *arg = argv[i];
			char *parm = arg+2;
			if (arg[0] != '-'){
				break;
			}else{
				const char *parm = arg+2;
				if (arg[2] == '\0'){
					i++;
					if (i==argc){
						fprintf(stderr,"Incomplete option %s\n",arg);
						ret = -1;
						break;
					}
					parm = argv[i];
				}
				if (arg[1] == 'g'){
					if (isdigit(parm[0])){
						gid = xtoi(parm,ret);
					}else{
						struct group *pt = getgrnam (parm);
						if (pt == NULL){
							fprintf (stderr,"Invalid option -g : "
								"Group %s unknown\n",parm);
							ret = -1;
						}else{
							gid = pt->gr_gid;
						}
					}
				}else if (arg[1] == 'm'){
					gid = xtoi(parm,ret);
				}else if (arg[1] == 'u'){
					if (isdigit(parm[0])){
						uid = xtoi(parm,ret);
					}else{
						struct passwd *pt = getpwnam (parm);
						if (pt == NULL){
							fprintf (stderr,"Invalid option -u : "
								"User %s unknown\n",parm);
							ret = -1;
						}else{
							uid = pt->pw_uid;
						}
					}
				}else{
					fprintf (stderr,"Invalid option %s\n",arg);
					ret = -1;
				}
			}
		}
		if (ret != -1){
			if (i == argc){
				fprintf (stderr,"You must specify a mount point\n");
				ret = -1;
			}else{
				UMSDOS_IOCTL ioc(argv[i],1,1);
				ret = ioc.dossetup (uid,gid,mode);
			}
		}
	}
	return ret;
}

