
#include <stdio.h>
#define NDEBUG
#include <assert.h>

#include <vdi.h>

#include "l_defs.h"

#include "trees.h"

OBJECT *
tr_add(t, as_child, type, flags, state, spec, x, y, width, height)
register TREE *t;
int as_child;
int type, flags, state;
long spec;
int x, y, width, height;
{
	register int new;
	register OBJECT *o;
	L_EXTEND(t->nobjs, t->obj, OBJECT, 1);
	if ( t->obj == NULL ) return NULL;
	new = t->nobjs - 1;
	if ( new == 0 ) NEXT(new)= -1;		/* Creating the root */
	else if ( as_child ) {				/* Add as first child of focus */
		assert( HEAD(t->focus) < 0 );	/* Must be first */
		HEAD(t->focus) = TAIL(t->focus)= new;
		NEXT(new) = t->focus;
	}
	else {								/* Add as sibling of focus */
		assert( TAIL(NEXT(t->focus)) == t->focus ); /* Must be last */
		NEXT(new) = NEXT(t->focus);
		NEXT(t->focus) = new;
		TAIL(NEXT(new)) = new;
	}
	HEAD(new) = TAIL(new) = -1;
	t->focus = new;
	o = &t->obj[new];
	o->ob_type = type;
	o->ob_flags = flags;
	o->ob_state = state;
	o->ob_spec.index = spec;
	o->ob_x = x;
	o->ob_y = y;
	o->ob_width = width;
	o->ob_height = height;
	return(o);
}

