/* Digital clock */

#include <ctype.h>
#include <stdio.h>
#include <time.h>

#include "stdwin.h"

#include "sevenseg.h"

extern long time();

int text_only;                          /* Non-zero on text-only device */

WINDOW *win;                            /* Our window */

#define NIMAGE  5                       /* Number of chars in image */
char image[NIMAGE+1];                   /* Text to draw, plus trailing \0 */

int aleft, atop, aright, abottom;       /* Rect in which to draw */

/* Forward declarations */
void newtime _ARGS((void));
void setup _ARGS((void));
void mainloop _ARGS((void));

void
getinfo()
{
        wgetwinsize(win, &aright, &abottom);
        wsetdocsize(win, aright, abottom);
        newtime();
}

void
newtime()
{
        unsigned long now;
        struct tm *tp;

        wchange(win, aleft, atop, aright, abottom);
        time(&now);
        tp= localtime(&now);
        wsettimer(win, 10 * (60 - now%60));
        sprintf(image, "%02d:%02d", tp->tm_hour, tp->tm_min);
}

void
drawdigit(digit, left, top, right, bottom, dh, dv)
        int digit;
        int left, top, right, bottom;
        int dh, dv; /* Segment thickness */
{
        int bits= sevenseg[digit];
        int mid= (top + bottom) / 2;

        if (bits & (1<<6))
                wpaint(left, top, right, top+dv);
        if (bits & (1<<5))
                wpaint(left, top, left+dh, mid);
        if (bits & (1<<4))
                wpaint(right-dh, top, right, mid);
        if (bits & (1<<3))
                wpaint(left, mid-dv/2, right, mid+dv-dv/2);
        if (bits & (1<<2))
                wpaint(left, mid, left+dh, bottom);
        if (bits & (1<<1))
                wpaint(right-dh, mid, right, bottom);
        if (bits & (1<<0))
                wpaint(left, bottom-dv, right, bottom);
}

void
drawproc(win, left, top, right, bottom)
        WINDOW *win;
        int left, top, right, bottom;
{
        int width= aright - aleft;
        int height= abottom - atop;
        int dh= width / (NIMAGE*6 + 1);
        int dv= height / 9;
        int spacing;
        int i;

        if (dh < 1)
                dh= 1;
        if (dv < 1)
                dv= 1;

        spacing= dh*6;

        for (i= 0; i < NIMAGE && image[i] != '\0'; ++i) {
                if (isdigit(image[i])) {
                        drawdigit(image[i] - '0',
                                aleft + dh + i*spacing, atop + dv,
                                aleft + dh + (i+1)*spacing - dh, abottom - dv,
                                dh, dv);
                }
        }
}

int
main(argc, argv)
        int argc;
        char **argv;
{
        winitargs(&argc, &argv);
        setup();
        mainloop();
        wdone();
        exit(0);
}

void
setup()
{
        if (wlineheight() == 1) {
                text_only= 1;
                wmessage("Text-only version");
        }
        win= wopen("DIGITAL CLOCK", drawproc);
        getinfo();
}

void
mainloop()
{
        for (;;) {
                EVENT e;
                wgetevent(&e);
                switch (e.type) {
                case WE_COMMAND:
                        switch (e.u.command) {
                        case WC_CLOSE:
                        case WC_CANCEL:
                                wclose(win);
                                return;
                        }
                        break;
                case WE_CLOSE:
                        wclose(win);
                        return;
                case WE_SIZE:
                        getinfo();
                        break;
                case WE_TIMER:
                        newtime();
                        break;
                }
        }
}
