/* dpv -- ditroff previewer.  Main program. */

#include "dpv.h"

int     dbg;            /* Amount of debugging output wanted */
int     windowarn;      /* Set if errors must go to dialog box */

char   *progname= "dpv"; /* Program name if not taken from argv[0] */

/* Main program.  Scan arguments and call other routines. */

main(argc, argv)
        int argc;
        char **argv;
{
        int firstpage;

        winitargs(&argc, &argv);
        wsetdefscrollbars(1, 1);

        if (argc > 0 && *argv != NULL && **argv != EOS) {
                progname= strrchr(argv[0], '/');
                if (progname != NULL)
                        ++progname;
                else
                        progname= argv[0];
        }

        for (;;) {
                int c;

                c= getopt(argc, argv, "df:t:P:");
                if (c == EOF)
                        break;
                switch (c) {

                case 'f':       /* Alternate funnytab file */
                        funnyfile = optarg;
                        break;

                case 't':       /* Alternative font translations file */
                        readtrans(optarg);
                        break;

                case 'd':       /* Ask for debugging output */
                        ++dbg; /* Use -dd to increment debug level */
                        break;

                case 'P':       /* Add printer definition */
                        addprinter(optarg);
                        break;

                default:
                        usage();
                        /*NOTREACHED*/

                }
        }

        if (optind < argc && argv[optind][0] == '+') {
                if (argv[optind][1] == EOS ||
                        argv[optind][1] == '$')
                        firstpage= 32000;
                else
                        firstpage= atoi(argv[optind] + 1);
                ++optind;
        }
        else
                firstpage= 1;

        if (optind+1 != argc || strcmp(argv[optind], "-") == 0)
                usage();

        windowarn= 1; /* From now on, use dialog box for warnings */

        preview(argv[optind], firstpage);

        exit(0);
}

usage()
{
        error(ABORT,
"usage: %s [-d] [-f funnytab] [-t translationsfile] [-P printer] [+page] file",
            progname);
}

/*VARARGS2*/
#if defined(__STDC__) && defined(HAVE_STDARG_H)

#include <stdarg.h>
void error (int f, char* s, ...)
{       va_list args;

        va_start(args,s);
        if (f != WARNING || !windowarn) { /* Use stderr */
                if (f != 0)
                        wdone();
                fprintf(stderr, "%s: ", progname);
                vfprintf(stderr, s, args);
                fprintf(stderr, "\n");
                if (f != 0)
                        exit(f);
        }
        else { /* use dialog box */
                char buf[256];
                vsprintf(buf, s, args);
                wmessage(buf);
        }
        va_end(args);
}

#else

#ifdef HAVE_VARARGS_H

#include <varargs.h>
void error (va_alist)
  va_dcl
{       va_list args;
        int f;
        char* s;

        va_start(args);
        f = va_arg(args,int);
        s = va_arg(args,char*);
        if (f != WARNING || !windowarn) { /* Use stderr */
                if (f != 0)
                        wdone();
                fprintf(stderr, "%s: ", progname);
                vfprintf(stderr, s, args);
                fprintf(stderr, "\n");
                if (f != 0)
                        exit(f);
        }
        else { /* use dialog box */
                char buf[256];
                vsprintf(buf, s, args);
                wmessage(buf);
        }
        va_end(args);
}

#else /* neither stdargs nor varargs */

void error(f, s, a1, a2, a3, a4, a5, a6, a7)
        int f;
        char *s;
{
        if (f != WARNING || !windowarn) { /* Use stderr */
                if (f != 0)
                        wdone();
                fprintf(stderr, "%s: ", progname);
                fprintf(stderr, s, a1, a2, a3, a4, a5, a6, a7);
                fprintf(stderr, "\n");
                if (f != 0)
                        exit(f);
        }
        else { /* use dialog box */
                char buf[256];
                sprintf(buf, s, a1, a2, a3, a4, a5, a6, a7);
                wmessage(buf);
        }
}

#endif /* HAVE_VARARGS_H */

#endif /* HAVE_STDARG_H */
