/* GCC Library
 * Jrg Hhle, 21-Nov-92
 */

#include "defs.h"
#include <exec/ports.h>
#include <libraries/dos.h>
#ifdef __GNUC__
  #include <inline/exec.h>
  #include <inline/dos.h>
#else
  #include <clib/exec.h>
  #include <clib/dos.h>
#endif

volatile void _exit(LONG);

BOOL _Close_Input = FALSE;
BOOL _Close_Output = FALSE;
BPTR _WBOrigDir = NULL;

volatile void exit(int code)
{
  /* we could zero all handles we free, _WBCurrentDir, In/Output_handle ... */
  if (NULL != DOSBase)
    {
      debug_asciz_out("In exit()");
      if (WBenchMsg != NULL)
	{ /* _WBOrigDir may have been NULL, so don't test this */
	  debug_asciz_out("Unlocking WBDir");
	  UnLock(CurrentDir(_WBOrigDir));
	}
      if (_Close_Input && NULL != Input_handle)
	{
	  debug_asciz_out("Closing Input");
	  Close(Input_handle);
	}
      if (_Close_Output && NULL != Output_handle)
	{
	  debug_asciz_out("Closing Output");
	  Close(Output_handle);
	}
      CloseLibrary(DOSBase);
      DOSBase = NULL;
    }
  if (WBenchMsg != NULL) /* WB startup */
    {
      Forbid();
      ReplyMsg((struct Message *)WBenchMsg);
    }
  _exit(code);
}
