/****************************************************************************/
/*                                                                          */
/*                         GNAT COMPILER COMPONENTS                         */
/*                                                                          */
/*                                  L D                                     */
/*                                                                          */
/*                          C Implementation File                           */
/*                                                                          */
/*                             $Revision: 1.2 $                             */
/*                                                                          */
/*                Copyright (c) 1994 NYU, All Rights Reserved               */
/*                                                                          */
/* GNAT is free software;  you can  redistribute it  and/or modify it under */
/* terms of the  GNU General Public License as published  by the Free Soft- */
/* ware  Foundation;  either version 2,  or (at your option) any later ver- */
/* sion.  GNAT is distributed in the hope that it will be useful, but WITH- */
/* OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY */
/* or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License */
/* for  more details.  You should have  received  a copy of the GNU General */
/* Public License  distributed with GNAT;  see file COPYING.  If not, write */
/* to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */
/*                                                                          */
/****************************************************************************/

/* The raison d'etre of this program is to get around the command line length
   limitation of the OS/2 linker (link386.exe).  This program basically echoes
   its arguments to a response file and invokes the linker using this response
   file.  */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <process.h>

char *program_name;

FILE *response_file;
int  logical_lines_written;

struct name_list {
  char *library_name;
  struct name_list *next;
} **ptr_first_library_name, *last_library_name;

int  link_arg_max = -1;
char **link_args = NULL;
int  link_arg_index = -1;

static void
addarg (char *str)
{
  int i;

  if (++link_arg_index >= link_arg_max)
  {
    char **new_link_args
      = (char **) calloc (link_arg_max + 1000, sizeof (char *));
    for (i = 0; i <= link_arg_max; i++)
      new_link_args [i] = link_args [i];
    if (link_args) free (link_args);
    link_arg_max += 1000;
    link_args = new_link_args;
  }

  link_args [link_arg_index] = str;
}

static void
add_library_name (char *name)
{
  if (strlen (name) == 0)
  {
    fprintf (stderr, "%s: Library name missing!\n", program_name);
    exit (1);
  }
  last_library_name->next
      = (struct name_list *) malloc (sizeof (struct name_list));
  if ((last_library_name = last_library_name->next) == NULL)
  {
    perror ("Out of memory");
    exit (1);
  }
  last_library_name->library_name = name;
  last_library_name->next = NULL;
}

/* Return a nonzero value if the name of at least one library was written.  */
static int
end_logical_line ()
{
  struct name_list *p;
  fputc ('\n', response_file);
  if (++logical_lines_written == 3 && *ptr_first_library_name != NULL)
  {
    fprintf (response_file, "%s", (*ptr_first_library_name)->library_name);
    for (p = (*ptr_first_library_name)->next; p != NULL; p = p->next)
      fprintf (response_file, " +\n%s", p->library_name);
    return 1;
  }
  else return 0;
}

main (int argc, char *argv [])
{
  int arg_ends_in_comma, last_arg_ended_in_comma;
  int exit_code = 0;
  char *link386 = "link386";
  char *link_arg;
  char *filename;
  int i;

  program_name = *argv;

  if ((filename = tmpnam (NULL)) == NULL)
  {
    perror (
      "Unable to create a suitable name to use for the linker response file");
    exit (1);
  }

  if ((response_file = fopen (filename, "w")) == NULL)
  {
    perror ("Unable to create the linker response file");
    exit (1);
  }

  if ((last_library_name
          = (struct name_list *) malloc (sizeof (struct name_list))) == NULL)
  {
    perror ("Out of memory");
    exit (1);
  }
  ptr_first_library_name = &last_library_name->next;
  last_library_name->next = NULL;
  last_arg_ended_in_comma = logical_lines_written = 0;

  /* Write the arguments to the linker response file.  */
  for (i = 1; i < argc; i++)
  {
    ++argv;
    if (arg_ends_in_comma = (*argv) [strlen (*argv) - 1] == ',')
      /* Remove the trailing comma.  */
      (*argv) [strlen (*argv) - 1] = '\0';
    if ((*argv) [0] == '-' && (*argv) [1] == 'l')
    {
      add_library_name (*argv + 2);
      /* Point to the end of the argument to avoid further processing of this
         argument.  */
      *argv = *argv + strlen (*argv);
    }
    if (strlen (*argv) == 0)
    {
      if (arg_ends_in_comma && last_arg_ended_in_comma)
        end_logical_line ();
    }
    else if (i == 1 || (*argv) [0] == ';' && (*argv) [1] == '\0')
    {
      if (last_arg_ended_in_comma)
        end_logical_line ();
      fprintf (response_file, "%s", *argv);
    }
    else if (last_arg_ended_in_comma)
    {
      if (end_logical_line ())
        fprintf (response_file, " +\n%s", *argv);
      else fprintf (response_file, "%s", *argv);
    }
    else
      fprintf (response_file, " +\n%s", *argv);
    last_arg_ended_in_comma = arg_ends_in_comma;
  }
  fprintf (response_file, "\n");

  if (fclose (response_file))
  {
    perror ("Unable to close the linker response file");
    exit (1);
  }

  addarg (link386);
  if ((link_arg = malloc (strlen (filename) + 2)) == NULL)
  {
    perror ("Out of memory");
    exit (1);
  }
  strcpy (link_arg, "@");
  addarg (strcat (link_arg, filename));
  addarg (NULL);

  if (spawnvp (P_WAIT, link386, link_args) != 0)
  {
    fprintf (stderr, "Error executing %s\n", link_args[0]);
    exit_code = 1;
  }

  if (remove (filename))
  {
    perror ("Unable to delete the linker response file");
    exit (1);
  }

  exit (exit_code);

}

#if 0
----------------------
-- REVISION HISTORY --
----------------------

----------------------------
revision 1.1
date: Fri Feb 18 02:52:48 1994;  author: figueroa
Initial revision
----------------------------
revision 1.2
date: Sat Jul  9 23:26:53 1994;  author: figueroa
Handle the -l switch
----------------------------
** New changes after this line and before endif. **
#endif
