/****************************************************************************/
/*                                                                          */
/*                         GNAT COMPILER COMPONENTS                         */
/*                                                                          */
/*                                  A S                                     */
/*                                                                          */
/*                          C Implementation File                           */
/*                                                                          */
/*                             $Revision: 1.1 $                             */
/*                                                                          */
/*                Copyright (c) 1994 NYU, All Rights Reserved               */
/*                                                                          */
/* GNAT is free software;  you can  redistribute it  and/or modify it under */
/* terms of the  GNU General Public License as published  by the Free Soft- */
/* ware  Foundation;  either version 2,  or (at your option) any later ver- */
/* sion.  GNAT is distributed in the hope that it will be useful, but WITH- */
/* OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY */
/* or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License */
/* for  more details.  You should have  received  a copy of the GNU General */
/* Public License  distributed with GNAT;  see file COPYING.  If not, write */
/* to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */
/*                                                                          */
/****************************************************************************/

/* This program is for use under OS/2.  It invokes the GNU assembler
   and the .o-to-.obj converter.  All arguments, except for the -o switch
   and the argument after that, are passed to the assembler.  */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <process.h>

int  arg_max = -1;
char **args = NULL;
int  arg_index = -1;

static void
addarg (char *str)
{
  int i;

  if (++arg_index >= arg_max)
  {
    char **new_args
      = (char **) calloc (arg_max + 1000, sizeof (char *));
    for (i = 0; i <= arg_max; i++)
      new_args [i] = args [i];
    if (args) free (args);
    arg_max += 1000;
    args = new_args;
  }

  args [arg_index] = str;
}

main (int argc, char *argv [])
{
  char *command_name, *program_name = *argv;
  char *o_filename, *obj_filename = NULL;
  int i, exit_code = 0;

  if ((o_filename = tmpnam (NULL)) == NULL)
  {
    perror (
      "Unable to create a suitable file name to use for the assembler output");
    exit (1);
  }

  arg_index = -1;
  command_name = "gas386";
  addarg (command_name);
  addarg ("-o");
  addarg (o_filename);

  for (i = 1; i < argc; i++)
  {
    ++argv;
    if (!strcmp (*argv, "-o"))
      if (++i < argc)
        obj_filename = *(++argv);
      else
      {
        fprintf (stderr, "%s: missing output file name\n", program_name);
        exit (1);
      }
    else
      addarg (*argv);
  }
  addarg (NULL);

  if (spawnvp (P_WAIT, command_name, args) != 0)
  {
    fprintf (stderr, "%s: error executing %s\n", program_name, args[0]);
    if (remove (o_filename))
      perror ("Unable to delete the .o file");
    exit (1);
  }

  arg_index = -1;
  command_name = "o2obj";
  addarg (command_name);
  if (obj_filename != NULL)
  {
    addarg ("-o");
    addarg (obj_filename);
  }
  addarg (o_filename);
  addarg (NULL);

  if (spawnvp (P_WAIT, command_name, args) != 0)
  {
    fprintf (stderr, "%s: error executing %s\n", program_name, args[0]);
    exit_code = 1;
  }

  if (remove (o_filename))
    perror ("Unable to delete the .o file");

  exit (exit_code);

}

#if 0
----------------------
-- REVISION HISTORY --
----------------------

----------------------------
revision 1.1
date: Wed Jul 27 00:55:18 1994;  author: figueroa
Initial revision
----------------------------
** New changes after this line and before endif. **
#endif
