#include	<pwd.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<sys/stat.h>

#if	defined(sun)
#include	<maillock.h>
#endif

char    mailbox[BUFSIZ];
struct stat st;
struct passwd *pw;
uid_t   uid;

main ()
{
    uid = getuid ();

    if ((pw = getpwuid (uid)) == NULL)
      {
	  (void) fprintf (stderr, "Who are you?\n");
	  exit (1);
      }

    (void) strcpy (mailbox, MAILDIR);
    (void) strcat (mailbox, pw -> pw_name);
    (void) stat (mailbox, &st);

    if (!OverMailLimit (getuid (), st.st_size))
	exit (0);

    printf ("\n** WARNING: system mailbox %s is over quota (%d bytes). **\n",
	    mailbox, st.st_size);
    printf ("** Until YOU make it less then %d bytes, you will receive NO MORE MAIL. **\n\n", MailLimit () + 1);

    exit (0);
}
