*** rmail/rmail.c
--- /tmp/getb7496	Sun Apr  7 16:46:31 1991
***************
*** 1,3 ****
--- 1,4 ----
+ /*	%W%	%G%	%U%	*/
  /*
   * Copyright (c) 1981, 1988 The Regents of the University of California.
   * All rights reserved.
***************
*** 21,32 ****
  char copyright[] =
  "@(#) Copyright (c) 1981, 1988 The Regents of the University of California.\n\
   All rights reserved.\n";
  #endif /* not lint */
  
  #ifndef lint
! static char sccsid[] = "@(#)rmail.c	4.15 (Berkeley) 5/31/90";
  #endif /* not lint */
  
  /*
   * RMAIL -- UUCP mail server.
   *
--- 22,49 ----
  char copyright[] =
  "@(#) Copyright (c) 1981, 1988 The Regents of the University of California.\n\
   All rights reserved.\n";
+ #ifdef	__GNUC__
+ 	static	char	compiled[] = "@(#)compiled by gcc "__VERSION__;
+ #endif
  #endif /* not lint */
  
  #ifndef lint
! static char sccsid[] = "@(#)rmail.c	4.15 (Berkeley) 5/31/90	%I% local";
  #endif /* not lint */
  
+ #ifndef	BSD
+ #define	index	strchr
+ #define	rindex	strrchr
+ #include	<unistd.h>
+ #include	<memory.h>
+ char	*calloc();	/* should be in malloc.h */
+ #include	<string.h>
+ #endif
+ 
+ #ifndef	HAVE_STRDUP
+ char	*strdup();
+ #endif
+ 
  /*
   * RMAIL -- UUCP mail server.
   *
***************
*** 41,46 ****
--- 58,64 ----
  #include <sys/stat.h>
  #include <stdio.h>
  #include <paths.h>
+ #include	<malloc.h>
  
  typedef char bool;
  #define TRUE	1
***************
*** 48,74 ****
  
  extern char *index();
  extern char *rindex();
  
  char *Domain = "UUCP";		/* Default "Domain" */
  
! main(argc, argv)
  	int argc;
  	char **argv;
  {
! 	char lbuf[1024];	/* one line of the message */
! 	char from[512];		/* accumulated path of sender */
! 	char ufrom[512];	/* user on remote system */
! 	char sys[512];		/* a system in path */
! 	char fsys[512];		/* first system in path */
! 	char junk[1024];	/* scratchpad */
! 	char *args[100];	/* arguments to mailer command */
  	register char *cp;
  	register char *uf = NULL;	/* ptr into ufrom */
  	int i;
- 	long position;
  	struct stat sbuf;
  #ifdef DEBUG
! 	bool Debug;
  
  	if (argc > 1 && strcmp(argv[1], "-T") == 0) {
  		Debug = TRUE;
--- 66,111 ----
  
  extern char *index();
  extern char *rindex();
+ extern	void	exit();
+ extern	int	close();
+ extern	int	dup2();
+ extern	int	execl();
+ extern	int	execv();
+ extern	int	fclose();
+ extern	int	fork();
+ extern	int	fprintf();
+ extern	int	fputs();
+ extern	int	fstat();
+ extern	int	pipe();
+ extern	int	printf();
+ extern	int	sscanf();
+ extern	int	sprintf();
+ extern	void	rewind();
+ extern	unsigned	sleep();
+ 
+ char	*xmalloc();
+ char	*xrealloc();
+ char	*xcalloc();
  
  char *Domain = "UUCP";		/* Default "Domain" */
  
! int	main(argc, argv)
  	int argc;
  	char **argv;
  {
! 	char *lbuf;	/* one line of the message */
! 	char *from;		/* accumulated path of sender */
! 	char *ufrom;	/* user on remote system */
! 	char *sys;		/* a system in path */
! 	char *fsys = NULL;		/* first system in path */
! 	char **args;	/* arguments to mailer command */
! 	char	*from_lines;	/* beginning of message */
  	register char *cp;
  	register char *uf = NULL;	/* ptr into ufrom */
  	int i;
  	struct stat sbuf;
  #ifdef DEBUG
! 	bool Debug = FALSE;
  
  	if (argc > 1 && strcmp(argv[1], "-T") == 0) {
  		Debug = TRUE;
***************
*** 77,116 ****
  	}
  #endif
  
  	if (argc < 2) {
  		fprintf(stderr, "Usage: rmail user ...\n");
  		exit(EX_USAGE);
  	}
! 	if (argc > 2 && strncmp(argv[1], "-D", 2) == 0) {
! 		Domain = &argv[1][2];
! 		argc -= 2;
! 		argv += 2;
! 	}
! 	from[0] = '\0';
! 	fsys[0] = '\0';
! 	(void) strcpy(ufrom, _PATH_DEVNULL);
! 
! 	for (position = 0;; position = ftell(stdin)) {
! 		if (fgets(lbuf, sizeof lbuf, stdin) == NULL)
! 			exit(EX_DATAERR);
  		if (strncmp(lbuf, "From ", 5) != 0 &&
  		    strncmp(lbuf, ">From ", 6) != 0)
  			break;
! 		(void) sscanf(lbuf, "%s %s", junk, ufrom);
! 		cp = lbuf;
  		uf = ufrom;
! 		for (;;) {
! 			cp = index(cp + 1, 'r');
! 			if (cp == NULL) {
  				register char *p = rindex(uf, '!');
  
! 				if (p != NULL) {
! 					*p = '\0';
! 					(void) strcpy(sys, uf);
! 					uf = p + 1;
  					break;
  				}
- 				(void) strcpy(sys, "");
  				break;	/* no "remote from" found */
  			}
  #ifdef DEBUG
--- 114,191 ----
  	}
  #endif
  
+ 	if (argc > 1 && strncmp(argv[1], "-D", 2) == 0) {
+ 		Domain = &argv[1][2];
+ 		argc--;
+ 		argv++;
+ 	}
  	if (argc < 2) {
  		fprintf(stderr, "Usage: rmail user ...\n");
  		exit(EX_USAGE);
  	}
! 	lbuf = (char *)xcalloc(BUFSIZ+1, sizeof(char));
! 	from = (char *)xcalloc(1, sizeof(char));
! 	from_lines = (char *)xcalloc(1, sizeof(char));
! 	sys = (char *)xcalloc(1, sizeof(char));
! 	ufrom = strdup(_PATH_DEVNULL);
! 
! 	/* read lines starting from the beginning until all the From lines are exhausted */
! 
! 	for (;;) {
! 		lbuf = (char *)xrealloc(lbuf, BUFSIZ+1);
! 		(void) memset(lbuf, '\0', BUFSIZ+1);
! 		(void) fgets(lbuf, BUFSIZ, stdin);
! 		lbuf = (char *)xrealloc(lbuf, strlen(lbuf)+1);
! 		from_lines = (char *)xrealloc(from_lines, strlen(from_lines)+strlen(lbuf)+1);
! 		strcat(from_lines, lbuf);	/* save what has already been read */
  		if (strncmp(lbuf, "From ", 5) != 0 &&
  		    strncmp(lbuf, ">From ", 6) != 0)
  			break;
! 
! #ifdef DEBUG
! 		if (Debug) /* replace the newline with a nul for pretty printing */
! 			if (cp = rindex(lbuf, '\n'))
! 				*cp = '\0';
! #endif
! 
! 		/* put "prev-path" from "From prev-path" in ufrom */
! 
! 		ufrom = (char *)xrealloc(ufrom, strlen(lbuf)-4);
! 		(void) sscanf(lbuf, "%*s %s", ufrom);
! 		ufrom = (char *)xrealloc(ufrom, strlen(ufrom)+1);
! 
! 		/* put the path in ! form if it has '@'s or '%'s */
! 		/* NB: this doesn't handle RFC822 source routing, deprecated by RFC1123 */
! 		/*		It does handle mixed !,%,@ syntax */
! 		/* first replace all '%'s with '@'s */
! 		for(cp = ufrom; *cp ; cp++)
! 			if (*cp == '%')
! 				*cp = '@';
! 		/* then move all domains to the front as a bang path, recursively */
  		uf = ufrom;
! 		while (cp = rindex(uf, '@')) {
! 			uf = (char *)xcalloc(strlen(uf)+1, sizeof(char));	/* same size */
! 			*cp++ = '\0';	/* cp points to domain; ufrom terminated */
! 			(void) sprintf(uf, "%s!%s", cp, ufrom);	/* uf now fixed */
! 			free(ufrom);	/* discard old data */
! 			ufrom = uf;	/* replace old form with new */
! 		}
! 		/* done; ufrom=uf points to the path */
! 
! 		cp = lbuf+4;	/* start near end of "From " */
! 		/* NB: cp points into lbuf; uf into ufrom -- they are distinct strings */
! 
! 		for (;;) {	/* look for "remote from" */
! 			if ((cp = index(++cp, 'r')) == (char *)NULL) { /* no 'r', no "remote from ..." */
  				register char *p = rindex(uf, '!');
  
! 				if (p != NULL) {	/* last '!' */
! 					*p = '\0';	/* terminate path before user */
! 					sys = (char *)xrealloc(sys, strlen(uf)+1);
! 					(void) strcpy(sys, uf);	/* sys holds leading part of path */
! 					uf = p + 1;	/* uf points to user */
  					break;
  				}
  				break;	/* no "remote from" found */
  			}
  #ifdef DEBUG
***************
*** 117,145 ****
  			if (Debug)
  				printf("cp='%s'\n", cp);
  #endif
  			if (strncmp(cp, "remote from ", 12) == 0)
! 				break;
  		}
! 		if (cp != NULL)
  			(void) sscanf(cp, "remote from %s", sys);
! 		if (fsys[0] == '\0')
! 			(void) strcpy(fsys, sys);
! 		if (sys[0]) {
  			(void) strcat(from, sys);
  			(void) strcat(from, "!");
  		}
  #ifdef DEBUG
  		if (Debug)
! 			printf("ufrom='%s', sys='%s', from now '%s'\n", uf, sys, from);
  #endif
! 	}
  	if (uf == NULL) {	/* No From line was provided */
  		fprintf(stderr, "No From line in rmail\n");
! 		exit(EX_DATAERR);
  	}
  	(void) strcat(from, uf);
  	(void) fstat(0, &sbuf);
! 	(void) lseek(0, position, L_SET);
  
  	/*
  	 * Now we rebuild the argument list and chain to sendmail. Note that
--- 192,241 ----
  			if (Debug)
  				printf("cp='%s'\n", cp);
  #endif
+ 			/* check to see if the 'r' starts "remote from " */
+ 
  			if (strncmp(cp, "remote from ", 12) == 0)
! 				break; /* we found it. we're outta here. */
  		}
! 
! 		/* if cp is non-NULL it points to "remote from ..." */
! 
! 		if (cp != NULL) {
! 			sys = (char *)xrealloc(sys, strlen(cp)-11);
  			(void) sscanf(cp, "remote from %s", sys);
! 			if (fsys == NULL)
! 				fsys = strdup(sys);	/* sys and fsys hold remote system name */
! 		}
! 		if (*sys) {	/* write remote system name followed by '!' (first hop in return path) */
! 			from = (char *)xrealloc(from, strlen(sys)+strlen(from)+2);
  			(void) strcat(from, sys);
  			(void) strcat(from, "!");
  		}
  #ifdef DEBUG
  		if (Debug)
! 			printf("ufrom='%s', uf='%s', sys='%s', from now '%s'\n", ufrom, uf, sys, from);
  #endif
! 	}	/* no more "From " lines */
! 	free(sys);
! 
! 	/* from holds the concatenation of the "remote from ..." parts, '!' separated, ends with '!' */
! 	/* fsys holds the system name from the FIRST "From ... remote from ..." line */
! 	/*		That's the first hop of the return path */
! 	/* uf points to the user name from the LAST "From " line */
! 
  	if (uf == NULL) {	/* No From line was provided */
  		fprintf(stderr, "No From line in rmail\n");
! 		/*	exit(EX_DATAERR);	*/
  	}
+ 	from = (char *)xrealloc(from, strlen(uf)+strlen(from)+1);
  	(void) strcat(from, uf);
+ #ifdef DEBUG
+ 	if (Debug)
+ 		printf("uf='%s', from now '%s'\n", uf, from);
+ #endif
+ 
  	(void) fstat(0, &sbuf);
! 	free(ufrom);
  
  	/*
  	 * Now we rebuild the argument list and chain to sendmail. Note that
***************
*** 146,174 ****
  	 * the above lseek might fail on irregular files, but we check for
  	 * that case below. 
  	 */
  	i = 0;
! 	args[i++] = _PATH_SENDMAIL;
  	args[i++] = "-oee";		/* no errors, just status */
! 	args[i++] = "-odq";		/* queue it, don't try to deliver */
  	args[i++] = "-oi";		/* ignore '.' on a line by itself */
! 	if (fsys[0] != '\0') {		/* set sender's host name */
! 		static char junk2[512];
! 
  		if (index(fsys, '.') == NULL) {
  			(void) strcat(fsys, ".");
  			(void) strcat(fsys, Domain);
  		}
! 		(void) sprintf(junk2, "-oMs%s", fsys);
! 		args[i++] = junk2;
  	}
- 					/* set protocol used */
- 	(void) sprintf(junk, "-oMr%s", Domain);
- 	args[i++] = junk;
  	if (from[0] != '\0') {		/* set name of ``from'' person */
! 		static char junk2[512];
! 
! 		(void) sprintf(junk2, "-f%s", from);
! 		args[i++] = junk2;
  	}
  	for (; *++argv != NULL; i++) {
  		/*
--- 242,269 ----
  	 * the above lseek might fail on irregular files, but we check for
  	 * that case below. 
  	 */
+ 	args = (char **)xcalloc(6, sizeof(char *)); /* start with mailer, flags */
  	i = 0;
! 	args[i++] = strrchr(_PATH_SENDMAIL, '/')+1;
  	args[i++] = "-oee";		/* no errors, just status */
! 	args[i++] = "-odb";		/* deliver in background */
  	args[i++] = "-oi";		/* ignore '.' on a line by itself */
! 	args[i++] = "-oMrUUCP";		/* set protocol used */
! 	if (fsys) {		/* set sender's host name */
  		if (index(fsys, '.') == NULL) {
+ 			fsys = (char *) xrealloc(fsys, strlen(fsys)+strlen(Domain)+2);
  			(void) strcat(fsys, ".");
  			(void) strcat(fsys, Domain);
  		}
! 		args[i] = (char *)xcalloc(5+strlen(fsys), sizeof(char));
! 		(void) sprintf(args[i++], "-oMs%s", fsys);
! 		free(fsys);
  	}
  	if (from[0] != '\0') {		/* set name of ``from'' person */
! 		args = (char **)xrealloc((char *)args, (i+1)*sizeof(char *));
! 		args[i] = (char *)xcalloc(strlen(from)+3, sizeof(char));
! 		(void) sprintf(args[i++], "-f%s", from);
! 		free(from);
  	}
  	for (; *++argv != NULL; i++) {
  		/*
***************
*** 177,185 ****
  		 * should be fixed in sendmail by using getopt(3), and
  		 * just passing "--" before regular args.
  		 */
! 		if (**argv != '-')
  			args[i] = *argv;
  	}
  	args[i] = NULL;
  #ifdef DEBUG
  	if (Debug) {
--- 272,283 ----
  		 * should be fixed in sendmail by using getopt(3), and
  		 * just passing "--" before regular args.
  		 */
! 		if (**argv != '-') {
! 			args = (char **)xrealloc((char *)args, (i+1)*sizeof(char *));
  			args[i] = *argv;
+ 		}
  	}
+ 	args = (char **)xrealloc((char *)args, (i+1)*sizeof(char *));
  	args[i] = NULL;
  #ifdef DEBUG
  	if (Debug) {
***************
*** 202,220 ****
  #endif
  		if (pipe(pipefd) < 0)
  			exit(EX_OSERR);
! 		if (fork() == 0) {
  			/*
  			 * Child: send the message down the pipe. 
  			 */
  			FILE *out;
  
  			out = fdopen(pipefd[1], "w");
  			close(pipefd[0]);
! 			fputs(lbuf, out);
  			while (fgets(lbuf, sizeof lbuf, stdin))
  				fputs(lbuf, out);
  			(void) fclose(out);
  			exit(EX_OK);
  		}
  		/*
  		 * Parent: call sendmail with pipe as standard input 
--- 300,329 ----
  #endif
  		if (pipe(pipefd) < 0)
  			exit(EX_OSERR);
! 		switch (fork()) {
! 		case -1:
! 			exit(EX_OSERR);
! 		/*NOTREACHED*/
! 		case 0:
  			/*
  			 * Child: send the message down the pipe. 
  			 */
+ 			{
  			FILE *out;
  
  			out = fdopen(pipefd[1], "w");
  			close(pipefd[0]);
! 			fputs(from_lines, out);
! 			lbuf = (char *)xrealloc(lbuf, BUFSIZ+1);
  			while (fgets(lbuf, sizeof lbuf, stdin))
  				fputs(lbuf, out);
  			(void) fclose(out);
  			exit(EX_OK);
+ 			}
+ 		/*NOTREACHED*/
+ 		default:
+ 			/*parent*/
+ 		break;
  		}
  		/*
  		 * Parent: call sendmail with pipe as standard input 
***************
*** 221,228 ****
  		 */
  		close(pipefd[1]);
  		dup2(pipefd[0], 0);
! 	}
  	execv(_PATH_SENDMAIL, args);
  	fprintf(stderr, "Exec of %s failed!\n", _PATH_SENDMAIL);
! 	exit(EX_OSERR);
  }
--- 330,406 ----
  		 */
  		close(pipefd[1]);
  		dup2(pipefd[0], 0);
! 	} else
! 		rewind(stdin);
! #ifdef DEBUG
! 	if (Debug)
! 		execl("/bin/cat", "cat", "-", (char *)NULL);
! 	else
! #endif
  	execv(_PATH_SENDMAIL, args);
  	fprintf(stderr, "Exec of %s failed!\n", _PATH_SENDMAIL);
! 	return(EX_OSERR);
! }
! 
! #ifndef	HAVE_STRDUP
! char	*strdup(s)
! char	*s;
! {
! 	char	*dup;
! 
! 	dup = (char *)xmalloc(strlen(s)+1);
! 	if (dup) {
! 		strcpy(dup, s);
! 	}
! 	return(dup);
! }
! #endif
! 
! #define	RETRIES	5
! #define	WAIT_TIME	5
! 
! char	*xmalloc(size)
! unsigned	size;
! {
! 	register	char	*ret;
! 	register	int	i = 0;
! 
! 	while ((ret = (char *)malloc(size)) == (char *)NULL)
! 		if (i++ > RETRIES) {
! 			fprintf(stderr, "rmail: no memory\n");
! 			exit(EX_OSERR);
! 		} else
! 			sleep(WAIT_TIME);
! 	return(ret);
! }
! 
! char	*xrealloc(cp, size)
! char	*cp;
! unsigned	size;
! {
! 	register	char	*ret;
! 	register	int	i = 0;
! 
! 	while ((ret = (char *)realloc(cp, size)) == (char *)NULL)
! 		if (i++ > RETRIES) {
! 			fprintf(stderr, "rmail: no memory\n");
! 			exit(EX_OSERR);
! 		} else
! 			sleep(WAIT_TIME);
! 	return(ret);
! }
! 
! char	*xcalloc(nelem, elsize)
! unsigned	nelem,	elsize;
! {
! 	register	char	*ret;
! 	register	int	i = 0;
! 
! 	while ((ret = (char *)calloc(nelem, elsize)) == (char *)NULL)
! 		if (i++ > RETRIES) {
! 			fprintf(stderr, "rmail: no memory\n");
! 			exit(EX_OSERR);
! 		} else
! 			sleep(WAIT_TIME);
! 	return(ret);
  }
*** mailstats/Makefile.3b1
--- mailstats/Makefile.3b1
***************
*** 0 ****
--- 1,17 ----
+ #	@(#)Makefile	5.1 (Berkeley) 5/11/90
+ 
+ all: mailstats
+ 
+ include	/u/bruce/Makefile
+ 
+ CC = gcc
+ CFLAGS= -g -O -I/usr/local/lib/gcc-include -I/usr/ethernet/include -I../src -I../support -DSYSTEM5 -DLIBC_SCCS -DSCANF -fcombine-regs -fstrength-reduce -fpcc-struct-return -Wall
+ 
+ PROG=	mailstats
+ 
+ LDFLAGS = -s
+ 
+ mailstats.o: pathnames.h ../src/mailstats.h
+ 
+ mailstats: mailstats.o
+ 	$(LD) $(LDFLAGS) -o mailstats /lib/crt0s.o mailstats.o /lib/shlib.ifile
*** mailstats/mailstats.c
--- mailstats/mailstats.c
***************
*** 1,3 ****
--- 1,4 ----
+ /*	%W%	%G%	%U%	*/
  /*
   * Copyright (c) 1983 Eric P. Allman
   * Copyright (c) 1988 Regents of the University of California.
***************
*** 26,32 ****
  #endif /* not lint */
  
  #ifndef lint
! static char sccsid[] = "@(#)mailstats.c	5.7 (Berkeley) 6/1/90";
  #endif /* not lint */
  
  #include <sys/file.h>
--- 27,36 ----
  #endif /* not lint */
  
  #ifndef lint
! static char sccsid[] = "@(#)mailstats.c	5.7 (Berkeley) 6/1/90	%I% local";
! #ifdef	__GNUC__
! static	char	compiled[] = "%Z%compiled by gcc version "__VERSION__;
! #endif
  #endif /* not lint */
  
  #include <sys/file.h>
***************
*** 34,39 ****
--- 38,44 ----
  #include <mailstats.h>
  #include "pathnames.h"
  
+ int
  main(argc, argv)
  	int argc;
  	char **argv;
***************
*** 74,81 ****
  	printf(" M msgsfr bytes_from  msgsto   bytes_to\n");
  	for (i = 0; i < MAXMAILERS; i++)
  		if (stat.stat_nf[i] || stat.stat_nt[i])
! 			printf("%2d %6ld %10ldK %6ld %10ldK\n", i,
  			    stat.stat_nf[i], stat.stat_bf[i],
  			    stat.stat_nt[i], stat.stat_bt[i]);
! 	exit(0);
  }
--- 79,86 ----
  	printf(" M msgsfr bytes_from  msgsto   bytes_to\n");
  	for (i = 0; i < MAXMAILERS; i++)
  		if (stat.stat_nf[i] || stat.stat_nt[i])
! 			printf("%2d %6lu %10lu  %6lu %10lu\n", i,
  			    stat.stat_nf[i], stat.stat_bf[i],
  			    stat.stat_nt[i], stat.stat_bt[i]);
! 	return(0);
  }
