/*
 *  These are defined to enable their inclsion in the branch table
 *  defined below.
 *
 *  Hacked by Eric Youngdale for iBCS (1993, 1994).
 *
 * $Id: abi4.h,v 1.2 1994/02/28 09:15:26 mike Exp $
 * $Source: /var/CVS/ibcs/include/ibcs/abi4.h,v $
 */

#ifdef __cplusplus
extern "C" {
#endif

typedef unsigned long ABI_dev_t;
typedef unsigned long ABI_ino_t;
typedef unsigned long ABI_mode_t;
typedef unsigned long ABI_nlink_t;
typedef long ABI_uid_t;
typedef long ABI_off_t;
typedef struct timeval ABI_timestruc_t;

struct abi_sigaction {
       int          sa_flags;
       __sighandler_t sa_handler;
       sigset_t     sa_mask;
       int	    sa_resv[2];  /* Reserved for something or another */
};

extern int abi_sigprocmask(int how, sigset_t *set, sigset_t *oset);
extern int abi_sigaction(int abi_signum, const struct abi_sigaction * action,
	struct abi_sigaction * oldaction);
extern int abi_sigsuspend(struct pt_regs * regs);


/*
 * This is the general form of the stat structure in an ABI compliant system.
 */

struct	xstat {
	ABI_dev_t	st_dev;
	long	st_pad1[3];	 
	ABI_ino_t	st_ino;
	ABI_mode_t	st_mode;
	ABI_nlink_t st_nlink;
	ABI_uid_t 	st_uid;
	ABI_uid_t 	st_gid;
	ABI_dev_t	st_rdev;
	long	st_pad2[2];
	ABI_off_t	st_size;
	long	st_pad3;	 
	ABI_timestruc_t st_atim;	
	ABI_timestruc_t st_mtim;	
	ABI_timestruc_t st_ctim;	
	long	st_blksize;
	long	st_blocks;
	char	st_fstype[ 16 ] ;
	long	st_pad4[8];	 
};

extern int ibcs_xstat(int vers, char * path, struct xstat * stat4);
extern int ibcs_lxstat(int vers, char * path, struct xstat * stat4);
extern int ibcs_fxstat(int vers, int fd, struct xstat * stat4);
extern int ibcs_xmknod(int vers, const char * path, mode_t mode, dev_t dev);

#ifdef __cplusplus
}
#endif
