/* This files contains functions to convert between big endian internal
   representation and little endian external representation. */

#ifndef A_OUT_H
#define A_OUT_H    <a.out.h>
#endif
#include A_OUT_H

#include "md.h"

long
md_chars_to_number (p, nbytes)
     unsigned char *p;
     int nbytes;
{
  long value;

  for (value = 0, p += nbytes - 1; nbytes--; p--)
    value = (value << 8) | *p;
  return value;
}

void
md_number_to_chars (value, nbytes, p)
     long value;
     int nbytes;
     unsigned char *p;
{
  switch (nbytes)
    {
    case 1:
      p[0] = value & 0xff;
      break;
    case 2:
      p[0] = value & 0xff;
      p[1] = (value >> 8) & 0xff;
      break;
    case 4:
      p[0] = value & 0xff;
      p[1] = (value >> 8) & 0xff;
      p[2] = (value >> 16) & 0xff;
      p[3] = (value >> 24) & 0xff;
      break;
    default:
      abort ();
    }
}

void
md_chars_to_hdr (p, hdr)
     unsigned char *p;
     struct exec *hdr;
{
  hdr->a_info = md_chars_to_number (p, sizeof hdr->a_info);
  hdr->a_text = md_chars_to_number (p + 4, sizeof hdr->a_text);
  hdr->a_data = md_chars_to_number (p + 8, sizeof hdr->a_data);
  hdr->a_bss = md_chars_to_number (p + 12, sizeof hdr->a_bss);
  hdr->a_syms= md_chars_to_number (p + 16, sizeof hdr->a_syms);
  hdr->a_entry = md_chars_to_number (p + 20, sizeof hdr->a_entry);
  hdr->a_trsize = md_chars_to_number (p + 24, sizeof hdr->a_trsize);
  hdr->a_drsize = md_chars_to_number (p + 28, sizeof hdr->a_drsize);
}

void
md_hdr_to_chars (hdr, p)
     struct exec *hdr;
     unsigned char *p;
{
  md_number_to_chars (hdr->a_info, sizeof hdr->a_info, p);
  md_number_to_chars (hdr->a_text, sizeof hdr->a_text, p + 4);
  md_number_to_chars (hdr->a_data, sizeof hdr->a_data, p + 8);
  md_number_to_chars (hdr->a_bss, sizeof hdr->a_bss, p + 12);
  md_number_to_chars (hdr->a_syms, sizeof hdr->a_syms, p + 16);
  md_number_to_chars (hdr->a_entry, sizeof hdr->a_entry, p + 20);
  md_number_to_chars (hdr->a_trsize, sizeof hdr->a_trsize, p + 24);
  md_number_to_chars (hdr->a_drsize, sizeof hdr->a_drsize, p + 28);
}

void
md_chars_to_nlist (p, nlist, nitems)
     unsigned char *p;
     struct nlist *nlist;
     int nitems;
{
  while (nitems--)
    {
      nlist->n_un.n_strx = md_chars_to_number (p, sizeof nlist->n_un.n_strx);
      nlist->n_type = p[4];
      nlist->n_other = p[5];
      nlist->n_desc = md_chars_to_number (p + 6, sizeof nlist->n_desc);
      nlist->n_value = md_chars_to_number (p + 8, sizeof nlist->n_value);
      p += 12;
      nlist++;
    }
}

void
md_nlist_to_chars (nlist, nitems, p)
     struct nlist *nlist;
     int nitems;
     unsigned char *p;
{
  while (nitems--)
    {
      md_number_to_chars (nlist->n_un.n_strx, sizeof nlist->n_un.n_strx, p);
      p[4] = nlist->n_type;
      p[5] = nlist->n_other;
      md_number_to_chars (nlist->n_desc, sizeof nlist->n_desc, p + 6);
      md_number_to_chars (nlist->n_value, sizeof nlist->n_value, p + 8);
      nlist++;
      p += 12;
    }
}

void
md_chars_to_symdefs (p, symdefs, nitems)
     unsigned char *p;
     struct md_symdef *symdefs;
     int nitems;
{
  while (nitems--)
    {
      symdefs->stringoffset
	= md_chars_to_number (p, sizeof symdefs->stringoffset);
      symdefs->offset = md_chars_to_number (p + 4, sizeof symdefs->offset);
      p += 8;
      symdefs++;
    }
}

void
md_symdefs_to_chars (symdefs, nitems, p)
     struct md_symdef *symdefs;
     int nitems;
     unsigned char *p;
{
  while (nitems--)
    {
      md_number_to_chars (symdefs->stringoffset,
			  sizeof symdefs->stringoffset, p);
      md_number_to_chars (symdefs->offset, sizeof symdefs->offset, p + 4);
      symdefs++;
      p += 8;
    }
}

void
md_chars_to_relocs (p, relocs, nitems)
     unsigned char *p;
     struct md_reloc_info *relocs;
     int nitems;
{
  unsigned char bytes[4];

  while (nitems--)
    {
      relocs->r_address = md_chars_to_number (p, sizeof relocs->r_address);
      bytes[0] = p[4];
      bytes[1] = p[5];
      bytes[2] = p[6];
      bytes[3] = p[7];
      relocs->r_symbolnum = (bytes[2] << 16) | (bytes[1] << 8) | bytes[0];
      relocs->r_pcrel = bytes[3] & 0x01;
      relocs->r_length = (bytes[3] >> 1) & 0x03;
      relocs->r_extern = (bytes[3] >> 3) & 0x01;
      relocs->r_pad = (bytes[3] >> 4) & 0x0f;
      p += 8;
      relocs++;
    }
}

void
md_relocs_to_chars (relocs, nitems, p)
     struct md_reloc_info *relocs;
     int nitems;
     unsigned char *p;
{
  unsigned char bytes[4];

  while (nitems--)
    {
      md_number_to_chars (relocs->r_address, sizeof relocs->r_address, p);
      bytes[0] = relocs->r_symbolnum & 0xff;
      bytes[1] = (relocs->r_symbolnum >> 8) & 0xff;
      bytes[2] = (relocs->r_symbolnum >> 16) & 0xff;
      bytes[3] = (((relocs->r_pad & 0x0f) << 4)
		  | ((relocs->r_extern & 0x01) << 3)
		  | ((relocs->r_length & 0x03) << 1)
		  | (relocs->r_pcrel & 0x01));
      p[4] = bytes[0];
      p[5] = bytes[1];
      p[6] = bytes[2];
      p[7] = bytes[3];
      relocs++;
      p += 8;
    }
}

void md_vector_to_chars (vector, nitems, p)
     unsigned long *vector;
     int nitems;
     unsigned char *p;
{
  while (nitems--)
    {
      md_number_to_chars (*vector, sizeof *vector, p);
      vector++;
      p += 4;
    }
}
