
static char	rcsid[] = 
"$Header: wbuild.web,v 1.17 92/12/07 19:32:29 bert Exp $";

#include<unistd.h>
#include<stdio.h>
#include<stdlib.h>
#include<stdarg.h>
#include<string.h>
#include<assert.h>
#include"types.c"
#include"util.e"
#include"generate.e"
extern int	yyparse();



extern char	*optarg;
extern int	optind;
static char	**arguments;
static int	nrarguments;
extern char	*filename;
extern FILE *yyin;
extern int	lineno;
static int	nerrors = 0;



int	yywrap()
{
	(void)fclose(yyin);
	lineno = 1;
	if (optind < nrarguments) {
		if (arguments[optind][0] == '-' && arguments[optind][1] == '\0') {
			filename = "<stdin>";
			yyin = stdin;
			optind++;
			return 0;
		} else if (!(yyin = fopen(arguments[optind], "r"))) {
			perror(arguments[optind]);
			return 1;
		} else {
			filename = arguments[optind];
			optind++;
			return 0;
		}
	} else {
		return 1;
	}
}



#ifdef __STDC__
void err(Boolean fatal, char *format, ...)
#else

void err(fatal, format)
Boolean fatal;
char	*format;
#endif
{
	va_list ap;
	nerrors++;
	va_start(ap, format);
	(void)fprintf(stderr, "%s:%d: ", filename, lineno);
	(void)vfprintf(stderr, format, ap);
	if (fatal)
		exit(1);
}



#ifndef INITFILE
#define INITFILE"wbuild.cfg"
#endif
int	main(argc, argv)
int	argc;
char	*argv[];
{
	char	*headerdir = "X11";
	char	*implemdir = ".";
	char	*docdir = ".";
	char	*prefix = "X11";
	char	*initfile = INITFILE;
	char	*only = NULL;
	int	doctp = 0;
	Boolean lines = True;
	char	c;
	if (rcsid != rcsid)
		rcsid[0] = 'a';
	arguments = argv;
	nrarguments = argc;
	while ((c = getopt(argc, argv, "lsnh:p:c:d:i:o:")) != EOF)
		switch (c) {
		case'l':
			lines = False;
			break;
		case's':
			doctp = 1;
			break;
		case'n':
			doctp = 2;
			break;
		case'h':
			headerdir = optarg;
			break;
		case'p':
			prefix = optarg;
			break;
		case'c':
			implemdir = optarg;
			break;
		case'd':
			docdir = optarg;
			break;
		case'i':
			initfile = optarg;
			break;
		case'o':
			only = optarg;
			break;
		case'?':
			nerrors++;
		}
	if (nerrors) {
		(void)fprintf(stderr, "usage: %s [-h dir] [-p dir] [-c dir] [-d dir] [-i file] [-s|-n] [-l] [files...]\n",
		    argv[0]);
		exit(2);
	}
	if (!(yyin = fopen(initfile, "r"))) {
		perror(initfile);
		return 1;
	}
	lineno = 1;
	(void)yyparse();
	if (!nerrors) {
		set_hierarchy();
		nerrors = generate(headerdir, implemdir, docdir, prefix, doctp, lines, only);
	}
	return nerrors;
}
