#ifndef _FTAPE_RW_H
#define _FTAPE_RW_H

/*
 * Copyright (C) 1993 Bas Laarhoven.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *
 $Source: /usr/src/distr/ftape-0.9.9d/RCS/ftape-rw.h,v $
 $Author: bas $
 *
 $Revision: 1.15 $
 $Date: 1994/01/16 15:44:54 $
 $State: ALPHA $
 *
 *      This file contains the non-read/write related functions
 *      for the QIC-40/80 floppy-tape driver for Linux.
 *
 */

#include "fdc-io.h"
#include "kernel-interface.h"

#define EMPTY_SEGMENT   (0xfffffffe)

typedef struct {
  int active;
  int error;
  int offset;
} ftape_fast_start_struct;

/* This defines the number of physical retries that the driver will
 * do until it assumes a hard error and lets the ecc correct the error.
 * This only applies if there's only one error.
 */
#define RETRIES_ON_SOFT_ERROR 2

/*      ftape-rw.c defined global vars.
 */
extern buffer_struct buffer[ NR_FTAPE_BUFFERS];
extern int location_known;
extern int current_segment;
extern volatile ftape_fast_start_struct ftape_fast_start;

/*      ftape-rw.c defined global functions.
 */
extern int setup_new_segment( unsigned int head, unsigned int segment_id,
                             unsigned int offset, unsigned int count);
extern int calc_next_cluster( void);
extern int setup_fdc_and_dma( unsigned char operation);
extern void next_buffer( volatile int* x);
extern int _ftape_read( char* buff, int req_len);
extern int _ftape_write( char* buff, int req_len);
extern int ftape_read_id( int* location);
extern void ftape_tape_parameters( unsigned char drive_configuration);
extern int wait_segment( buffer_state_enum state);
extern void ftape_zap_buffers( void);
extern int ftape_flush_buffers( void);
extern int ftape_smart_stop( int* location_known, int* location);
extern int ftape_start_tape( int segment_id);

#endif /* _FTAPE_RW_H */
