.TH SPLITVT 1 "4/12/94" "SPLITVT" "NONESSENTIAL UTILITIES"

.SH NAME
splitvt - run two shells in a split window
.SH SYNOPSIS
.nf
.ft B
splitvt [options] [shell]

.SH OPTIONS
.LP
.TP
.SB -upper command
Runs 'command' in the upper window
.TP
.SB -lower command
Runs 'command' in the lower window
.TP
.SB -s numlines
Sets 'numlines' to the number of lines in the top window.  This number
will be modified if the screen isn't big enough to handle the full
size.
.SH DESCRIPTION
.LP
This program splits the screen into two windows, one above the other,
and runs a shell in each one.  The default shell is taken from the
SHELL environment variable, or /bin/csh if SHELL isn't in the
environment, but another shell can be specified on the command line.

The top window is the default current window, but you can change to
the other by pressing ^W.  Pressing ^V will quote the next character
to the current shell.  Pressing ^O will put splitvt into command mode.

These special characters (command mode, switch window, and quote next
character) can be modified from within the .splitvtrc file.

When in command mode, splitvt will read one character, perform the
requested command, and then revert to normal operations.  The
currently supported commands are:

.TP
.SB 'q'
Quickly quit splitvt, killing the running shells
.LP
More functions may be added in the future.

If the -s command line option is used, the upper window will be bound 
to the user defined number of lines even if the screen is resized.  
Otherwise, the screen will be split into two equal parts based on 
the new size of the screen.

The environment variable SPLITVT is set in the shells forked by splitvt.
In the shell running in the upper window, this variable is set to the
value "upper", while the shell running in the lower window has this
variable set to the value "lower".  This is useful in shell scripts to
provide different behavior depending on which window the script is 
running in.  An example of this is shown in the file "menu.example"
in the splitvt distribution.

When splitvt starts up, it looks in your home directory for a file named
.SB .splitvtrc  
You can set a number of parameters from within this file, including
all of the special characters, the default number of lines in the upper
window, and default commands to run in each window.
.LP
Here is an example .splitvtrc file:
.LP
.SB .splitvtrc ----------------------------------------------
.LP
# This is an example .splitvtrc file.  
.LP
set command_char        ^O
.LP
set quote_char          ^V
.LP
set switch_char         ^W
.LP
set upper_lines         12
.LP
run -upper              /bin/sh
.LP
run -lower              top
.LP
# This next line would override the above run statements
.LP
#run /bin/tcsh
.LP
---------------------------------------------------------

If programs like vi are doing strange things to the window while in
splitvt, you probably need to set the LINES environment variable to a
correct value, or set the terminal's window sizing correctly.  This
should be done automatically, but may need to be corrected.

Under certain conditions, resizing the window (assuming you are
running splitvt in a window managed by a window manager) will cause
splitvt to resize its own split windows.  This will happen under
Sun/OS, HP-UX, ULTRIX, and through rlogin, but not on Apollo DOMAIN_OS
or through telnet or a modem.

splitvt will attempt to erase the current utmp entry, and replace it
with entries for the two windows.  This allows you to use programs
such as 'talk' within the splitvt windows.  If you do not have write
permission to the /etc/utmp file, you will not be able to modify the
utmp entries.

splitvt can be made set-uid root.  splitvt will reset its user id to
that of the person running it, just before it exec()'s the shell under
the window.  The splitvt process remains with root permissions, and
will change ownership of the pseudo terminals to that of the person
running splitvt, and then reset it to root when the window is closed.
.LP
SPLITVT IS NOT GUARANTEED TO BE A SAFE SET-UID PROGRAM!
.LP
I have done all I know to keep splitvt a safely usable set-uid program, 
but I do not know everything, and am not responsible for any security 
weaknesses splitvt might posess.
.SH BUGS
When used with a certain public domain version of ksh, you have to
manually kill -9 on the shell processes after you quit splitvt.  This
has to do with a bug in that version of ksh (Version 06/03/86a and
possibly others).

There is a bug with highlighting between windows.  Don't worry, you'll
notice it if you see it.  :^)

The vt100 handling could benefit from improvement.  
.SH CAVEATS
The screen cannot be refreshed if it is messed up.  

There may be conflicts between splitvt's characters and other
programs.  You can either change splitvt's default characters with
command line options, or you can type Ctrl-V (the quote character)
within splitvt, and the next character typed will be sent to the
current window, no matter what it is.

splitvt can only be used by terminals using vt100 emulation, due to
the use of specific vt100 escape codes.  (vt300, xterm, Linux console,
etc, emulation also works)


.SH AUTHOR
Sam Lantinga 	slouken@toadflax.cs.ucdavis.edu

