/* Any copyright is dedicated to the Public Domain.
 * http://creativecommons.org/publicdomain/zero/1.0/ */

MARIONETTE_TIMEOUT = 60000;
MARIONETTE_HEAD_JS = 'head.js';

// Binary form of test certificate.
var testCertInfo = {
  nickname: 'Test Certificate',
  password: '12345678',
  usage: ['UserCert', 'ServerCert'],
  blob: [0x30, 0x82, 0x09, 0xF1, 0x02, 0x01, 0x03, 0x30,
        0x82, 0x09, 0xB7, 0x06, 0x09, 0x2A, 0x86, 0x48,
        0x86, 0xF7, 0x0D, 0x01, 0x07, 0x01, 0xA0, 0x82,
        0x09, 0xA8, 0x04, 0x82, 0x09, 0xA4, 0x30, 0x82,
        0x09, 0xA0, 0x30, 0x82, 0x06, 0x9F, 0x06, 0x09,
        0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x07,
        0x06, 0xA0, 0x82, 0x06, 0x90, 0x30, 0x82, 0x06,
        0x8C, 0x02, 0x01, 0x00, 0x30, 0x82, 0x06, 0x85,
        0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D,
        0x01, 0x07, 0x01, 0x30, 0x1C, 0x06, 0x0A, 0x2A,
        0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x0C, 0x01,
        0x06, 0x30, 0x0E, 0x04, 0x08, 0x13, 0xB5, 0x2F,
        0x5A, 0xB9, 0x49, 0xE6, 0x0B, 0x02, 0x02, 0x08,
        0x00, 0x80, 0x82, 0x06, 0x58, 0x35, 0x77, 0x6B,
        0xBF, 0x5C, 0x06, 0x09, 0xD8, 0xF0, 0x36, 0x06,
        0x69, 0x8D, 0xA2, 0x86, 0xCF, 0x6B, 0x73, 0x86,
        0x14, 0xFA, 0x51, 0x9A, 0x87, 0x73, 0x29, 0x71,
        0xC5, 0xB1, 0x4F, 0xFB, 0xEC, 0x64, 0x84, 0x20,
        0xFC, 0x06, 0x4A, 0x93, 0x74, 0x01, 0xFB, 0xEB,
        0x1F, 0xDC, 0xF8, 0xF7, 0xBB, 0xDC, 0x42, 0xA1,
        0x4A, 0x71, 0xDE, 0x08, 0x33, 0x7A, 0xCA, 0xD3,
        0xD8, 0x40, 0x24, 0x47, 0xAE, 0x41, 0x42, 0x8E,
        0xC8, 0x4E, 0xBE, 0x8B, 0xB3, 0xE5, 0x77, 0xAC,
        0xBD, 0x98, 0x0C, 0x0E, 0x53, 0xBE, 0x38, 0xB7,
        0xEA, 0xD2, 0x29, 0x35, 0xD2, 0xC4, 0xF4, 0xC7,
        0xD8, 0xB1, 0x73, 0x2A, 0x13, 0x11, 0x65, 0xF7,
        0x0C, 0x8B, 0xC0, 0x43, 0xFB, 0x31, 0x6C, 0xD2,
        0xE4, 0x43, 0x85, 0x51, 0x16, 0xBF, 0x35, 0xB5,
        0x05, 0x6B, 0x86, 0x11, 0xEA, 0x78, 0x64, 0x9F,
        0x42, 0x29, 0xB9, 0x79, 0xAF, 0xB0, 0x7C, 0xBF,
        0xC0, 0x89, 0xAD, 0xC7, 0x37, 0xD2, 0x30, 0x8C,
        0xDC, 0xF6, 0x77, 0x5E, 0x1F, 0x26, 0x28, 0x8F,
        0xAC, 0x19, 0x6C, 0xA0, 0x15, 0xC7, 0x12, 0xA3,
        0x0A, 0xD5, 0xC6, 0x15, 0x60, 0x58, 0x16, 0xB8,
        0x30, 0x12, 0x3C, 0x78, 0x3C, 0x93, 0x23, 0xA1,
        0x56, 0x75, 0x0B, 0x77, 0xAA, 0x0B, 0x0B, 0x2B,
        0x91, 0xB6, 0x41, 0xAB, 0xF5, 0x09, 0x4C, 0x1E,
        0x36, 0xC0, 0x88, 0xC3, 0x08, 0xF2, 0x65, 0xCB,
        0x58, 0x8F, 0x94, 0xB4, 0xB4, 0x05, 0xCC, 0x44,
        0x49, 0x73, 0x1B, 0x25, 0x6F, 0x5D, 0x83, 0xBD,
        0xF0, 0x70, 0xD0, 0xE8, 0x0D, 0x18, 0x2E, 0x44,
        0xD7, 0x89, 0x64, 0x6A, 0xED, 0x23, 0x30, 0xDF,
        0xAD, 0x84, 0x3B, 0x74, 0x2C, 0x0D, 0x2B, 0x51,
        0x84, 0xA2, 0xA4, 0x9E, 0x42, 0xC3, 0x81, 0x69,
        0xFA, 0x56, 0x76, 0x9F, 0xD9, 0x02, 0x64, 0x04,
        0xFE, 0xF0, 0xD9, 0x01, 0xBC, 0xE2, 0xC9, 0xDD,
        0x88, 0xAC, 0xFA, 0x24, 0x7E, 0xB1, 0xF8, 0x39,
        0x27, 0xA2, 0xEB, 0xE4, 0x53, 0xC1, 0xF3, 0xFE,
        0x2D, 0x9A, 0x49, 0x73, 0xFF, 0x7C, 0x8E, 0x39,
        0xF7, 0x15, 0x27, 0xB3, 0x47, 0x48, 0x92, 0x8C,
        0x57, 0x60, 0x9C, 0x97, 0xBA, 0x80, 0xD2, 0x25,
        0x80, 0x94, 0xCE, 0x2C, 0x0C, 0x00, 0x44, 0x8C,
        0x8C, 0x37, 0x82, 0x5D, 0x5F, 0x62, 0x8B, 0x05,
        0x6F, 0xB0, 0x07, 0x34, 0xF9, 0xC3, 0xA1, 0x34,
        0x3D, 0xE4, 0x90, 0xB0, 0x03, 0x59, 0x97, 0x6E,
        0xFB, 0xF2, 0x92, 0xE5, 0xB5, 0x30, 0x7C, 0x0D,
        0x3B, 0x8F, 0x90, 0x8E, 0x04, 0x47, 0x01, 0x0E,
        0x88, 0x50, 0x4A, 0x88, 0xA0, 0xFF, 0xB7, 0x9E,
        0x2B, 0x2C, 0x98, 0xD0, 0x3E, 0x16, 0x35, 0x5B,
        0xD5, 0xEA, 0x54, 0x86, 0xE0, 0xFB, 0x9F, 0x2F,
        0x62, 0x89, 0x36, 0x36, 0x9D, 0x6E, 0x62, 0xCB,
        0xC8, 0x6C, 0x62, 0x34, 0x8F, 0x66, 0x07, 0x62,
        0xA7, 0x00, 0x90, 0x31, 0xFA, 0x5D, 0xDD, 0x12,
        0x33, 0x69, 0xD0, 0x74, 0x0E, 0x0B, 0x42, 0x9A,
        0xF3, 0x40, 0x7E, 0x3E, 0x48, 0x1D, 0xF2, 0x5C,
        0x71, 0x0B, 0x78, 0x7E, 0xD5, 0x15, 0xA4, 0x16,
        0x1E, 0xBD, 0x71, 0x18, 0x87, 0x3A, 0xC9, 0xE3,
        0x45, 0xEE, 0x70, 0xA2, 0x4C, 0x50, 0xF5, 0x16,
        0x5C, 0xF8, 0x76, 0xE6, 0x9F, 0x8D, 0x86, 0x41,
        0x7E, 0xF8, 0x60, 0x3D, 0x75, 0x6D, 0x55, 0x96,
        0x9E, 0x43, 0x48, 0x82, 0xF7, 0xB6, 0xAC, 0x98,
        0x6F, 0x10, 0xAA, 0x20, 0x64, 0xD0, 0x7C, 0x25,
        0x24, 0xF7, 0xD8, 0xA4, 0xCC, 0x2D, 0xBF, 0x85,
        0x62, 0x6C, 0x4F, 0xFF, 0x9D, 0x71, 0x04, 0x98,
        0x61, 0xB0, 0xBC, 0x31, 0xC1, 0xE9, 0xB8, 0x29,
        0xA5, 0xEB, 0xD1, 0x1D, 0x65, 0x8E, 0xAE, 0x38,
        0x55, 0x65, 0x22, 0xC7, 0xFD, 0x7E, 0xF2, 0x6A,
        0xB6, 0xB1, 0x51, 0x37, 0x4B, 0x05, 0x8F, 0xA7,
        0x2D, 0x3F, 0x5C, 0x04, 0x2B, 0xBA, 0x2C, 0x37,
        0xCA, 0xDE, 0xD5, 0x3E, 0xA0, 0xA5, 0x86, 0x59,
        0xA7, 0xD7, 0x38, 0x07, 0xFB, 0x79, 0xF6, 0x2D,
        0xE1, 0xAA, 0x7C, 0xD1, 0x91, 0xBE, 0x39, 0xDF,
        0x53, 0x3C, 0xD1, 0x44, 0x2C, 0xF9, 0x12, 0x7D,
        0xB1, 0xCD, 0xF3, 0x35, 0x1F, 0x85, 0xA6, 0x64,
        0x2F, 0xFD, 0x28, 0xF2, 0x85, 0xA8, 0xA7, 0x1F,
        0x7F, 0xD9, 0x79, 0x30, 0x9B, 0xFC, 0x69, 0x3A,
        0x9B, 0x1F, 0x55, 0x70, 0xC9, 0x60, 0x82, 0x3D,
        0xE9, 0x5A, 0x37, 0x5F, 0x8C, 0xBD, 0x19, 0x5D,
        0xCC, 0x1C, 0xBE, 0x26, 0x4A, 0xEA, 0x8B, 0x39,
        0xCE, 0x0D, 0xBD, 0x63, 0x05, 0x98, 0x75, 0xAB,
        0x08, 0x79, 0x90, 0xC7, 0x20, 0xFF, 0xE4, 0x0D,
        0xB1, 0xA0, 0x92, 0x2B, 0x0C, 0x4B, 0x0C, 0xDC,
        0xB9, 0x72, 0x2A, 0xA4, 0xCC, 0xA6, 0x32, 0xA3,
        0x57, 0x82, 0xB4, 0xB9, 0x0F, 0x81, 0xC5, 0xD9,
        0x7C, 0xB8, 0x0F, 0x7D, 0xEA, 0x5D, 0xD3, 0xC4,
        0x2F, 0x31, 0x79, 0x11, 0xAD, 0x36, 0x56, 0x1F,
        0xFA, 0xE3, 0xCE, 0xD2, 0x29, 0x23, 0xE8, 0x2C,
        0xDF, 0x7D, 0x94, 0x28, 0x28, 0x9A, 0x0E, 0x64,
        0xFC, 0x07, 0x11, 0x96, 0x06, 0x1A, 0x39, 0xCD,
        0x04, 0x37, 0x37, 0xDB, 0xFE, 0x68, 0x37, 0xF5,
        0x59, 0x54, 0xBC, 0xEF, 0xDB, 0x0C, 0x80, 0xCD,
        0xD3, 0x46, 0xA8, 0xA2, 0xBE, 0xE0, 0x63, 0x80,
        0xA1, 0x5F, 0x5D, 0xF1, 0xFB, 0x96, 0x8C, 0x06,
        0x38, 0xB6, 0xCB, 0x70, 0xB0, 0xFB, 0xD3, 0x26,
        0xB3, 0x8B, 0xC6, 0x85, 0x34, 0xB7, 0xAB, 0x5F,
        0x7E, 0xC6, 0xAA, 0x79, 0x5B, 0x48, 0x11, 0x65,
        0x9E, 0x2A, 0xCD, 0x6A, 0xF0, 0xB2, 0x93, 0xF5,
        0x2B, 0x88, 0x45, 0xB7, 0xC9, 0xBE, 0x1A, 0x72,
        0x60, 0x62, 0xA4, 0xA5, 0x3B, 0xC2, 0x1C, 0xC6,
        0x21, 0x09, 0xA9, 0x40, 0xF6, 0x58, 0x2B, 0xE5,
        0x70, 0xDC, 0xFC, 0x47, 0x3B, 0x08, 0xEE, 0xA9,
        0x94, 0x26, 0x43, 0xFE, 0xA7, 0x75, 0xD6, 0x4E,
        0x52, 0xF6, 0x46, 0xD1, 0x80, 0xEB, 0x3B, 0x8E,
        0xBE, 0x54, 0x4F, 0xBD, 0x42, 0x0E, 0x41, 0xF9,
        0x36, 0x7D, 0xB6, 0x7F, 0x99, 0x20, 0xC9, 0x63,
        0xE7, 0x93, 0x02, 0x62, 0x59, 0x94, 0xCB, 0xC6,
        0x62, 0xA9, 0x26, 0xE1, 0x1E, 0x03, 0x5A, 0x41,
        0x2F, 0x43, 0x28, 0x75, 0xB7, 0x0C, 0x02, 0x9C,
        0x1E, 0xE0, 0x40, 0xB3, 0xE2, 0x9A, 0xED, 0xC6,
        0x20, 0x49, 0xEC, 0xDD, 0xC5, 0x64, 0x95, 0x83,
        0x51, 0xAE, 0x46, 0x9D, 0x70, 0x17, 0xC6, 0x47,
        0xD3, 0x82, 0xCC, 0x6A, 0x5D, 0x93, 0xB2, 0x85,
        0x5B, 0x25, 0x05, 0xE7, 0x26, 0x2E, 0xD3, 0xDA,
        0x1C, 0xD9, 0x06, 0xB6, 0x16, 0x69, 0x8C, 0x7F,
        0xC8, 0xCF, 0x95, 0x18, 0xB5, 0x98, 0xC0, 0x42,
        0x61, 0xDE, 0x77, 0x41, 0x3A, 0xF6, 0xE1, 0xB0,
        0xE8, 0x64, 0x4A, 0xC2, 0x58, 0xBE, 0x27, 0xC6,
        0x9B, 0x0D, 0x47, 0x1A, 0x09, 0x56, 0x7D, 0x2B,
        0x19, 0x01, 0x88, 0xC7, 0xFB, 0x1E, 0xCF, 0x5E,
        0xF6, 0xB0, 0x82, 0x87, 0xC0, 0xBE, 0xD6, 0xA5,
        0xC3, 0xAC, 0x3A, 0x97, 0x88, 0x25, 0x81, 0xAA,
        0x3A, 0xCE, 0x66, 0x88, 0x0F, 0xC3, 0x02, 0x50,
        0x1C, 0xC3, 0x2B, 0xBC, 0x53, 0x52, 0xFE, 0xD2,
        0x3F, 0x50, 0xC8, 0xB2, 0x19, 0x0A, 0x14, 0xB1,
        0x73, 0x18, 0xB4, 0xDF, 0xBD, 0xED, 0x43, 0xC5,
        0x91, 0xF4, 0x91, 0xBA, 0x7E, 0xB0, 0x7E, 0xA9,
        0x43, 0x67, 0x06, 0xCF, 0x51, 0xC1, 0xBF, 0x63,
        0x7E, 0x91, 0x76, 0xFF, 0x4F, 0x48, 0x91, 0xCF,
        0xDF, 0x01, 0x4D, 0x7E, 0x81, 0x22, 0xFB, 0x79,
        0xFC, 0x1D, 0xE3, 0xA7, 0x45, 0x16, 0xFB, 0xF2,
        0x83, 0xC7, 0xAE, 0xC6, 0xC5, 0x81, 0xDB, 0xA2,
        0x9F, 0x2F, 0xEA, 0xE6, 0x8E, 0x12, 0x8D, 0x43,
        0x14, 0x26, 0x25, 0x0E, 0xB4, 0x18, 0xE8, 0x41,
        0x84, 0xA3, 0x04, 0xDF, 0x97, 0xFF, 0xAA, 0x45,
        0xEC, 0x18, 0xAA, 0xB1, 0xFC, 0xDC, 0xB9, 0xAB,
        0xEE, 0xD1, 0xC4, 0x9E, 0x42, 0x3F, 0x5B, 0x8F,
        0x9F, 0x22, 0xAF, 0xCC, 0x6F, 0xA0, 0x41, 0x41,
        0xCB, 0xD3, 0xAC, 0x96, 0x20, 0xF1, 0x63, 0x56,
        0x65, 0xCE, 0x83, 0xC6, 0x62, 0x04, 0x85, 0x16,
        0x7F, 0x4E, 0xFB, 0xA0, 0x68, 0x11, 0x85, 0x5B,
        0x51, 0xB6, 0x9F, 0xA2, 0xF5, 0xA1, 0xCF, 0x01,
        0x9A, 0x80, 0x68, 0xC3, 0xE9, 0x7F, 0x9E, 0x2E,
        0x83, 0x84, 0xDC, 0x3C, 0x35, 0xCF, 0x24, 0xBF,
        0xF5, 0x00, 0x91, 0x45, 0x14, 0x65, 0xE0, 0xC5,
        0x75, 0xDA, 0xEF, 0x14, 0xBD, 0xDB, 0x28, 0x8D,
        0x30, 0x96, 0xC9, 0xFE, 0xA8, 0x49, 0x76, 0xC9,
        0xED, 0x90, 0x4C, 0x2E, 0xF1, 0x14, 0x2C, 0xF7,
        0x13, 0x7C, 0xF1, 0xCC, 0x67, 0xA5, 0x11, 0x55,
        0xBD, 0x66, 0x13, 0x8A, 0x76, 0xF9, 0xAC, 0xC9,
        0x51, 0x8A, 0xBB, 0x5D, 0x29, 0xEF, 0xF6, 0x37,
        0xA0, 0x3E, 0x99, 0x77, 0x6B, 0xE5, 0xCD, 0x06,
        0xAC, 0x57, 0x07, 0x37, 0x44, 0x3D, 0x5D, 0xD7,
        0xB6, 0x5C, 0xCB, 0x77, 0xD0, 0x4C, 0x28, 0x9D,
        0x12, 0x69, 0x5A, 0x68, 0xD1, 0x15, 0x30, 0xC4,
        0x30, 0xD2, 0x20, 0xDF, 0xD5, 0x73, 0x9F, 0x83,
        0xE9, 0x4C, 0x55, 0xF5, 0xAF, 0xAA, 0x37, 0xF8,
        0x28, 0xB6, 0x3F, 0x99, 0x4B, 0x15, 0x1E, 0x40,
        0xAB, 0x4F, 0x58, 0x3D, 0x3B, 0x81, 0x7D, 0x62,
        0x28, 0x6E, 0x73, 0x58, 0x50, 0x36, 0x49, 0x01,
        0xF7, 0x04, 0x3A, 0x23, 0x28, 0xDA, 0x15, 0xC5,
        0xE3, 0xF6, 0x6F, 0xE1, 0x79, 0x07, 0xFB, 0xAA,
        0xFF, 0x44, 0x48, 0x53, 0x9E, 0x7F, 0x8D, 0x89,
        0x88, 0x1A, 0x9A, 0xF9, 0x47, 0x58, 0x20, 0xBB,
        0x79, 0x4A, 0x2A, 0x14, 0x03, 0x9B, 0x65, 0x4C,
        0x67, 0x02, 0x02, 0xFE, 0xEB, 0xCD, 0xCB, 0x84,
        0xF5, 0xCE, 0x32, 0x59, 0xBC, 0xEA, 0xEC, 0xB1,
        0x3C, 0x22, 0xCF, 0x9D, 0xB0, 0x34, 0x6D, 0xE6,
        0x5A, 0x37, 0xC0, 0x22, 0xAA, 0xF3, 0xB5, 0x71,
        0x90, 0x21, 0xE0, 0xB6, 0x19, 0xE9, 0xB3, 0x10,
        0xCE, 0x5B, 0xF9, 0xD4, 0x25, 0x30, 0x7D, 0xF6,
        0x7D, 0xB6, 0x16, 0xFC, 0x20, 0x3C, 0x2F, 0x96,
        0xD5, 0x79, 0x90, 0x88, 0x24, 0x5D, 0x46, 0x64,
        0x99, 0xC1, 0xF8, 0x7F, 0x96, 0xA7, 0xB5, 0xA9,
        0x47, 0xA3, 0x14, 0xED, 0x93, 0xED, 0x30, 0x56,
        0x58, 0xA5, 0xD4, 0x54, 0x2A, 0xF3, 0x89, 0x27,
        0x7C, 0x55, 0x41, 0x11, 0x27, 0x9D, 0xF6, 0x4D,
        0xA6, 0xB1, 0x00, 0xE0, 0xB0, 0xF6, 0x1E, 0xAB,
        0x20, 0x1F, 0xAE, 0x8A, 0x82, 0xA7, 0x49, 0xFC,
        0xBB, 0x66, 0xAC, 0x97, 0x95, 0x49, 0x29, 0xCB,
        0x6F, 0xF4, 0xC1, 0xB7, 0x6B, 0xF9, 0x8C, 0x25,
        0xC6, 0xF0, 0xB5, 0x81, 0xB0, 0xA2, 0x4D, 0xCC,
        0x2E, 0xD0, 0x13, 0x5F, 0x96, 0x3F, 0xCD, 0xD0,
        0x52, 0xD1, 0xFE, 0xF9, 0xC2, 0x7E, 0x9D, 0xAB,
        0xCB, 0x95, 0x0F, 0x27, 0x01, 0x9E, 0x23, 0x6B,
        0x19, 0xFF, 0x52, 0x55, 0x71, 0x0A, 0xD4, 0xBB,
        0x43, 0x65, 0x29, 0x66, 0xBE, 0x2D, 0x6C, 0xE3,
        0x2A, 0x7C, 0xB4, 0x02, 0x32, 0x59, 0x94, 0x80,
        0x14, 0xE7, 0x62, 0xE4, 0xCE, 0xB0, 0xCA, 0xCA,
        0x37, 0xD7, 0x0C, 0x68, 0x29, 0xE2, 0x92, 0xE1,
        0xEB, 0x91, 0xE5, 0xA1, 0x0C, 0xFC, 0x55, 0xCB,
        0x56, 0xB3, 0x96, 0xFB, 0x64, 0xD9, 0x53, 0x8E,
        0x82, 0x2B, 0xDF, 0x7F, 0xCB, 0x2A, 0xF6, 0x3C,
        0xA7, 0x89, 0x52, 0x13, 0x2C, 0x6A, 0x93, 0xA2,
        0x74, 0xF5, 0x91, 0x00, 0x17, 0xAA, 0x74, 0x45,
        0x63, 0x5A, 0xE5, 0xC3, 0x16, 0xFC, 0x0E, 0xF7,
        0xF3, 0xA4, 0x55, 0x8A, 0xA2, 0x60, 0x24, 0x57,
        0x25, 0x2C, 0x94, 0xE0, 0xF5, 0x32, 0x54, 0x4A,
        0x2D, 0x63, 0x5F, 0xD8, 0x35, 0x96, 0xBD, 0xFE,
        0x90, 0x33, 0x17, 0xF6, 0xB5, 0x81, 0x02, 0xFA,
        0x5C, 0x94, 0x3A, 0xBE, 0x22, 0xB9, 0xFC, 0x3E,
        0x09, 0xE4, 0x76, 0xD7, 0x03, 0x38, 0x38, 0xC2,
        0xC2, 0x0D, 0x66, 0x3C, 0xD0, 0x91, 0x5C, 0xF4,
        0x0E, 0xC2, 0xDE, 0x46, 0x90, 0x2E, 0xF5, 0x22,
        0xA9, 0x3D, 0x15, 0x20, 0x5F, 0x17, 0x10, 0x5A,
        0x54, 0x63, 0x93, 0x7B, 0xC3, 0x00, 0x3D, 0x42,
        0x73, 0xF1, 0xAD, 0xC1, 0xDE, 0x76, 0x18, 0x9C,
        0x68, 0x17, 0xBF, 0x3B, 0xE0, 0x30, 0x82, 0x02,
        0xF9, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7,
        0x0D, 0x01, 0x07, 0x01, 0xA0, 0x82, 0x02, 0xEA,
        0x04, 0x82, 0x02, 0xE6, 0x30, 0x82, 0x02, 0xE2,
        0x30, 0x82, 0x02, 0xDE, 0x06, 0x0B, 0x2A, 0x86,
        0x48, 0x86, 0xF7, 0x0D, 0x01, 0x0C, 0x0A, 0x01,
        0x02, 0xA0, 0x82, 0x02, 0xA6, 0x30, 0x82, 0x02,
        0xA2, 0x30, 0x1C, 0x06, 0x0A, 0x2A, 0x86, 0x48,
        0x86, 0xF7, 0x0D, 0x01, 0x0C, 0x01, 0x03, 0x30,
        0x0E, 0x04, 0x08, 0x34, 0x37, 0x27, 0x5F, 0xE8,
        0xD6, 0x00, 0x0D, 0x02, 0x02, 0x08, 0x00, 0x04,
        0x82, 0x02, 0x80, 0xC0, 0xE6, 0xB1, 0x63, 0x73,
        0xFC, 0xBF, 0x50, 0xFB, 0x54, 0xCF, 0x67, 0x16,
        0xF8, 0x28, 0x48, 0x13, 0x7F, 0xF2, 0xBD, 0x66,
        0x70, 0xC7, 0xF6, 0x01, 0xD0, 0x58, 0xF4, 0xA4,
        0xD9, 0x45, 0xE2, 0x63, 0x92, 0x7F, 0x78, 0x2B,
        0xB6, 0xDB, 0x16, 0x44, 0x1D, 0x11, 0xCB, 0xC3,
        0x20, 0xA9, 0x8A, 0x96, 0x13, 0xB8, 0x6E, 0xF3,
        0xDA, 0x46, 0x05, 0x2C, 0xF9, 0x67, 0xBB, 0x05,
        0x88, 0xC0, 0xC8, 0x60, 0x09, 0xA3, 0x82, 0x27,
        0x33, 0xEB, 0xEE, 0x43, 0x98, 0xE9, 0xE2, 0x24,
        0xA8, 0x06, 0xD5, 0xFF, 0xF5, 0xC0, 0x79, 0x4B,
        0x06, 0x40, 0xE6, 0x28, 0xC6, 0x6E, 0x4E, 0x03,
        0xCC, 0x9B, 0xB6, 0xBD, 0xB6, 0x81, 0x88, 0x5C,
        0x34, 0x6B, 0x8B, 0x15, 0x23, 0x75, 0x21, 0xAC,
        0x79, 0xFD, 0xDB, 0x80, 0x1D, 0x20, 0x84, 0xF1,
        0x47, 0xAF, 0x7B, 0x40, 0x6C, 0xD2, 0x64, 0x52,
        0x11, 0x1B, 0x01, 0x1E, 0xB5, 0xA9, 0x4B, 0xC4,
        0x51, 0x54, 0x40, 0xE2, 0xC8, 0xEB, 0x20, 0x48,
        0x2D, 0x40, 0xF8, 0xC6, 0x58, 0x5A, 0xE3, 0x34,
        0xD8, 0x79, 0x04, 0xD7, 0xD6, 0x07, 0xF2, 0x12,
        0x66, 0xC8, 0x31, 0x37, 0x71, 0x60, 0xF4, 0x75,
        0xDC, 0x60, 0x54, 0x19, 0x6A, 0x75, 0x56, 0xC5,
        0xA9, 0x67, 0x4A, 0x03, 0x7A, 0xFD, 0x12, 0x59,
        0x2B, 0x74, 0xE6, 0xA5, 0xE2, 0xF8, 0xBB, 0x1E,
        0x76, 0x96, 0xD4, 0xD4, 0x3F, 0x8B, 0xAD, 0x90,
        0xAF, 0x04, 0x41, 0xDB, 0xD8, 0xCC, 0x2D, 0x37,
        0x06, 0x20, 0x9B, 0xE7, 0x98, 0x87, 0x12, 0xAC,
        0x70, 0xC9, 0xF4, 0x1C, 0x28, 0xFB, 0x2C, 0x9E,
        0x18, 0xE1, 0x6D, 0x79, 0x34, 0xBC, 0xAC, 0xCB,
        0x75, 0x92, 0x7E, 0x8E, 0x7C, 0xA9, 0x0B, 0x86,
        0x4A, 0x88, 0xFB, 0xE8, 0xBE, 0x6A, 0x32, 0xEF,
        0x58, 0xCC, 0x4C, 0x89, 0x50, 0xEF, 0xDF, 0xE0,
        0xDD, 0x35, 0x07, 0x8C, 0x01, 0x8B, 0x57, 0x38,
        0xB5, 0x64, 0xBB, 0x0A, 0xC2, 0xD8, 0xAB, 0xC5,
        0x45, 0xA6, 0x83, 0xBF, 0xA6, 0xA2, 0xCC, 0x06,
        0x64, 0xBE, 0x84, 0x04, 0x55, 0x8E, 0xF4, 0x4C,
        0xB5, 0xBC, 0xE5, 0x97, 0x2B, 0x3C, 0x42, 0x44,
        0x91, 0x9B, 0xB2, 0x65, 0x70, 0x02, 0xC5, 0xB7,
        0x71, 0xB3, 0xF0, 0xAA, 0x46, 0x4F, 0x42, 0x40,
        0x53, 0x65, 0x89, 0xA5, 0x6C, 0xBC, 0xB5, 0x6C,
        0x0C, 0x3B, 0x50, 0x46, 0x67, 0xFA, 0x14, 0x68,
        0x01, 0xE7, 0xA6, 0xD4, 0xB5, 0xD0, 0x82, 0x44,
        0x92, 0x2C, 0xE3, 0x43, 0x5D, 0x34, 0x7C, 0x04,
        0xA3, 0x4D, 0x2F, 0x5A, 0x75, 0xE7, 0x0B, 0x64,
        0xD0, 0xAE, 0x7F, 0xCB, 0xDD, 0x7D, 0x05, 0x88,
        0x4C, 0x34, 0xBB, 0xF4, 0x00, 0xCE, 0x1C, 0x13,
        0x4E, 0xA3, 0xE3, 0x60, 0x4B, 0x50, 0x4E, 0xE1,
        0x26, 0x22, 0x51, 0xD4, 0x32, 0x60, 0xC6, 0x3E,
        0x7D, 0x4A, 0x3E, 0x56, 0x78, 0xBD, 0x5F, 0x23,
        0x7F, 0x0A, 0xA0, 0xC1, 0x1A, 0x60, 0xA2, 0x7C,
        0x9E, 0x17, 0x6F, 0xD8, 0x73, 0x0F, 0x1A, 0x1F,
        0x47, 0x58, 0x44, 0x20, 0x80, 0xC6, 0x5D, 0x6E,
        0xEC, 0xFF, 0xCA, 0x65, 0xA1, 0xFB, 0xEE, 0xF2,
        0x56, 0x1A, 0x16, 0x9E, 0x4D, 0xCA, 0x67, 0x81,
        0x23, 0xDE, 0xBE, 0x5E, 0x31, 0x56, 0xF0, 0x34,
        0xBA, 0x12, 0xFC, 0x07, 0x03, 0x96, 0xD2, 0x8E,
        0xCE, 0xA6, 0xF6, 0x74, 0x07, 0x4F, 0x63, 0x40,
        0x14, 0x0A, 0xD6, 0x45, 0xB4, 0xF1, 0x72, 0x87,
        0x34, 0x89, 0x5C, 0x06, 0x1B, 0x8C, 0x0E, 0xA2,
        0x84, 0x50, 0x12, 0xAD, 0x26, 0x5B, 0x4F, 0x6B,
        0x23, 0x9D, 0x3C, 0xBB, 0x8A, 0xDA, 0x08, 0x4B,
        0x93, 0x47, 0x02, 0x96, 0x76, 0xD4, 0x87, 0xE9,
        0x4B, 0x69, 0x82, 0xD6, 0xCC, 0x69, 0x02, 0xC0,
        0xA4, 0x75, 0x7A, 0x90, 0xFD, 0xF6, 0xD6, 0x9D,
        0xE2, 0x4C, 0xB6, 0xFA, 0x61, 0xA5, 0x7C, 0x18,
        0xEA, 0x84, 0xA1, 0x74, 0x85, 0x2E, 0xCA, 0xF9,
        0x17, 0x29, 0xFF, 0x67, 0x70, 0xC9, 0x6F, 0xF1,
        0x41, 0xEF, 0xA1, 0x59, 0x54, 0xA0, 0x99, 0x14,
        0x48, 0x74, 0x5D, 0x14, 0x3E, 0x04, 0xCE, 0xF7,
        0x16, 0x9F, 0x8A, 0x41, 0xF4, 0xAE, 0xB3, 0x10,
        0xCE, 0x19, 0xC2, 0x83, 0x7B, 0xD0, 0x26, 0x1E,
        0x75, 0x8A, 0x0A, 0x40, 0x4A, 0xB8, 0xE0, 0x5C,
        0x13, 0x8B, 0xCC, 0x6F, 0xF3, 0x00, 0xB3, 0x64,
        0x1B, 0x3C, 0x3D, 0x08, 0x3B, 0x9F, 0xD0, 0x9B,
        0xE5, 0x72, 0x45, 0x96, 0x95, 0x4D, 0x66, 0xC7,
        0x79, 0x5D, 0x3A, 0x1A, 0x94, 0x64, 0x94, 0x07,
        0x1A, 0xE8, 0x7C, 0xD1, 0x1C, 0xB1, 0x7E, 0x32,
        0x28, 0x1A, 0x90, 0x22, 0xD9, 0x86, 0x9B, 0x9C,
        0x9B, 0x0C, 0x04, 0x31, 0x85, 0x10, 0x42, 0x50,
        0x40, 0x11, 0x72, 0xAB, 0x94, 0x0C, 0xAF, 0xC3,
        0x22, 0x1A, 0xC1, 0x31, 0x25, 0x30, 0x23, 0x06,
        0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01,
        0x09, 0x15, 0x31, 0x16, 0x04, 0x14, 0xFD, 0x78,
        0xA7, 0x70, 0x1F, 0x8A, 0xE9, 0x07, 0xB9, 0xCA,
        0x3C, 0xD1, 0xE8, 0xDC, 0x68, 0xFF, 0x02, 0x61,
        0x29, 0x97, 0x30, 0x31, 0x30, 0x21, 0x30, 0x09,
        0x06, 0x05, 0x2B, 0x0E, 0x03, 0x02, 0x1A, 0x05,
        0x00, 0x04, 0x14, 0x22, 0x7E, 0x99, 0x10, 0xB3,
        0x99, 0x79, 0xE7, 0x14, 0x7F, 0x91, 0x59, 0x24,
        0x4F, 0x2F, 0xCF, 0xE8, 0x53, 0x1D, 0x0F, 0x04,
        0x08, 0x30, 0x1E, 0x5C, 0xE4, 0x3C, 0x66, 0xDF,
        0xB0, 0x02, 0x02, 0x08, 0x00]
};

gTestSuite.doTestWithCertificate(
  new Blob([new Uint8Array(testCertInfo.blob)]),
  testCertInfo.password,
  testCertInfo.nickname,
  testCertInfo.usage
);
