.TH XvSelectPortNotify __libmansuffix__ __vendorversion__ "libXv Functions"
.SH NAME
XvSelectPortNotify \- enable or disable XvPortNotify events
.\"
.SH SYNOPSIS
.B #include <X11/extensions/Xvlib.h>
.sp
.nf
.BI "int XvSelectPortNotify(Display *" dpy ", XvPortID " port ", Bool " onoff ");"
.fi
.SH ARGUMENTS
.\"
.IP \fIdpy\fR 8
Specifies the connection to the X server.
.IP \fIport\fR 8
Specifies the port for which PortNotify events are to be generated
when its attributes are changed using
.BR XvSetPortAttribute (__libmansuffix__)
.
.IP \fIonoff\fR 8
Specifies whether notification is to be enabled or disabled.
.\"
.SH DESCRIPTION
.\"
.BR XvSelectPortNotify (__libmansuffix__)
enables or disables PortNotify event delivery to the requesting client.
.BR XvPortNotify (__libmansuffix__)
events are generated when port attributes are changed using
.BR XvSetPortAttribute (__libmansuffix__).
.\"
.SH RETURN VALUES
.IP [Success] 8
Returned if
.BR XvSelectPortNotify (__libmansuffix__)
completed successfully.
.IP [XvBadExtension] 8
Returned if the Xv extension is unavailable.
.IP [XvBadAlloc] 8
Returned if
.BR XvSelectPortNotify (__libmansuffix__)
failed to allocate memory to process the request.
.SH DIAGNOSTICS
.IP [XvBadPort] 8
Generated if the requested port does not exist.
.SH SEE ALSO
.\"
.BR XvSetPortNotify (__libmansuffix__),
.BR XvSetPortAttribute (__libmansuffix__),
.BR XvPortNotify (__libmansuffix__)
