/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.nativerdf.btree;

import info.aduna.io.ByteArrayUtil;
import info.aduna.io.IOUtil;
import java.io.File;
import java.io.IOException;
import java.util.BitSet;
import org.openrdf.sail.nativerdf.btree.BTree;

public class AllocatedNodesList {
    private final BTree btree;
    private final File allocNodesFile;
    private BitSet allocatedNodes;
    private boolean needsSync = false;

    public AllocatedNodesList(File allocNodesFile, BTree btree) {
        if (allocNodesFile == null) {
            throw new IllegalArgumentException("allocNodesFile must not be null");
        }
        if (btree == null) {
            throw new IllegalArgumentException("btree muts not be null");
        }
        this.allocNodesFile = allocNodesFile;
        this.btree = btree;
    }

    public File getFile() {
        return this.allocNodesFile;
    }

    public synchronized boolean delete() throws IOException {
        this.allocatedNodes = null;
        this.needsSync = false;
        return this.allocNodesFile.delete();
    }

    public synchronized void sync() throws IOException {
        if (this.needsSync) {
            BitSet bitSet = this.allocatedNodes;
            int bitSetLength = this.allocatedNodes.length();
            if (bitSetLength < this.allocatedNodes.size()) {
                bitSet = this.allocatedNodes.get(0, bitSetLength);
            }
            byte[] data = ByteArrayUtil.toByteArray(bitSet);
            IOUtil.writeBytes(data, this.allocNodesFile);
            this.needsSync = false;
        }
    }

    private void scheduleSync() throws IOException {
        if (!this.needsSync) {
            boolean success;
            if (this.allocNodesFile.exists() && !(success = this.allocNodesFile.delete())) {
                throw new IOException("Failed to delete " + this.allocateNode());
            }
            this.needsSync = true;
        }
    }

    public synchronized void clear() throws IOException {
        if (this.allocatedNodes != null) {
            this.allocatedNodes.clear();
        } else {
            this.allocatedNodes = new BitSet();
        }
        this.scheduleSync();
    }

    public synchronized int allocateNode() throws IOException {
        this.initAllocatedNodes();
        int newNodeID = this.allocatedNodes.nextClearBit(1);
        this.allocatedNodes.set(newNodeID);
        this.scheduleSync();
        return newNodeID;
    }

    public synchronized void freeNode(int nodeID) throws IOException {
        this.initAllocatedNodes();
        this.allocatedNodes.clear(nodeID);
        this.scheduleSync();
    }

    public synchronized int getMaxNodeID() throws IOException {
        this.initAllocatedNodes();
        return Math.max(0, this.allocatedNodes.length() - 1);
    }

    public synchronized int getNodeCount() throws IOException {
        this.initAllocatedNodes();
        return this.allocatedNodes.cardinality();
    }

    private void initAllocatedNodes() throws IOException {
        if (this.allocatedNodes == null) {
            if (this.allocNodesFile.exists()) {
                this.loadAllocatedNodesInfo();
            } else {
                this.crawlAllocatedNodes();
            }
        }
    }

    private void loadAllocatedNodesInfo() throws IOException {
        byte[] data = IOUtil.readBytes(this.allocNodesFile);
        this.allocatedNodes = ByteArrayUtil.toBitSet(data);
    }

    private void crawlAllocatedNodes() throws IOException {
        this.allocatedNodes = new BitSet();
        BTree.Node rootNode = this.btree.readRootNode();
        if (rootNode != null) {
            this.crawlAllocatedNodes(rootNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void crawlAllocatedNodes(BTree.Node node) throws IOException {
        try {
            this.allocatedNodes.set(node.getID());
            if (!node.isLeaf()) {
                for (int i = 0; i < node.getValueCount() + 1; ++i) {
                    this.crawlAllocatedNodes(node.getChildNode(i));
                }
            }
        }
        finally {
            node.release();
        }
    }
}

