.TH XScreenSaver 1 "30-Oct-99" "X Version 11"
.SH NAME
glmatrix - simulates the title sequence effect of the movie
.SH SYNOPSIS
.B glmatrix
[\-display \fIhost:display.screen\fP] [\-window] [\-root] [\-install]
[\-visual \fIvisual\fP] 
[\-delay \fIusecs\fP] 
[\-speed \fIratio\fP]
[\-density \fIpct\fP]
[\-no\-fog]
[\-no\-waves]
[\-no\-rotate]
[\-binary]
[\-hexadecimal]
[\-dna]
[\-clock]
[\-timefmt \fIfmt\fP]
[\-wireframe]
[\-fps]
.SH DESCRIPTION
The \fIglmatrix\fP program draws dropping characters similar to what
is seen in the title sequence of the Wachowski brothers' film,
"The Matrix".

Also see
.BR xmatrix (MANSUFFIX)
for a 2D rendering of the similar effect that appeared on the
computer monitors actually \fIin\fP the movie.
.SH OPTIONS
.I glmatrix
accepts the following options:
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-install
Install a private colormap for the window.
.TP 8
.B \-visual \fIvisual\fP\fP
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-delay \fIusecs\fP
The delay between frames of the animation, in microseconds: default 30000.
.TP 8
.B \-speed \fIratio\fP
How fast the glyphs should move; default 1.0.  2.0 means twice as fast,
0.5 means half as fast.
.TP 8
.B \-density \fIpercentage\fP
The approximate percentage of the screen that should be filled with 
characters at any given time.  Default 20%.
.TP 8
.B \-no\-fog
By default, glyphs are dimmer the farther away they are.  This 
argument disables that.
.TP 8
.B \-no\-waves
By default, waves of color roll down the columns of glyphs.  This
argument disables that.
.TP 8
.B \-no-rotate\fP
By default, the scene slowly tilts and rotates.  This
argument disables that.
.TP 8
.B \-binary\fP
Instead of displaying Matrix glyphs, only display ones and zeros.
.TP 8
.B \-hexadecimal\fP
Instead of displaying Matrix glyphs, display hexadecimal digits.
.TP 8
.B \-dna\fP
Instead of displaying Matrix glyphs, display genetic code
(guanine, adenine, thymine, and cytosine.)
.TP 8
.B \-clock\fP
Hide a clock displaying the current time somewhere in the glyphs.
.TP 8
.B \-timefmt\fP \fIstrftime-string\fP
How to format the clock when \fI\-clock\fP is specified.
Default "\ %l%M%p\ ".
.TP 8
.B \-speed \fIratio\fP
Less than 1 for slower, greater than 1 for faster.  Default 1.
.TP 8
.B \-wireframe
Just draw boxes instead of textured characters.
.TP 8
.B \-fps
Display the current frame rate, CPU load, and polygon count.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR xmatrix (MANSUFFIX),
.BR X (1),
.BR xscreensaver (1)
.SH COPYRIGHT
Copyright \(co 1999-2003 by Jamie Zawinski.  Permission to use, copy, modify, 
distribute, and sell this software and its documentation for any purpose is 
hereby granted without fee, provided that the above copyright notice appear 
in all copies and that both that copyright notice and this permission notice
appear in supporting documentation.  No representations are made about the 
suitability of this software for any purpose.  It is provided "as is" without
express or implied warranty.
.SH AUTHOR
Jamie Zawinski <jwz@jwz.org>, 8-Jun-2003.
