/*
   Copyright (c) 2008-2009 Sebastian Trueg <trueg@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef _NEPOMUK_VIRTUAL_FOLDER_CONNECTION_H_
#define _NEPOMUK_VIRTUAL_FOLDER_CONNECTION_H_

#include <QtCore/QObject>

class QUrl;

namespace Nepomuk {
    namespace Query {

        class Result;
        class ResultIterator;
        class Folder;

        class FolderConnection : public QObject
        {
            Q_OBJECT

        public:
            FolderConnection( Folder* parentFolder );
            ~FolderConnection();

        public Q_SLOTS:
            /// List all entries in the folder, used by the public kdelibs API
            void list();

            /// internal API used by the kio kded module to listen for changes
            void listen();

            /// close the connection to the folder. Will delete this connection
            void close();

        Q_SIGNALS:
            void newEntries( const QList<Nepomuk::Query::Result>& );
            void entriesRemoved( const QStringList& );
            void finishedListing();

        private Q_SLOTS:
            void slotEntriesRemoved( const QList<QUrl>& entries );
            void slotFinishedListing();

        private:
            Folder* m_folder;
        };
    }
}

#endif
