/* This is a utility for making Links fonts from postscript files and
 * Ghostscript fonts.
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

/* Here switch on which encoding the Ghostscript font is in. */
/* #define LATIN */
/* #define CYRILLIC */
/* #define HEBREW */
/* #define HIRAGANA */
/* #define KATAKANA */
/* #define DINGBATS */
/* #define GREEK */
/* #define ARABIC */
/* #define ARABIC2 */
/* #define GEORGIAN_MKHEDRULI */
# define STANDARD_SYMBOL

#ifdef STANDARD_SYMBOL /* (s050000l.pfb) */
int copy[]={
	34,0x2200,
	36,0x2203,
	39,0x220d,
	64,0x2245,
	68,0x2206,
	92,0x2234,
	94,0x22a5,
	163,0x2264,
	165,0x221e,
	164,0x2215,
	177,0x00b1,
	179,0x2265,
	180,0x2062,
	181,0x221d,
	182,0x2202,
	183,0x2981,
	184,0x00f7,
	185,0x2260,
	186,0x2261,
	187,0x2248,
	188,0x20e8,
	189,0x2223,
	196,0x2297,
	197,0x2295,
	198,0x2205,
	198,0x2300,
	199,0x22c2,
	200,0x22c3,
	201,0x2283,
	202,0x2287,
	203,0x2284,
	204,0x2282,
	205,0x2286,
	206,0x220a,
	207,0x2209,
	208,0x2220,
	208,0x299f,
	209,0x2207,
	210,0x00ae,
	211,0x00a9,
	212,0x2122,
	213,0x220f,
	214,0x221a,
	215,0x2219,
	216,0x00ac,
	217,0x2227,
	217,0x22c0,
	218,0x22c1,
	218,0x2228,
	219,0x27fa,
	220,0x27f8,
	221,0x21d1,
	222,0x21d2,
	223,0x21d3,
	225,0x2329,
	229,0x2211,
	230,0x239b,
	231,0x239c,
	232,0x239d,
	233,0x23a1,
	234,0x23a2,
	235,0x23a3,
	236,0x23a7,
	237,0x23a8,
	238,0x23a9,
	239,0x23aa,
	241,0x232a,
	241,0x27e9,
	242,0x222b,
	246,0x239e,
	247,0x239f,
	248,0x23a0,
	249,0x23a4,
	250,0x23a5,
	251,0x23a6,
	252,0x23ab,
	253,0x23ac,
	254,0x23ad,
	242,0x222b
};

int merge[]={};
#endif /* #ifdef STANDARD_SYMBOL */
	
#ifdef GEORGIAN_MKHEDRULI  /* mkhedruli.pfb */
int copy[]={
	35,0x10d0,
	36,0x10d1,
	37,0x10d2,
	38,0x10d3,
	39,0x10d4,
	40,0x10d5,
	41,0x10d6,
	42,0x10f1,
	43,0x10d7,
	44,0x10d8,
	45,0x10d9,
	46,0x10da,
	47,0x10db,
	48,0x10dc,
	49,0x10f2,
	50,0x10dd,
	51,0x10de,
	52,0x10df,
	53,0x10e0,
	54,0x10e1,
	55,0x10e2,
	56,0x10e3,
	57,0x10f3,
	58,0x10e4,
	59,0x10e5,
	60,0x10e6,
	61,0x10e7,
	62,0x10e8,
	63,0x10e9,
	64,0x10ea,
	65,0x10eb,
	66,0x10ec,
	67,0x10ed,
	68,0x10ee,
	69,0x10f4,
	70,0x10ef,
	71,0x10f0,
	72,0x10f5,
	73,0x10f6,
};

int merge[]={};
#endif /* #ifdef GEORGIAN_MKHEDRULI */

#ifdef ARABIC2	/* irnafnt5.pfb */
int copy[]={
	48,0x06f0,
	49,0x06f1,
	50,0x06f2,
	51,0x06f3,
	52,0x06f4,
	53,0x06f5,
	54,0x06f6,
	55,0x06f7,
	56,0x06f8,
	57,0x06f9,
	76,0x0686,
	86,0x0698,
	111,0x06af,
	125,0x06cc,
	158,0x0640,
};

int merge[]={};
#endif

#ifdef ARABIC	/* ArabicNaskh.pfb */
int copy[]={
	37,0x066a,
	44,0x060c,
	48,0x0660,
	49,0x0661,
	50,0x0662,
	51,0x0663,
	52,0x0664,
	53,0x0665,
	54,0x0666,
	55,0x0667,
	56,0x0668,
	57,0x0669,
	59,0x061b,
	63,0x061f,
	64,0x0604,
	65,0x0627,
	67,0x0623,
	69,0x0622,
	71,0x0625,
	76,0x0628,
	80,0x062a,
	84,0x062b,
	88,0x062c,
	94,0x066c,
	95,0x0671,
	96,0x062d,
	100,0x062e,
	101,0x062f,
	103,0x0630,
	105,0x0631,
	107,0x0632,
	112,0x0633,
	116,0x0634,
	120,0x0635,
	123,0x0670,
	126,0x0636,
	162,0x0637,
	166,0x0638,
	167,0x0621,
	167,0x06f6,
	170,0x0639,
	174,0x063a,
	178,0x0641,
	182,0x0642,
	183,0x06a9,
	186,0x0643,
	190,0x0644,
	194,0x0645,
	198,0x0646,
	199,0x0647,
	199,0x06be,
	202,0x06d5,
	203,0x0648,
	205,0x068d,
	208,0x064a,
	212,0x0649,
	213,0x0674,
	215,0x06c2,
	217,0x0626,
	218,0x0624,
	220,0x06d9,
	228,0x064e,
	231,0x064b,
	232,0x064c,
	234,0x0650,
	235,0x064d,
	233,0x0651,
	230,0x0652,
	229,0x064f,
	42,0x066d,
	78,0x06c3,
};

int merge[]={};
#endif

#ifdef HEBREW	/* elronm.pfb - monospaced, hebrewmm.pfb - proportional */
int copy[]={	/* iso 8859-8 */
	0xE0,0x05D0,
	0xE1,0x05D1,
	0xE2,0x05D2,
	0xE3,0x05D3,
	0xE4,0x05D4,
	0xE5,0x05D5,
	0xE6,0x05D6,
	0xE7,0x05D7,
	0xE8,0x05D8,
	0xE9,0x05D9,
	0xEA,0x05DA,
	0xEB,0x05DB,
	0xEC,0x05DC,
	0xED,0x05DD,
	0xEE,0x05DE,
	0xEF,0x05DF,
	0xF0,0x05E0,
	0xF1,0x05E1,
	0xF2,0x05E2,
	0xF3,0x05E3,
	0xF4,0x05E4,
	0xF5,0x05E5,
	0xF6,0x05E6,
	0xF7,0x05E7,
	0xF8,0x05E8,
	0xF9,0x05E9,
	0xFA,0x05EA,
};


int merge[]={};
#endif


#ifdef KATAKANA
int copy[]={
	33,0x30ac,
	35,0x30f7,
	36,0x30b2,
	37,0x30b4,
	38,0x30d3,
	39,0x30ef,
	40,0x30d9,
	41,0x30dc,
	42,0x30d6,
	43,0x30c3,
	44,0x30e4,
	45,0x30e9,
	46,0x30e6,
	47,0x30e8,
	48,0x30ce,
	49,0x30de,
	50,0x30a4,
	51,0x30a6,
	52,0x30a8,
	53,0x30aa,
	54,0x30ca,
	55,0x30cb,
	56,0x30cc,
	57,0x30cd,
	58,0x30dd,
	59,0x30e2,
	60,0x30e3,
	61,0x30ea,
	62,0x30e5,
	63,0x30e7,
	64,0x30f8,
	65,0x30b6,
	66,0x30c9,
	67,0x30c5,
	68,0x30ba,
	70,0x30bc,
	71,0x30be,
	72,0x30d1,
	74,0x30d4,
	75,0x30d7,
	76,0x30da,
	77,0x30a3,
	78,0x30a9,
	83,0x30b8,
	85,0x30a7,
	86,0x30c7,
	88,0x30c2,
	89,0x30a1,
	90,0x30c0,
	91,0x30eb,
	92,0x30ed,
	93,0x30ec,
	94,0x30d0,
	95,0x30fc,
	97,0x30b5,
	98,0x30c8,
	99,0x30c4,
	100,0x30b9,
	101,0x30af,
	102,0x30bb,
	103,0x30bd,
	104,0x30de,
	105,0x30d5,
	106,0x30df,
	107,0x30e0,
	108,0x30e1,
	109,0x30f3,
	110,0x30f2,
	111,0x30d8,
	112,0x30db,
	113,0x30f5,
	114,0x30f6,
	115,0x30c4,
	116,0x30b3,
	117,0x30d2,
	118,0x30c6,
	119,0x30f0,
	120,0x30c1,
	121,0x30cf,
	122,0x30bf,
	124,0x30a5,
};
int merge[]={};
#endif


#ifdef HIRAGANA
int copy[]={
	33,0x304c,
	35,0x3050,
	36,0x3052,
	37,0x3054,
	38,0x3073,
	39,0x308f,
	40,0x3079,
	41,0x307c,
	42,0x3076,
	43,0x3063,
	44,0x3084,
	45,0x3089,
	46,0x3086,
	47,0x3088,
	48,0x306e,
	49,0x3042,
	50,0x3044,
	51,0x3046,
	52,0x3048,
	53,0x304a,
	54,0x306a,
	55,0x306b,
	56,0x306c,
	57,0x306d,
	58,0x307d,
	59,0x3082,
	60,0x3083,
	62,0x3085,
	63,0x3087,
	64,0x304e,
	65,0x3056,
	66,0x3069,
	67,0x3065,
	68,0x305a,
	70,0x305c,
	71,0x305e,
	72,0x3071,
	74,0x3074,
	75,0x3077,
	76,0x307a,
	77,0x3043,
	78,0x3049,
	79,0x309c,
	83,0x3058,
	85,0x3047,
	86,0x3067,
	88,0x3062,
	89,0x3041,
	90,0x3060,
	91,0x308b,
	92,0x308d,
	93,0x308c,
	94,0x3070,
	97,0x3055,
	98,0x3068,
	99,0x3064,
	100,0x3059,
	101,0x304f,
	102,0x305b,
	103,0x305d,
	104,0x307e,
	105,0x3075,
	106,0x307f,
	107,0x3080,
	108,0x3081,
	109,0x3093,
	110,0x3092,
	111,0x3078,
	112,0x307b,
	113,0x304b,
	114,0x3051,
	115,0x3057,
	116,0x3053,
	117,0x3072,
	118,0x3066,
	119,0x304d,
	120,0x3061,
	121,0x306f,
	122,0x305f,
	124,0x3045
};

int merge[]={};
#endif

#ifdef LATIN

/* 0xc2: acute
 */
int copy[]={
	161,0xa1,
	162,0xa2,  
	163,0xa3,
	165,0xa5,  
	167,0xa7,
	171,0xab,	
	172,0x2039,	
	173,0x203a,
	174,0xfb01,
	175,0xfb02,
	177,0x2013,
	178,0x2020,	
	179,0x2021,	
	182,0xb6,	
	183,0x2022,	
	187,0xbb,	
	188,0x2026,	
	189,0x2030,	
	191,0xbf,	
	196,0x2dc,	
	208,0x2014,	
	225,0xc6,	
	232,0x141,	
	233,0xd8,	
	234,0x152,	
	235,0x2116,	
	241,0xe6,	
	248,0x142,	
	249,0xf8,	
	250,0x153,	
	251,0xdf,	

	193,0x300,
#define GRA 193		/* ` */
	194,0xb4,	
#define ACU 194		/* ' */
	195,0x2c6,
#define CIR 195		/* ^ */
	196,0x2dc,	
#define TIL 196		/* ~ */
	197,0xaf,	
#define MAC 197		/* - above */
	198,0x306,
#define LSC 198		/* lower semicircle above */
	199,0x2d9,
	199,0xb7,
#define DOT 199		/* . above */
	200,0xa8,	
#define UML 200		/* .. above */
	202,0x2da,	
	202,0xb0,
#define RIN 202		/* o above */
	203,0xb8,
#define CED 203		/* (5 without the top stroke) under */
	205,0x30b,
#define DAC 205		/* " */
	206,0x2db,
#define OGO 206		/* left-right mirrored J under (ogonek) */
	207,0x2c7,	
#define CAR 207		/* v above */

	
	
};

int merge[]={
	'+','-',0xb1,
	'A',GRA,0xc0,
	'A',ACU,0xc1,
	'A',CIR,0xc2,
	'A',TIL,0xc3,
	'A',UML,0xc4,
	'A',RIN,0xc5,
	'C',CED,0xc7,
	'E',GRA,0xc8,
	'E',ACU,0xc9,
	'E',CIR,0xca,
	'E',UML,0xcb,
	'I',GRA,0xcc,
	'I',ACU,0xcd,
	'I',CIR,0xce,
	'I',UML,0xcf,
	'D','-',0xd0,
	'N',TIL,0xd1,
	'O',GRA,0xd2,
	'O',ACU,0xd3,
	'O',CIR,0xd4,
	'O',TIL,0xd5,
	'O',UML,0xd6,
	'U',GRA,0xd9,
	'U',ACU,0xda,
	'U',CIR,0xdb,
	'U',UML,0xdc,
	'Y',ACU,0xdd,
	'a',GRA,0xe0,
	'a',ACU,0xe1,
	'a',CIR,0xe2,
	'a',TIL,0xe3,
	'a',UML,0xe4,
	'a',RIN,0xe5,
	'c',CED,0xe7,
	'e',GRA,0xe8,
	'e',ACU,0xe9,
	'e',CIR,0xea,
	'e',UML,0xeb,
	'i',GRA,0xec,
	'i',ACU,0xed,
	'i',CIR,0xee,
	'i',UML,0xef,
	'n',TIL,0xf1,
	'o',GRA,0xf2,
	'o',ACU,0xf3,
	'o',CIR,0xf4,
	'o',TIL,0xf5,
	'o',UML,0xf6,
	'u',GRA,0xf9,
	'u',ACU,0xfa,
	'u',CIR,0xfb,
	'u',UML,0xfc,
	'y',ACU,0xfd,
	'y',UML,0xff,
	'A',MAC,0x100,
	'a',MAC,0x101,
	'A',LSC,0x102,
	'a',LSC,0x103,
	'A',OGO,0x104,
	'a',OGO,0x105,
	'C',ACU,0x106,
	'c',ACU,0x107,
	'C',CIR,0x108,
	'c',CIR,0x109,
	'C',DOT,0x10a,
	'c',DOT,0x10b,
	'C',CAR,0x10c,
	'c',CAR,0x10d,
	'D',CAR,0x10e,
	'd',0x27,0x10f,
	'D','-',0x110,
	'd','-',0x111,
	'E',MAC,0x112,
	'e',MAC,0x113,
	'E',LSC,0x114,
	'e',LSC,0x115,
	'E',DOT,0x116,
	'e',DOT,0x117,
	'E',OGO,0x118,
	'e',OGO,0x119,
	'E',CAR,0x11a,
	'e',CAR,0x11b,
	'G',CIR,0x11c,
	'g',CIR,0x11d,
	'G',LSC,0x11e,
	'g',LSC,0x11f,
	'G',DOT,0x120,
	'g',DOT,0x121,
	'H',CIR,0x124,
	'h',CIR,0x125,
	'H','-',0x126,
	'h','-',0x127,
	'I',TIL,0x128,
	'i',TIL,0x129,
	'I',MAC,0x12a,
	'i',MAC,0x12b,
	'I',LSC,0x12c,
	'i',LSC,0x12d,
	'I',OGO,0x12e,
	'i',OGO,0x12f,
	'I',DOT,0x130,
	'I','J',0x132,
	'i','j',0x133,
	'J',CIR,0x134,
	'j',CIR,0x135,
	'L',ACU,0x139,
	'l',ACU,0x13a,
	'L',0x27,0x13d,
	'l',0x27,0x13e,
	'N',ACU,0x143,
	'n',ACU,0x144,
	'N',CAR,0x147,
	'n',CAR,0x148,
	'O',MAC,0x14c,
	'o',MAC,0x14d,
	'O',LSC,0x14e,
	'o',LSC,0x14f,
	'O',DAC,0x150,
	'o',DAC,0x151,
	'R',ACU,0x154,
	'r',ACU,0x155,
	'R',CAR,0x158,
	'r',CAR,0x159,
	'S',ACU,0x15a,
	's',ACU,0x15b,
	'S',CIR,0x15c,
	's',CIR,0x15d,
	'S',CED,0x15e,
	's',CED,0x15f,
	'S',CAR,0x160,
	's',CAR,0x161,
	'T',CED,0x162,
	't',CED,0x163,
	'T',CAR,0x164,
	't',0x27,0x165,
	'T','-',0x166,
	't','-',0x167,
	'U',TIL,0x168,
	'u',TIL,0x169,
	'U',MAC,0x16a,
	'u',MAC,0x16b,
	'U',LSC,0x16c,
	'u',LSC,0x16d,
	'U',RIN,0x16e,
	'u',RIN,0x16f,
	'U',DAC,0x170,
	'u',DAC,0x171,
	'U',OGO,0x172,
	'u',OGO,0x173,
	'W',CIR,0x174,
	'w',CIR,0x175,
	'Y',CIR,0x176,
	'y',CIR,0x177,
	'Y',UML,0x178,
	'Z',ACU,0x179,
	'z',ACU,0x17a,
	'Z',DOT,0x17b,
	'z',DOT,0x17c,
	'Z',CAR,0x17d,
	'z',CAR,0x17e,
	'A',CAR,0x1cd,
	'a',CAR,0x1ce,
	'I',CAR,0x1cf,
	'i',CAR,0x1d0,
	'O',CAR,0x1d1,
	'o',CAR,0x1d2,
	'U',CAR,0x1d3,
	'u',CAR,0x1d4,
	'G',CAR,0x1e6,
	'g',CAR,0x1e7,
	'K',CAR,0x1e8,
	'k',CAR,0x1e9,
	'O',OGO,0x1ea,
	'o',OGO,0x1eb,
	'j',CAR,0x1f0,
	'G',ACU,0x1f4,
	'g',ACU,0x1f5,
	'N',GRA,0x1f8,
	'n',GRA,0x1f9,
};

#endif /* LATIN */

#ifdef DINGBATS

int merge[]={};

int copy[]={
	43,0x261e,
};

#endif /* DINGBATS */

#ifdef CYRILLIC

int merge[]={};

int copy[]={
	45,0x044d,
	65,0x0410,
	66,0x0411,
	67,0x0426,
	68,0x0414,
	69,0x0415,
	70,0x0424,
	71,0x0413,
	72,0x0425,
	73,0x0418,
	74,0x0416,
	75,0x041a,
	76,0x041b,
	77,0x041c,
	78,0x041d,
	79,0x041e,
	80,0x041f,
	81,0x0427,
	82,0x0420,
	83,0x0421,
	84,0x0422,
	85,0x0423,
	86,0x0412,
	87,0x0428,
	88,0x0429,
	89,0x0419,
	90,0x0417,
	91,0x044b,
	93,0x044e,
	95,0x042d,
	97,0x0430,
	98,0x0431,
	99,0x0446,
	100,0x0434,
	101,0x0435,
	102,0x0444,
	103,0x0433,
	104,0x0445,
	105,0x0438,
	106,0x0436,
	107,0x043a,
	108,0x043b,
	109,0x043c,
	110,0x043d,
	111,0x043e,
	112,0x043f,
	113,0x0447,
	114,0x0440,
	115,0x0441,
	116,0x0442,
	117,0x0443,
	118,0x0432,
	119,0x0448,
	120,0x0449,
	121,0x0439,
	122,0x0437,
	123,0x042b,
	125,0x042e,
	161,0x044c,
	164,0x042c,
	168,0x042a,
	233,0x0401,
	249,0x0451
};

#endif /* CYRILLIC */

#ifdef GREEK
int copy[]={
	65,0x0391,
	66,0x0392,
	67,0x0393,
	68,0x0394,
	69,0x0395,
	70,0x0396,
	71,0x0397,
	72,0x0398,
	73,0x0399,
	74,0x039a,
	75,0x039b,
	76,0x039c,
	77,0x039d,
	78,0x039e,
	79,0x039f,
	80,0x03a0,
	81,0x03a1,
	82,0x03a3,
	83,0x03a4,
	84,0x03d2,
	85,0x03a6,
	86,0x03a7,
	87,0x03a8,
	88,0x03a9,
	97,0x03b1,
	98,0x03b2,
	99,0x03b3,
	100,0x03b4,
	101,0x03b5,
	102,0x03b6,
	103,0x03b7,
	104,0x03d1,
	105,0x03b8,
	106,0x03ba,
	107,0x03bb,
	108,0x03bc,
	109,0x03bd,
	110,0x03be,
	111,0x03bf,
	112,0x03c0,
	113,0x03c1,
	114,0x03c3,
	115,0x03c4,
	116,0x03c5,
	117,0x03c6,
	118,0x03c7,
	119,0x03c8,
	120,0x03c9,
};

int merge[]={};

#endif /* #ifdef GREEK */
unsigned char string[256];
	
void cp(int src, int dest)
{
		sprintf(string,"cp font/new/orig_%04x.png font/new/%04x.png"
		"\n",src,dest);
		fputs(string,stderr);
		system(string);
}

void mrg(int letter, int accent, int dest)
{
	sprintf(string,"convert +append font/new/orig_%04x.png spacer.png"
	" font/new/orig_%04x.png font/new/%04x.png\n",
	letter,accent,dest);
	fputs(string,stderr);
	system(string);
}

int main(int argc, char **argv)
{
	int a,top_margin,bottom_margin;
	float dpi;
	unsigned char *txt;
	FILE *f;
	
	if (!(txt=getenv("hundred_dpi"))){
		fprintf(stderr,"Can't find environment variable \"hundred_dpi\".\n");
		exit(1);
	}
	dpi=atof(txt)/100;
	if (!(txt=getenv("top_promile"))){
		fprintf(stderr,"Can't find environment variable \"top_promile\".\n");
		exit(1);
	}
	top_margin=atol(txt)*842*dpi/72000;
	if (!(txt=getenv("bottom_promile"))){
		fprintf(stderr,"Can't find environment variable \"bottom_promile\".\n");
		exit(1);
	}
	bottom_margin=atol(txt)*842*dpi/72000;

	f=fopen("clip_improcess_program","w");
	if (!f){
		fprintf(stderr,"Can't open \"clip_improcess_program\" file for"
		" writing.\n");
		perror(argv[0]);
		exit(1);
	}
	fprintf(f,"detract %d\n",bottom_margin);
	fprintf(f,"mirror\nflip\nmirror\nflip\n");
	fprintf(f,"detract %d\n",top_margin);
	fprintf(f,"mirror\nflip\nmirror\nflip\n");
	fclose(f);
	
	fprintf(stderr,"mkdir -p font/new\n");
	system("mkdir -p font/new");
	fprintf(stderr,"rm font/new/*\n");
	system("rm font/new/*");
	for (a=0;a<256;a++)
	{
		sprintf(string,"convert -crop 0x0 letters%d.png letters%d.png\n",a,a);
		fputs(string,stderr);
		system(string);
		sprintf(string,"improcess letters%d.png clip_improcess_program"
			" font/new/orig_%04x.png\n",a,a);
		fputs(string,stderr);
		system(string);
	}
	sprintf(string,"rm letters*.png\n");
	fputs(string,stderr);
	system(string);
#ifdef LATIN
	for (a=32;a<127;a++){
		cp(a,a);
	}
#endif /* LATIN */
	for (a=0;a<sizeof(copy)/sizeof(*copy)/2;a++){
		cp(copy[a*2],copy[a*2+1]);
	}
	for (a=0;a<sizeof(merge)/sizeof(*merge)/3;a++){
		mrg(merge[a*3],merge[a*3+1],merge[a*3+2]);
	}
	fprintf(stderr,"rm font/new/orig_????.png\n");
	system("rm font/new/orig_????.png\n");
	return 0;
}

