/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSTextMetrics.h"

#include <wtf/GetPtr.h>

#include "TextMetrics.h"

#include <runtime/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSTextMetrics)

/* Hash table */

static const HashTableValue JSTextMetricsTableValues[3] =
{
    { "width", DontDelete|ReadOnly, (intptr_t)jsTextMetricsWidth, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsTextMetricsConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSTextMetricsTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSTextMetricsTableValues, 0 };
#else
    { 4, 3, JSTextMetricsTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSTextMetricsConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSTextMetricsConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSTextMetricsConstructorTableValues, 0 };
#else
    { 1, 0, JSTextMetricsConstructorTableValues, 0 };
#endif

class JSTextMetricsConstructor : public DOMObject {
public:
    JSTextMetricsConstructor(ExecState* exec)
        : DOMObject(JSTextMetricsConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSTextMetricsPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSTextMetricsConstructor::s_info = { "TextMetricsConstructor", 0, &JSTextMetricsConstructorTable, 0 };

bool JSTextMetricsConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSTextMetricsConstructor, DOMObject>(exec, &JSTextMetricsConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSTextMetricsPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSTextMetricsPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSTextMetricsPrototypeTableValues, 0 };
#else
    { 1, 0, JSTextMetricsPrototypeTableValues, 0 };
#endif

const ClassInfo JSTextMetricsPrototype::s_info = { "TextMetricsPrototype", 0, &JSTextMetricsPrototypeTable, 0 };

JSObject* JSTextMetricsPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSTextMetrics>(exec);
}

const ClassInfo JSTextMetrics::s_info = { "TextMetrics", 0, &JSTextMetricsTable, 0 };

JSTextMetrics::JSTextMetrics(PassRefPtr<Structure> structure, PassRefPtr<TextMetrics> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSTextMetrics::~JSTextMetrics()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSTextMetrics::createPrototype(ExecState* exec)
{
    return new (exec) JSTextMetricsPrototype(JSTextMetricsPrototype::createStructure(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSTextMetrics::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSTextMetrics, Base>(exec, &JSTextMetricsTable, this, propertyName, slot);
}

JSValuePtr jsTextMetricsWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    TextMetrics* imp = static_cast<TextMetrics*>(static_cast<JSTextMetrics*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->width());
}

JSValuePtr jsTextMetricsConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSTextMetrics*>(asObject(slot.slotBase()))->getConstructor(exec);
}
JSValuePtr JSTextMetrics::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSTextMetricsConstructor>(exec);
}

JSC::JSValuePtr toJS(JSC::ExecState* exec, TextMetrics* object)
{
    return getDOMObjectWrapper<JSTextMetrics>(exec, object);
}
TextMetrics* toTextMetrics(JSC::JSValuePtr value)
{
    return value->isObject(&JSTextMetrics::s_info) ? static_cast<JSTextMetrics*>(asObject(value))->impl() : 0;
}

}
