/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "SVGElement.h"
#include "JSSVGImageElement.h"

#include <wtf/GetPtr.h>

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedPreserveAspectRatio.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "KURL.h"
#include "SVGElement.h"
#include "SVGImageElement.h"
#include "SVGStringList.h"

#include <runtime/Error.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGImageElement)

/* Hash table */

static const HashTableValue JSSVGImageElementTableValues[18] =
{
    { "x", DontDelete|ReadOnly, (intptr_t)jsSVGImageElementX, (intptr_t)0 },
    { "y", DontDelete|ReadOnly, (intptr_t)jsSVGImageElementY, (intptr_t)0 },
    { "width", DontDelete|ReadOnly, (intptr_t)jsSVGImageElementWidth, (intptr_t)0 },
    { "height", DontDelete|ReadOnly, (intptr_t)jsSVGImageElementHeight, (intptr_t)0 },
    { "preserveAspectRatio", DontDelete|ReadOnly, (intptr_t)jsSVGImageElementPreserveAspectRatio, (intptr_t)0 },
    { "href", DontDelete|ReadOnly, (intptr_t)jsSVGImageElementHref, (intptr_t)0 },
    { "requiredFeatures", DontDelete|ReadOnly, (intptr_t)jsSVGImageElementRequiredFeatures, (intptr_t)0 },
    { "requiredExtensions", DontDelete|ReadOnly, (intptr_t)jsSVGImageElementRequiredExtensions, (intptr_t)0 },
    { "systemLanguage", DontDelete|ReadOnly, (intptr_t)jsSVGImageElementSystemLanguage, (intptr_t)0 },
    { "xmllang", DontDelete, (intptr_t)jsSVGImageElementXmllang, (intptr_t)setJSSVGImageElementXmllang },
    { "xmlspace", DontDelete, (intptr_t)jsSVGImageElementXmlspace, (intptr_t)setJSSVGImageElementXmlspace },
    { "externalResourcesRequired", DontDelete|ReadOnly, (intptr_t)jsSVGImageElementExternalResourcesRequired, (intptr_t)0 },
    { "className", DontDelete|ReadOnly, (intptr_t)jsSVGImageElementClassName, (intptr_t)0 },
    { "style", DontDelete|ReadOnly, (intptr_t)jsSVGImageElementStyle, (intptr_t)0 },
    { "transform", DontDelete|ReadOnly, (intptr_t)jsSVGImageElementTransform, (intptr_t)0 },
    { "nearestViewportElement", DontDelete|ReadOnly, (intptr_t)jsSVGImageElementNearestViewportElement, (intptr_t)0 },
    { "farthestViewportElement", DontDelete|ReadOnly, (intptr_t)jsSVGImageElementFarthestViewportElement, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGImageElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 1023, JSSVGImageElementTableValues, 0 };
#else
    { 68, 63, JSSVGImageElementTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGImageElementPrototypeTableValues[7] =
{
    { "hasExtension", DontDelete|Function, (intptr_t)jsSVGImageElementPrototypeFunctionHasExtension, (intptr_t)1 },
    { "getPresentationAttribute", DontDelete|Function, (intptr_t)jsSVGImageElementPrototypeFunctionGetPresentationAttribute, (intptr_t)1 },
    { "getBBox", DontDelete|Function, (intptr_t)jsSVGImageElementPrototypeFunctionGetBBox, (intptr_t)0 },
    { "getCTM", DontDelete|Function, (intptr_t)jsSVGImageElementPrototypeFunctionGetCTM, (intptr_t)0 },
    { "getScreenCTM", DontDelete|Function, (intptr_t)jsSVGImageElementPrototypeFunctionGetScreenCTM, (intptr_t)0 },
    { "getTransformToElement", DontDelete|Function, (intptr_t)jsSVGImageElementPrototypeFunctionGetTransformToElement, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGImageElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 2047, JSSVGImageElementPrototypeTableValues, 0 };
#else
    { 17, 15, JSSVGImageElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGImageElementPrototype::s_info = { "SVGImageElementPrototype", 0, &JSSVGImageElementPrototypeTable, 0 };

JSObject* JSSVGImageElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSSVGImageElement>(exec);
}

bool JSSVGImageElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGImageElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGImageElement::s_info = { "SVGImageElement", &JSSVGElement::s_info, &JSSVGImageElementTable, 0 };

JSSVGImageElement::JSSVGImageElement(PassRefPtr<Structure> structure, PassRefPtr<SVGImageElement> impl)
    : JSSVGElement(structure, impl)
{
}

JSObject* JSSVGImageElement::createPrototype(ExecState* exec)
{
    return new (exec) JSSVGImageElementPrototype(JSSVGImageElementPrototype::createStructure(JSSVGElementPrototype::self(exec)));
}

bool JSSVGImageElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGImageElement, Base>(exec, &JSSVGImageElementTable, this, propertyName, slot);
}

JSValuePtr jsSVGImageElementX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedLength> obj = imp->xAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGImageElementY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedLength> obj = imp->yAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGImageElementWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedLength> obj = imp->widthAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGImageElementHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedLength> obj = imp->heightAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGImageElementPreserveAspectRatio(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedPreserveAspectRatio> obj = imp->preserveAspectRatioAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGImageElementHref(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedString> obj = imp->hrefAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGImageElementRequiredFeatures(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->requiredFeatures()), imp);
}

JSValuePtr jsSVGImageElementRequiredExtensions(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->requiredExtensions()), imp);
}

JSValuePtr jsSVGImageElementSystemLanguage(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->systemLanguage()), imp);
}

JSValuePtr jsSVGImageElementXmllang(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->xmllang());
}

JSValuePtr jsSVGImageElementXmlspace(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->xmlspace());
}

JSValuePtr jsSVGImageElementExternalResourcesRequired(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGImageElementClassName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGImageElementStyle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->style()));
}

JSValuePtr jsSVGImageElementTransform(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedTransformList> obj = imp->transformAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGImageElementNearestViewportElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->nearestViewportElement()));
}

JSValuePtr jsSVGImageElementFarthestViewportElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->farthestViewportElement()));
}

void JSSVGImageElement::put(ExecState* exec, const Identifier& propertyName, JSValuePtr value, PutPropertySlot& slot)
{
    lookupPut<JSSVGImageElement, Base>(exec, propertyName, value, &JSSVGImageElementTable, this, slot);
}

void setJSSVGImageElementXmllang(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(thisObject)->impl());
    imp->setXmllang(value->toString(exec));
}

void setJSSVGImageElementXmlspace(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(thisObject)->impl());
    imp->setXmlspace(value->toString(exec));
}

JSValuePtr jsSVGImageElementPrototypeFunctionHasExtension(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGImageElement::s_info))
        return throwError(exec, TypeError);
    JSSVGImageElement* castedThisObj = static_cast<JSSVGImageElement*>(asObject(thisValue));
    SVGImageElement* imp = static_cast<SVGImageElement*>(castedThisObj->impl());
    const UString& extension = args.at(exec, 0)->toString(exec);


    JSC::JSValuePtr result = jsBoolean(imp->hasExtension(extension));
    return result;
}

JSValuePtr jsSVGImageElementPrototypeFunctionGetPresentationAttribute(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGImageElement::s_info))
        return throwError(exec, TypeError);
    JSSVGImageElement* castedThisObj = static_cast<JSSVGImageElement*>(asObject(thisValue));
    SVGImageElement* imp = static_cast<SVGImageElement*>(castedThisObj->impl());
    const UString& name = args.at(exec, 0)->toString(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->getPresentationAttribute(name)));
    return result;
}

JSValuePtr jsSVGImageElementPrototypeFunctionGetBBox(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGImageElement::s_info))
        return throwError(exec, TypeError);
    JSSVGImageElement* castedThisObj = static_cast<JSSVGImageElement*>(asObject(thisValue));
    SVGImageElement* imp = static_cast<SVGImageElement*>(castedThisObj->impl());


    JSC::JSValuePtr result = toJS(exec, JSSVGStaticPODTypeWrapper<FloatRect>::create(imp->getBBox()).get(), imp);
    return result;
}

JSValuePtr jsSVGImageElementPrototypeFunctionGetCTM(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGImageElement::s_info))
        return throwError(exec, TypeError);
    JSSVGImageElement* castedThisObj = static_cast<JSSVGImageElement*>(asObject(thisValue));
    SVGImageElement* imp = static_cast<SVGImageElement*>(castedThisObj->impl());


    JSC::JSValuePtr result = toJS(exec, JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp->getCTM()).get(), imp);
    return result;
}

JSValuePtr jsSVGImageElementPrototypeFunctionGetScreenCTM(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGImageElement::s_info))
        return throwError(exec, TypeError);
    JSSVGImageElement* castedThisObj = static_cast<JSSVGImageElement*>(asObject(thisValue));
    SVGImageElement* imp = static_cast<SVGImageElement*>(castedThisObj->impl());


    JSC::JSValuePtr result = toJS(exec, JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp->getScreenCTM()).get(), imp);
    return result;
}

JSValuePtr jsSVGImageElementPrototypeFunctionGetTransformToElement(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGImageElement::s_info))
        return throwError(exec, TypeError);
    JSSVGImageElement* castedThisObj = static_cast<JSSVGImageElement*>(asObject(thisValue));
    SVGImageElement* imp = static_cast<SVGImageElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    SVGElement* element = toSVGElement(args.at(exec, 0));


    JSC::JSValuePtr result = toJS(exec, JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp->getTransformToElement(element, ec)).get(), imp);
    setDOMException(exec, ec);
    return result;
}


}

#endif // ENABLE(SVG)
